<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TaxDetails StructType
 * @subpackage Structs
 */
class TaxDetails extends AbstractStructBase
{
    /**
     * The taxDetailsReference
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $taxDetailsReference;
    /**
     * The lineType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $lineType;
    /**
     * The lineName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $lineName;
    /**
     * The netAmount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $netAmount;
    /**
     * The grossAmount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $grossAmount;
    /**
     * The taxType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $taxType;
    /**
     * The taxCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $taxCode;
    /**
     * The taxBasis
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $taxBasis;
    /**
     * The taxRate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $taxRate;
    /**
     * The taxAmount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $taxAmount;
    /**
     * The calcDetail
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $calcDetail;
    /**
     * Constructor method for TaxDetails
     * @uses TaxDetails::setTaxDetailsReference()
     * @uses TaxDetails::setLineType()
     * @uses TaxDetails::setLineName()
     * @uses TaxDetails::setNetAmount()
     * @uses TaxDetails::setGrossAmount()
     * @uses TaxDetails::setTaxType()
     * @uses TaxDetails::setTaxCode()
     * @uses TaxDetails::setTaxBasis()
     * @uses TaxDetails::setTaxRate()
     * @uses TaxDetails::setTaxAmount()
     * @uses TaxDetails::setCalcDetail()
     * @param string $taxDetailsReference
     * @param string $lineType
     * @param string $lineName
     * @param float $netAmount
     * @param float $grossAmount
     * @param \StructType\RecordRef $taxType
     * @param \StructType\RecordRef $taxCode
     * @param float $taxBasis
     * @param float $taxRate
     * @param float $taxAmount
     * @param string $calcDetail
     */
    public function __construct($taxDetailsReference = null, $lineType = null, $lineName = null, $netAmount = null, $grossAmount = null, \StructType\RecordRef $taxType = null, \StructType\RecordRef $taxCode = null, $taxBasis = null, $taxRate = null, $taxAmount = null, $calcDetail = null)
    {
        $this
            ->setTaxDetailsReference($taxDetailsReference)
            ->setLineType($lineType)
            ->setLineName($lineName)
            ->setNetAmount($netAmount)
            ->setGrossAmount($grossAmount)
            ->setTaxType($taxType)
            ->setTaxCode($taxCode)
            ->setTaxBasis($taxBasis)
            ->setTaxRate($taxRate)
            ->setTaxAmount($taxAmount)
            ->setCalcDetail($calcDetail);
    }
    /**
     * Get taxDetailsReference value
     * @return string|null
     */
    public function getTaxDetailsReference()
    {
        return $this->taxDetailsReference;
    }
    /**
     * Set taxDetailsReference value
     * @param string $taxDetailsReference
     * @return \StructType\TaxDetails
     */
    public function setTaxDetailsReference($taxDetailsReference = null)
    {
        // validation for constraint: string
        if (!is_null($taxDetailsReference) && !is_string($taxDetailsReference)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($taxDetailsReference, true), gettype($taxDetailsReference)), __LINE__);
        }
        $this->taxDetailsReference = $taxDetailsReference;
        return $this;
    }
    /**
     * Get lineType value
     * @return string|null
     */
    public function getLineType()
    {
        return $this->lineType;
    }
    /**
     * Set lineType value
     * @param string $lineType
     * @return \StructType\TaxDetails
     */
    public function setLineType($lineType = null)
    {
        // validation for constraint: string
        if (!is_null($lineType) && !is_string($lineType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lineType, true), gettype($lineType)), __LINE__);
        }
        $this->lineType = $lineType;
        return $this;
    }
    /**
     * Get lineName value
     * @return string|null
     */
    public function getLineName()
    {
        return $this->lineName;
    }
    /**
     * Set lineName value
     * @param string $lineName
     * @return \StructType\TaxDetails
     */
    public function setLineName($lineName = null)
    {
        // validation for constraint: string
        if (!is_null($lineName) && !is_string($lineName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lineName, true), gettype($lineName)), __LINE__);
        }
        $this->lineName = $lineName;
        return $this;
    }
    /**
     * Get netAmount value
     * @return float|null
     */
    public function getNetAmount()
    {
        return $this->netAmount;
    }
    /**
     * Set netAmount value
     * @param float $netAmount
     * @return \StructType\TaxDetails
     */
    public function setNetAmount($netAmount = null)
    {
        // validation for constraint: float
        if (!is_null($netAmount) && !(is_float($netAmount) || is_numeric($netAmount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($netAmount, true), gettype($netAmount)), __LINE__);
        }
        $this->netAmount = $netAmount;
        return $this;
    }
    /**
     * Get grossAmount value
     * @return float|null
     */
    public function getGrossAmount()
    {
        return $this->grossAmount;
    }
    /**
     * Set grossAmount value
     * @param float $grossAmount
     * @return \StructType\TaxDetails
     */
    public function setGrossAmount($grossAmount = null)
    {
        // validation for constraint: float
        if (!is_null($grossAmount) && !(is_float($grossAmount) || is_numeric($grossAmount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($grossAmount, true), gettype($grossAmount)), __LINE__);
        }
        $this->grossAmount = $grossAmount;
        return $this;
    }
    /**
     * Get taxType value
     * @return \StructType\RecordRef|null
     */
    public function getTaxType()
    {
        return $this->taxType;
    }
    /**
     * Set taxType value
     * @param \StructType\RecordRef $taxType
     * @return \StructType\TaxDetails
     */
    public function setTaxType(\StructType\RecordRef $taxType = null)
    {
        $this->taxType = $taxType;
        return $this;
    }
    /**
     * Get taxCode value
     * @return \StructType\RecordRef|null
     */
    public function getTaxCode()
    {
        return $this->taxCode;
    }
    /**
     * Set taxCode value
     * @param \StructType\RecordRef $taxCode
     * @return \StructType\TaxDetails
     */
    public function setTaxCode(\StructType\RecordRef $taxCode = null)
    {
        $this->taxCode = $taxCode;
        return $this;
    }
    /**
     * Get taxBasis value
     * @return float|null
     */
    public function getTaxBasis()
    {
        return $this->taxBasis;
    }
    /**
     * Set taxBasis value
     * @param float $taxBasis
     * @return \StructType\TaxDetails
     */
    public function setTaxBasis($taxBasis = null)
    {
        // validation for constraint: float
        if (!is_null($taxBasis) && !(is_float($taxBasis) || is_numeric($taxBasis))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($taxBasis, true), gettype($taxBasis)), __LINE__);
        }
        $this->taxBasis = $taxBasis;
        return $this;
    }
    /**
     * Get taxRate value
     * @return float|null
     */
    public function getTaxRate()
    {
        return $this->taxRate;
    }
    /**
     * Set taxRate value
     * @param float $taxRate
     * @return \StructType\TaxDetails
     */
    public function setTaxRate($taxRate = null)
    {
        // validation for constraint: float
        if (!is_null($taxRate) && !(is_float($taxRate) || is_numeric($taxRate))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($taxRate, true), gettype($taxRate)), __LINE__);
        }
        $this->taxRate = $taxRate;
        return $this;
    }
    /**
     * Get taxAmount value
     * @return float|null
     */
    public function getTaxAmount()
    {
        return $this->taxAmount;
    }
    /**
     * Set taxAmount value
     * @param float $taxAmount
     * @return \StructType\TaxDetails
     */
    public function setTaxAmount($taxAmount = null)
    {
        // validation for constraint: float
        if (!is_null($taxAmount) && !(is_float($taxAmount) || is_numeric($taxAmount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($taxAmount, true), gettype($taxAmount)), __LINE__);
        }
        $this->taxAmount = $taxAmount;
        return $this;
    }
    /**
     * Get calcDetail value
     * @return string|null
     */
    public function getCalcDetail()
    {
        return $this->calcDetail;
    }
    /**
     * Set calcDetail value
     * @param string $calcDetail
     * @return \StructType\TaxDetails
     */
    public function setCalcDetail($calcDetail = null)
    {
        // validation for constraint: string
        if (!is_null($calcDetail) && !is_string($calcDetail)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($calcDetail, true), gettype($calcDetail)), __LINE__);
        }
        $this->calcDetail = $calcDetail;
        return $this;
    }
}
