<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TaxDetailSearchRowBasic StructType
 * @subpackage Structs
 */
class TaxDetailSearchRowBasic extends SearchRowBasic
{
    /**
     * The account
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SearchColumnStringField[]
     */
    public $account;
    /**
     * The details
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SearchColumnStringField[]
     */
    public $details;
    /**
     * The lineNumber
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SearchColumnLongField[]
     */
    public $lineNumber;
    /**
     * The taxAmount
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SearchColumnDoubleField[]
     */
    public $taxAmount;
    /**
     * The taxBasis
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SearchColumnDoubleField[]
     */
    public $taxBasis;
    /**
     * The taxCode
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SearchColumnSelectField[]
     */
    public $taxCode;
    /**
     * The taxRate
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SearchColumnDoubleField[]
     */
    public $taxRate;
    /**
     * The taxType
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SearchColumnSelectField[]
     */
    public $taxType;
    /**
     * The tranId
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SearchColumnLongField[]
     */
    public $tranId;
    /**
     * Constructor method for TaxDetailSearchRowBasic
     * @uses TaxDetailSearchRowBasic::setAccount()
     * @uses TaxDetailSearchRowBasic::setDetails()
     * @uses TaxDetailSearchRowBasic::setLineNumber()
     * @uses TaxDetailSearchRowBasic::setTaxAmount()
     * @uses TaxDetailSearchRowBasic::setTaxBasis()
     * @uses TaxDetailSearchRowBasic::setTaxCode()
     * @uses TaxDetailSearchRowBasic::setTaxRate()
     * @uses TaxDetailSearchRowBasic::setTaxType()
     * @uses TaxDetailSearchRowBasic::setTranId()
     * @param \StructType\SearchColumnStringField[] $account
     * @param \StructType\SearchColumnStringField[] $details
     * @param \StructType\SearchColumnLongField[] $lineNumber
     * @param \StructType\SearchColumnDoubleField[] $taxAmount
     * @param \StructType\SearchColumnDoubleField[] $taxBasis
     * @param \StructType\SearchColumnSelectField[] $taxCode
     * @param \StructType\SearchColumnDoubleField[] $taxRate
     * @param \StructType\SearchColumnSelectField[] $taxType
     * @param \StructType\SearchColumnLongField[] $tranId
     */
    public function __construct(array $account = array(), array $details = array(), array $lineNumber = array(), array $taxAmount = array(), array $taxBasis = array(), array $taxCode = array(), array $taxRate = array(), array $taxType = array(), array $tranId = array())
    {
        $this
            ->setAccount($account)
            ->setDetails($details)
            ->setLineNumber($lineNumber)
            ->setTaxAmount($taxAmount)
            ->setTaxBasis($taxBasis)
            ->setTaxCode($taxCode)
            ->setTaxRate($taxRate)
            ->setTaxType($taxType)
            ->setTranId($tranId);
    }
    /**
     * Get account value
     * @return \StructType\SearchColumnStringField[]|null
     */
    public function getAccount()
    {
        return $this->account;
    }
    /**
     * This method is responsible for validating the values passed to the setAccount method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAccount method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAccountForArrayConstraintsFromSetAccount(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $taxDetailSearchRowBasicAccountItem) {
            // validation for constraint: itemType
            if (!$taxDetailSearchRowBasicAccountItem instanceof \StructType\SearchColumnStringField) {
                $invalidValues[] = is_object($taxDetailSearchRowBasicAccountItem) ? get_class($taxDetailSearchRowBasicAccountItem) : sprintf('%s(%s)', gettype($taxDetailSearchRowBasicAccountItem), var_export($taxDetailSearchRowBasicAccountItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The account property can only contain items of type \StructType\SearchColumnStringField, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set account value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnStringField[] $account
     * @return \StructType\TaxDetailSearchRowBasic
     */
    public function setAccount(array $account = array())
    {
        // validation for constraint: array
        if ('' !== ($accountArrayErrorMessage = self::validateAccountForArrayConstraintsFromSetAccount($account))) {
            throw new \InvalidArgumentException($accountArrayErrorMessage, __LINE__);
        }
        $this->account = $account;
        return $this;
    }
    /**
     * Add item to account value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnStringField $item
     * @return \StructType\TaxDetailSearchRowBasic
     */
    public function addToAccount(\StructType\SearchColumnStringField $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SearchColumnStringField) {
            throw new \InvalidArgumentException(sprintf('The account property can only contain items of type \StructType\SearchColumnStringField, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->account[] = $item;
        return $this;
    }
    /**
     * Get details value
     * @return \StructType\SearchColumnStringField[]|null
     */
    public function getDetails()
    {
        return $this->details;
    }
    /**
     * This method is responsible for validating the values passed to the setDetails method
     * This method is willingly generated in order to preserve the one-line inline validation within the setDetails method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateDetailsForArrayConstraintsFromSetDetails(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $taxDetailSearchRowBasicDetailsItem) {
            // validation for constraint: itemType
            if (!$taxDetailSearchRowBasicDetailsItem instanceof \StructType\SearchColumnStringField) {
                $invalidValues[] = is_object($taxDetailSearchRowBasicDetailsItem) ? get_class($taxDetailSearchRowBasicDetailsItem) : sprintf('%s(%s)', gettype($taxDetailSearchRowBasicDetailsItem), var_export($taxDetailSearchRowBasicDetailsItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The details property can only contain items of type \StructType\SearchColumnStringField, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set details value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnStringField[] $details
     * @return \StructType\TaxDetailSearchRowBasic
     */
    public function setDetails(array $details = array())
    {
        // validation for constraint: array
        if ('' !== ($detailsArrayErrorMessage = self::validateDetailsForArrayConstraintsFromSetDetails($details))) {
            throw new \InvalidArgumentException($detailsArrayErrorMessage, __LINE__);
        }
        $this->details = $details;
        return $this;
    }
    /**
     * Add item to details value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnStringField $item
     * @return \StructType\TaxDetailSearchRowBasic
     */
    public function addToDetails(\StructType\SearchColumnStringField $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SearchColumnStringField) {
            throw new \InvalidArgumentException(sprintf('The details property can only contain items of type \StructType\SearchColumnStringField, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->details[] = $item;
        return $this;
    }
    /**
     * Get lineNumber value
     * @return \StructType\SearchColumnLongField[]|null
     */
    public function getLineNumber()
    {
        return $this->lineNumber;
    }
    /**
     * This method is responsible for validating the values passed to the setLineNumber method
     * This method is willingly generated in order to preserve the one-line inline validation within the setLineNumber method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateLineNumberForArrayConstraintsFromSetLineNumber(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $taxDetailSearchRowBasicLineNumberItem) {
            // validation for constraint: itemType
            if (!$taxDetailSearchRowBasicLineNumberItem instanceof \StructType\SearchColumnLongField) {
                $invalidValues[] = is_object($taxDetailSearchRowBasicLineNumberItem) ? get_class($taxDetailSearchRowBasicLineNumberItem) : sprintf('%s(%s)', gettype($taxDetailSearchRowBasicLineNumberItem), var_export($taxDetailSearchRowBasicLineNumberItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The lineNumber property can only contain items of type \StructType\SearchColumnLongField, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set lineNumber value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnLongField[] $lineNumber
     * @return \StructType\TaxDetailSearchRowBasic
     */
    public function setLineNumber(array $lineNumber = array())
    {
        // validation for constraint: array
        if ('' !== ($lineNumberArrayErrorMessage = self::validateLineNumberForArrayConstraintsFromSetLineNumber($lineNumber))) {
            throw new \InvalidArgumentException($lineNumberArrayErrorMessage, __LINE__);
        }
        $this->lineNumber = $lineNumber;
        return $this;
    }
    /**
     * Add item to lineNumber value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnLongField $item
     * @return \StructType\TaxDetailSearchRowBasic
     */
    public function addToLineNumber(\StructType\SearchColumnLongField $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SearchColumnLongField) {
            throw new \InvalidArgumentException(sprintf('The lineNumber property can only contain items of type \StructType\SearchColumnLongField, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->lineNumber[] = $item;
        return $this;
    }
    /**
     * Get taxAmount value
     * @return \StructType\SearchColumnDoubleField[]|null
     */
    public function getTaxAmount()
    {
        return $this->taxAmount;
    }
    /**
     * This method is responsible for validating the values passed to the setTaxAmount method
     * This method is willingly generated in order to preserve the one-line inline validation within the setTaxAmount method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateTaxAmountForArrayConstraintsFromSetTaxAmount(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $taxDetailSearchRowBasicTaxAmountItem) {
            // validation for constraint: itemType
            if (!$taxDetailSearchRowBasicTaxAmountItem instanceof \StructType\SearchColumnDoubleField) {
                $invalidValues[] = is_object($taxDetailSearchRowBasicTaxAmountItem) ? get_class($taxDetailSearchRowBasicTaxAmountItem) : sprintf('%s(%s)', gettype($taxDetailSearchRowBasicTaxAmountItem), var_export($taxDetailSearchRowBasicTaxAmountItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The taxAmount property can only contain items of type \StructType\SearchColumnDoubleField, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set taxAmount value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnDoubleField[] $taxAmount
     * @return \StructType\TaxDetailSearchRowBasic
     */
    public function setTaxAmount(array $taxAmount = array())
    {
        // validation for constraint: array
        if ('' !== ($taxAmountArrayErrorMessage = self::validateTaxAmountForArrayConstraintsFromSetTaxAmount($taxAmount))) {
            throw new \InvalidArgumentException($taxAmountArrayErrorMessage, __LINE__);
        }
        $this->taxAmount = $taxAmount;
        return $this;
    }
    /**
     * Add item to taxAmount value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnDoubleField $item
     * @return \StructType\TaxDetailSearchRowBasic
     */
    public function addToTaxAmount(\StructType\SearchColumnDoubleField $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SearchColumnDoubleField) {
            throw new \InvalidArgumentException(sprintf('The taxAmount property can only contain items of type \StructType\SearchColumnDoubleField, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->taxAmount[] = $item;
        return $this;
    }
    /**
     * Get taxBasis value
     * @return \StructType\SearchColumnDoubleField[]|null
     */
    public function getTaxBasis()
    {
        return $this->taxBasis;
    }
    /**
     * This method is responsible for validating the values passed to the setTaxBasis method
     * This method is willingly generated in order to preserve the one-line inline validation within the setTaxBasis method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateTaxBasisForArrayConstraintsFromSetTaxBasis(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $taxDetailSearchRowBasicTaxBasisItem) {
            // validation for constraint: itemType
            if (!$taxDetailSearchRowBasicTaxBasisItem instanceof \StructType\SearchColumnDoubleField) {
                $invalidValues[] = is_object($taxDetailSearchRowBasicTaxBasisItem) ? get_class($taxDetailSearchRowBasicTaxBasisItem) : sprintf('%s(%s)', gettype($taxDetailSearchRowBasicTaxBasisItem), var_export($taxDetailSearchRowBasicTaxBasisItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The taxBasis property can only contain items of type \StructType\SearchColumnDoubleField, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set taxBasis value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnDoubleField[] $taxBasis
     * @return \StructType\TaxDetailSearchRowBasic
     */
    public function setTaxBasis(array $taxBasis = array())
    {
        // validation for constraint: array
        if ('' !== ($taxBasisArrayErrorMessage = self::validateTaxBasisForArrayConstraintsFromSetTaxBasis($taxBasis))) {
            throw new \InvalidArgumentException($taxBasisArrayErrorMessage, __LINE__);
        }
        $this->taxBasis = $taxBasis;
        return $this;
    }
    /**
     * Add item to taxBasis value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnDoubleField $item
     * @return \StructType\TaxDetailSearchRowBasic
     */
    public function addToTaxBasis(\StructType\SearchColumnDoubleField $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SearchColumnDoubleField) {
            throw new \InvalidArgumentException(sprintf('The taxBasis property can only contain items of type \StructType\SearchColumnDoubleField, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->taxBasis[] = $item;
        return $this;
    }
    /**
     * Get taxCode value
     * @return \StructType\SearchColumnSelectField[]|null
     */
    public function getTaxCode()
    {
        return $this->taxCode;
    }
    /**
     * This method is responsible for validating the values passed to the setTaxCode method
     * This method is willingly generated in order to preserve the one-line inline validation within the setTaxCode method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateTaxCodeForArrayConstraintsFromSetTaxCode(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $taxDetailSearchRowBasicTaxCodeItem) {
            // validation for constraint: itemType
            if (!$taxDetailSearchRowBasicTaxCodeItem instanceof \StructType\SearchColumnSelectField) {
                $invalidValues[] = is_object($taxDetailSearchRowBasicTaxCodeItem) ? get_class($taxDetailSearchRowBasicTaxCodeItem) : sprintf('%s(%s)', gettype($taxDetailSearchRowBasicTaxCodeItem), var_export($taxDetailSearchRowBasicTaxCodeItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The taxCode property can only contain items of type \StructType\SearchColumnSelectField, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set taxCode value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnSelectField[] $taxCode
     * @return \StructType\TaxDetailSearchRowBasic
     */
    public function setTaxCode(array $taxCode = array())
    {
        // validation for constraint: array
        if ('' !== ($taxCodeArrayErrorMessage = self::validateTaxCodeForArrayConstraintsFromSetTaxCode($taxCode))) {
            throw new \InvalidArgumentException($taxCodeArrayErrorMessage, __LINE__);
        }
        $this->taxCode = $taxCode;
        return $this;
    }
    /**
     * Add item to taxCode value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnSelectField $item
     * @return \StructType\TaxDetailSearchRowBasic
     */
    public function addToTaxCode(\StructType\SearchColumnSelectField $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SearchColumnSelectField) {
            throw new \InvalidArgumentException(sprintf('The taxCode property can only contain items of type \StructType\SearchColumnSelectField, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->taxCode[] = $item;
        return $this;
    }
    /**
     * Get taxRate value
     * @return \StructType\SearchColumnDoubleField[]|null
     */
    public function getTaxRate()
    {
        return $this->taxRate;
    }
    /**
     * This method is responsible for validating the values passed to the setTaxRate method
     * This method is willingly generated in order to preserve the one-line inline validation within the setTaxRate method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateTaxRateForArrayConstraintsFromSetTaxRate(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $taxDetailSearchRowBasicTaxRateItem) {
            // validation for constraint: itemType
            if (!$taxDetailSearchRowBasicTaxRateItem instanceof \StructType\SearchColumnDoubleField) {
                $invalidValues[] = is_object($taxDetailSearchRowBasicTaxRateItem) ? get_class($taxDetailSearchRowBasicTaxRateItem) : sprintf('%s(%s)', gettype($taxDetailSearchRowBasicTaxRateItem), var_export($taxDetailSearchRowBasicTaxRateItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The taxRate property can only contain items of type \StructType\SearchColumnDoubleField, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set taxRate value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnDoubleField[] $taxRate
     * @return \StructType\TaxDetailSearchRowBasic
     */
    public function setTaxRate(array $taxRate = array())
    {
        // validation for constraint: array
        if ('' !== ($taxRateArrayErrorMessage = self::validateTaxRateForArrayConstraintsFromSetTaxRate($taxRate))) {
            throw new \InvalidArgumentException($taxRateArrayErrorMessage, __LINE__);
        }
        $this->taxRate = $taxRate;
        return $this;
    }
    /**
     * Add item to taxRate value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnDoubleField $item
     * @return \StructType\TaxDetailSearchRowBasic
     */
    public function addToTaxRate(\StructType\SearchColumnDoubleField $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SearchColumnDoubleField) {
            throw new \InvalidArgumentException(sprintf('The taxRate property can only contain items of type \StructType\SearchColumnDoubleField, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->taxRate[] = $item;
        return $this;
    }
    /**
     * Get taxType value
     * @return \StructType\SearchColumnSelectField[]|null
     */
    public function getTaxType()
    {
        return $this->taxType;
    }
    /**
     * This method is responsible for validating the values passed to the setTaxType method
     * This method is willingly generated in order to preserve the one-line inline validation within the setTaxType method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateTaxTypeForArrayConstraintsFromSetTaxType(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $taxDetailSearchRowBasicTaxTypeItem) {
            // validation for constraint: itemType
            if (!$taxDetailSearchRowBasicTaxTypeItem instanceof \StructType\SearchColumnSelectField) {
                $invalidValues[] = is_object($taxDetailSearchRowBasicTaxTypeItem) ? get_class($taxDetailSearchRowBasicTaxTypeItem) : sprintf('%s(%s)', gettype($taxDetailSearchRowBasicTaxTypeItem), var_export($taxDetailSearchRowBasicTaxTypeItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The taxType property can only contain items of type \StructType\SearchColumnSelectField, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set taxType value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnSelectField[] $taxType
     * @return \StructType\TaxDetailSearchRowBasic
     */
    public function setTaxType(array $taxType = array())
    {
        // validation for constraint: array
        if ('' !== ($taxTypeArrayErrorMessage = self::validateTaxTypeForArrayConstraintsFromSetTaxType($taxType))) {
            throw new \InvalidArgumentException($taxTypeArrayErrorMessage, __LINE__);
        }
        $this->taxType = $taxType;
        return $this;
    }
    /**
     * Add item to taxType value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnSelectField $item
     * @return \StructType\TaxDetailSearchRowBasic
     */
    public function addToTaxType(\StructType\SearchColumnSelectField $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SearchColumnSelectField) {
            throw new \InvalidArgumentException(sprintf('The taxType property can only contain items of type \StructType\SearchColumnSelectField, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->taxType[] = $item;
        return $this;
    }
    /**
     * Get tranId value
     * @return \StructType\SearchColumnLongField[]|null
     */
    public function getTranId()
    {
        return $this->tranId;
    }
    /**
     * This method is responsible for validating the values passed to the setTranId method
     * This method is willingly generated in order to preserve the one-line inline validation within the setTranId method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateTranIdForArrayConstraintsFromSetTranId(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $taxDetailSearchRowBasicTranIdItem) {
            // validation for constraint: itemType
            if (!$taxDetailSearchRowBasicTranIdItem instanceof \StructType\SearchColumnLongField) {
                $invalidValues[] = is_object($taxDetailSearchRowBasicTranIdItem) ? get_class($taxDetailSearchRowBasicTranIdItem) : sprintf('%s(%s)', gettype($taxDetailSearchRowBasicTranIdItem), var_export($taxDetailSearchRowBasicTranIdItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The tranId property can only contain items of type \StructType\SearchColumnLongField, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set tranId value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnLongField[] $tranId
     * @return \StructType\TaxDetailSearchRowBasic
     */
    public function setTranId(array $tranId = array())
    {
        // validation for constraint: array
        if ('' !== ($tranIdArrayErrorMessage = self::validateTranIdForArrayConstraintsFromSetTranId($tranId))) {
            throw new \InvalidArgumentException($tranIdArrayErrorMessage, __LINE__);
        }
        $this->tranId = $tranId;
        return $this;
    }
    /**
     * Add item to tranId value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnLongField $item
     * @return \StructType\TaxDetailSearchRowBasic
     */
    public function addToTranId(\StructType\SearchColumnLongField $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SearchColumnLongField) {
            throw new \InvalidArgumentException(sprintf('The tranId property can only contain items of type \StructType\SearchColumnLongField, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->tranId[] = $item;
        return $this;
    }
}
