<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TaxAcct StructType
 * @subpackage Structs
 */
class TaxAcct extends Record
{
    /**
     * The name
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $name;
    /**
     * The description
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $description;
    /**
     * The nexus
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $nexus;
    /**
     * The country
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $country;
    /**
     * The taxAcctType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $taxAcctType;
    /**
     * The isInactive
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $isInactive;
    /**
     * The internalId
     * @var string
     */
    public $internalId;
    /**
     * The externalId
     * @var string
     */
    public $externalId;
    /**
     * Constructor method for TaxAcct
     * @uses TaxAcct::setName()
     * @uses TaxAcct::setDescription()
     * @uses TaxAcct::setNexus()
     * @uses TaxAcct::setCountry()
     * @uses TaxAcct::setTaxAcctType()
     * @uses TaxAcct::setIsInactive()
     * @uses TaxAcct::setInternalId()
     * @uses TaxAcct::setExternalId()
     * @param string $name
     * @param string $description
     * @param \StructType\RecordRef $nexus
     * @param string $country
     * @param string $taxAcctType
     * @param bool $isInactive
     * @param string $internalId
     * @param string $externalId
     */
    public function __construct($name = null, $description = null, \StructType\RecordRef $nexus = null, $country = null, $taxAcctType = null, $isInactive = null, $internalId = null, $externalId = null)
    {
        $this
            ->setName($name)
            ->setDescription($description)
            ->setNexus($nexus)
            ->setCountry($country)
            ->setTaxAcctType($taxAcctType)
            ->setIsInactive($isInactive)
            ->setInternalId($internalId)
            ->setExternalId($externalId);
    }
    /**
     * Get name value
     * @return string|null
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return \StructType\TaxAcct
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        $this->name = $name;
        return $this;
    }
    /**
     * Get description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return \StructType\TaxAcct
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        $this->description = $description;
        return $this;
    }
    /**
     * Get nexus value
     * @return \StructType\RecordRef|null
     */
    public function getNexus()
    {
        return $this->nexus;
    }
    /**
     * Set nexus value
     * @param \StructType\RecordRef $nexus
     * @return \StructType\TaxAcct
     */
    public function setNexus(\StructType\RecordRef $nexus = null)
    {
        $this->nexus = $nexus;
        return $this;
    }
    /**
     * Get country value
     * @return string|null
     */
    public function getCountry()
    {
        return $this->country;
    }
    /**
     * Set country value
     * @uses \EnumType\Country::valueIsValid()
     * @uses \EnumType\Country::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $country
     * @return \StructType\TaxAcct
     */
    public function setCountry($country = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\Country::valueIsValid($country)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\Country', is_array($country) ? implode(', ', $country) : var_export($country, true), implode(', ', \EnumType\Country::getValidValues())), __LINE__);
        }
        $this->country = $country;
        return $this;
    }
    /**
     * Get taxAcctType value
     * @return string|null
     */
    public function getTaxAcctType()
    {
        return $this->taxAcctType;
    }
    /**
     * Set taxAcctType value
     * @uses \EnumType\TaxAcctType::valueIsValid()
     * @uses \EnumType\TaxAcctType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $taxAcctType
     * @return \StructType\TaxAcct
     */
    public function setTaxAcctType($taxAcctType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\TaxAcctType::valueIsValid($taxAcctType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\TaxAcctType', is_array($taxAcctType) ? implode(', ', $taxAcctType) : var_export($taxAcctType, true), implode(', ', \EnumType\TaxAcctType::getValidValues())), __LINE__);
        }
        $this->taxAcctType = $taxAcctType;
        return $this;
    }
    /**
     * Get isInactive value
     * @return bool|null
     */
    public function getIsInactive()
    {
        return $this->isInactive;
    }
    /**
     * Set isInactive value
     * @param bool $isInactive
     * @return \StructType\TaxAcct
     */
    public function setIsInactive($isInactive = null)
    {
        // validation for constraint: boolean
        if (!is_null($isInactive) && !is_bool($isInactive)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isInactive, true), gettype($isInactive)), __LINE__);
        }
        $this->isInactive = $isInactive;
        return $this;
    }
    /**
     * Get internalId value
     * @return string|null
     */
    public function getInternalId()
    {
        return $this->internalId;
    }
    /**
     * Set internalId value
     * @param string $internalId
     * @return \StructType\TaxAcct
     */
    public function setInternalId($internalId = null)
    {
        // validation for constraint: string
        if (!is_null($internalId) && !is_string($internalId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($internalId, true), gettype($internalId)), __LINE__);
        }
        $this->internalId = $internalId;
        return $this;
    }
    /**
     * Get externalId value
     * @return string|null
     */
    public function getExternalId()
    {
        return $this->externalId;
    }
    /**
     * Set externalId value
     * @param string $externalId
     * @return \StructType\TaxAcct
     */
    public function setExternalId($externalId = null)
    {
        // validation for constraint: string
        if (!is_null($externalId) && !is_string($externalId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($externalId, true), gettype($externalId)), __LINE__);
        }
        $this->externalId = $externalId;
        return $this;
    }
}
