<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SupportCaseEscalateTo StructType
 * @subpackage Structs
 */
class SupportCaseEscalateTo extends AbstractStructBase
{
    /**
     * The escalatee
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $escalatee;
    /**
     * The email
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $email;
    /**
     * The phone
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $phone;
    /**
     * Constructor method for SupportCaseEscalateTo
     * @uses SupportCaseEscalateTo::setEscalatee()
     * @uses SupportCaseEscalateTo::setEmail()
     * @uses SupportCaseEscalateTo::setPhone()
     * @param \StructType\RecordRef $escalatee
     * @param string $email
     * @param string $phone
     */
    public function __construct(\StructType\RecordRef $escalatee = null, $email = null, $phone = null)
    {
        $this
            ->setEscalatee($escalatee)
            ->setEmail($email)
            ->setPhone($phone);
    }
    /**
     * Get escalatee value
     * @return \StructType\RecordRef|null
     */
    public function getEscalatee()
    {
        return $this->escalatee;
    }
    /**
     * Set escalatee value
     * @param \StructType\RecordRef $escalatee
     * @return \StructType\SupportCaseEscalateTo
     */
    public function setEscalatee(\StructType\RecordRef $escalatee = null)
    {
        $this->escalatee = $escalatee;
        return $this;
    }
    /**
     * Get email value
     * @return string|null
     */
    public function getEmail()
    {
        return $this->email;
    }
    /**
     * Set email value
     * @param string $email
     * @return \StructType\SupportCaseEscalateTo
     */
    public function setEmail($email = null)
    {
        // validation for constraint: string
        if (!is_null($email) && !is_string($email)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($email, true), gettype($email)), __LINE__);
        }
        $this->email = $email;
        return $this;
    }
    /**
     * Get phone value
     * @return string|null
     */
    public function getPhone()
    {
        return $this->phone;
    }
    /**
     * Set phone value
     * @param string $phone
     * @return \StructType\SupportCaseEscalateTo
     */
    public function setPhone($phone = null)
    {
        // validation for constraint: string
        if (!is_null($phone) && !is_string($phone)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($phone, true), gettype($phone)), __LINE__);
        }
        $this->phone = $phone;
        return $this;
    }
}
