<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SubsidiaryTaxRegistration StructType
 * @subpackage Structs
 */
class SubsidiaryTaxRegistration extends AbstractStructBase
{
    /**
     * The id
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $id;
    /**
     * The nexusCountry
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $nexusCountry;
    /**
     * The nexus
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $nexus;
    /**
     * The taxAgency
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $taxAgency;
    /**
     * The taxRegistrationNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $taxRegistrationNumber;
    /**
     * The taxEngine
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $taxEngine;
    /**
     * The effectiveFrom
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $effectiveFrom;
    /**
     * The validUntil
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $validUntil;
    /**
     * Constructor method for SubsidiaryTaxRegistration
     * @uses SubsidiaryTaxRegistration::setId()
     * @uses SubsidiaryTaxRegistration::setNexusCountry()
     * @uses SubsidiaryTaxRegistration::setNexus()
     * @uses SubsidiaryTaxRegistration::setTaxAgency()
     * @uses SubsidiaryTaxRegistration::setTaxRegistrationNumber()
     * @uses SubsidiaryTaxRegistration::setTaxEngine()
     * @uses SubsidiaryTaxRegistration::setEffectiveFrom()
     * @uses SubsidiaryTaxRegistration::setValidUntil()
     * @param int $id
     * @param string $nexusCountry
     * @param \StructType\RecordRef $nexus
     * @param \StructType\RecordRef $taxAgency
     * @param string $taxRegistrationNumber
     * @param \StructType\RecordRef $taxEngine
     * @param string $effectiveFrom
     * @param string $validUntil
     */
    public function __construct($id = null, $nexusCountry = null, \StructType\RecordRef $nexus = null, \StructType\RecordRef $taxAgency = null, $taxRegistrationNumber = null, \StructType\RecordRef $taxEngine = null, $effectiveFrom = null, $validUntil = null)
    {
        $this
            ->setId($id)
            ->setNexusCountry($nexusCountry)
            ->setNexus($nexus)
            ->setTaxAgency($taxAgency)
            ->setTaxRegistrationNumber($taxRegistrationNumber)
            ->setTaxEngine($taxEngine)
            ->setEffectiveFrom($effectiveFrom)
            ->setValidUntil($validUntil);
    }
    /**
     * Get id value
     * @return int|null
     */
    public function getId()
    {
        return $this->id;
    }
    /**
     * Set id value
     * @param int $id
     * @return \StructType\SubsidiaryTaxRegistration
     */
    public function setId($id = null)
    {
        // validation for constraint: int
        if (!is_null($id) && !(is_int($id) || ctype_digit($id))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($id, true), gettype($id)), __LINE__);
        }
        $this->id = $id;
        return $this;
    }
    /**
     * Get nexusCountry value
     * @return string|null
     */
    public function getNexusCountry()
    {
        return $this->nexusCountry;
    }
    /**
     * Set nexusCountry value
     * @uses \EnumType\Country::valueIsValid()
     * @uses \EnumType\Country::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $nexusCountry
     * @return \StructType\SubsidiaryTaxRegistration
     */
    public function setNexusCountry($nexusCountry = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\Country::valueIsValid($nexusCountry)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\Country', is_array($nexusCountry) ? implode(', ', $nexusCountry) : var_export($nexusCountry, true), implode(', ', \EnumType\Country::getValidValues())), __LINE__);
        }
        $this->nexusCountry = $nexusCountry;
        return $this;
    }
    /**
     * Get nexus value
     * @return \StructType\RecordRef|null
     */
    public function getNexus()
    {
        return $this->nexus;
    }
    /**
     * Set nexus value
     * @param \StructType\RecordRef $nexus
     * @return \StructType\SubsidiaryTaxRegistration
     */
    public function setNexus(\StructType\RecordRef $nexus = null)
    {
        $this->nexus = $nexus;
        return $this;
    }
    /**
     * Get taxAgency value
     * @return \StructType\RecordRef|null
     */
    public function getTaxAgency()
    {
        return $this->taxAgency;
    }
    /**
     * Set taxAgency value
     * @param \StructType\RecordRef $taxAgency
     * @return \StructType\SubsidiaryTaxRegistration
     */
    public function setTaxAgency(\StructType\RecordRef $taxAgency = null)
    {
        $this->taxAgency = $taxAgency;
        return $this;
    }
    /**
     * Get taxRegistrationNumber value
     * @return string|null
     */
    public function getTaxRegistrationNumber()
    {
        return $this->taxRegistrationNumber;
    }
    /**
     * Set taxRegistrationNumber value
     * @param string $taxRegistrationNumber
     * @return \StructType\SubsidiaryTaxRegistration
     */
    public function setTaxRegistrationNumber($taxRegistrationNumber = null)
    {
        // validation for constraint: string
        if (!is_null($taxRegistrationNumber) && !is_string($taxRegistrationNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($taxRegistrationNumber, true), gettype($taxRegistrationNumber)), __LINE__);
        }
        $this->taxRegistrationNumber = $taxRegistrationNumber;
        return $this;
    }
    /**
     * Get taxEngine value
     * @return \StructType\RecordRef|null
     */
    public function getTaxEngine()
    {
        return $this->taxEngine;
    }
    /**
     * Set taxEngine value
     * @param \StructType\RecordRef $taxEngine
     * @return \StructType\SubsidiaryTaxRegistration
     */
    public function setTaxEngine(\StructType\RecordRef $taxEngine = null)
    {
        $this->taxEngine = $taxEngine;
        return $this;
    }
    /**
     * Get effectiveFrom value
     * @return string|null
     */
    public function getEffectiveFrom()
    {
        return $this->effectiveFrom;
    }
    /**
     * Set effectiveFrom value
     * @param string $effectiveFrom
     * @return \StructType\SubsidiaryTaxRegistration
     */
    public function setEffectiveFrom($effectiveFrom = null)
    {
        // validation for constraint: string
        if (!is_null($effectiveFrom) && !is_string($effectiveFrom)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($effectiveFrom, true), gettype($effectiveFrom)), __LINE__);
        }
        $this->effectiveFrom = $effectiveFrom;
        return $this;
    }
    /**
     * Get validUntil value
     * @return string|null
     */
    public function getValidUntil()
    {
        return $this->validUntil;
    }
    /**
     * Set validUntil value
     * @param string $validUntil
     * @return \StructType\SubsidiaryTaxRegistration
     */
    public function setValidUntil($validUntil = null)
    {
        // validation for constraint: string
        if (!is_null($validUntil) && !is_string($validUntil)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($validUntil, true), gettype($validUntil)), __LINE__);
        }
        $this->validUntil = $validUntil;
        return $this;
    }
}
