<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SubsidiaryAccountingBookDetail StructType
 * @subpackage Structs
 */
class SubsidiaryAccountingBookDetail extends AbstractStructBase
{
    /**
     * The accountingBook
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $accountingBook;
    /**
     * The currency
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $currency;
    /**
     * The bookStatus
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $bookStatus;
    /**
     * Constructor method for SubsidiaryAccountingBookDetail
     * @uses SubsidiaryAccountingBookDetail::setAccountingBook()
     * @uses SubsidiaryAccountingBookDetail::setCurrency()
     * @uses SubsidiaryAccountingBookDetail::setBookStatus()
     * @param \StructType\RecordRef $accountingBook
     * @param \StructType\RecordRef $currency
     * @param string $bookStatus
     */
    public function __construct(\StructType\RecordRef $accountingBook = null, \StructType\RecordRef $currency = null, $bookStatus = null)
    {
        $this
            ->setAccountingBook($accountingBook)
            ->setCurrency($currency)
            ->setBookStatus($bookStatus);
    }
    /**
     * Get accountingBook value
     * @return \StructType\RecordRef|null
     */
    public function getAccountingBook()
    {
        return $this->accountingBook;
    }
    /**
     * Set accountingBook value
     * @param \StructType\RecordRef $accountingBook
     * @return \StructType\SubsidiaryAccountingBookDetail
     */
    public function setAccountingBook(\StructType\RecordRef $accountingBook = null)
    {
        $this->accountingBook = $accountingBook;
        return $this;
    }
    /**
     * Get currency value
     * @return \StructType\RecordRef|null
     */
    public function getCurrency()
    {
        return $this->currency;
    }
    /**
     * Set currency value
     * @param \StructType\RecordRef $currency
     * @return \StructType\SubsidiaryAccountingBookDetail
     */
    public function setCurrency(\StructType\RecordRef $currency = null)
    {
        $this->currency = $currency;
        return $this;
    }
    /**
     * Get bookStatus value
     * @return string|null
     */
    public function getBookStatus()
    {
        return $this->bookStatus;
    }
    /**
     * Set bookStatus value
     * @uses \EnumType\AccountingBookStatus::valueIsValid()
     * @uses \EnumType\AccountingBookStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $bookStatus
     * @return \StructType\SubsidiaryAccountingBookDetail
     */
    public function setBookStatus($bookStatus = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\AccountingBookStatus::valueIsValid($bookStatus)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\AccountingBookStatus', is_array($bookStatus) ? implode(', ', $bookStatus) : var_export($bookStatus, true), implode(', ', \EnumType\AccountingBookStatus::getValidValues())), __LINE__);
        }
        $this->bookStatus = $bookStatus;
        return $this;
    }
}
