<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SubscriptionsList StructType
 * @subpackage Structs
 */
class SubscriptionsList extends AbstractStructBase
{
    /**
     * The subscriptions
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Subscriptions[]
     */
    public $subscriptions;
    /**
     * The replaceAll
     * Meta information extracted from the WSDL
     * - default: true
     * @var bool
     */
    public $replaceAll;
    /**
     * Constructor method for SubscriptionsList
     * @uses SubscriptionsList::setSubscriptions()
     * @uses SubscriptionsList::setReplaceAll()
     * @param \StructType\Subscriptions[] $subscriptions
     * @param bool $replaceAll
     */
    public function __construct(array $subscriptions = array(), $replaceAll = true)
    {
        $this
            ->setSubscriptions($subscriptions)
            ->setReplaceAll($replaceAll);
    }
    /**
     * Get subscriptions value
     * @return \StructType\Subscriptions[]|null
     */
    public function getSubscriptions()
    {
        return $this->subscriptions;
    }
    /**
     * This method is responsible for validating the values passed to the setSubscriptions method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSubscriptions method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateSubscriptionsForArrayConstraintsFromSetSubscriptions(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $subscriptionsListSubscriptionsItem) {
            // validation for constraint: itemType
            if (!$subscriptionsListSubscriptionsItem instanceof \StructType\Subscriptions) {
                $invalidValues[] = is_object($subscriptionsListSubscriptionsItem) ? get_class($subscriptionsListSubscriptionsItem) : sprintf('%s(%s)', gettype($subscriptionsListSubscriptionsItem), var_export($subscriptionsListSubscriptionsItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The subscriptions property can only contain items of type \StructType\Subscriptions, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set subscriptions value
     * @throws \InvalidArgumentException
     * @param \StructType\Subscriptions[] $subscriptions
     * @return \StructType\SubscriptionsList
     */
    public function setSubscriptions(array $subscriptions = array())
    {
        // validation for constraint: array
        if ('' !== ($subscriptionsArrayErrorMessage = self::validateSubscriptionsForArrayConstraintsFromSetSubscriptions($subscriptions))) {
            throw new \InvalidArgumentException($subscriptionsArrayErrorMessage, __LINE__);
        }
        $this->subscriptions = $subscriptions;
        return $this;
    }
    /**
     * Add item to subscriptions value
     * @throws \InvalidArgumentException
     * @param \StructType\Subscriptions $item
     * @return \StructType\SubscriptionsList
     */
    public function addToSubscriptions(\StructType\Subscriptions $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Subscriptions) {
            throw new \InvalidArgumentException(sprintf('The subscriptions property can only contain items of type \StructType\Subscriptions, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->subscriptions[] = $item;
        return $this;
    }
    /**
     * Get replaceAll value
     * @return bool|null
     */
    public function getReplaceAll()
    {
        return $this->replaceAll;
    }
    /**
     * Set replaceAll value
     * @param bool $replaceAll
     * @return \StructType\SubscriptionsList
     */
    public function setReplaceAll($replaceAll = true)
    {
        // validation for constraint: boolean
        if (!is_null($replaceAll) && !is_bool($replaceAll)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($replaceAll, true), gettype($replaceAll)), __LINE__);
        }
        $this->replaceAll = $replaceAll;
        return $this;
    }
}
