<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Subscriptions StructType
 * @subpackage Structs
 */
class Subscriptions extends AbstractStructBase
{
    /**
     * The subscribed
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $subscribed;
    /**
     * The subscription
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $subscription;
    /**
     * The lastModifiedDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $lastModifiedDate;
    /**
     * Constructor method for Subscriptions
     * @uses Subscriptions::setSubscribed()
     * @uses Subscriptions::setSubscription()
     * @uses Subscriptions::setLastModifiedDate()
     * @param bool $subscribed
     * @param \StructType\RecordRef $subscription
     * @param string $lastModifiedDate
     */
    public function __construct($subscribed = null, \StructType\RecordRef $subscription = null, $lastModifiedDate = null)
    {
        $this
            ->setSubscribed($subscribed)
            ->setSubscription($subscription)
            ->setLastModifiedDate($lastModifiedDate);
    }
    /**
     * Get subscribed value
     * @return bool|null
     */
    public function getSubscribed()
    {
        return $this->subscribed;
    }
    /**
     * Set subscribed value
     * @param bool $subscribed
     * @return \StructType\Subscriptions
     */
    public function setSubscribed($subscribed = null)
    {
        // validation for constraint: boolean
        if (!is_null($subscribed) && !is_bool($subscribed)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($subscribed, true), gettype($subscribed)), __LINE__);
        }
        $this->subscribed = $subscribed;
        return $this;
    }
    /**
     * Get subscription value
     * @return \StructType\RecordRef|null
     */
    public function getSubscription()
    {
        return $this->subscription;
    }
    /**
     * Set subscription value
     * @param \StructType\RecordRef $subscription
     * @return \StructType\Subscriptions
     */
    public function setSubscription(\StructType\RecordRef $subscription = null)
    {
        $this->subscription = $subscription;
        return $this;
    }
    /**
     * Get lastModifiedDate value
     * @return string|null
     */
    public function getLastModifiedDate()
    {
        return $this->lastModifiedDate;
    }
    /**
     * Set lastModifiedDate value
     * @param string $lastModifiedDate
     * @return \StructType\Subscriptions
     */
    public function setLastModifiedDate($lastModifiedDate = null)
    {
        // validation for constraint: string
        if (!is_null($lastModifiedDate) && !is_string($lastModifiedDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lastModifiedDate, true), gettype($lastModifiedDate)), __LINE__);
        }
        $this->lastModifiedDate = $lastModifiedDate;
        return $this;
    }
}
