<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for StatisticalJournalEntryLine StructType
 * @subpackage Structs
 */
class StatisticalJournalEntryLine extends AbstractStructBase
{
    /**
     * The account
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $account;
    /**
     * The line
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $line;
    /**
     * The location
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $location;
    /**
     * The scheduleNum
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $scheduleNum;
    /**
     * The debit
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $debit;
    /**
     * The memo
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $memo;
    /**
     * The entity
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $entity;
    /**
     * The department
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $department;
    /**
     * The class
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $class;
    /**
     * The lineUnit
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $lineUnit;
    /**
     * The previewDebit
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $previewDebit;
    /**
     * The customFieldList
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\CustomFieldList
     */
    public $customFieldList;
    /**
     * Constructor method for StatisticalJournalEntryLine
     * @uses StatisticalJournalEntryLine::setAccount()
     * @uses StatisticalJournalEntryLine::setLine()
     * @uses StatisticalJournalEntryLine::setLocation()
     * @uses StatisticalJournalEntryLine::setScheduleNum()
     * @uses StatisticalJournalEntryLine::setDebit()
     * @uses StatisticalJournalEntryLine::setMemo()
     * @uses StatisticalJournalEntryLine::setEntity()
     * @uses StatisticalJournalEntryLine::setDepartment()
     * @uses StatisticalJournalEntryLine::setClass()
     * @uses StatisticalJournalEntryLine::setLineUnit()
     * @uses StatisticalJournalEntryLine::setPreviewDebit()
     * @uses StatisticalJournalEntryLine::setCustomFieldList()
     * @param \StructType\RecordRef $account
     * @param int $line
     * @param \StructType\RecordRef $location
     * @param \StructType\RecordRef $scheduleNum
     * @param float $debit
     * @param string $memo
     * @param \StructType\RecordRef $entity
     * @param \StructType\RecordRef $department
     * @param \StructType\RecordRef $class
     * @param \StructType\RecordRef $lineUnit
     * @param string $previewDebit
     * @param \StructType\CustomFieldList $customFieldList
     */
    public function __construct(\StructType\RecordRef $account = null, $line = null, \StructType\RecordRef $location = null, \StructType\RecordRef $scheduleNum = null, $debit = null, $memo = null, \StructType\RecordRef $entity = null, \StructType\RecordRef $department = null, \StructType\RecordRef $class = null, \StructType\RecordRef $lineUnit = null, $previewDebit = null, \StructType\CustomFieldList $customFieldList = null)
    {
        $this
            ->setAccount($account)
            ->setLine($line)
            ->setLocation($location)
            ->setScheduleNum($scheduleNum)
            ->setDebit($debit)
            ->setMemo($memo)
            ->setEntity($entity)
            ->setDepartment($department)
            ->setClass($class)
            ->setLineUnit($lineUnit)
            ->setPreviewDebit($previewDebit)
            ->setCustomFieldList($customFieldList);
    }
    /**
     * Get account value
     * @return \StructType\RecordRef|null
     */
    public function getAccount()
    {
        return $this->account;
    }
    /**
     * Set account value
     * @param \StructType\RecordRef $account
     * @return \StructType\StatisticalJournalEntryLine
     */
    public function setAccount(\StructType\RecordRef $account = null)
    {
        $this->account = $account;
        return $this;
    }
    /**
     * Get line value
     * @return int|null
     */
    public function getLine()
    {
        return $this->line;
    }
    /**
     * Set line value
     * @param int $line
     * @return \StructType\StatisticalJournalEntryLine
     */
    public function setLine($line = null)
    {
        // validation for constraint: int
        if (!is_null($line) && !(is_int($line) || ctype_digit($line))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($line, true), gettype($line)), __LINE__);
        }
        $this->line = $line;
        return $this;
    }
    /**
     * Get location value
     * @return \StructType\RecordRef|null
     */
    public function getLocation()
    {
        return $this->location;
    }
    /**
     * Set location value
     * @param \StructType\RecordRef $location
     * @return \StructType\StatisticalJournalEntryLine
     */
    public function setLocation(\StructType\RecordRef $location = null)
    {
        $this->location = $location;
        return $this;
    }
    /**
     * Get scheduleNum value
     * @return \StructType\RecordRef|null
     */
    public function getScheduleNum()
    {
        return $this->scheduleNum;
    }
    /**
     * Set scheduleNum value
     * @param \StructType\RecordRef $scheduleNum
     * @return \StructType\StatisticalJournalEntryLine
     */
    public function setScheduleNum(\StructType\RecordRef $scheduleNum = null)
    {
        $this->scheduleNum = $scheduleNum;
        return $this;
    }
    /**
     * Get debit value
     * @return float|null
     */
    public function getDebit()
    {
        return $this->debit;
    }
    /**
     * Set debit value
     * @param float $debit
     * @return \StructType\StatisticalJournalEntryLine
     */
    public function setDebit($debit = null)
    {
        // validation for constraint: float
        if (!is_null($debit) && !(is_float($debit) || is_numeric($debit))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($debit, true), gettype($debit)), __LINE__);
        }
        $this->debit = $debit;
        return $this;
    }
    /**
     * Get memo value
     * @return string|null
     */
    public function getMemo()
    {
        return $this->memo;
    }
    /**
     * Set memo value
     * @param string $memo
     * @return \StructType\StatisticalJournalEntryLine
     */
    public function setMemo($memo = null)
    {
        // validation for constraint: string
        if (!is_null($memo) && !is_string($memo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($memo, true), gettype($memo)), __LINE__);
        }
        $this->memo = $memo;
        return $this;
    }
    /**
     * Get entity value
     * @return \StructType\RecordRef|null
     */
    public function getEntity()
    {
        return $this->entity;
    }
    /**
     * Set entity value
     * @param \StructType\RecordRef $entity
     * @return \StructType\StatisticalJournalEntryLine
     */
    public function setEntity(\StructType\RecordRef $entity = null)
    {
        $this->entity = $entity;
        return $this;
    }
    /**
     * Get department value
     * @return \StructType\RecordRef|null
     */
    public function getDepartment()
    {
        return $this->department;
    }
    /**
     * Set department value
     * @param \StructType\RecordRef $department
     * @return \StructType\StatisticalJournalEntryLine
     */
    public function setDepartment(\StructType\RecordRef $department = null)
    {
        $this->department = $department;
        return $this;
    }
    /**
     * Get class value
     * @return \StructType\RecordRef|null
     */
    public function getClass()
    {
        return $this->class;
    }
    /**
     * Set class value
     * @param \StructType\RecordRef $class
     * @return \StructType\StatisticalJournalEntryLine
     */
    public function setClass(\StructType\RecordRef $class = null)
    {
        $this->class = $class;
        return $this;
    }
    /**
     * Get lineUnit value
     * @return \StructType\RecordRef|null
     */
    public function getLineUnit()
    {
        return $this->lineUnit;
    }
    /**
     * Set lineUnit value
     * @param \StructType\RecordRef $lineUnit
     * @return \StructType\StatisticalJournalEntryLine
     */
    public function setLineUnit(\StructType\RecordRef $lineUnit = null)
    {
        $this->lineUnit = $lineUnit;
        return $this;
    }
    /**
     * Get previewDebit value
     * @return string|null
     */
    public function getPreviewDebit()
    {
        return $this->previewDebit;
    }
    /**
     * Set previewDebit value
     * @param string $previewDebit
     * @return \StructType\StatisticalJournalEntryLine
     */
    public function setPreviewDebit($previewDebit = null)
    {
        // validation for constraint: string
        if (!is_null($previewDebit) && !is_string($previewDebit)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($previewDebit, true), gettype($previewDebit)), __LINE__);
        }
        $this->previewDebit = $previewDebit;
        return $this;
    }
    /**
     * Get customFieldList value
     * @return \StructType\CustomFieldList|null
     */
    public function getCustomFieldList()
    {
        return $this->customFieldList;
    }
    /**
     * Set customFieldList value
     * @param \StructType\CustomFieldList $customFieldList
     * @return \StructType\StatisticalJournalEntryLine
     */
    public function setCustomFieldList(\StructType\CustomFieldList $customFieldList = null)
    {
        $this->customFieldList = $customFieldList;
        return $this;
    }
}
