<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SolutionTopicsList StructType
 * @subpackage Structs
 */
class SolutionTopicsList extends AbstractStructBase
{
    /**
     * The topics
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SolutionTopics[]
     */
    public $topics;
    /**
     * The replaceAll
     * Meta information extracted from the WSDL
     * - default: true
     * @var bool
     */
    public $replaceAll;
    /**
     * Constructor method for SolutionTopicsList
     * @uses SolutionTopicsList::setTopics()
     * @uses SolutionTopicsList::setReplaceAll()
     * @param \StructType\SolutionTopics[] $topics
     * @param bool $replaceAll
     */
    public function __construct(array $topics = array(), $replaceAll = true)
    {
        $this
            ->setTopics($topics)
            ->setReplaceAll($replaceAll);
    }
    /**
     * Get topics value
     * @return \StructType\SolutionTopics[]|null
     */
    public function getTopics()
    {
        return $this->topics;
    }
    /**
     * This method is responsible for validating the values passed to the setTopics method
     * This method is willingly generated in order to preserve the one-line inline validation within the setTopics method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateTopicsForArrayConstraintsFromSetTopics(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $solutionTopicsListTopicsItem) {
            // validation for constraint: itemType
            if (!$solutionTopicsListTopicsItem instanceof \StructType\SolutionTopics) {
                $invalidValues[] = is_object($solutionTopicsListTopicsItem) ? get_class($solutionTopicsListTopicsItem) : sprintf('%s(%s)', gettype($solutionTopicsListTopicsItem), var_export($solutionTopicsListTopicsItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The topics property can only contain items of type \StructType\SolutionTopics, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set topics value
     * @throws \InvalidArgumentException
     * @param \StructType\SolutionTopics[] $topics
     * @return \StructType\SolutionTopicsList
     */
    public function setTopics(array $topics = array())
    {
        // validation for constraint: array
        if ('' !== ($topicsArrayErrorMessage = self::validateTopicsForArrayConstraintsFromSetTopics($topics))) {
            throw new \InvalidArgumentException($topicsArrayErrorMessage, __LINE__);
        }
        $this->topics = $topics;
        return $this;
    }
    /**
     * Add item to topics value
     * @throws \InvalidArgumentException
     * @param \StructType\SolutionTopics $item
     * @return \StructType\SolutionTopicsList
     */
    public function addToTopics(\StructType\SolutionTopics $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SolutionTopics) {
            throw new \InvalidArgumentException(sprintf('The topics property can only contain items of type \StructType\SolutionTopics, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->topics[] = $item;
        return $this;
    }
    /**
     * Get replaceAll value
     * @return bool|null
     */
    public function getReplaceAll()
    {
        return $this->replaceAll;
    }
    /**
     * Set replaceAll value
     * @param bool $replaceAll
     * @return \StructType\SolutionTopicsList
     */
    public function setReplaceAll($replaceAll = true)
    {
        // validation for constraint: boolean
        if (!is_null($replaceAll) && !is_bool($replaceAll)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($replaceAll, true), gettype($replaceAll)), __LINE__);
        }
        $this->replaceAll = $replaceAll;
        return $this;
    }
}
