<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SolutionSearch StructType
 * @subpackage Structs
 */
class SolutionSearch extends SearchRecord
{
    /**
     * The basic
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\SolutionSearchBasic
     */
    public $basic;
    /**
     * The caseJoin
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\SupportCaseSearchBasic
     */
    public $caseJoin;
    /**
     * The relatedSolutionJoin
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\SolutionSearchBasic
     */
    public $relatedSolutionJoin;
    /**
     * The topicJoin
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\TopicSearchBasic
     */
    public $topicJoin;
    /**
     * The userJoin
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\EmployeeSearchBasic
     */
    public $userJoin;
    /**
     * The userNotesJoin
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\NoteSearchBasic
     */
    public $userNotesJoin;
    /**
     * The customSearchJoin
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\CustomSearchJoin[]
     */
    public $customSearchJoin;
    /**
     * Constructor method for SolutionSearch
     * @uses SolutionSearch::setBasic()
     * @uses SolutionSearch::setCaseJoin()
     * @uses SolutionSearch::setRelatedSolutionJoin()
     * @uses SolutionSearch::setTopicJoin()
     * @uses SolutionSearch::setUserJoin()
     * @uses SolutionSearch::setUserNotesJoin()
     * @uses SolutionSearch::setCustomSearchJoin()
     * @param \StructType\SolutionSearchBasic $basic
     * @param \StructType\SupportCaseSearchBasic $caseJoin
     * @param \StructType\SolutionSearchBasic $relatedSolutionJoin
     * @param \StructType\TopicSearchBasic $topicJoin
     * @param \StructType\EmployeeSearchBasic $userJoin
     * @param \StructType\NoteSearchBasic $userNotesJoin
     * @param \StructType\CustomSearchJoin[] $customSearchJoin
     */
    public function __construct(\StructType\SolutionSearchBasic $basic = null, \StructType\SupportCaseSearchBasic $caseJoin = null, \StructType\SolutionSearchBasic $relatedSolutionJoin = null, \StructType\TopicSearchBasic $topicJoin = null, \StructType\EmployeeSearchBasic $userJoin = null, \StructType\NoteSearchBasic $userNotesJoin = null, array $customSearchJoin = array())
    {
        $this
            ->setBasic($basic)
            ->setCaseJoin($caseJoin)
            ->setRelatedSolutionJoin($relatedSolutionJoin)
            ->setTopicJoin($topicJoin)
            ->setUserJoin($userJoin)
            ->setUserNotesJoin($userNotesJoin)
            ->setCustomSearchJoin($customSearchJoin);
    }
    /**
     * Get basic value
     * @return \StructType\SolutionSearchBasic|null
     */
    public function getBasic()
    {
        return $this->basic;
    }
    /**
     * Set basic value
     * @param \StructType\SolutionSearchBasic $basic
     * @return \StructType\SolutionSearch
     */
    public function setBasic(\StructType\SolutionSearchBasic $basic = null)
    {
        $this->basic = $basic;
        return $this;
    }
    /**
     * Get caseJoin value
     * @return \StructType\SupportCaseSearchBasic|null
     */
    public function getCaseJoin()
    {
        return $this->caseJoin;
    }
    /**
     * Set caseJoin value
     * @param \StructType\SupportCaseSearchBasic $caseJoin
     * @return \StructType\SolutionSearch
     */
    public function setCaseJoin(\StructType\SupportCaseSearchBasic $caseJoin = null)
    {
        $this->caseJoin = $caseJoin;
        return $this;
    }
    /**
     * Get relatedSolutionJoin value
     * @return \StructType\SolutionSearchBasic|null
     */
    public function getRelatedSolutionJoin()
    {
        return $this->relatedSolutionJoin;
    }
    /**
     * Set relatedSolutionJoin value
     * @param \StructType\SolutionSearchBasic $relatedSolutionJoin
     * @return \StructType\SolutionSearch
     */
    public function setRelatedSolutionJoin(\StructType\SolutionSearchBasic $relatedSolutionJoin = null)
    {
        $this->relatedSolutionJoin = $relatedSolutionJoin;
        return $this;
    }
    /**
     * Get topicJoin value
     * @return \StructType\TopicSearchBasic|null
     */
    public function getTopicJoin()
    {
        return $this->topicJoin;
    }
    /**
     * Set topicJoin value
     * @param \StructType\TopicSearchBasic $topicJoin
     * @return \StructType\SolutionSearch
     */
    public function setTopicJoin(\StructType\TopicSearchBasic $topicJoin = null)
    {
        $this->topicJoin = $topicJoin;
        return $this;
    }
    /**
     * Get userJoin value
     * @return \StructType\EmployeeSearchBasic|null
     */
    public function getUserJoin()
    {
        return $this->userJoin;
    }
    /**
     * Set userJoin value
     * @param \StructType\EmployeeSearchBasic $userJoin
     * @return \StructType\SolutionSearch
     */
    public function setUserJoin(\StructType\EmployeeSearchBasic $userJoin = null)
    {
        $this->userJoin = $userJoin;
        return $this;
    }
    /**
     * Get userNotesJoin value
     * @return \StructType\NoteSearchBasic|null
     */
    public function getUserNotesJoin()
    {
        return $this->userNotesJoin;
    }
    /**
     * Set userNotesJoin value
     * @param \StructType\NoteSearchBasic $userNotesJoin
     * @return \StructType\SolutionSearch
     */
    public function setUserNotesJoin(\StructType\NoteSearchBasic $userNotesJoin = null)
    {
        $this->userNotesJoin = $userNotesJoin;
        return $this;
    }
    /**
     * Get customSearchJoin value
     * @return \StructType\CustomSearchJoin[]|null
     */
    public function getCustomSearchJoin()
    {
        return $this->customSearchJoin;
    }
    /**
     * This method is responsible for validating the values passed to the setCustomSearchJoin method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCustomSearchJoin method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCustomSearchJoinForArrayConstraintsFromSetCustomSearchJoin(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $solutionSearchCustomSearchJoinItem) {
            // validation for constraint: itemType
            if (!$solutionSearchCustomSearchJoinItem instanceof \StructType\CustomSearchJoin) {
                $invalidValues[] = is_object($solutionSearchCustomSearchJoinItem) ? get_class($solutionSearchCustomSearchJoinItem) : sprintf('%s(%s)', gettype($solutionSearchCustomSearchJoinItem), var_export($solutionSearchCustomSearchJoinItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The customSearchJoin property can only contain items of type \StructType\CustomSearchJoin, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set customSearchJoin value
     * @throws \InvalidArgumentException
     * @param \StructType\CustomSearchJoin[] $customSearchJoin
     * @return \StructType\SolutionSearch
     */
    public function setCustomSearchJoin(array $customSearchJoin = array())
    {
        // validation for constraint: array
        if ('' !== ($customSearchJoinArrayErrorMessage = self::validateCustomSearchJoinForArrayConstraintsFromSetCustomSearchJoin($customSearchJoin))) {
            throw new \InvalidArgumentException($customSearchJoinArrayErrorMessage, __LINE__);
        }
        $this->customSearchJoin = $customSearchJoin;
        return $this;
    }
    /**
     * Add item to customSearchJoin value
     * @throws \InvalidArgumentException
     * @param \StructType\CustomSearchJoin $item
     * @return \StructType\SolutionSearch
     */
    public function addToCustomSearchJoin(\StructType\CustomSearchJoin $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\CustomSearchJoin) {
            throw new \InvalidArgumentException(sprintf('The customSearchJoin property can only contain items of type \StructType\CustomSearchJoin, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->customSearchJoin[] = $item;
        return $this;
    }
}
