<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Solution StructType
 * Meta information extracted from the WSDL
 * - type: listSupport:Solution
 * @subpackage Structs
 */
class Solution extends Record
{
    /**
     * The customForm
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $customForm;
    /**
     * The solutionCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $solutionCode;
    /**
     * The title
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $title;
    /**
     * The message
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $message;
    /**
     * The status
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $status;
    /**
     * The displayOnline
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $displayOnline;
    /**
     * The assigned
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $assigned;
    /**
     * The isInactive
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $isInactive;
    /**
     * The longDescription
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $longDescription;
    /**
     * The topicsList
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\SolutionTopicsList
     */
    public $topicsList;
    /**
     * The createdDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $createdDate;
    /**
     * The lastModifiedDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $lastModifiedDate;
    /**
     * The solutionsList
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\SolutionsList
     */
    public $solutionsList;
    /**
     * The customFieldList
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\CustomFieldList
     */
    public $customFieldList;
    /**
     * The internalId
     * @var string
     */
    public $internalId;
    /**
     * The externalId
     * @var string
     */
    public $externalId;
    /**
     * Constructor method for Solution
     * @uses Solution::setCustomForm()
     * @uses Solution::setSolutionCode()
     * @uses Solution::setTitle()
     * @uses Solution::setMessage()
     * @uses Solution::setStatus()
     * @uses Solution::setDisplayOnline()
     * @uses Solution::setAssigned()
     * @uses Solution::setIsInactive()
     * @uses Solution::setLongDescription()
     * @uses Solution::setTopicsList()
     * @uses Solution::setCreatedDate()
     * @uses Solution::setLastModifiedDate()
     * @uses Solution::setSolutionsList()
     * @uses Solution::setCustomFieldList()
     * @uses Solution::setInternalId()
     * @uses Solution::setExternalId()
     * @param \StructType\RecordRef $customForm
     * @param string $solutionCode
     * @param string $title
     * @param string $message
     * @param string $status
     * @param bool $displayOnline
     * @param \StructType\RecordRef $assigned
     * @param bool $isInactive
     * @param string $longDescription
     * @param \StructType\SolutionTopicsList $topicsList
     * @param string $createdDate
     * @param string $lastModifiedDate
     * @param \StructType\SolutionsList $solutionsList
     * @param \StructType\CustomFieldList $customFieldList
     * @param string $internalId
     * @param string $externalId
     */
    public function __construct(\StructType\RecordRef $customForm = null, $solutionCode = null, $title = null, $message = null, $status = null, $displayOnline = null, \StructType\RecordRef $assigned = null, $isInactive = null, $longDescription = null, \StructType\SolutionTopicsList $topicsList = null, $createdDate = null, $lastModifiedDate = null, \StructType\SolutionsList $solutionsList = null, \StructType\CustomFieldList $customFieldList = null, $internalId = null, $externalId = null)
    {
        $this
            ->setCustomForm($customForm)
            ->setSolutionCode($solutionCode)
            ->setTitle($title)
            ->setMessage($message)
            ->setStatus($status)
            ->setDisplayOnline($displayOnline)
            ->setAssigned($assigned)
            ->setIsInactive($isInactive)
            ->setLongDescription($longDescription)
            ->setTopicsList($topicsList)
            ->setCreatedDate($createdDate)
            ->setLastModifiedDate($lastModifiedDate)
            ->setSolutionsList($solutionsList)
            ->setCustomFieldList($customFieldList)
            ->setInternalId($internalId)
            ->setExternalId($externalId);
    }
    /**
     * Get customForm value
     * @return \StructType\RecordRef|null
     */
    public function getCustomForm()
    {
        return $this->customForm;
    }
    /**
     * Set customForm value
     * @param \StructType\RecordRef $customForm
     * @return \StructType\Solution
     */
    public function setCustomForm(\StructType\RecordRef $customForm = null)
    {
        $this->customForm = $customForm;
        return $this;
    }
    /**
     * Get solutionCode value
     * @return string|null
     */
    public function getSolutionCode()
    {
        return $this->solutionCode;
    }
    /**
     * Set solutionCode value
     * @param string $solutionCode
     * @return \StructType\Solution
     */
    public function setSolutionCode($solutionCode = null)
    {
        // validation for constraint: string
        if (!is_null($solutionCode) && !is_string($solutionCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($solutionCode, true), gettype($solutionCode)), __LINE__);
        }
        $this->solutionCode = $solutionCode;
        return $this;
    }
    /**
     * Get title value
     * @return string|null
     */
    public function getTitle()
    {
        return $this->title;
    }
    /**
     * Set title value
     * @param string $title
     * @return \StructType\Solution
     */
    public function setTitle($title = null)
    {
        // validation for constraint: string
        if (!is_null($title) && !is_string($title)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($title, true), gettype($title)), __LINE__);
        }
        $this->title = $title;
        return $this;
    }
    /**
     * Get message value
     * @return string|null
     */
    public function getMessage()
    {
        return $this->message;
    }
    /**
     * Set message value
     * @param string $message
     * @return \StructType\Solution
     */
    public function setMessage($message = null)
    {
        // validation for constraint: string
        if (!is_null($message) && !is_string($message)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($message, true), gettype($message)), __LINE__);
        }
        $this->message = $message;
        return $this;
    }
    /**
     * Get status value
     * @return string|null
     */
    public function getStatus()
    {
        return $this->status;
    }
    /**
     * Set status value
     * @uses \EnumType\SolutionStatus::valueIsValid()
     * @uses \EnumType\SolutionStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $status
     * @return \StructType\Solution
     */
    public function setStatus($status = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\SolutionStatus::valueIsValid($status)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\SolutionStatus', is_array($status) ? implode(', ', $status) : var_export($status, true), implode(', ', \EnumType\SolutionStatus::getValidValues())), __LINE__);
        }
        $this->status = $status;
        return $this;
    }
    /**
     * Get displayOnline value
     * @return bool|null
     */
    public function getDisplayOnline()
    {
        return $this->displayOnline;
    }
    /**
     * Set displayOnline value
     * @param bool $displayOnline
     * @return \StructType\Solution
     */
    public function setDisplayOnline($displayOnline = null)
    {
        // validation for constraint: boolean
        if (!is_null($displayOnline) && !is_bool($displayOnline)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($displayOnline, true), gettype($displayOnline)), __LINE__);
        }
        $this->displayOnline = $displayOnline;
        return $this;
    }
    /**
     * Get assigned value
     * @return \StructType\RecordRef|null
     */
    public function getAssigned()
    {
        return $this->assigned;
    }
    /**
     * Set assigned value
     * @param \StructType\RecordRef $assigned
     * @return \StructType\Solution
     */
    public function setAssigned(\StructType\RecordRef $assigned = null)
    {
        $this->assigned = $assigned;
        return $this;
    }
    /**
     * Get isInactive value
     * @return bool|null
     */
    public function getIsInactive()
    {
        return $this->isInactive;
    }
    /**
     * Set isInactive value
     * @param bool $isInactive
     * @return \StructType\Solution
     */
    public function setIsInactive($isInactive = null)
    {
        // validation for constraint: boolean
        if (!is_null($isInactive) && !is_bool($isInactive)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isInactive, true), gettype($isInactive)), __LINE__);
        }
        $this->isInactive = $isInactive;
        return $this;
    }
    /**
     * Get longDescription value
     * @return string|null
     */
    public function getLongDescription()
    {
        return $this->longDescription;
    }
    /**
     * Set longDescription value
     * @param string $longDescription
     * @return \StructType\Solution
     */
    public function setLongDescription($longDescription = null)
    {
        // validation for constraint: string
        if (!is_null($longDescription) && !is_string($longDescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($longDescription, true), gettype($longDescription)), __LINE__);
        }
        $this->longDescription = $longDescription;
        return $this;
    }
    /**
     * Get topicsList value
     * @return \StructType\SolutionTopicsList|null
     */
    public function getTopicsList()
    {
        return $this->topicsList;
    }
    /**
     * Set topicsList value
     * @param \StructType\SolutionTopicsList $topicsList
     * @return \StructType\Solution
     */
    public function setTopicsList(\StructType\SolutionTopicsList $topicsList = null)
    {
        $this->topicsList = $topicsList;
        return $this;
    }
    /**
     * Get createdDate value
     * @return string|null
     */
    public function getCreatedDate()
    {
        return $this->createdDate;
    }
    /**
     * Set createdDate value
     * @param string $createdDate
     * @return \StructType\Solution
     */
    public function setCreatedDate($createdDate = null)
    {
        // validation for constraint: string
        if (!is_null($createdDate) && !is_string($createdDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($createdDate, true), gettype($createdDate)), __LINE__);
        }
        $this->createdDate = $createdDate;
        return $this;
    }
    /**
     * Get lastModifiedDate value
     * @return string|null
     */
    public function getLastModifiedDate()
    {
        return $this->lastModifiedDate;
    }
    /**
     * Set lastModifiedDate value
     * @param string $lastModifiedDate
     * @return \StructType\Solution
     */
    public function setLastModifiedDate($lastModifiedDate = null)
    {
        // validation for constraint: string
        if (!is_null($lastModifiedDate) && !is_string($lastModifiedDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lastModifiedDate, true), gettype($lastModifiedDate)), __LINE__);
        }
        $this->lastModifiedDate = $lastModifiedDate;
        return $this;
    }
    /**
     * Get solutionsList value
     * @return \StructType\SolutionsList|null
     */
    public function getSolutionsList()
    {
        return $this->solutionsList;
    }
    /**
     * Set solutionsList value
     * @param \StructType\SolutionsList $solutionsList
     * @return \StructType\Solution
     */
    public function setSolutionsList(\StructType\SolutionsList $solutionsList = null)
    {
        $this->solutionsList = $solutionsList;
        return $this;
    }
    /**
     * Get customFieldList value
     * @return \StructType\CustomFieldList|null
     */
    public function getCustomFieldList()
    {
        return $this->customFieldList;
    }
    /**
     * Set customFieldList value
     * @param \StructType\CustomFieldList $customFieldList
     * @return \StructType\Solution
     */
    public function setCustomFieldList(\StructType\CustomFieldList $customFieldList = null)
    {
        $this->customFieldList = $customFieldList;
        return $this;
    }
    /**
     * Get internalId value
     * @return string|null
     */
    public function getInternalId()
    {
        return $this->internalId;
    }
    /**
     * Set internalId value
     * @param string $internalId
     * @return \StructType\Solution
     */
    public function setInternalId($internalId = null)
    {
        // validation for constraint: string
        if (!is_null($internalId) && !is_string($internalId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($internalId, true), gettype($internalId)), __LINE__);
        }
        $this->internalId = $internalId;
        return $this;
    }
    /**
     * Get externalId value
     * @return string|null
     */
    public function getExternalId()
    {
        return $this->externalId;
    }
    /**
     * Set externalId value
     * @param string $externalId
     * @return \StructType\Solution
     */
    public function setExternalId($externalId = null)
    {
        // validation for constraint: string
        if (!is_null($externalId) && !is_string($externalId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($externalId, true), gettype($externalId)), __LINE__);
        }
        $this->externalId = $externalId;
        return $this;
    }
}
