<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SessionResponse StructType
 * @subpackage Structs
 */
class SessionResponse extends AbstractStructBase
{
    /**
     * The status
     * Meta information extracted from the WSDL
     * - ref: platformCore:status
     * @var \StructType\Status
     */
    public $status;
    /**
     * The userId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $userId;
    /**
     * The wsRoleList
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - ref: platformCore:wsRoleList
     * @var \StructType\WsRoleList
     */
    public $wsRoleList;
    /**
     * Constructor method for SessionResponse
     * @uses SessionResponse::setStatus()
     * @uses SessionResponse::setUserId()
     * @uses SessionResponse::setWsRoleList()
     * @param \StructType\Status $status
     * @param \StructType\RecordRef $userId
     * @param \StructType\WsRoleList $wsRoleList
     */
    public function __construct(\StructType\Status $status = null, \StructType\RecordRef $userId = null, \StructType\WsRoleList $wsRoleList = null)
    {
        $this
            ->setStatus($status)
            ->setUserId($userId)
            ->setWsRoleList($wsRoleList);
    }
    /**
     * Get status value
     * @return \StructType\Status|null
     */
    public function getStatus()
    {
        return $this->status;
    }
    /**
     * Set status value
     * @param \StructType\Status $status
     * @return \StructType\SessionResponse
     */
    public function setStatus(\StructType\Status $status = null)
    {
        $this->status = $status;
        return $this;
    }
    /**
     * Get userId value
     * @return \StructType\RecordRef|null
     */
    public function getUserId()
    {
        return $this->userId;
    }
    /**
     * Set userId value
     * @param \StructType\RecordRef $userId
     * @return \StructType\SessionResponse
     */
    public function setUserId(\StructType\RecordRef $userId = null)
    {
        $this->userId = $userId;
        return $this;
    }
    /**
     * Get wsRoleList value
     * @return \StructType\WsRoleList|null
     */
    public function getWsRoleList()
    {
        return $this->wsRoleList;
    }
    /**
     * Set wsRoleList value
     * @param \StructType\WsRoleList $wsRoleList
     * @return \StructType\SessionResponse
     */
    public function setWsRoleList(\StructType\WsRoleList $wsRoleList = null)
    {
        $this->wsRoleList = $wsRoleList;
        return $this;
    }
}
