<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ServiceSaleItem StructType
 * Meta information extracted from the WSDL
 * - type: listAcct:ServiceSaleItem
 * @subpackage Structs
 */
class ServiceSaleItem extends Record
{
    /**
     * The createdDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $createdDate;
    /**
     * The lastModifiedDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $lastModifiedDate;
    /**
     * The salesDescription
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $salesDescription;
    /**
     * The includeChildren
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $includeChildren;
    /**
     * The incomeAccount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $incomeAccount;
    /**
     * The isTaxable
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $isTaxable;
    /**
     * The matrixType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $matrixType;
    /**
     * The taxSchedule
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $taxSchedule;
    /**
     * The costEstimateType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $costEstimateType;
    /**
     * The costEstimate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $costEstimate;
    /**
     * The unitsType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $unitsType;
    /**
     * The saleUnit
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $saleUnit;
    /**
     * The issueProduct
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $issueProduct;
    /**
     * The costEstimateUnits
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $costEstimateUnits;
    /**
     * The billingSchedule
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $billingSchedule;
    /**
     * The deferredRevenueAccount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $deferredRevenueAccount;
    /**
     * The revRecSchedule
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $revRecSchedule;
    /**
     * The minimumQuantity
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $minimumQuantity;
    /**
     * The enforceMinQtyInternally
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $enforceMinQtyInternally;
    /**
     * The maximumQuantity
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $maximumQuantity;
    /**
     * The softDescriptor
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $softDescriptor;
    /**
     * The pricesIncludeTax
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $pricesIncludeTax;
    /**
     * The quantityPricingSchedule
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $quantityPricingSchedule;
    /**
     * The useMarginalRates
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $useMarginalRates;
    /**
     * The overallQuantityPricingType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $overallQuantityPricingType;
    /**
     * The isFulfillable
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $isFulfillable;
    /**
     * The costCategory
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $costCategory;
    /**
     * The pricingGroup
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $pricingGroup;
    /**
     * The minimumQuantityUnits
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $minimumQuantityUnits;
    /**
     * The vsoePrice
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $vsoePrice;
    /**
     * The vsoeSopGroup
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $vsoeSopGroup;
    /**
     * The vsoeDeferral
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $vsoeDeferral;
    /**
     * The vsoePermitDiscount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $vsoePermitDiscount;
    /**
     * The vsoeDelivered
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $vsoeDelivered;
    /**
     * The itemRevenueCategory
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $itemRevenueCategory;
    /**
     * The deferRevRec
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $deferRevRec;
    /**
     * The revenueRecognitionRule
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $revenueRecognitionRule;
    /**
     * The revRecForecastRule
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $revRecForecastRule;
    /**
     * The revenueAllocationGroup
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $revenueAllocationGroup;
    /**
     * The createRevenuePlansOn
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $createRevenuePlansOn;
    /**
     * The directRevenuePosting
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $directRevenuePosting;
    /**
     * The contingentRevenueHandling
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $contingentRevenueHandling;
    /**
     * The revReclassFXAccount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $revReclassFXAccount;
    /**
     * The createJob
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $createJob;
    /**
     * The matrixItemNameTemplate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $matrixItemNameTemplate;
    /**
     * The storeDisplayName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $storeDisplayName;
    /**
     * The storeDisplayThumbnail
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $storeDisplayThumbnail;
    /**
     * The storeDisplayImage
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $storeDisplayImage;
    /**
     * The storeDescription
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $storeDescription;
    /**
     * The storeDetailedDescription
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $storeDetailedDescription;
    /**
     * The storeItemTemplate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $storeItemTemplate;
    /**
     * The pageTitle
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $pageTitle;
    /**
     * The urlComponent
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $urlComponent;
    /**
     * The metaTagHtml
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $metaTagHtml;
    /**
     * The excludeFromSitemap
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $excludeFromSitemap;
    /**
     * The sitemapPriority
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $sitemapPriority;
    /**
     * The searchKeywords
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $searchKeywords;
    /**
     * The isDonationItem
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $isDonationItem;
    /**
     * The showDefaultDonationAmount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $showDefaultDonationAmount;
    /**
     * The maxDonationAmount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $maxDonationAmount;
    /**
     * The dontShowPrice
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $dontShowPrice;
    /**
     * The noPriceMessage
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $noPriceMessage;
    /**
     * The outOfStockMessage
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $outOfStockMessage;
    /**
     * The onSpecial
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $onSpecial;
    /**
     * The outOfStockBehavior
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $outOfStockBehavior;
    /**
     * The relatedItemsDescription
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $relatedItemsDescription;
    /**
     * The specialsDescription
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $specialsDescription;
    /**
     * The itemTaskTemplatesList
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\ServiceItemTaskTemplatesList
     */
    public $itemTaskTemplatesList;
    /**
     * The featuredDescription
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $featuredDescription;
    /**
     * The customForm
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $customForm;
    /**
     * The itemId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $itemId;
    /**
     * The upcCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $upcCode;
    /**
     * The displayName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $displayName;
    /**
     * The parent
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $parent;
    /**
     * The isOnline
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $isOnline;
    /**
     * The isGcoCompliant
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $isGcoCompliant;
    /**
     * The offerSupport
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $offerSupport;
    /**
     * The isInactive
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $isInactive;
    /**
     * The availableToPartners
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $availableToPartners;
    /**
     * The department
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $department;
    /**
     * The class
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $class;
    /**
     * The location
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $location;
    /**
     * The subsidiaryList
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRefList
     */
    public $subsidiaryList;
    /**
     * The billingRatesMatrix
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\BillingRatesMatrix
     */
    public $billingRatesMatrix;
    /**
     * The accountingBookDetailList
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\ItemAccountingBookDetailList
     */
    public $accountingBookDetailList;
    /**
     * The itemOptionsList
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\ItemOptionsList
     */
    public $itemOptionsList;
    /**
     * The matrixOptionList
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\MatrixOptionList
     */
    public $matrixOptionList;
    /**
     * The pricingMatrix
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\PricingMatrix
     */
    public $pricingMatrix;
    /**
     * The purchaseTaxCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $purchaseTaxCode;
    /**
     * The rate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $rate;
    /**
     * The salesTaxCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $salesTaxCode;
    /**
     * The siteCategoryList
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\SiteCategoryList
     */
    public $siteCategoryList;
    /**
     * The translationsList
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\TranslationList
     */
    public $translationsList;
    /**
     * The presentationItemList
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\PresentationItemList
     */
    public $presentationItemList;
    /**
     * The hierarchyVersionsList
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\ServiceSaleItemHierarchyVersionsList
     */
    public $hierarchyVersionsList;
    /**
     * The consumptionUnit
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $consumptionUnit;
    /**
     * The customFieldList
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\CustomFieldList
     */
    public $customFieldList;
    /**
     * The internalId
     * @var string
     */
    public $internalId;
    /**
     * The externalId
     * @var string
     */
    public $externalId;
    /**
     * Constructor method for ServiceSaleItem
     * @uses ServiceSaleItem::setCreatedDate()
     * @uses ServiceSaleItem::setLastModifiedDate()
     * @uses ServiceSaleItem::setSalesDescription()
     * @uses ServiceSaleItem::setIncludeChildren()
     * @uses ServiceSaleItem::setIncomeAccount()
     * @uses ServiceSaleItem::setIsTaxable()
     * @uses ServiceSaleItem::setMatrixType()
     * @uses ServiceSaleItem::setTaxSchedule()
     * @uses ServiceSaleItem::setCostEstimateType()
     * @uses ServiceSaleItem::setCostEstimate()
     * @uses ServiceSaleItem::setUnitsType()
     * @uses ServiceSaleItem::setSaleUnit()
     * @uses ServiceSaleItem::setIssueProduct()
     * @uses ServiceSaleItem::setCostEstimateUnits()
     * @uses ServiceSaleItem::setBillingSchedule()
     * @uses ServiceSaleItem::setDeferredRevenueAccount()
     * @uses ServiceSaleItem::setRevRecSchedule()
     * @uses ServiceSaleItem::setMinimumQuantity()
     * @uses ServiceSaleItem::setEnforceMinQtyInternally()
     * @uses ServiceSaleItem::setMaximumQuantity()
     * @uses ServiceSaleItem::setSoftDescriptor()
     * @uses ServiceSaleItem::setPricesIncludeTax()
     * @uses ServiceSaleItem::setQuantityPricingSchedule()
     * @uses ServiceSaleItem::setUseMarginalRates()
     * @uses ServiceSaleItem::setOverallQuantityPricingType()
     * @uses ServiceSaleItem::setIsFulfillable()
     * @uses ServiceSaleItem::setCostCategory()
     * @uses ServiceSaleItem::setPricingGroup()
     * @uses ServiceSaleItem::setMinimumQuantityUnits()
     * @uses ServiceSaleItem::setVsoePrice()
     * @uses ServiceSaleItem::setVsoeSopGroup()
     * @uses ServiceSaleItem::setVsoeDeferral()
     * @uses ServiceSaleItem::setVsoePermitDiscount()
     * @uses ServiceSaleItem::setVsoeDelivered()
     * @uses ServiceSaleItem::setItemRevenueCategory()
     * @uses ServiceSaleItem::setDeferRevRec()
     * @uses ServiceSaleItem::setRevenueRecognitionRule()
     * @uses ServiceSaleItem::setRevRecForecastRule()
     * @uses ServiceSaleItem::setRevenueAllocationGroup()
     * @uses ServiceSaleItem::setCreateRevenuePlansOn()
     * @uses ServiceSaleItem::setDirectRevenuePosting()
     * @uses ServiceSaleItem::setContingentRevenueHandling()
     * @uses ServiceSaleItem::setRevReclassFXAccount()
     * @uses ServiceSaleItem::setCreateJob()
     * @uses ServiceSaleItem::setMatrixItemNameTemplate()
     * @uses ServiceSaleItem::setStoreDisplayName()
     * @uses ServiceSaleItem::setStoreDisplayThumbnail()
     * @uses ServiceSaleItem::setStoreDisplayImage()
     * @uses ServiceSaleItem::setStoreDescription()
     * @uses ServiceSaleItem::setStoreDetailedDescription()
     * @uses ServiceSaleItem::setStoreItemTemplate()
     * @uses ServiceSaleItem::setPageTitle()
     * @uses ServiceSaleItem::setUrlComponent()
     * @uses ServiceSaleItem::setMetaTagHtml()
     * @uses ServiceSaleItem::setExcludeFromSitemap()
     * @uses ServiceSaleItem::setSitemapPriority()
     * @uses ServiceSaleItem::setSearchKeywords()
     * @uses ServiceSaleItem::setIsDonationItem()
     * @uses ServiceSaleItem::setShowDefaultDonationAmount()
     * @uses ServiceSaleItem::setMaxDonationAmount()
     * @uses ServiceSaleItem::setDontShowPrice()
     * @uses ServiceSaleItem::setNoPriceMessage()
     * @uses ServiceSaleItem::setOutOfStockMessage()
     * @uses ServiceSaleItem::setOnSpecial()
     * @uses ServiceSaleItem::setOutOfStockBehavior()
     * @uses ServiceSaleItem::setRelatedItemsDescription()
     * @uses ServiceSaleItem::setSpecialsDescription()
     * @uses ServiceSaleItem::setItemTaskTemplatesList()
     * @uses ServiceSaleItem::setFeaturedDescription()
     * @uses ServiceSaleItem::setCustomForm()
     * @uses ServiceSaleItem::setItemId()
     * @uses ServiceSaleItem::setUpcCode()
     * @uses ServiceSaleItem::setDisplayName()
     * @uses ServiceSaleItem::setParent()
     * @uses ServiceSaleItem::setIsOnline()
     * @uses ServiceSaleItem::setIsGcoCompliant()
     * @uses ServiceSaleItem::setOfferSupport()
     * @uses ServiceSaleItem::setIsInactive()
     * @uses ServiceSaleItem::setAvailableToPartners()
     * @uses ServiceSaleItem::setDepartment()
     * @uses ServiceSaleItem::setClass()
     * @uses ServiceSaleItem::setLocation()
     * @uses ServiceSaleItem::setSubsidiaryList()
     * @uses ServiceSaleItem::setBillingRatesMatrix()
     * @uses ServiceSaleItem::setAccountingBookDetailList()
     * @uses ServiceSaleItem::setItemOptionsList()
     * @uses ServiceSaleItem::setMatrixOptionList()
     * @uses ServiceSaleItem::setPricingMatrix()
     * @uses ServiceSaleItem::setPurchaseTaxCode()
     * @uses ServiceSaleItem::setRate()
     * @uses ServiceSaleItem::setSalesTaxCode()
     * @uses ServiceSaleItem::setSiteCategoryList()
     * @uses ServiceSaleItem::setTranslationsList()
     * @uses ServiceSaleItem::setPresentationItemList()
     * @uses ServiceSaleItem::setHierarchyVersionsList()
     * @uses ServiceSaleItem::setConsumptionUnit()
     * @uses ServiceSaleItem::setCustomFieldList()
     * @uses ServiceSaleItem::setInternalId()
     * @uses ServiceSaleItem::setExternalId()
     * @param string $createdDate
     * @param string $lastModifiedDate
     * @param string $salesDescription
     * @param bool $includeChildren
     * @param \StructType\RecordRef $incomeAccount
     * @param bool $isTaxable
     * @param string $matrixType
     * @param \StructType\RecordRef $taxSchedule
     * @param string $costEstimateType
     * @param float $costEstimate
     * @param \StructType\RecordRef $unitsType
     * @param \StructType\RecordRef $saleUnit
     * @param \StructType\RecordRef $issueProduct
     * @param string $costEstimateUnits
     * @param \StructType\RecordRef $billingSchedule
     * @param \StructType\RecordRef $deferredRevenueAccount
     * @param \StructType\RecordRef $revRecSchedule
     * @param int $minimumQuantity
     * @param bool $enforceMinQtyInternally
     * @param int $maximumQuantity
     * @param string $softDescriptor
     * @param bool $pricesIncludeTax
     * @param \StructType\RecordRef $quantityPricingSchedule
     * @param bool $useMarginalRates
     * @param string $overallQuantityPricingType
     * @param bool $isFulfillable
     * @param \StructType\RecordRef $costCategory
     * @param \StructType\RecordRef $pricingGroup
     * @param string $minimumQuantityUnits
     * @param float $vsoePrice
     * @param string $vsoeSopGroup
     * @param string $vsoeDeferral
     * @param string $vsoePermitDiscount
     * @param bool $vsoeDelivered
     * @param \StructType\RecordRef $itemRevenueCategory
     * @param bool $deferRevRec
     * @param \StructType\RecordRef $revenueRecognitionRule
     * @param \StructType\RecordRef $revRecForecastRule
     * @param \StructType\RecordRef $revenueAllocationGroup
     * @param \StructType\RecordRef $createRevenuePlansOn
     * @param bool $directRevenuePosting
     * @param bool $contingentRevenueHandling
     * @param \StructType\RecordRef $revReclassFXAccount
     * @param bool $createJob
     * @param string $matrixItemNameTemplate
     * @param string $storeDisplayName
     * @param \StructType\RecordRef $storeDisplayThumbnail
     * @param \StructType\RecordRef $storeDisplayImage
     * @param string $storeDescription
     * @param string $storeDetailedDescription
     * @param \StructType\RecordRef $storeItemTemplate
     * @param string $pageTitle
     * @param string $urlComponent
     * @param string $metaTagHtml
     * @param bool $excludeFromSitemap
     * @param string $sitemapPriority
     * @param string $searchKeywords
     * @param bool $isDonationItem
     * @param bool $showDefaultDonationAmount
     * @param float $maxDonationAmount
     * @param bool $dontShowPrice
     * @param string $noPriceMessage
     * @param string $outOfStockMessage
     * @param bool $onSpecial
     * @param string $outOfStockBehavior
     * @param string $relatedItemsDescription
     * @param string $specialsDescription
     * @param \StructType\ServiceItemTaskTemplatesList $itemTaskTemplatesList
     * @param string $featuredDescription
     * @param \StructType\RecordRef $customForm
     * @param string $itemId
     * @param string $upcCode
     * @param string $displayName
     * @param \StructType\RecordRef $parent
     * @param bool $isOnline
     * @param bool $isGcoCompliant
     * @param bool $offerSupport
     * @param bool $isInactive
     * @param bool $availableToPartners
     * @param \StructType\RecordRef $department
     * @param \StructType\RecordRef $class
     * @param \StructType\RecordRef $location
     * @param \StructType\RecordRefList $subsidiaryList
     * @param \StructType\BillingRatesMatrix $billingRatesMatrix
     * @param \StructType\ItemAccountingBookDetailList $accountingBookDetailList
     * @param \StructType\ItemOptionsList $itemOptionsList
     * @param \StructType\MatrixOptionList $matrixOptionList
     * @param \StructType\PricingMatrix $pricingMatrix
     * @param \StructType\RecordRef $purchaseTaxCode
     * @param float $rate
     * @param \StructType\RecordRef $salesTaxCode
     * @param \StructType\SiteCategoryList $siteCategoryList
     * @param \StructType\TranslationList $translationsList
     * @param \StructType\PresentationItemList $presentationItemList
     * @param \StructType\ServiceSaleItemHierarchyVersionsList $hierarchyVersionsList
     * @param \StructType\RecordRef $consumptionUnit
     * @param \StructType\CustomFieldList $customFieldList
     * @param string $internalId
     * @param string $externalId
     */
    public function __construct($createdDate = null, $lastModifiedDate = null, $salesDescription = null, $includeChildren = null, \StructType\RecordRef $incomeAccount = null, $isTaxable = null, $matrixType = null, \StructType\RecordRef $taxSchedule = null, $costEstimateType = null, $costEstimate = null, \StructType\RecordRef $unitsType = null, \StructType\RecordRef $saleUnit = null, \StructType\RecordRef $issueProduct = null, $costEstimateUnits = null, \StructType\RecordRef $billingSchedule = null, \StructType\RecordRef $deferredRevenueAccount = null, \StructType\RecordRef $revRecSchedule = null, $minimumQuantity = null, $enforceMinQtyInternally = null, $maximumQuantity = null, $softDescriptor = null, $pricesIncludeTax = null, \StructType\RecordRef $quantityPricingSchedule = null, $useMarginalRates = null, $overallQuantityPricingType = null, $isFulfillable = null, \StructType\RecordRef $costCategory = null, \StructType\RecordRef $pricingGroup = null, $minimumQuantityUnits = null, $vsoePrice = null, $vsoeSopGroup = null, $vsoeDeferral = null, $vsoePermitDiscount = null, $vsoeDelivered = null, \StructType\RecordRef $itemRevenueCategory = null, $deferRevRec = null, \StructType\RecordRef $revenueRecognitionRule = null, \StructType\RecordRef $revRecForecastRule = null, \StructType\RecordRef $revenueAllocationGroup = null, \StructType\RecordRef $createRevenuePlansOn = null, $directRevenuePosting = null, $contingentRevenueHandling = null, \StructType\RecordRef $revReclassFXAccount = null, $createJob = null, $matrixItemNameTemplate = null, $storeDisplayName = null, \StructType\RecordRef $storeDisplayThumbnail = null, \StructType\RecordRef $storeDisplayImage = null, $storeDescription = null, $storeDetailedDescription = null, \StructType\RecordRef $storeItemTemplate = null, $pageTitle = null, $urlComponent = null, $metaTagHtml = null, $excludeFromSitemap = null, $sitemapPriority = null, $searchKeywords = null, $isDonationItem = null, $showDefaultDonationAmount = null, $maxDonationAmount = null, $dontShowPrice = null, $noPriceMessage = null, $outOfStockMessage = null, $onSpecial = null, $outOfStockBehavior = null, $relatedItemsDescription = null, $specialsDescription = null, \StructType\ServiceItemTaskTemplatesList $itemTaskTemplatesList = null, $featuredDescription = null, \StructType\RecordRef $customForm = null, $itemId = null, $upcCode = null, $displayName = null, \StructType\RecordRef $parent = null, $isOnline = null, $isGcoCompliant = null, $offerSupport = null, $isInactive = null, $availableToPartners = null, \StructType\RecordRef $department = null, \StructType\RecordRef $class = null, \StructType\RecordRef $location = null, \StructType\RecordRefList $subsidiaryList = null, \StructType\BillingRatesMatrix $billingRatesMatrix = null, \StructType\ItemAccountingBookDetailList $accountingBookDetailList = null, \StructType\ItemOptionsList $itemOptionsList = null, \StructType\MatrixOptionList $matrixOptionList = null, \StructType\PricingMatrix $pricingMatrix = null, \StructType\RecordRef $purchaseTaxCode = null, $rate = null, \StructType\RecordRef $salesTaxCode = null, \StructType\SiteCategoryList $siteCategoryList = null, \StructType\TranslationList $translationsList = null, \StructType\PresentationItemList $presentationItemList = null, \StructType\ServiceSaleItemHierarchyVersionsList $hierarchyVersionsList = null, \StructType\RecordRef $consumptionUnit = null, \StructType\CustomFieldList $customFieldList = null, $internalId = null, $externalId = null)
    {
        $this
            ->setCreatedDate($createdDate)
            ->setLastModifiedDate($lastModifiedDate)
            ->setSalesDescription($salesDescription)
            ->setIncludeChildren($includeChildren)
            ->setIncomeAccount($incomeAccount)
            ->setIsTaxable($isTaxable)
            ->setMatrixType($matrixType)
            ->setTaxSchedule($taxSchedule)
            ->setCostEstimateType($costEstimateType)
            ->setCostEstimate($costEstimate)
            ->setUnitsType($unitsType)
            ->setSaleUnit($saleUnit)
            ->setIssueProduct($issueProduct)
            ->setCostEstimateUnits($costEstimateUnits)
            ->setBillingSchedule($billingSchedule)
            ->setDeferredRevenueAccount($deferredRevenueAccount)
            ->setRevRecSchedule($revRecSchedule)
            ->setMinimumQuantity($minimumQuantity)
            ->setEnforceMinQtyInternally($enforceMinQtyInternally)
            ->setMaximumQuantity($maximumQuantity)
            ->setSoftDescriptor($softDescriptor)
            ->setPricesIncludeTax($pricesIncludeTax)
            ->setQuantityPricingSchedule($quantityPricingSchedule)
            ->setUseMarginalRates($useMarginalRates)
            ->setOverallQuantityPricingType($overallQuantityPricingType)
            ->setIsFulfillable($isFulfillable)
            ->setCostCategory($costCategory)
            ->setPricingGroup($pricingGroup)
            ->setMinimumQuantityUnits($minimumQuantityUnits)
            ->setVsoePrice($vsoePrice)
            ->setVsoeSopGroup($vsoeSopGroup)
            ->setVsoeDeferral($vsoeDeferral)
            ->setVsoePermitDiscount($vsoePermitDiscount)
            ->setVsoeDelivered($vsoeDelivered)
            ->setItemRevenueCategory($itemRevenueCategory)
            ->setDeferRevRec($deferRevRec)
            ->setRevenueRecognitionRule($revenueRecognitionRule)
            ->setRevRecForecastRule($revRecForecastRule)
            ->setRevenueAllocationGroup($revenueAllocationGroup)
            ->setCreateRevenuePlansOn($createRevenuePlansOn)
            ->setDirectRevenuePosting($directRevenuePosting)
            ->setContingentRevenueHandling($contingentRevenueHandling)
            ->setRevReclassFXAccount($revReclassFXAccount)
            ->setCreateJob($createJob)
            ->setMatrixItemNameTemplate($matrixItemNameTemplate)
            ->setStoreDisplayName($storeDisplayName)
            ->setStoreDisplayThumbnail($storeDisplayThumbnail)
            ->setStoreDisplayImage($storeDisplayImage)
            ->setStoreDescription($storeDescription)
            ->setStoreDetailedDescription($storeDetailedDescription)
            ->setStoreItemTemplate($storeItemTemplate)
            ->setPageTitle($pageTitle)
            ->setUrlComponent($urlComponent)
            ->setMetaTagHtml($metaTagHtml)
            ->setExcludeFromSitemap($excludeFromSitemap)
            ->setSitemapPriority($sitemapPriority)
            ->setSearchKeywords($searchKeywords)
            ->setIsDonationItem($isDonationItem)
            ->setShowDefaultDonationAmount($showDefaultDonationAmount)
            ->setMaxDonationAmount($maxDonationAmount)
            ->setDontShowPrice($dontShowPrice)
            ->setNoPriceMessage($noPriceMessage)
            ->setOutOfStockMessage($outOfStockMessage)
            ->setOnSpecial($onSpecial)
            ->setOutOfStockBehavior($outOfStockBehavior)
            ->setRelatedItemsDescription($relatedItemsDescription)
            ->setSpecialsDescription($specialsDescription)
            ->setItemTaskTemplatesList($itemTaskTemplatesList)
            ->setFeaturedDescription($featuredDescription)
            ->setCustomForm($customForm)
            ->setItemId($itemId)
            ->setUpcCode($upcCode)
            ->setDisplayName($displayName)
            ->setParent($parent)
            ->setIsOnline($isOnline)
            ->setIsGcoCompliant($isGcoCompliant)
            ->setOfferSupport($offerSupport)
            ->setIsInactive($isInactive)
            ->setAvailableToPartners($availableToPartners)
            ->setDepartment($department)
            ->setClass($class)
            ->setLocation($location)
            ->setSubsidiaryList($subsidiaryList)
            ->setBillingRatesMatrix($billingRatesMatrix)
            ->setAccountingBookDetailList($accountingBookDetailList)
            ->setItemOptionsList($itemOptionsList)
            ->setMatrixOptionList($matrixOptionList)
            ->setPricingMatrix($pricingMatrix)
            ->setPurchaseTaxCode($purchaseTaxCode)
            ->setRate($rate)
            ->setSalesTaxCode($salesTaxCode)
            ->setSiteCategoryList($siteCategoryList)
            ->setTranslationsList($translationsList)
            ->setPresentationItemList($presentationItemList)
            ->setHierarchyVersionsList($hierarchyVersionsList)
            ->setConsumptionUnit($consumptionUnit)
            ->setCustomFieldList($customFieldList)
            ->setInternalId($internalId)
            ->setExternalId($externalId);
    }
    /**
     * Get createdDate value
     * @return string|null
     */
    public function getCreatedDate()
    {
        return $this->createdDate;
    }
    /**
     * Set createdDate value
     * @param string $createdDate
     * @return \StructType\ServiceSaleItem
     */
    public function setCreatedDate($createdDate = null)
    {
        // validation for constraint: string
        if (!is_null($createdDate) && !is_string($createdDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($createdDate, true), gettype($createdDate)), __LINE__);
        }
        $this->createdDate = $createdDate;
        return $this;
    }
    /**
     * Get lastModifiedDate value
     * @return string|null
     */
    public function getLastModifiedDate()
    {
        return $this->lastModifiedDate;
    }
    /**
     * Set lastModifiedDate value
     * @param string $lastModifiedDate
     * @return \StructType\ServiceSaleItem
     */
    public function setLastModifiedDate($lastModifiedDate = null)
    {
        // validation for constraint: string
        if (!is_null($lastModifiedDate) && !is_string($lastModifiedDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lastModifiedDate, true), gettype($lastModifiedDate)), __LINE__);
        }
        $this->lastModifiedDate = $lastModifiedDate;
        return $this;
    }
    /**
     * Get salesDescription value
     * @return string|null
     */
    public function getSalesDescription()
    {
        return $this->salesDescription;
    }
    /**
     * Set salesDescription value
     * @param string $salesDescription
     * @return \StructType\ServiceSaleItem
     */
    public function setSalesDescription($salesDescription = null)
    {
        // validation for constraint: string
        if (!is_null($salesDescription) && !is_string($salesDescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($salesDescription, true), gettype($salesDescription)), __LINE__);
        }
        $this->salesDescription = $salesDescription;
        return $this;
    }
    /**
     * Get includeChildren value
     * @return bool|null
     */
    public function getIncludeChildren()
    {
        return $this->includeChildren;
    }
    /**
     * Set includeChildren value
     * @param bool $includeChildren
     * @return \StructType\ServiceSaleItem
     */
    public function setIncludeChildren($includeChildren = null)
    {
        // validation for constraint: boolean
        if (!is_null($includeChildren) && !is_bool($includeChildren)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($includeChildren, true), gettype($includeChildren)), __LINE__);
        }
        $this->includeChildren = $includeChildren;
        return $this;
    }
    /**
     * Get incomeAccount value
     * @return \StructType\RecordRef|null
     */
    public function getIncomeAccount()
    {
        return $this->incomeAccount;
    }
    /**
     * Set incomeAccount value
     * @param \StructType\RecordRef $incomeAccount
     * @return \StructType\ServiceSaleItem
     */
    public function setIncomeAccount(\StructType\RecordRef $incomeAccount = null)
    {
        $this->incomeAccount = $incomeAccount;
        return $this;
    }
    /**
     * Get isTaxable value
     * @return bool|null
     */
    public function getIsTaxable()
    {
        return $this->isTaxable;
    }
    /**
     * Set isTaxable value
     * @param bool $isTaxable
     * @return \StructType\ServiceSaleItem
     */
    public function setIsTaxable($isTaxable = null)
    {
        // validation for constraint: boolean
        if (!is_null($isTaxable) && !is_bool($isTaxable)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isTaxable, true), gettype($isTaxable)), __LINE__);
        }
        $this->isTaxable = $isTaxable;
        return $this;
    }
    /**
     * Get matrixType value
     * @return string|null
     */
    public function getMatrixType()
    {
        return $this->matrixType;
    }
    /**
     * Set matrixType value
     * @uses \EnumType\ItemMatrixType::valueIsValid()
     * @uses \EnumType\ItemMatrixType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $matrixType
     * @return \StructType\ServiceSaleItem
     */
    public function setMatrixType($matrixType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\ItemMatrixType::valueIsValid($matrixType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\ItemMatrixType', is_array($matrixType) ? implode(', ', $matrixType) : var_export($matrixType, true), implode(', ', \EnumType\ItemMatrixType::getValidValues())), __LINE__);
        }
        $this->matrixType = $matrixType;
        return $this;
    }
    /**
     * Get taxSchedule value
     * @return \StructType\RecordRef|null
     */
    public function getTaxSchedule()
    {
        return $this->taxSchedule;
    }
    /**
     * Set taxSchedule value
     * @param \StructType\RecordRef $taxSchedule
     * @return \StructType\ServiceSaleItem
     */
    public function setTaxSchedule(\StructType\RecordRef $taxSchedule = null)
    {
        $this->taxSchedule = $taxSchedule;
        return $this;
    }
    /**
     * Get costEstimateType value
     * @return string|null
     */
    public function getCostEstimateType()
    {
        return $this->costEstimateType;
    }
    /**
     * Set costEstimateType value
     * @uses \EnumType\ItemCostEstimateType::valueIsValid()
     * @uses \EnumType\ItemCostEstimateType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $costEstimateType
     * @return \StructType\ServiceSaleItem
     */
    public function setCostEstimateType($costEstimateType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\ItemCostEstimateType::valueIsValid($costEstimateType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\ItemCostEstimateType', is_array($costEstimateType) ? implode(', ', $costEstimateType) : var_export($costEstimateType, true), implode(', ', \EnumType\ItemCostEstimateType::getValidValues())), __LINE__);
        }
        $this->costEstimateType = $costEstimateType;
        return $this;
    }
    /**
     * Get costEstimate value
     * @return float|null
     */
    public function getCostEstimate()
    {
        return $this->costEstimate;
    }
    /**
     * Set costEstimate value
     * @param float $costEstimate
     * @return \StructType\ServiceSaleItem
     */
    public function setCostEstimate($costEstimate = null)
    {
        // validation for constraint: float
        if (!is_null($costEstimate) && !(is_float($costEstimate) || is_numeric($costEstimate))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($costEstimate, true), gettype($costEstimate)), __LINE__);
        }
        $this->costEstimate = $costEstimate;
        return $this;
    }
    /**
     * Get unitsType value
     * @return \StructType\RecordRef|null
     */
    public function getUnitsType()
    {
        return $this->unitsType;
    }
    /**
     * Set unitsType value
     * @param \StructType\RecordRef $unitsType
     * @return \StructType\ServiceSaleItem
     */
    public function setUnitsType(\StructType\RecordRef $unitsType = null)
    {
        $this->unitsType = $unitsType;
        return $this;
    }
    /**
     * Get saleUnit value
     * @return \StructType\RecordRef|null
     */
    public function getSaleUnit()
    {
        return $this->saleUnit;
    }
    /**
     * Set saleUnit value
     * @param \StructType\RecordRef $saleUnit
     * @return \StructType\ServiceSaleItem
     */
    public function setSaleUnit(\StructType\RecordRef $saleUnit = null)
    {
        $this->saleUnit = $saleUnit;
        return $this;
    }
    /**
     * Get issueProduct value
     * @return \StructType\RecordRef|null
     */
    public function getIssueProduct()
    {
        return $this->issueProduct;
    }
    /**
     * Set issueProduct value
     * @param \StructType\RecordRef $issueProduct
     * @return \StructType\ServiceSaleItem
     */
    public function setIssueProduct(\StructType\RecordRef $issueProduct = null)
    {
        $this->issueProduct = $issueProduct;
        return $this;
    }
    /**
     * Get costEstimateUnits value
     * @return string|null
     */
    public function getCostEstimateUnits()
    {
        return $this->costEstimateUnits;
    }
    /**
     * Set costEstimateUnits value
     * @param string $costEstimateUnits
     * @return \StructType\ServiceSaleItem
     */
    public function setCostEstimateUnits($costEstimateUnits = null)
    {
        // validation for constraint: string
        if (!is_null($costEstimateUnits) && !is_string($costEstimateUnits)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($costEstimateUnits, true), gettype($costEstimateUnits)), __LINE__);
        }
        $this->costEstimateUnits = $costEstimateUnits;
        return $this;
    }
    /**
     * Get billingSchedule value
     * @return \StructType\RecordRef|null
     */
    public function getBillingSchedule()
    {
        return $this->billingSchedule;
    }
    /**
     * Set billingSchedule value
     * @param \StructType\RecordRef $billingSchedule
     * @return \StructType\ServiceSaleItem
     */
    public function setBillingSchedule(\StructType\RecordRef $billingSchedule = null)
    {
        $this->billingSchedule = $billingSchedule;
        return $this;
    }
    /**
     * Get deferredRevenueAccount value
     * @return \StructType\RecordRef|null
     */
    public function getDeferredRevenueAccount()
    {
        return $this->deferredRevenueAccount;
    }
    /**
     * Set deferredRevenueAccount value
     * @param \StructType\RecordRef $deferredRevenueAccount
     * @return \StructType\ServiceSaleItem
     */
    public function setDeferredRevenueAccount(\StructType\RecordRef $deferredRevenueAccount = null)
    {
        $this->deferredRevenueAccount = $deferredRevenueAccount;
        return $this;
    }
    /**
     * Get revRecSchedule value
     * @return \StructType\RecordRef|null
     */
    public function getRevRecSchedule()
    {
        return $this->revRecSchedule;
    }
    /**
     * Set revRecSchedule value
     * @param \StructType\RecordRef $revRecSchedule
     * @return \StructType\ServiceSaleItem
     */
    public function setRevRecSchedule(\StructType\RecordRef $revRecSchedule = null)
    {
        $this->revRecSchedule = $revRecSchedule;
        return $this;
    }
    /**
     * Get minimumQuantity value
     * @return int|null
     */
    public function getMinimumQuantity()
    {
        return $this->minimumQuantity;
    }
    /**
     * Set minimumQuantity value
     * @param int $minimumQuantity
     * @return \StructType\ServiceSaleItem
     */
    public function setMinimumQuantity($minimumQuantity = null)
    {
        // validation for constraint: int
        if (!is_null($minimumQuantity) && !(is_int($minimumQuantity) || ctype_digit($minimumQuantity))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($minimumQuantity, true), gettype($minimumQuantity)), __LINE__);
        }
        $this->minimumQuantity = $minimumQuantity;
        return $this;
    }
    /**
     * Get enforceMinQtyInternally value
     * @return bool|null
     */
    public function getEnforceMinQtyInternally()
    {
        return $this->enforceMinQtyInternally;
    }
    /**
     * Set enforceMinQtyInternally value
     * @param bool $enforceMinQtyInternally
     * @return \StructType\ServiceSaleItem
     */
    public function setEnforceMinQtyInternally($enforceMinQtyInternally = null)
    {
        // validation for constraint: boolean
        if (!is_null($enforceMinQtyInternally) && !is_bool($enforceMinQtyInternally)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($enforceMinQtyInternally, true), gettype($enforceMinQtyInternally)), __LINE__);
        }
        $this->enforceMinQtyInternally = $enforceMinQtyInternally;
        return $this;
    }
    /**
     * Get maximumQuantity value
     * @return int|null
     */
    public function getMaximumQuantity()
    {
        return $this->maximumQuantity;
    }
    /**
     * Set maximumQuantity value
     * @param int $maximumQuantity
     * @return \StructType\ServiceSaleItem
     */
    public function setMaximumQuantity($maximumQuantity = null)
    {
        // validation for constraint: int
        if (!is_null($maximumQuantity) && !(is_int($maximumQuantity) || ctype_digit($maximumQuantity))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($maximumQuantity, true), gettype($maximumQuantity)), __LINE__);
        }
        $this->maximumQuantity = $maximumQuantity;
        return $this;
    }
    /**
     * Get softDescriptor value
     * @return string|null
     */
    public function getSoftDescriptor()
    {
        return $this->softDescriptor;
    }
    /**
     * Set softDescriptor value
     * @param string $softDescriptor
     * @return \StructType\ServiceSaleItem
     */
    public function setSoftDescriptor($softDescriptor = null)
    {
        // validation for constraint: string
        if (!is_null($softDescriptor) && !is_string($softDescriptor)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($softDescriptor, true), gettype($softDescriptor)), __LINE__);
        }
        $this->softDescriptor = $softDescriptor;
        return $this;
    }
    /**
     * Get pricesIncludeTax value
     * @return bool|null
     */
    public function getPricesIncludeTax()
    {
        return $this->pricesIncludeTax;
    }
    /**
     * Set pricesIncludeTax value
     * @param bool $pricesIncludeTax
     * @return \StructType\ServiceSaleItem
     */
    public function setPricesIncludeTax($pricesIncludeTax = null)
    {
        // validation for constraint: boolean
        if (!is_null($pricesIncludeTax) && !is_bool($pricesIncludeTax)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($pricesIncludeTax, true), gettype($pricesIncludeTax)), __LINE__);
        }
        $this->pricesIncludeTax = $pricesIncludeTax;
        return $this;
    }
    /**
     * Get quantityPricingSchedule value
     * @return \StructType\RecordRef|null
     */
    public function getQuantityPricingSchedule()
    {
        return $this->quantityPricingSchedule;
    }
    /**
     * Set quantityPricingSchedule value
     * @param \StructType\RecordRef $quantityPricingSchedule
     * @return \StructType\ServiceSaleItem
     */
    public function setQuantityPricingSchedule(\StructType\RecordRef $quantityPricingSchedule = null)
    {
        $this->quantityPricingSchedule = $quantityPricingSchedule;
        return $this;
    }
    /**
     * Get useMarginalRates value
     * @return bool|null
     */
    public function getUseMarginalRates()
    {
        return $this->useMarginalRates;
    }
    /**
     * Set useMarginalRates value
     * @param bool $useMarginalRates
     * @return \StructType\ServiceSaleItem
     */
    public function setUseMarginalRates($useMarginalRates = null)
    {
        // validation for constraint: boolean
        if (!is_null($useMarginalRates) && !is_bool($useMarginalRates)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($useMarginalRates, true), gettype($useMarginalRates)), __LINE__);
        }
        $this->useMarginalRates = $useMarginalRates;
        return $this;
    }
    /**
     * Get overallQuantityPricingType value
     * @return string|null
     */
    public function getOverallQuantityPricingType()
    {
        return $this->overallQuantityPricingType;
    }
    /**
     * Set overallQuantityPricingType value
     * @uses \EnumType\ItemOverallQuantityPricingType::valueIsValid()
     * @uses \EnumType\ItemOverallQuantityPricingType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $overallQuantityPricingType
     * @return \StructType\ServiceSaleItem
     */
    public function setOverallQuantityPricingType($overallQuantityPricingType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\ItemOverallQuantityPricingType::valueIsValid($overallQuantityPricingType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\ItemOverallQuantityPricingType', is_array($overallQuantityPricingType) ? implode(', ', $overallQuantityPricingType) : var_export($overallQuantityPricingType, true), implode(', ', \EnumType\ItemOverallQuantityPricingType::getValidValues())), __LINE__);
        }
        $this->overallQuantityPricingType = $overallQuantityPricingType;
        return $this;
    }
    /**
     * Get isFulfillable value
     * @return bool|null
     */
    public function getIsFulfillable()
    {
        return $this->isFulfillable;
    }
    /**
     * Set isFulfillable value
     * @param bool $isFulfillable
     * @return \StructType\ServiceSaleItem
     */
    public function setIsFulfillable($isFulfillable = null)
    {
        // validation for constraint: boolean
        if (!is_null($isFulfillable) && !is_bool($isFulfillable)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isFulfillable, true), gettype($isFulfillable)), __LINE__);
        }
        $this->isFulfillable = $isFulfillable;
        return $this;
    }
    /**
     * Get costCategory value
     * @return \StructType\RecordRef|null
     */
    public function getCostCategory()
    {
        return $this->costCategory;
    }
    /**
     * Set costCategory value
     * @param \StructType\RecordRef $costCategory
     * @return \StructType\ServiceSaleItem
     */
    public function setCostCategory(\StructType\RecordRef $costCategory = null)
    {
        $this->costCategory = $costCategory;
        return $this;
    }
    /**
     * Get pricingGroup value
     * @return \StructType\RecordRef|null
     */
    public function getPricingGroup()
    {
        return $this->pricingGroup;
    }
    /**
     * Set pricingGroup value
     * @param \StructType\RecordRef $pricingGroup
     * @return \StructType\ServiceSaleItem
     */
    public function setPricingGroup(\StructType\RecordRef $pricingGroup = null)
    {
        $this->pricingGroup = $pricingGroup;
        return $this;
    }
    /**
     * Get minimumQuantityUnits value
     * @return string|null
     */
    public function getMinimumQuantityUnits()
    {
        return $this->minimumQuantityUnits;
    }
    /**
     * Set minimumQuantityUnits value
     * @param string $minimumQuantityUnits
     * @return \StructType\ServiceSaleItem
     */
    public function setMinimumQuantityUnits($minimumQuantityUnits = null)
    {
        // validation for constraint: string
        if (!is_null($minimumQuantityUnits) && !is_string($minimumQuantityUnits)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($minimumQuantityUnits, true), gettype($minimumQuantityUnits)), __LINE__);
        }
        $this->minimumQuantityUnits = $minimumQuantityUnits;
        return $this;
    }
    /**
     * Get vsoePrice value
     * @return float|null
     */
    public function getVsoePrice()
    {
        return $this->vsoePrice;
    }
    /**
     * Set vsoePrice value
     * @param float $vsoePrice
     * @return \StructType\ServiceSaleItem
     */
    public function setVsoePrice($vsoePrice = null)
    {
        // validation for constraint: float
        if (!is_null($vsoePrice) && !(is_float($vsoePrice) || is_numeric($vsoePrice))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($vsoePrice, true), gettype($vsoePrice)), __LINE__);
        }
        $this->vsoePrice = $vsoePrice;
        return $this;
    }
    /**
     * Get vsoeSopGroup value
     * @return string|null
     */
    public function getVsoeSopGroup()
    {
        return $this->vsoeSopGroup;
    }
    /**
     * Set vsoeSopGroup value
     * @uses \EnumType\VsoeSopGroup::valueIsValid()
     * @uses \EnumType\VsoeSopGroup::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $vsoeSopGroup
     * @return \StructType\ServiceSaleItem
     */
    public function setVsoeSopGroup($vsoeSopGroup = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\VsoeSopGroup::valueIsValid($vsoeSopGroup)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\VsoeSopGroup', is_array($vsoeSopGroup) ? implode(', ', $vsoeSopGroup) : var_export($vsoeSopGroup, true), implode(', ', \EnumType\VsoeSopGroup::getValidValues())), __LINE__);
        }
        $this->vsoeSopGroup = $vsoeSopGroup;
        return $this;
    }
    /**
     * Get vsoeDeferral value
     * @return string|null
     */
    public function getVsoeDeferral()
    {
        return $this->vsoeDeferral;
    }
    /**
     * Set vsoeDeferral value
     * @uses \EnumType\VsoeDeferral::valueIsValid()
     * @uses \EnumType\VsoeDeferral::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $vsoeDeferral
     * @return \StructType\ServiceSaleItem
     */
    public function setVsoeDeferral($vsoeDeferral = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\VsoeDeferral::valueIsValid($vsoeDeferral)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\VsoeDeferral', is_array($vsoeDeferral) ? implode(', ', $vsoeDeferral) : var_export($vsoeDeferral, true), implode(', ', \EnumType\VsoeDeferral::getValidValues())), __LINE__);
        }
        $this->vsoeDeferral = $vsoeDeferral;
        return $this;
    }
    /**
     * Get vsoePermitDiscount value
     * @return string|null
     */
    public function getVsoePermitDiscount()
    {
        return $this->vsoePermitDiscount;
    }
    /**
     * Set vsoePermitDiscount value
     * @uses \EnumType\VsoePermitDiscount::valueIsValid()
     * @uses \EnumType\VsoePermitDiscount::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $vsoePermitDiscount
     * @return \StructType\ServiceSaleItem
     */
    public function setVsoePermitDiscount($vsoePermitDiscount = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\VsoePermitDiscount::valueIsValid($vsoePermitDiscount)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\VsoePermitDiscount', is_array($vsoePermitDiscount) ? implode(', ', $vsoePermitDiscount) : var_export($vsoePermitDiscount, true), implode(', ', \EnumType\VsoePermitDiscount::getValidValues())), __LINE__);
        }
        $this->vsoePermitDiscount = $vsoePermitDiscount;
        return $this;
    }
    /**
     * Get vsoeDelivered value
     * @return bool|null
     */
    public function getVsoeDelivered()
    {
        return $this->vsoeDelivered;
    }
    /**
     * Set vsoeDelivered value
     * @param bool $vsoeDelivered
     * @return \StructType\ServiceSaleItem
     */
    public function setVsoeDelivered($vsoeDelivered = null)
    {
        // validation for constraint: boolean
        if (!is_null($vsoeDelivered) && !is_bool($vsoeDelivered)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($vsoeDelivered, true), gettype($vsoeDelivered)), __LINE__);
        }
        $this->vsoeDelivered = $vsoeDelivered;
        return $this;
    }
    /**
     * Get itemRevenueCategory value
     * @return \StructType\RecordRef|null
     */
    public function getItemRevenueCategory()
    {
        return $this->itemRevenueCategory;
    }
    /**
     * Set itemRevenueCategory value
     * @param \StructType\RecordRef $itemRevenueCategory
     * @return \StructType\ServiceSaleItem
     */
    public function setItemRevenueCategory(\StructType\RecordRef $itemRevenueCategory = null)
    {
        $this->itemRevenueCategory = $itemRevenueCategory;
        return $this;
    }
    /**
     * Get deferRevRec value
     * @return bool|null
     */
    public function getDeferRevRec()
    {
        return $this->deferRevRec;
    }
    /**
     * Set deferRevRec value
     * @param bool $deferRevRec
     * @return \StructType\ServiceSaleItem
     */
    public function setDeferRevRec($deferRevRec = null)
    {
        // validation for constraint: boolean
        if (!is_null($deferRevRec) && !is_bool($deferRevRec)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($deferRevRec, true), gettype($deferRevRec)), __LINE__);
        }
        $this->deferRevRec = $deferRevRec;
        return $this;
    }
    /**
     * Get revenueRecognitionRule value
     * @return \StructType\RecordRef|null
     */
    public function getRevenueRecognitionRule()
    {
        return $this->revenueRecognitionRule;
    }
    /**
     * Set revenueRecognitionRule value
     * @param \StructType\RecordRef $revenueRecognitionRule
     * @return \StructType\ServiceSaleItem
     */
    public function setRevenueRecognitionRule(\StructType\RecordRef $revenueRecognitionRule = null)
    {
        $this->revenueRecognitionRule = $revenueRecognitionRule;
        return $this;
    }
    /**
     * Get revRecForecastRule value
     * @return \StructType\RecordRef|null
     */
    public function getRevRecForecastRule()
    {
        return $this->revRecForecastRule;
    }
    /**
     * Set revRecForecastRule value
     * @param \StructType\RecordRef $revRecForecastRule
     * @return \StructType\ServiceSaleItem
     */
    public function setRevRecForecastRule(\StructType\RecordRef $revRecForecastRule = null)
    {
        $this->revRecForecastRule = $revRecForecastRule;
        return $this;
    }
    /**
     * Get revenueAllocationGroup value
     * @return \StructType\RecordRef|null
     */
    public function getRevenueAllocationGroup()
    {
        return $this->revenueAllocationGroup;
    }
    /**
     * Set revenueAllocationGroup value
     * @param \StructType\RecordRef $revenueAllocationGroup
     * @return \StructType\ServiceSaleItem
     */
    public function setRevenueAllocationGroup(\StructType\RecordRef $revenueAllocationGroup = null)
    {
        $this->revenueAllocationGroup = $revenueAllocationGroup;
        return $this;
    }
    /**
     * Get createRevenuePlansOn value
     * @return \StructType\RecordRef|null
     */
    public function getCreateRevenuePlansOn()
    {
        return $this->createRevenuePlansOn;
    }
    /**
     * Set createRevenuePlansOn value
     * @param \StructType\RecordRef $createRevenuePlansOn
     * @return \StructType\ServiceSaleItem
     */
    public function setCreateRevenuePlansOn(\StructType\RecordRef $createRevenuePlansOn = null)
    {
        $this->createRevenuePlansOn = $createRevenuePlansOn;
        return $this;
    }
    /**
     * Get directRevenuePosting value
     * @return bool|null
     */
    public function getDirectRevenuePosting()
    {
        return $this->directRevenuePosting;
    }
    /**
     * Set directRevenuePosting value
     * @param bool $directRevenuePosting
     * @return \StructType\ServiceSaleItem
     */
    public function setDirectRevenuePosting($directRevenuePosting = null)
    {
        // validation for constraint: boolean
        if (!is_null($directRevenuePosting) && !is_bool($directRevenuePosting)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($directRevenuePosting, true), gettype($directRevenuePosting)), __LINE__);
        }
        $this->directRevenuePosting = $directRevenuePosting;
        return $this;
    }
    /**
     * Get contingentRevenueHandling value
     * @return bool|null
     */
    public function getContingentRevenueHandling()
    {
        return $this->contingentRevenueHandling;
    }
    /**
     * Set contingentRevenueHandling value
     * @param bool $contingentRevenueHandling
     * @return \StructType\ServiceSaleItem
     */
    public function setContingentRevenueHandling($contingentRevenueHandling = null)
    {
        // validation for constraint: boolean
        if (!is_null($contingentRevenueHandling) && !is_bool($contingentRevenueHandling)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($contingentRevenueHandling, true), gettype($contingentRevenueHandling)), __LINE__);
        }
        $this->contingentRevenueHandling = $contingentRevenueHandling;
        return $this;
    }
    /**
     * Get revReclassFXAccount value
     * @return \StructType\RecordRef|null
     */
    public function getRevReclassFXAccount()
    {
        return $this->revReclassFXAccount;
    }
    /**
     * Set revReclassFXAccount value
     * @param \StructType\RecordRef $revReclassFXAccount
     * @return \StructType\ServiceSaleItem
     */
    public function setRevReclassFXAccount(\StructType\RecordRef $revReclassFXAccount = null)
    {
        $this->revReclassFXAccount = $revReclassFXAccount;
        return $this;
    }
    /**
     * Get createJob value
     * @return bool|null
     */
    public function getCreateJob()
    {
        return $this->createJob;
    }
    /**
     * Set createJob value
     * @param bool $createJob
     * @return \StructType\ServiceSaleItem
     */
    public function setCreateJob($createJob = null)
    {
        // validation for constraint: boolean
        if (!is_null($createJob) && !is_bool($createJob)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($createJob, true), gettype($createJob)), __LINE__);
        }
        $this->createJob = $createJob;
        return $this;
    }
    /**
     * Get matrixItemNameTemplate value
     * @return string|null
     */
    public function getMatrixItemNameTemplate()
    {
        return $this->matrixItemNameTemplate;
    }
    /**
     * Set matrixItemNameTemplate value
     * @param string $matrixItemNameTemplate
     * @return \StructType\ServiceSaleItem
     */
    public function setMatrixItemNameTemplate($matrixItemNameTemplate = null)
    {
        // validation for constraint: string
        if (!is_null($matrixItemNameTemplate) && !is_string($matrixItemNameTemplate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($matrixItemNameTemplate, true), gettype($matrixItemNameTemplate)), __LINE__);
        }
        $this->matrixItemNameTemplate = $matrixItemNameTemplate;
        return $this;
    }
    /**
     * Get storeDisplayName value
     * @return string|null
     */
    public function getStoreDisplayName()
    {
        return $this->storeDisplayName;
    }
    /**
     * Set storeDisplayName value
     * @param string $storeDisplayName
     * @return \StructType\ServiceSaleItem
     */
    public function setStoreDisplayName($storeDisplayName = null)
    {
        // validation for constraint: string
        if (!is_null($storeDisplayName) && !is_string($storeDisplayName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($storeDisplayName, true), gettype($storeDisplayName)), __LINE__);
        }
        $this->storeDisplayName = $storeDisplayName;
        return $this;
    }
    /**
     * Get storeDisplayThumbnail value
     * @return \StructType\RecordRef|null
     */
    public function getStoreDisplayThumbnail()
    {
        return $this->storeDisplayThumbnail;
    }
    /**
     * Set storeDisplayThumbnail value
     * @param \StructType\RecordRef $storeDisplayThumbnail
     * @return \StructType\ServiceSaleItem
     */
    public function setStoreDisplayThumbnail(\StructType\RecordRef $storeDisplayThumbnail = null)
    {
        $this->storeDisplayThumbnail = $storeDisplayThumbnail;
        return $this;
    }
    /**
     * Get storeDisplayImage value
     * @return \StructType\RecordRef|null
     */
    public function getStoreDisplayImage()
    {
        return $this->storeDisplayImage;
    }
    /**
     * Set storeDisplayImage value
     * @param \StructType\RecordRef $storeDisplayImage
     * @return \StructType\ServiceSaleItem
     */
    public function setStoreDisplayImage(\StructType\RecordRef $storeDisplayImage = null)
    {
        $this->storeDisplayImage = $storeDisplayImage;
        return $this;
    }
    /**
     * Get storeDescription value
     * @return string|null
     */
    public function getStoreDescription()
    {
        return $this->storeDescription;
    }
    /**
     * Set storeDescription value
     * @param string $storeDescription
     * @return \StructType\ServiceSaleItem
     */
    public function setStoreDescription($storeDescription = null)
    {
        // validation for constraint: string
        if (!is_null($storeDescription) && !is_string($storeDescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($storeDescription, true), gettype($storeDescription)), __LINE__);
        }
        $this->storeDescription = $storeDescription;
        return $this;
    }
    /**
     * Get storeDetailedDescription value
     * @return string|null
     */
    public function getStoreDetailedDescription()
    {
        return $this->storeDetailedDescription;
    }
    /**
     * Set storeDetailedDescription value
     * @param string $storeDetailedDescription
     * @return \StructType\ServiceSaleItem
     */
    public function setStoreDetailedDescription($storeDetailedDescription = null)
    {
        // validation for constraint: string
        if (!is_null($storeDetailedDescription) && !is_string($storeDetailedDescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($storeDetailedDescription, true), gettype($storeDetailedDescription)), __LINE__);
        }
        $this->storeDetailedDescription = $storeDetailedDescription;
        return $this;
    }
    /**
     * Get storeItemTemplate value
     * @return \StructType\RecordRef|null
     */
    public function getStoreItemTemplate()
    {
        return $this->storeItemTemplate;
    }
    /**
     * Set storeItemTemplate value
     * @param \StructType\RecordRef $storeItemTemplate
     * @return \StructType\ServiceSaleItem
     */
    public function setStoreItemTemplate(\StructType\RecordRef $storeItemTemplate = null)
    {
        $this->storeItemTemplate = $storeItemTemplate;
        return $this;
    }
    /**
     * Get pageTitle value
     * @return string|null
     */
    public function getPageTitle()
    {
        return $this->pageTitle;
    }
    /**
     * Set pageTitle value
     * @param string $pageTitle
     * @return \StructType\ServiceSaleItem
     */
    public function setPageTitle($pageTitle = null)
    {
        // validation for constraint: string
        if (!is_null($pageTitle) && !is_string($pageTitle)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pageTitle, true), gettype($pageTitle)), __LINE__);
        }
        $this->pageTitle = $pageTitle;
        return $this;
    }
    /**
     * Get urlComponent value
     * @return string|null
     */
    public function getUrlComponent()
    {
        return $this->urlComponent;
    }
    /**
     * Set urlComponent value
     * @param string $urlComponent
     * @return \StructType\ServiceSaleItem
     */
    public function setUrlComponent($urlComponent = null)
    {
        // validation for constraint: string
        if (!is_null($urlComponent) && !is_string($urlComponent)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($urlComponent, true), gettype($urlComponent)), __LINE__);
        }
        $this->urlComponent = $urlComponent;
        return $this;
    }
    /**
     * Get metaTagHtml value
     * @return string|null
     */
    public function getMetaTagHtml()
    {
        return $this->metaTagHtml;
    }
    /**
     * Set metaTagHtml value
     * @param string $metaTagHtml
     * @return \StructType\ServiceSaleItem
     */
    public function setMetaTagHtml($metaTagHtml = null)
    {
        // validation for constraint: string
        if (!is_null($metaTagHtml) && !is_string($metaTagHtml)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($metaTagHtml, true), gettype($metaTagHtml)), __LINE__);
        }
        $this->metaTagHtml = $metaTagHtml;
        return $this;
    }
    /**
     * Get excludeFromSitemap value
     * @return bool|null
     */
    public function getExcludeFromSitemap()
    {
        return $this->excludeFromSitemap;
    }
    /**
     * Set excludeFromSitemap value
     * @param bool $excludeFromSitemap
     * @return \StructType\ServiceSaleItem
     */
    public function setExcludeFromSitemap($excludeFromSitemap = null)
    {
        // validation for constraint: boolean
        if (!is_null($excludeFromSitemap) && !is_bool($excludeFromSitemap)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($excludeFromSitemap, true), gettype($excludeFromSitemap)), __LINE__);
        }
        $this->excludeFromSitemap = $excludeFromSitemap;
        return $this;
    }
    /**
     * Get sitemapPriority value
     * @return string|null
     */
    public function getSitemapPriority()
    {
        return $this->sitemapPriority;
    }
    /**
     * Set sitemapPriority value
     * @uses \EnumType\SitemapPriority::valueIsValid()
     * @uses \EnumType\SitemapPriority::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $sitemapPriority
     * @return \StructType\ServiceSaleItem
     */
    public function setSitemapPriority($sitemapPriority = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\SitemapPriority::valueIsValid($sitemapPriority)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\SitemapPriority', is_array($sitemapPriority) ? implode(', ', $sitemapPriority) : var_export($sitemapPriority, true), implode(', ', \EnumType\SitemapPriority::getValidValues())), __LINE__);
        }
        $this->sitemapPriority = $sitemapPriority;
        return $this;
    }
    /**
     * Get searchKeywords value
     * @return string|null
     */
    public function getSearchKeywords()
    {
        return $this->searchKeywords;
    }
    /**
     * Set searchKeywords value
     * @param string $searchKeywords
     * @return \StructType\ServiceSaleItem
     */
    public function setSearchKeywords($searchKeywords = null)
    {
        // validation for constraint: string
        if (!is_null($searchKeywords) && !is_string($searchKeywords)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($searchKeywords, true), gettype($searchKeywords)), __LINE__);
        }
        $this->searchKeywords = $searchKeywords;
        return $this;
    }
    /**
     * Get isDonationItem value
     * @return bool|null
     */
    public function getIsDonationItem()
    {
        return $this->isDonationItem;
    }
    /**
     * Set isDonationItem value
     * @param bool $isDonationItem
     * @return \StructType\ServiceSaleItem
     */
    public function setIsDonationItem($isDonationItem = null)
    {
        // validation for constraint: boolean
        if (!is_null($isDonationItem) && !is_bool($isDonationItem)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isDonationItem, true), gettype($isDonationItem)), __LINE__);
        }
        $this->isDonationItem = $isDonationItem;
        return $this;
    }
    /**
     * Get showDefaultDonationAmount value
     * @return bool|null
     */
    public function getShowDefaultDonationAmount()
    {
        return $this->showDefaultDonationAmount;
    }
    /**
     * Set showDefaultDonationAmount value
     * @param bool $showDefaultDonationAmount
     * @return \StructType\ServiceSaleItem
     */
    public function setShowDefaultDonationAmount($showDefaultDonationAmount = null)
    {
        // validation for constraint: boolean
        if (!is_null($showDefaultDonationAmount) && !is_bool($showDefaultDonationAmount)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($showDefaultDonationAmount, true), gettype($showDefaultDonationAmount)), __LINE__);
        }
        $this->showDefaultDonationAmount = $showDefaultDonationAmount;
        return $this;
    }
    /**
     * Get maxDonationAmount value
     * @return float|null
     */
    public function getMaxDonationAmount()
    {
        return $this->maxDonationAmount;
    }
    /**
     * Set maxDonationAmount value
     * @param float $maxDonationAmount
     * @return \StructType\ServiceSaleItem
     */
    public function setMaxDonationAmount($maxDonationAmount = null)
    {
        // validation for constraint: float
        if (!is_null($maxDonationAmount) && !(is_float($maxDonationAmount) || is_numeric($maxDonationAmount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($maxDonationAmount, true), gettype($maxDonationAmount)), __LINE__);
        }
        $this->maxDonationAmount = $maxDonationAmount;
        return $this;
    }
    /**
     * Get dontShowPrice value
     * @return bool|null
     */
    public function getDontShowPrice()
    {
        return $this->dontShowPrice;
    }
    /**
     * Set dontShowPrice value
     * @param bool $dontShowPrice
     * @return \StructType\ServiceSaleItem
     */
    public function setDontShowPrice($dontShowPrice = null)
    {
        // validation for constraint: boolean
        if (!is_null($dontShowPrice) && !is_bool($dontShowPrice)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($dontShowPrice, true), gettype($dontShowPrice)), __LINE__);
        }
        $this->dontShowPrice = $dontShowPrice;
        return $this;
    }
    /**
     * Get noPriceMessage value
     * @return string|null
     */
    public function getNoPriceMessage()
    {
        return $this->noPriceMessage;
    }
    /**
     * Set noPriceMessage value
     * @param string $noPriceMessage
     * @return \StructType\ServiceSaleItem
     */
    public function setNoPriceMessage($noPriceMessage = null)
    {
        // validation for constraint: string
        if (!is_null($noPriceMessage) && !is_string($noPriceMessage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($noPriceMessage, true), gettype($noPriceMessage)), __LINE__);
        }
        $this->noPriceMessage = $noPriceMessage;
        return $this;
    }
    /**
     * Get outOfStockMessage value
     * @return string|null
     */
    public function getOutOfStockMessage()
    {
        return $this->outOfStockMessage;
    }
    /**
     * Set outOfStockMessage value
     * @param string $outOfStockMessage
     * @return \StructType\ServiceSaleItem
     */
    public function setOutOfStockMessage($outOfStockMessage = null)
    {
        // validation for constraint: string
        if (!is_null($outOfStockMessage) && !is_string($outOfStockMessage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($outOfStockMessage, true), gettype($outOfStockMessage)), __LINE__);
        }
        $this->outOfStockMessage = $outOfStockMessage;
        return $this;
    }
    /**
     * Get onSpecial value
     * @return bool|null
     */
    public function getOnSpecial()
    {
        return $this->onSpecial;
    }
    /**
     * Set onSpecial value
     * @param bool $onSpecial
     * @return \StructType\ServiceSaleItem
     */
    public function setOnSpecial($onSpecial = null)
    {
        // validation for constraint: boolean
        if (!is_null($onSpecial) && !is_bool($onSpecial)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($onSpecial, true), gettype($onSpecial)), __LINE__);
        }
        $this->onSpecial = $onSpecial;
        return $this;
    }
    /**
     * Get outOfStockBehavior value
     * @return string|null
     */
    public function getOutOfStockBehavior()
    {
        return $this->outOfStockBehavior;
    }
    /**
     * Set outOfStockBehavior value
     * @uses \EnumType\ItemOutOfStockBehavior::valueIsValid()
     * @uses \EnumType\ItemOutOfStockBehavior::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $outOfStockBehavior
     * @return \StructType\ServiceSaleItem
     */
    public function setOutOfStockBehavior($outOfStockBehavior = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\ItemOutOfStockBehavior::valueIsValid($outOfStockBehavior)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\ItemOutOfStockBehavior', is_array($outOfStockBehavior) ? implode(', ', $outOfStockBehavior) : var_export($outOfStockBehavior, true), implode(', ', \EnumType\ItemOutOfStockBehavior::getValidValues())), __LINE__);
        }
        $this->outOfStockBehavior = $outOfStockBehavior;
        return $this;
    }
    /**
     * Get relatedItemsDescription value
     * @return string|null
     */
    public function getRelatedItemsDescription()
    {
        return $this->relatedItemsDescription;
    }
    /**
     * Set relatedItemsDescription value
     * @param string $relatedItemsDescription
     * @return \StructType\ServiceSaleItem
     */
    public function setRelatedItemsDescription($relatedItemsDescription = null)
    {
        // validation for constraint: string
        if (!is_null($relatedItemsDescription) && !is_string($relatedItemsDescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($relatedItemsDescription, true), gettype($relatedItemsDescription)), __LINE__);
        }
        $this->relatedItemsDescription = $relatedItemsDescription;
        return $this;
    }
    /**
     * Get specialsDescription value
     * @return string|null
     */
    public function getSpecialsDescription()
    {
        return $this->specialsDescription;
    }
    /**
     * Set specialsDescription value
     * @param string $specialsDescription
     * @return \StructType\ServiceSaleItem
     */
    public function setSpecialsDescription($specialsDescription = null)
    {
        // validation for constraint: string
        if (!is_null($specialsDescription) && !is_string($specialsDescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($specialsDescription, true), gettype($specialsDescription)), __LINE__);
        }
        $this->specialsDescription = $specialsDescription;
        return $this;
    }
    /**
     * Get itemTaskTemplatesList value
     * @return \StructType\ServiceItemTaskTemplatesList|null
     */
    public function getItemTaskTemplatesList()
    {
        return $this->itemTaskTemplatesList;
    }
    /**
     * Set itemTaskTemplatesList value
     * @param \StructType\ServiceItemTaskTemplatesList $itemTaskTemplatesList
     * @return \StructType\ServiceSaleItem
     */
    public function setItemTaskTemplatesList(\StructType\ServiceItemTaskTemplatesList $itemTaskTemplatesList = null)
    {
        $this->itemTaskTemplatesList = $itemTaskTemplatesList;
        return $this;
    }
    /**
     * Get featuredDescription value
     * @return string|null
     */
    public function getFeaturedDescription()
    {
        return $this->featuredDescription;
    }
    /**
     * Set featuredDescription value
     * @param string $featuredDescription
     * @return \StructType\ServiceSaleItem
     */
    public function setFeaturedDescription($featuredDescription = null)
    {
        // validation for constraint: string
        if (!is_null($featuredDescription) && !is_string($featuredDescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($featuredDescription, true), gettype($featuredDescription)), __LINE__);
        }
        $this->featuredDescription = $featuredDescription;
        return $this;
    }
    /**
     * Get customForm value
     * @return \StructType\RecordRef|null
     */
    public function getCustomForm()
    {
        return $this->customForm;
    }
    /**
     * Set customForm value
     * @param \StructType\RecordRef $customForm
     * @return \StructType\ServiceSaleItem
     */
    public function setCustomForm(\StructType\RecordRef $customForm = null)
    {
        $this->customForm = $customForm;
        return $this;
    }
    /**
     * Get itemId value
     * @return string|null
     */
    public function getItemId()
    {
        return $this->itemId;
    }
    /**
     * Set itemId value
     * @param string $itemId
     * @return \StructType\ServiceSaleItem
     */
    public function setItemId($itemId = null)
    {
        // validation for constraint: string
        if (!is_null($itemId) && !is_string($itemId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($itemId, true), gettype($itemId)), __LINE__);
        }
        $this->itemId = $itemId;
        return $this;
    }
    /**
     * Get upcCode value
     * @return string|null
     */
    public function getUpcCode()
    {
        return $this->upcCode;
    }
    /**
     * Set upcCode value
     * @param string $upcCode
     * @return \StructType\ServiceSaleItem
     */
    public function setUpcCode($upcCode = null)
    {
        // validation for constraint: string
        if (!is_null($upcCode) && !is_string($upcCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($upcCode, true), gettype($upcCode)), __LINE__);
        }
        $this->upcCode = $upcCode;
        return $this;
    }
    /**
     * Get displayName value
     * @return string|null
     */
    public function getDisplayName()
    {
        return $this->displayName;
    }
    /**
     * Set displayName value
     * @param string $displayName
     * @return \StructType\ServiceSaleItem
     */
    public function setDisplayName($displayName = null)
    {
        // validation for constraint: string
        if (!is_null($displayName) && !is_string($displayName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($displayName, true), gettype($displayName)), __LINE__);
        }
        $this->displayName = $displayName;
        return $this;
    }
    /**
     * Get parent value
     * @return \StructType\RecordRef|null
     */
    public function getParent()
    {
        return $this->parent;
    }
    /**
     * Set parent value
     * @param \StructType\RecordRef $parent
     * @return \StructType\ServiceSaleItem
     */
    public function setParent(\StructType\RecordRef $parent = null)
    {
        $this->parent = $parent;
        return $this;
    }
    /**
     * Get isOnline value
     * @return bool|null
     */
    public function getIsOnline()
    {
        return $this->isOnline;
    }
    /**
     * Set isOnline value
     * @param bool $isOnline
     * @return \StructType\ServiceSaleItem
     */
    public function setIsOnline($isOnline = null)
    {
        // validation for constraint: boolean
        if (!is_null($isOnline) && !is_bool($isOnline)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isOnline, true), gettype($isOnline)), __LINE__);
        }
        $this->isOnline = $isOnline;
        return $this;
    }
    /**
     * Get isGcoCompliant value
     * @return bool|null
     */
    public function getIsGcoCompliant()
    {
        return $this->isGcoCompliant;
    }
    /**
     * Set isGcoCompliant value
     * @param bool $isGcoCompliant
     * @return \StructType\ServiceSaleItem
     */
    public function setIsGcoCompliant($isGcoCompliant = null)
    {
        // validation for constraint: boolean
        if (!is_null($isGcoCompliant) && !is_bool($isGcoCompliant)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isGcoCompliant, true), gettype($isGcoCompliant)), __LINE__);
        }
        $this->isGcoCompliant = $isGcoCompliant;
        return $this;
    }
    /**
     * Get offerSupport value
     * @return bool|null
     */
    public function getOfferSupport()
    {
        return $this->offerSupport;
    }
    /**
     * Set offerSupport value
     * @param bool $offerSupport
     * @return \StructType\ServiceSaleItem
     */
    public function setOfferSupport($offerSupport = null)
    {
        // validation for constraint: boolean
        if (!is_null($offerSupport) && !is_bool($offerSupport)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($offerSupport, true), gettype($offerSupport)), __LINE__);
        }
        $this->offerSupport = $offerSupport;
        return $this;
    }
    /**
     * Get isInactive value
     * @return bool|null
     */
    public function getIsInactive()
    {
        return $this->isInactive;
    }
    /**
     * Set isInactive value
     * @param bool $isInactive
     * @return \StructType\ServiceSaleItem
     */
    public function setIsInactive($isInactive = null)
    {
        // validation for constraint: boolean
        if (!is_null($isInactive) && !is_bool($isInactive)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isInactive, true), gettype($isInactive)), __LINE__);
        }
        $this->isInactive = $isInactive;
        return $this;
    }
    /**
     * Get availableToPartners value
     * @return bool|null
     */
    public function getAvailableToPartners()
    {
        return $this->availableToPartners;
    }
    /**
     * Set availableToPartners value
     * @param bool $availableToPartners
     * @return \StructType\ServiceSaleItem
     */
    public function setAvailableToPartners($availableToPartners = null)
    {
        // validation for constraint: boolean
        if (!is_null($availableToPartners) && !is_bool($availableToPartners)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($availableToPartners, true), gettype($availableToPartners)), __LINE__);
        }
        $this->availableToPartners = $availableToPartners;
        return $this;
    }
    /**
     * Get department value
     * @return \StructType\RecordRef|null
     */
    public function getDepartment()
    {
        return $this->department;
    }
    /**
     * Set department value
     * @param \StructType\RecordRef $department
     * @return \StructType\ServiceSaleItem
     */
    public function setDepartment(\StructType\RecordRef $department = null)
    {
        $this->department = $department;
        return $this;
    }
    /**
     * Get class value
     * @return \StructType\RecordRef|null
     */
    public function getClass()
    {
        return $this->class;
    }
    /**
     * Set class value
     * @param \StructType\RecordRef $class
     * @return \StructType\ServiceSaleItem
     */
    public function setClass(\StructType\RecordRef $class = null)
    {
        $this->class = $class;
        return $this;
    }
    /**
     * Get location value
     * @return \StructType\RecordRef|null
     */
    public function getLocation()
    {
        return $this->location;
    }
    /**
     * Set location value
     * @param \StructType\RecordRef $location
     * @return \StructType\ServiceSaleItem
     */
    public function setLocation(\StructType\RecordRef $location = null)
    {
        $this->location = $location;
        return $this;
    }
    /**
     * Get subsidiaryList value
     * @return \StructType\RecordRefList|null
     */
    public function getSubsidiaryList()
    {
        return $this->subsidiaryList;
    }
    /**
     * Set subsidiaryList value
     * @param \StructType\RecordRefList $subsidiaryList
     * @return \StructType\ServiceSaleItem
     */
    public function setSubsidiaryList(\StructType\RecordRefList $subsidiaryList = null)
    {
        $this->subsidiaryList = $subsidiaryList;
        return $this;
    }
    /**
     * Get billingRatesMatrix value
     * @return \StructType\BillingRatesMatrix|null
     */
    public function getBillingRatesMatrix()
    {
        return $this->billingRatesMatrix;
    }
    /**
     * Set billingRatesMatrix value
     * @param \StructType\BillingRatesMatrix $billingRatesMatrix
     * @return \StructType\ServiceSaleItem
     */
    public function setBillingRatesMatrix(\StructType\BillingRatesMatrix $billingRatesMatrix = null)
    {
        $this->billingRatesMatrix = $billingRatesMatrix;
        return $this;
    }
    /**
     * Get accountingBookDetailList value
     * @return \StructType\ItemAccountingBookDetailList|null
     */
    public function getAccountingBookDetailList()
    {
        return $this->accountingBookDetailList;
    }
    /**
     * Set accountingBookDetailList value
     * @param \StructType\ItemAccountingBookDetailList $accountingBookDetailList
     * @return \StructType\ServiceSaleItem
     */
    public function setAccountingBookDetailList(\StructType\ItemAccountingBookDetailList $accountingBookDetailList = null)
    {
        $this->accountingBookDetailList = $accountingBookDetailList;
        return $this;
    }
    /**
     * Get itemOptionsList value
     * @return \StructType\ItemOptionsList|null
     */
    public function getItemOptionsList()
    {
        return $this->itemOptionsList;
    }
    /**
     * Set itemOptionsList value
     * @param \StructType\ItemOptionsList $itemOptionsList
     * @return \StructType\ServiceSaleItem
     */
    public function setItemOptionsList(\StructType\ItemOptionsList $itemOptionsList = null)
    {
        $this->itemOptionsList = $itemOptionsList;
        return $this;
    }
    /**
     * Get matrixOptionList value
     * @return \StructType\MatrixOptionList|null
     */
    public function getMatrixOptionList()
    {
        return $this->matrixOptionList;
    }
    /**
     * Set matrixOptionList value
     * @param \StructType\MatrixOptionList $matrixOptionList
     * @return \StructType\ServiceSaleItem
     */
    public function setMatrixOptionList(\StructType\MatrixOptionList $matrixOptionList = null)
    {
        $this->matrixOptionList = $matrixOptionList;
        return $this;
    }
    /**
     * Get pricingMatrix value
     * @return \StructType\PricingMatrix|null
     */
    public function getPricingMatrix()
    {
        return $this->pricingMatrix;
    }
    /**
     * Set pricingMatrix value
     * @param \StructType\PricingMatrix $pricingMatrix
     * @return \StructType\ServiceSaleItem
     */
    public function setPricingMatrix(\StructType\PricingMatrix $pricingMatrix = null)
    {
        $this->pricingMatrix = $pricingMatrix;
        return $this;
    }
    /**
     * Get purchaseTaxCode value
     * @return \StructType\RecordRef|null
     */
    public function getPurchaseTaxCode()
    {
        return $this->purchaseTaxCode;
    }
    /**
     * Set purchaseTaxCode value
     * @param \StructType\RecordRef $purchaseTaxCode
     * @return \StructType\ServiceSaleItem
     */
    public function setPurchaseTaxCode(\StructType\RecordRef $purchaseTaxCode = null)
    {
        $this->purchaseTaxCode = $purchaseTaxCode;
        return $this;
    }
    /**
     * Get rate value
     * @return float|null
     */
    public function getRate()
    {
        return $this->rate;
    }
    /**
     * Set rate value
     * @param float $rate
     * @return \StructType\ServiceSaleItem
     */
    public function setRate($rate = null)
    {
        // validation for constraint: float
        if (!is_null($rate) && !(is_float($rate) || is_numeric($rate))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($rate, true), gettype($rate)), __LINE__);
        }
        $this->rate = $rate;
        return $this;
    }
    /**
     * Get salesTaxCode value
     * @return \StructType\RecordRef|null
     */
    public function getSalesTaxCode()
    {
        return $this->salesTaxCode;
    }
    /**
     * Set salesTaxCode value
     * @param \StructType\RecordRef $salesTaxCode
     * @return \StructType\ServiceSaleItem
     */
    public function setSalesTaxCode(\StructType\RecordRef $salesTaxCode = null)
    {
        $this->salesTaxCode = $salesTaxCode;
        return $this;
    }
    /**
     * Get siteCategoryList value
     * @return \StructType\SiteCategoryList|null
     */
    public function getSiteCategoryList()
    {
        return $this->siteCategoryList;
    }
    /**
     * Set siteCategoryList value
     * @param \StructType\SiteCategoryList $siteCategoryList
     * @return \StructType\ServiceSaleItem
     */
    public function setSiteCategoryList(\StructType\SiteCategoryList $siteCategoryList = null)
    {
        $this->siteCategoryList = $siteCategoryList;
        return $this;
    }
    /**
     * Get translationsList value
     * @return \StructType\TranslationList|null
     */
    public function getTranslationsList()
    {
        return $this->translationsList;
    }
    /**
     * Set translationsList value
     * @param \StructType\TranslationList $translationsList
     * @return \StructType\ServiceSaleItem
     */
    public function setTranslationsList(\StructType\TranslationList $translationsList = null)
    {
        $this->translationsList = $translationsList;
        return $this;
    }
    /**
     * Get presentationItemList value
     * @return \StructType\PresentationItemList|null
     */
    public function getPresentationItemList()
    {
        return $this->presentationItemList;
    }
    /**
     * Set presentationItemList value
     * @param \StructType\PresentationItemList $presentationItemList
     * @return \StructType\ServiceSaleItem
     */
    public function setPresentationItemList(\StructType\PresentationItemList $presentationItemList = null)
    {
        $this->presentationItemList = $presentationItemList;
        return $this;
    }
    /**
     * Get hierarchyVersionsList value
     * @return \StructType\ServiceSaleItemHierarchyVersionsList|null
     */
    public function getHierarchyVersionsList()
    {
        return $this->hierarchyVersionsList;
    }
    /**
     * Set hierarchyVersionsList value
     * @param \StructType\ServiceSaleItemHierarchyVersionsList $hierarchyVersionsList
     * @return \StructType\ServiceSaleItem
     */
    public function setHierarchyVersionsList(\StructType\ServiceSaleItemHierarchyVersionsList $hierarchyVersionsList = null)
    {
        $this->hierarchyVersionsList = $hierarchyVersionsList;
        return $this;
    }
    /**
     * Get consumptionUnit value
     * @return \StructType\RecordRef|null
     */
    public function getConsumptionUnit()
    {
        return $this->consumptionUnit;
    }
    /**
     * Set consumptionUnit value
     * @param \StructType\RecordRef $consumptionUnit
     * @return \StructType\ServiceSaleItem
     */
    public function setConsumptionUnit(\StructType\RecordRef $consumptionUnit = null)
    {
        $this->consumptionUnit = $consumptionUnit;
        return $this;
    }
    /**
     * Get customFieldList value
     * @return \StructType\CustomFieldList|null
     */
    public function getCustomFieldList()
    {
        return $this->customFieldList;
    }
    /**
     * Set customFieldList value
     * @param \StructType\CustomFieldList $customFieldList
     * @return \StructType\ServiceSaleItem
     */
    public function setCustomFieldList(\StructType\CustomFieldList $customFieldList = null)
    {
        $this->customFieldList = $customFieldList;
        return $this;
    }
    /**
     * Get internalId value
     * @return string|null
     */
    public function getInternalId()
    {
        return $this->internalId;
    }
    /**
     * Set internalId value
     * @param string $internalId
     * @return \StructType\ServiceSaleItem
     */
    public function setInternalId($internalId = null)
    {
        // validation for constraint: string
        if (!is_null($internalId) && !is_string($internalId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($internalId, true), gettype($internalId)), __LINE__);
        }
        $this->internalId = $internalId;
        return $this;
    }
    /**
     * Get externalId value
     * @return string|null
     */
    public function getExternalId()
    {
        return $this->externalId;
    }
    /**
     * Set externalId value
     * @param string $externalId
     * @return \StructType\ServiceSaleItem
     */
    public function setExternalId($externalId = null)
    {
        // validation for constraint: string
        if (!is_null($externalId) && !is_string($externalId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($externalId, true), gettype($externalId)), __LINE__);
        }
        $this->externalId = $externalId;
        return $this;
    }
}
