<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ServiceItemTaskTemplates StructType
 * @subpackage Structs
 */
class ServiceItemTaskTemplates extends AbstractStructBase
{
    /**
     * The taskName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $taskName;
    /**
     * The taskStartOffset
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $taskStartOffset;
    /**
     * The taskDuration
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Duration
     */
    public $taskDuration;
    /**
     * Constructor method for ServiceItemTaskTemplates
     * @uses ServiceItemTaskTemplates::setTaskName()
     * @uses ServiceItemTaskTemplates::setTaskStartOffset()
     * @uses ServiceItemTaskTemplates::setTaskDuration()
     * @param string $taskName
     * @param int $taskStartOffset
     * @param \StructType\Duration $taskDuration
     */
    public function __construct($taskName = null, $taskStartOffset = null, \StructType\Duration $taskDuration = null)
    {
        $this
            ->setTaskName($taskName)
            ->setTaskStartOffset($taskStartOffset)
            ->setTaskDuration($taskDuration);
    }
    /**
     * Get taskName value
     * @return string|null
     */
    public function getTaskName()
    {
        return $this->taskName;
    }
    /**
     * Set taskName value
     * @param string $taskName
     * @return \StructType\ServiceItemTaskTemplates
     */
    public function setTaskName($taskName = null)
    {
        // validation for constraint: string
        if (!is_null($taskName) && !is_string($taskName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($taskName, true), gettype($taskName)), __LINE__);
        }
        $this->taskName = $taskName;
        return $this;
    }
    /**
     * Get taskStartOffset value
     * @return int|null
     */
    public function getTaskStartOffset()
    {
        return $this->taskStartOffset;
    }
    /**
     * Set taskStartOffset value
     * @param int $taskStartOffset
     * @return \StructType\ServiceItemTaskTemplates
     */
    public function setTaskStartOffset($taskStartOffset = null)
    {
        // validation for constraint: int
        if (!is_null($taskStartOffset) && !(is_int($taskStartOffset) || ctype_digit($taskStartOffset))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($taskStartOffset, true), gettype($taskStartOffset)), __LINE__);
        }
        $this->taskStartOffset = $taskStartOffset;
        return $this;
    }
    /**
     * Get taskDuration value
     * @return \StructType\Duration|null
     */
    public function getTaskDuration()
    {
        return $this->taskDuration;
    }
    /**
     * Set taskDuration value
     * @param \StructType\Duration $taskDuration
     * @return \StructType\ServiceItemTaskTemplates
     */
    public function setTaskDuration(\StructType\Duration $taskDuration = null)
    {
        $this->taskDuration = $taskDuration;
        return $this;
    }
}
