<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SerializedInventoryItemNumbersList StructType
 * @subpackage Structs
 */
class SerializedInventoryItemNumbersList extends AbstractStructBase
{
    /**
     * The numbers
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SerializedInventoryItemNumbers[]
     */
    public $numbers;
    /**
     * The replaceAll
     * Meta information extracted from the WSDL
     * - default: true
     * @var bool
     */
    public $replaceAll;
    /**
     * Constructor method for SerializedInventoryItemNumbersList
     * @uses SerializedInventoryItemNumbersList::setNumbers()
     * @uses SerializedInventoryItemNumbersList::setReplaceAll()
     * @param \StructType\SerializedInventoryItemNumbers[] $numbers
     * @param bool $replaceAll
     */
    public function __construct(array $numbers = array(), $replaceAll = true)
    {
        $this
            ->setNumbers($numbers)
            ->setReplaceAll($replaceAll);
    }
    /**
     * Get numbers value
     * @return \StructType\SerializedInventoryItemNumbers[]|null
     */
    public function getNumbers()
    {
        return $this->numbers;
    }
    /**
     * This method is responsible for validating the values passed to the setNumbers method
     * This method is willingly generated in order to preserve the one-line inline validation within the setNumbers method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateNumbersForArrayConstraintsFromSetNumbers(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $serializedInventoryItemNumbersListNumbersItem) {
            // validation for constraint: itemType
            if (!$serializedInventoryItemNumbersListNumbersItem instanceof \StructType\SerializedInventoryItemNumbers) {
                $invalidValues[] = is_object($serializedInventoryItemNumbersListNumbersItem) ? get_class($serializedInventoryItemNumbersListNumbersItem) : sprintf('%s(%s)', gettype($serializedInventoryItemNumbersListNumbersItem), var_export($serializedInventoryItemNumbersListNumbersItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The numbers property can only contain items of type \StructType\SerializedInventoryItemNumbers, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set numbers value
     * @throws \InvalidArgumentException
     * @param \StructType\SerializedInventoryItemNumbers[] $numbers
     * @return \StructType\SerializedInventoryItemNumbersList
     */
    public function setNumbers(array $numbers = array())
    {
        // validation for constraint: array
        if ('' !== ($numbersArrayErrorMessage = self::validateNumbersForArrayConstraintsFromSetNumbers($numbers))) {
            throw new \InvalidArgumentException($numbersArrayErrorMessage, __LINE__);
        }
        $this->numbers = $numbers;
        return $this;
    }
    /**
     * Add item to numbers value
     * @throws \InvalidArgumentException
     * @param \StructType\SerializedInventoryItemNumbers $item
     * @return \StructType\SerializedInventoryItemNumbersList
     */
    public function addToNumbers(\StructType\SerializedInventoryItemNumbers $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SerializedInventoryItemNumbers) {
            throw new \InvalidArgumentException(sprintf('The numbers property can only contain items of type \StructType\SerializedInventoryItemNumbers, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->numbers[] = $item;
        return $this;
    }
    /**
     * Get replaceAll value
     * @return bool|null
     */
    public function getReplaceAll()
    {
        return $this->replaceAll;
    }
    /**
     * Set replaceAll value
     * @param bool $replaceAll
     * @return \StructType\SerializedInventoryItemNumbersList
     */
    public function setReplaceAll($replaceAll = true)
    {
        // validation for constraint: boolean
        if (!is_null($replaceAll) && !is_bool($replaceAll)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($replaceAll, true), gettype($replaceAll)), __LINE__);
        }
        $this->replaceAll = $replaceAll;
        return $this;
    }
}
