<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SearchTextNumberField StructType
 * @subpackage Structs
 */
class SearchTextNumberField extends AbstractStructBase
{
    /**
     * The searchValue
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $searchValue;
    /**
     * The searchValue2
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $searchValue2;
    /**
     * The operator
     * @var string
     */
    public $operator;
    /**
     * Constructor method for SearchTextNumberField
     * @uses SearchTextNumberField::setSearchValue()
     * @uses SearchTextNumberField::setSearchValue2()
     * @uses SearchTextNumberField::setOperator()
     * @param string $searchValue
     * @param string $searchValue2
     * @param string $operator
     */
    public function __construct($searchValue = null, $searchValue2 = null, $operator = null)
    {
        $this
            ->setSearchValue($searchValue)
            ->setSearchValue2($searchValue2)
            ->setOperator($operator);
    }
    /**
     * Get searchValue value
     * @return string|null
     */
    public function getSearchValue()
    {
        return $this->searchValue;
    }
    /**
     * Set searchValue value
     * @param string $searchValue
     * @return \StructType\SearchTextNumberField
     */
    public function setSearchValue($searchValue = null)
    {
        // validation for constraint: string
        if (!is_null($searchValue) && !is_string($searchValue)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($searchValue, true), gettype($searchValue)), __LINE__);
        }
        $this->searchValue = $searchValue;
        return $this;
    }
    /**
     * Get searchValue2 value
     * @return string|null
     */
    public function getSearchValue2()
    {
        return $this->searchValue2;
    }
    /**
     * Set searchValue2 value
     * @param string $searchValue2
     * @return \StructType\SearchTextNumberField
     */
    public function setSearchValue2($searchValue2 = null)
    {
        // validation for constraint: string
        if (!is_null($searchValue2) && !is_string($searchValue2)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($searchValue2, true), gettype($searchValue2)), __LINE__);
        }
        $this->searchValue2 = $searchValue2;
        return $this;
    }
    /**
     * Get operator value
     * @return string|null
     */
    public function getOperator()
    {
        return $this->operator;
    }
    /**
     * Set operator value
     * @uses \EnumType\SearchTextNumberFieldOperator::valueIsValid()
     * @uses \EnumType\SearchTextNumberFieldOperator::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $operator
     * @return \StructType\SearchTextNumberField
     */
    public function setOperator($operator = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\SearchTextNumberFieldOperator::valueIsValid($operator)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\SearchTextNumberFieldOperator', is_array($operator) ? implode(', ', $operator) : var_export($operator, true), implode(', ', \EnumType\SearchTextNumberFieldOperator::getValidValues())), __LINE__);
        }
        $this->operator = $operator;
        return $this;
    }
}
