<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SearchStringCustomField StructType
 * @subpackage Structs
 */
class SearchStringCustomField extends SearchCustomField
{
    /**
     * The searchValue
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $searchValue;
    /**
     * The operator
     * @var string
     */
    public $operator;
    /**
     * Constructor method for SearchStringCustomField
     * @uses SearchStringCustomField::setSearchValue()
     * @uses SearchStringCustomField::setOperator()
     * @param string $searchValue
     * @param string $operator
     */
    public function __construct($searchValue = null, $operator = null)
    {
        $this
            ->setSearchValue($searchValue)
            ->setOperator($operator);
    }
    /**
     * Get searchValue value
     * @return string|null
     */
    public function getSearchValue()
    {
        return $this->searchValue;
    }
    /**
     * Set searchValue value
     * @param string $searchValue
     * @return \StructType\SearchStringCustomField
     */
    public function setSearchValue($searchValue = null)
    {
        // validation for constraint: string
        if (!is_null($searchValue) && !is_string($searchValue)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($searchValue, true), gettype($searchValue)), __LINE__);
        }
        $this->searchValue = $searchValue;
        return $this;
    }
    /**
     * Get operator value
     * @return string|null
     */
    public function getOperator()
    {
        return $this->operator;
    }
    /**
     * Set operator value
     * @uses \EnumType\SearchStringFieldOperator::valueIsValid()
     * @uses \EnumType\SearchStringFieldOperator::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $operator
     * @return \StructType\SearchStringCustomField
     */
    public function setOperator($operator = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\SearchStringFieldOperator::valueIsValid($operator)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\SearchStringFieldOperator', is_array($operator) ? implode(', ', $operator) : var_export($operator, true), implode(', ', \EnumType\SearchStringFieldOperator::getValidValues())), __LINE__);
        }
        $this->operator = $operator;
        return $this;
    }
}
