<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SearchResult StructType
 * @subpackage Structs
 */
class SearchResult extends AbstractStructBase
{
    /**
     * The status
     * Meta information extracted from the WSDL
     * - ref: platformCore:status
     * @var \StructType\Status
     */
    public $status;
    /**
     * The totalRecords
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $totalRecords;
    /**
     * The pageSize
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $pageSize;
    /**
     * The totalPages
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $totalPages;
    /**
     * The pageIndex
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $pageIndex;
    /**
     * The searchId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $searchId;
    /**
     * The recordList
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - ref: platformCore:recordList
     * @var \StructType\RecordList
     */
    public $recordList;
    /**
     * The searchRowList
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - ref: platformCore:searchRowList
     * @var \StructType\SearchRowList
     */
    public $searchRowList;
    /**
     * Constructor method for SearchResult
     * @uses SearchResult::setStatus()
     * @uses SearchResult::setTotalRecords()
     * @uses SearchResult::setPageSize()
     * @uses SearchResult::setTotalPages()
     * @uses SearchResult::setPageIndex()
     * @uses SearchResult::setSearchId()
     * @uses SearchResult::setRecordList()
     * @uses SearchResult::setSearchRowList()
     * @param \StructType\Status $status
     * @param int $totalRecords
     * @param int $pageSize
     * @param int $totalPages
     * @param int $pageIndex
     * @param string $searchId
     * @param \StructType\RecordList $recordList
     * @param \StructType\SearchRowList $searchRowList
     */
    public function __construct(\StructType\Status $status = null, $totalRecords = null, $pageSize = null, $totalPages = null, $pageIndex = null, $searchId = null, \StructType\RecordList $recordList = null, \StructType\SearchRowList $searchRowList = null)
    {
        $this
            ->setStatus($status)
            ->setTotalRecords($totalRecords)
            ->setPageSize($pageSize)
            ->setTotalPages($totalPages)
            ->setPageIndex($pageIndex)
            ->setSearchId($searchId)
            ->setRecordList($recordList)
            ->setSearchRowList($searchRowList);
    }
    /**
     * Get status value
     * @return \StructType\Status|null
     */
    public function getStatus()
    {
        return $this->status;
    }
    /**
     * Set status value
     * @param \StructType\Status $status
     * @return \StructType\SearchResult
     */
    public function setStatus(\StructType\Status $status = null)
    {
        $this->status = $status;
        return $this;
    }
    /**
     * Get totalRecords value
     * @return int|null
     */
    public function getTotalRecords()
    {
        return $this->totalRecords;
    }
    /**
     * Set totalRecords value
     * @param int $totalRecords
     * @return \StructType\SearchResult
     */
    public function setTotalRecords($totalRecords = null)
    {
        // validation for constraint: int
        if (!is_null($totalRecords) && !(is_int($totalRecords) || ctype_digit($totalRecords))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($totalRecords, true), gettype($totalRecords)), __LINE__);
        }
        $this->totalRecords = $totalRecords;
        return $this;
    }
    /**
     * Get pageSize value
     * @return int|null
     */
    public function getPageSize()
    {
        return $this->pageSize;
    }
    /**
     * Set pageSize value
     * @param int $pageSize
     * @return \StructType\SearchResult
     */
    public function setPageSize($pageSize = null)
    {
        // validation for constraint: int
        if (!is_null($pageSize) && !(is_int($pageSize) || ctype_digit($pageSize))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($pageSize, true), gettype($pageSize)), __LINE__);
        }
        $this->pageSize = $pageSize;
        return $this;
    }
    /**
     * Get totalPages value
     * @return int|null
     */
    public function getTotalPages()
    {
        return $this->totalPages;
    }
    /**
     * Set totalPages value
     * @param int $totalPages
     * @return \StructType\SearchResult
     */
    public function setTotalPages($totalPages = null)
    {
        // validation for constraint: int
        if (!is_null($totalPages) && !(is_int($totalPages) || ctype_digit($totalPages))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($totalPages, true), gettype($totalPages)), __LINE__);
        }
        $this->totalPages = $totalPages;
        return $this;
    }
    /**
     * Get pageIndex value
     * @return int|null
     */
    public function getPageIndex()
    {
        return $this->pageIndex;
    }
    /**
     * Set pageIndex value
     * @param int $pageIndex
     * @return \StructType\SearchResult
     */
    public function setPageIndex($pageIndex = null)
    {
        // validation for constraint: int
        if (!is_null($pageIndex) && !(is_int($pageIndex) || ctype_digit($pageIndex))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($pageIndex, true), gettype($pageIndex)), __LINE__);
        }
        $this->pageIndex = $pageIndex;
        return $this;
    }
    /**
     * Get searchId value
     * @return string|null
     */
    public function getSearchId()
    {
        return $this->searchId;
    }
    /**
     * Set searchId value
     * @param string $searchId
     * @return \StructType\SearchResult
     */
    public function setSearchId($searchId = null)
    {
        // validation for constraint: string
        if (!is_null($searchId) && !is_string($searchId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($searchId, true), gettype($searchId)), __LINE__);
        }
        $this->searchId = $searchId;
        return $this;
    }
    /**
     * Get recordList value
     * @return \StructType\RecordList|null
     */
    public function getRecordList()
    {
        return $this->recordList;
    }
    /**
     * Set recordList value
     * @param \StructType\RecordList $recordList
     * @return \StructType\SearchResult
     */
    public function setRecordList(\StructType\RecordList $recordList = null)
    {
        $this->recordList = $recordList;
        return $this;
    }
    /**
     * Get searchRowList value
     * @return \StructType\SearchRowList|null
     */
    public function getSearchRowList()
    {
        return $this->searchRowList;
    }
    /**
     * Set searchRowList value
     * @param \StructType\SearchRowList $searchRowList
     * @return \StructType\SearchResult
     */
    public function setSearchRowList(\StructType\SearchRowList $searchRowList = null)
    {
        $this->searchRowList = $searchRowList;
        return $this;
    }
}
