<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SearchPreferences StructType
 * @subpackage Structs
 */
class SearchPreferences extends AbstractStructBase
{
    /**
     * The bodyFieldsOnly
     * Meta information extracted from the WSDL
     * - default: true
     * - minOccurs: 0
     * @var bool
     */
    public $bodyFieldsOnly;
    /**
     * The returnSearchColumns
     * Meta information extracted from the WSDL
     * - default: true
     * - minOccurs: 0
     * @var bool
     */
    public $returnSearchColumns;
    /**
     * The pageSize
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $pageSize;
    /**
     * Constructor method for SearchPreferences
     * @uses SearchPreferences::setBodyFieldsOnly()
     * @uses SearchPreferences::setReturnSearchColumns()
     * @uses SearchPreferences::setPageSize()
     * @param bool $bodyFieldsOnly
     * @param bool $returnSearchColumns
     * @param int $pageSize
     */
    public function __construct($bodyFieldsOnly = true, $returnSearchColumns = true, $pageSize = null)
    {
        $this
            ->setBodyFieldsOnly($bodyFieldsOnly)
            ->setReturnSearchColumns($returnSearchColumns)
            ->setPageSize($pageSize);
    }
    /**
     * Get bodyFieldsOnly value
     * @return bool|null
     */
    public function getBodyFieldsOnly()
    {
        return $this->bodyFieldsOnly;
    }
    /**
     * Set bodyFieldsOnly value
     * @param bool $bodyFieldsOnly
     * @return \StructType\SearchPreferences
     */
    public function setBodyFieldsOnly($bodyFieldsOnly = true)
    {
        // validation for constraint: boolean
        if (!is_null($bodyFieldsOnly) && !is_bool($bodyFieldsOnly)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($bodyFieldsOnly, true), gettype($bodyFieldsOnly)), __LINE__);
        }
        $this->bodyFieldsOnly = $bodyFieldsOnly;
        return $this;
    }
    /**
     * Get returnSearchColumns value
     * @return bool|null
     */
    public function getReturnSearchColumns()
    {
        return $this->returnSearchColumns;
    }
    /**
     * Set returnSearchColumns value
     * @param bool $returnSearchColumns
     * @return \StructType\SearchPreferences
     */
    public function setReturnSearchColumns($returnSearchColumns = true)
    {
        // validation for constraint: boolean
        if (!is_null($returnSearchColumns) && !is_bool($returnSearchColumns)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($returnSearchColumns, true), gettype($returnSearchColumns)), __LINE__);
        }
        $this->returnSearchColumns = $returnSearchColumns;
        return $this;
    }
    /**
     * Get pageSize value
     * @return int|null
     */
    public function getPageSize()
    {
        return $this->pageSize;
    }
    /**
     * Set pageSize value
     * @param int $pageSize
     * @return \StructType\SearchPreferences
     */
    public function setPageSize($pageSize = null)
    {
        // validation for constraint: int
        if (!is_null($pageSize) && !(is_int($pageSize) || ctype_digit($pageSize))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($pageSize, true), gettype($pageSize)), __LINE__);
        }
        $this->pageSize = $pageSize;
        return $this;
    }
}
