<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SearchMultiSelectField StructType
 * @subpackage Structs
 */
class SearchMultiSelectField extends AbstractStructBase
{
    /**
     * The searchValue
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\RecordRef[]
     */
    public $searchValue;
    /**
     * The operator
     * @var string
     */
    public $operator;
    /**
     * Constructor method for SearchMultiSelectField
     * @uses SearchMultiSelectField::setSearchValue()
     * @uses SearchMultiSelectField::setOperator()
     * @param \StructType\RecordRef[] $searchValue
     * @param string $operator
     */
    public function __construct(array $searchValue = array(), $operator = null)
    {
        $this
            ->setSearchValue($searchValue)
            ->setOperator($operator);
    }
    /**
     * Get searchValue value
     * @return \StructType\RecordRef[]|null
     */
    public function getSearchValue()
    {
        return $this->searchValue;
    }
    /**
     * This method is responsible for validating the values passed to the setSearchValue method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSearchValue method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateSearchValueForArrayConstraintsFromSetSearchValue(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $searchMultiSelectFieldSearchValueItem) {
            // validation for constraint: itemType
            if (!$searchMultiSelectFieldSearchValueItem instanceof \StructType\RecordRef) {
                $invalidValues[] = is_object($searchMultiSelectFieldSearchValueItem) ? get_class($searchMultiSelectFieldSearchValueItem) : sprintf('%s(%s)', gettype($searchMultiSelectFieldSearchValueItem), var_export($searchMultiSelectFieldSearchValueItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The searchValue property can only contain items of type \StructType\RecordRef, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set searchValue value
     * @throws \InvalidArgumentException
     * @param \StructType\RecordRef[] $searchValue
     * @return \StructType\SearchMultiSelectField
     */
    public function setSearchValue(array $searchValue = array())
    {
        // validation for constraint: array
        if ('' !== ($searchValueArrayErrorMessage = self::validateSearchValueForArrayConstraintsFromSetSearchValue($searchValue))) {
            throw new \InvalidArgumentException($searchValueArrayErrorMessage, __LINE__);
        }
        $this->searchValue = $searchValue;
        return $this;
    }
    /**
     * Add item to searchValue value
     * @throws \InvalidArgumentException
     * @param \StructType\RecordRef $item
     * @return \StructType\SearchMultiSelectField
     */
    public function addToSearchValue(\StructType\RecordRef $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\RecordRef) {
            throw new \InvalidArgumentException(sprintf('The searchValue property can only contain items of type \StructType\RecordRef, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->searchValue[] = $item;
        return $this;
    }
    /**
     * Get operator value
     * @return string|null
     */
    public function getOperator()
    {
        return $this->operator;
    }
    /**
     * Set operator value
     * @uses \EnumType\SearchMultiSelectFieldOperator::valueIsValid()
     * @uses \EnumType\SearchMultiSelectFieldOperator::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $operator
     * @return \StructType\SearchMultiSelectField
     */
    public function setOperator($operator = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\SearchMultiSelectFieldOperator::valueIsValid($operator)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\SearchMultiSelectFieldOperator', is_array($operator) ? implode(', ', $operator) : var_export($operator, true), implode(', ', \EnumType\SearchMultiSelectFieldOperator::getValidValues())), __LINE__);
        }
        $this->operator = $operator;
        return $this;
    }
}
