<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SearchDoubleCustomField StructType
 * @subpackage Structs
 */
class SearchDoubleCustomField extends SearchCustomField
{
    /**
     * The searchValue
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $searchValue;
    /**
     * The searchValue2
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $searchValue2;
    /**
     * The operator
     * @var string
     */
    public $operator;
    /**
     * Constructor method for SearchDoubleCustomField
     * @uses SearchDoubleCustomField::setSearchValue()
     * @uses SearchDoubleCustomField::setSearchValue2()
     * @uses SearchDoubleCustomField::setOperator()
     * @param float $searchValue
     * @param float $searchValue2
     * @param string $operator
     */
    public function __construct($searchValue = null, $searchValue2 = null, $operator = null)
    {
        $this
            ->setSearchValue($searchValue)
            ->setSearchValue2($searchValue2)
            ->setOperator($operator);
    }
    /**
     * Get searchValue value
     * @return float|null
     */
    public function getSearchValue()
    {
        return $this->searchValue;
    }
    /**
     * Set searchValue value
     * @param float $searchValue
     * @return \StructType\SearchDoubleCustomField
     */
    public function setSearchValue($searchValue = null)
    {
        // validation for constraint: float
        if (!is_null($searchValue) && !(is_float($searchValue) || is_numeric($searchValue))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($searchValue, true), gettype($searchValue)), __LINE__);
        }
        $this->searchValue = $searchValue;
        return $this;
    }
    /**
     * Get searchValue2 value
     * @return float|null
     */
    public function getSearchValue2()
    {
        return $this->searchValue2;
    }
    /**
     * Set searchValue2 value
     * @param float $searchValue2
     * @return \StructType\SearchDoubleCustomField
     */
    public function setSearchValue2($searchValue2 = null)
    {
        // validation for constraint: float
        if (!is_null($searchValue2) && !(is_float($searchValue2) || is_numeric($searchValue2))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($searchValue2, true), gettype($searchValue2)), __LINE__);
        }
        $this->searchValue2 = $searchValue2;
        return $this;
    }
    /**
     * Get operator value
     * @return string|null
     */
    public function getOperator()
    {
        return $this->operator;
    }
    /**
     * Set operator value
     * @uses \EnumType\SearchDoubleFieldOperator::valueIsValid()
     * @uses \EnumType\SearchDoubleFieldOperator::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $operator
     * @return \StructType\SearchDoubleCustomField
     */
    public function setOperator($operator = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\SearchDoubleFieldOperator::valueIsValid($operator)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\SearchDoubleFieldOperator', is_array($operator) ? implode(', ', $operator) : var_export($operator, true), implode(', ', \EnumType\SearchDoubleFieldOperator::getValidValues())), __LINE__);
        }
        $this->operator = $operator;
        return $this;
    }
}
