<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SearchDateField StructType
 * @subpackage Structs
 */
class SearchDateField extends AbstractStructBase
{
    /**
     * The predefinedSearchValue
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $predefinedSearchValue;
    /**
     * The searchValue
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $searchValue;
    /**
     * The searchValue2
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $searchValue2;
    /**
     * The operator
     * @var string
     */
    public $operator;
    /**
     * Constructor method for SearchDateField
     * @uses SearchDateField::setPredefinedSearchValue()
     * @uses SearchDateField::setSearchValue()
     * @uses SearchDateField::setSearchValue2()
     * @uses SearchDateField::setOperator()
     * @param string $predefinedSearchValue
     * @param string $searchValue
     * @param string $searchValue2
     * @param string $operator
     */
    public function __construct($predefinedSearchValue = null, $searchValue = null, $searchValue2 = null, $operator = null)
    {
        $this
            ->setPredefinedSearchValue($predefinedSearchValue)
            ->setSearchValue($searchValue)
            ->setSearchValue2($searchValue2)
            ->setOperator($operator);
    }
    /**
     * Get predefinedSearchValue value
     * @return string|null
     */
    public function getPredefinedSearchValue()
    {
        return $this->predefinedSearchValue;
    }
    /**
     * Set predefinedSearchValue value
     * @uses \EnumType\SearchDate::valueIsValid()
     * @uses \EnumType\SearchDate::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $predefinedSearchValue
     * @return \StructType\SearchDateField
     */
    public function setPredefinedSearchValue($predefinedSearchValue = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\SearchDate::valueIsValid($predefinedSearchValue)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\SearchDate', is_array($predefinedSearchValue) ? implode(', ', $predefinedSearchValue) : var_export($predefinedSearchValue, true), implode(', ', \EnumType\SearchDate::getValidValues())), __LINE__);
        }
        $this->predefinedSearchValue = $predefinedSearchValue;
        return $this;
    }
    /**
     * Get searchValue value
     * @return string|null
     */
    public function getSearchValue()
    {
        return $this->searchValue;
    }
    /**
     * Set searchValue value
     * @param string $searchValue
     * @return \StructType\SearchDateField
     */
    public function setSearchValue($searchValue = null)
    {
        // validation for constraint: string
        if (!is_null($searchValue) && !is_string($searchValue)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($searchValue, true), gettype($searchValue)), __LINE__);
        }
        $this->searchValue = $searchValue;
        return $this;
    }
    /**
     * Get searchValue2 value
     * @return string|null
     */
    public function getSearchValue2()
    {
        return $this->searchValue2;
    }
    /**
     * Set searchValue2 value
     * @param string $searchValue2
     * @return \StructType\SearchDateField
     */
    public function setSearchValue2($searchValue2 = null)
    {
        // validation for constraint: string
        if (!is_null($searchValue2) && !is_string($searchValue2)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($searchValue2, true), gettype($searchValue2)), __LINE__);
        }
        $this->searchValue2 = $searchValue2;
        return $this;
    }
    /**
     * Get operator value
     * @return string|null
     */
    public function getOperator()
    {
        return $this->operator;
    }
    /**
     * Set operator value
     * @uses \EnumType\SearchDateFieldOperator::valueIsValid()
     * @uses \EnumType\SearchDateFieldOperator::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $operator
     * @return \StructType\SearchDateField
     */
    public function setOperator($operator = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\SearchDateFieldOperator::valueIsValid($operator)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\SearchDateFieldOperator', is_array($operator) ? implode(', ', $operator) : var_export($operator, true), implode(', ', \EnumType\SearchDateFieldOperator::getValidValues())), __LINE__);
        }
        $this->operator = $operator;
        return $this;
    }
}
