<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SearchColumnCustomField StructType
 * @subpackage Structs
 */
abstract class SearchColumnCustomField extends AbstractStructBase
{
    /**
     * The customLabel
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $customLabel;
    /**
     * The internalId
     * @var string
     */
    public $internalId;
    /**
     * The scriptId
     * @var string
     */
    public $scriptId;
    /**
     * Constructor method for SearchColumnCustomField
     * @uses SearchColumnCustomField::setCustomLabel()
     * @uses SearchColumnCustomField::setInternalId()
     * @uses SearchColumnCustomField::setScriptId()
     * @param string $customLabel
     * @param string $internalId
     * @param string $scriptId
     */
    public function __construct($customLabel = null, $internalId = null, $scriptId = null)
    {
        $this
            ->setCustomLabel($customLabel)
            ->setInternalId($internalId)
            ->setScriptId($scriptId);
    }
    /**
     * Get customLabel value
     * @return string|null
     */
    public function getCustomLabel()
    {
        return $this->customLabel;
    }
    /**
     * Set customLabel value
     * @param string $customLabel
     * @return \StructType\SearchColumnCustomField
     */
    public function setCustomLabel($customLabel = null)
    {
        // validation for constraint: string
        if (!is_null($customLabel) && !is_string($customLabel)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($customLabel, true), gettype($customLabel)), __LINE__);
        }
        $this->customLabel = $customLabel;
        return $this;
    }
    /**
     * Get internalId value
     * @return string|null
     */
    public function getInternalId()
    {
        return $this->internalId;
    }
    /**
     * Set internalId value
     * @param string $internalId
     * @return \StructType\SearchColumnCustomField
     */
    public function setInternalId($internalId = null)
    {
        // validation for constraint: string
        if (!is_null($internalId) && !is_string($internalId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($internalId, true), gettype($internalId)), __LINE__);
        }
        $this->internalId = $internalId;
        return $this;
    }
    /**
     * Get scriptId value
     * @return string|null
     */
    public function getScriptId()
    {
        return $this->scriptId;
    }
    /**
     * Set scriptId value
     * @param string $scriptId
     * @return \StructType\SearchColumnCustomField
     */
    public function setScriptId($scriptId = null)
    {
        // validation for constraint: string
        if (!is_null($scriptId) && !is_string($scriptId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($scriptId, true), gettype($scriptId)), __LINE__);
        }
        $this->scriptId = $scriptId;
        return $this;
    }
}
