<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SalesOrderItem StructType
 * @subpackage Structs
 */
class SalesOrderItem extends AbstractStructBase
{
    /**
     * The job
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $job;
    /**
     * The subscription
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $subscription;
    /**
     * The item
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $item;
    /**
     * The quantityAvailable
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $quantityAvailable;
    /**
     * The expandItemGroup
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $expandItemGroup;
    /**
     * The lineUniqueKey
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $lineUniqueKey;
    /**
     * The quantityOnHand
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $quantityOnHand;
    /**
     * The quantity
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $quantity;
    /**
     * The units
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $units;
    /**
     * The inventoryDetail
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\InventoryDetail
     */
    public $inventoryDetail;
    /**
     * The description
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $description;
    /**
     * The price
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $price;
    /**
     * The rate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $rate;
    /**
     * The serialNumbers
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $serialNumbers;
    /**
     * The amount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $amount;
    /**
     * The isTaxable
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $isTaxable;
    /**
     * The commitInventory
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $commitInventory;
    /**
     * The orderPriority
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $orderPriority;
    /**
     * The licenseCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $licenseCode;
    /**
     * The options
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\CustomFieldList
     */
    public $options;
    /**
     * The department
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $department;
    /**
     * The class
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $class;
    /**
     * The location
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $location;
    /**
     * The createPo
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $createPo;
    /**
     * The createdPo
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $createdPo;
    /**
     * The altSalesAmt
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $altSalesAmt;
    /**
     * The createWo
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $createWo;
    /**
     * The poVendor
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $poVendor;
    /**
     * The poCurrency
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $poCurrency;
    /**
     * The poRate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $poRate;
    /**
     * The revRecSchedule
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $revRecSchedule;
    /**
     * The revRecStartDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $revRecStartDate;
    /**
     * The revRecTermInMonths
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $revRecTermInMonths;
    /**
     * The revRecEndDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $revRecEndDate;
    /**
     * The deferRevRec
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $deferRevRec;
    /**
     * The isClosed
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $isClosed;
    /**
     * The itemFulfillmentChoice
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $itemFulfillmentChoice;
    /**
     * The catchUpPeriod
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $catchUpPeriod;
    /**
     * The billingSchedule
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $billingSchedule;
    /**
     * The fromJob
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $fromJob;
    /**
     * The grossAmt
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $grossAmt;
    /**
     * The taxAmount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $taxAmount;
    /**
     * The excludeFromRateRequest
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $excludeFromRateRequest;
    /**
     * The isEstimate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $isEstimate;
    /**
     * The inventoryLocation
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $inventoryLocation;
    /**
     * The inventorySubsidiary
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $inventorySubsidiary;
    /**
     * The line
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $line;
    /**
     * The percentComplete
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $percentComplete;
    /**
     * The costEstimateType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $costEstimateType;
    /**
     * The costEstimate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $costEstimate;
    /**
     * The quantityBackOrdered
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $quantityBackOrdered;
    /**
     * The quantityBilled
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $quantityBilled;
    /**
     * The quantityCommitted
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $quantityCommitted;
    /**
     * The quantityFulfilled
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $quantityFulfilled;
    /**
     * The quantityPacked
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $quantityPacked;
    /**
     * The quantityPicked
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $quantityPicked;
    /**
     * The tax1Amt
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $tax1Amt;
    /**
     * The taxCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $taxCode;
    /**
     * The taxRate1
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $taxRate1;
    /**
     * The taxRate2
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $taxRate2;
    /**
     * The giftCertFrom
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $giftCertFrom;
    /**
     * The giftCertRecipientName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $giftCertRecipientName;
    /**
     * The giftCertRecipientEmail
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $giftCertRecipientEmail;
    /**
     * The giftCertMessage
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $giftCertMessage;
    /**
     * The giftCertNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $giftCertNumber;
    /**
     * The shipGroup
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $shipGroup;
    /**
     * The itemIsFulfilled
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $itemIsFulfilled;
    /**
     * The shipAddress
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $shipAddress;
    /**
     * The shipMethod
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $shipMethod;
    /**
     * The vsoeSopGroup
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $vsoeSopGroup;
    /**
     * The vsoeIsEstimate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $vsoeIsEstimate;
    /**
     * The vsoePrice
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $vsoePrice;
    /**
     * The vsoeAmount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $vsoeAmount;
    /**
     * The vsoeAllocation
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $vsoeAllocation;
    /**
     * The vsoeDeferral
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $vsoeDeferral;
    /**
     * The vsoePermitDiscount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $vsoePermitDiscount;
    /**
     * The vsoeDelivered
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $vsoeDelivered;
    /**
     * The expectedShipDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $expectedShipDate;
    /**
     * The noAutoAssignLocation
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $noAutoAssignLocation;
    /**
     * The locationAutoAssigned
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $locationAutoAssigned;
    /**
     * The taxDetailsReference
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $taxDetailsReference;
    /**
     * The chargeType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $chargeType;
    /**
     * The orderAllocationStrategy
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $orderAllocationStrategy;
    /**
     * The requestedDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $requestedDate;
    /**
     * The customFieldList
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\CustomFieldList
     */
    public $customFieldList;
    /**
     * Constructor method for SalesOrderItem
     * @uses SalesOrderItem::setJob()
     * @uses SalesOrderItem::setSubscription()
     * @uses SalesOrderItem::setItem()
     * @uses SalesOrderItem::setQuantityAvailable()
     * @uses SalesOrderItem::setExpandItemGroup()
     * @uses SalesOrderItem::setLineUniqueKey()
     * @uses SalesOrderItem::setQuantityOnHand()
     * @uses SalesOrderItem::setQuantity()
     * @uses SalesOrderItem::setUnits()
     * @uses SalesOrderItem::setInventoryDetail()
     * @uses SalesOrderItem::setDescription()
     * @uses SalesOrderItem::setPrice()
     * @uses SalesOrderItem::setRate()
     * @uses SalesOrderItem::setSerialNumbers()
     * @uses SalesOrderItem::setAmount()
     * @uses SalesOrderItem::setIsTaxable()
     * @uses SalesOrderItem::setCommitInventory()
     * @uses SalesOrderItem::setOrderPriority()
     * @uses SalesOrderItem::setLicenseCode()
     * @uses SalesOrderItem::setOptions()
     * @uses SalesOrderItem::setDepartment()
     * @uses SalesOrderItem::setClass()
     * @uses SalesOrderItem::setLocation()
     * @uses SalesOrderItem::setCreatePo()
     * @uses SalesOrderItem::setCreatedPo()
     * @uses SalesOrderItem::setAltSalesAmt()
     * @uses SalesOrderItem::setCreateWo()
     * @uses SalesOrderItem::setPoVendor()
     * @uses SalesOrderItem::setPoCurrency()
     * @uses SalesOrderItem::setPoRate()
     * @uses SalesOrderItem::setRevRecSchedule()
     * @uses SalesOrderItem::setRevRecStartDate()
     * @uses SalesOrderItem::setRevRecTermInMonths()
     * @uses SalesOrderItem::setRevRecEndDate()
     * @uses SalesOrderItem::setDeferRevRec()
     * @uses SalesOrderItem::setIsClosed()
     * @uses SalesOrderItem::setItemFulfillmentChoice()
     * @uses SalesOrderItem::setCatchUpPeriod()
     * @uses SalesOrderItem::setBillingSchedule()
     * @uses SalesOrderItem::setFromJob()
     * @uses SalesOrderItem::setGrossAmt()
     * @uses SalesOrderItem::setTaxAmount()
     * @uses SalesOrderItem::setExcludeFromRateRequest()
     * @uses SalesOrderItem::setIsEstimate()
     * @uses SalesOrderItem::setInventoryLocation()
     * @uses SalesOrderItem::setInventorySubsidiary()
     * @uses SalesOrderItem::setLine()
     * @uses SalesOrderItem::setPercentComplete()
     * @uses SalesOrderItem::setCostEstimateType()
     * @uses SalesOrderItem::setCostEstimate()
     * @uses SalesOrderItem::setQuantityBackOrdered()
     * @uses SalesOrderItem::setQuantityBilled()
     * @uses SalesOrderItem::setQuantityCommitted()
     * @uses SalesOrderItem::setQuantityFulfilled()
     * @uses SalesOrderItem::setQuantityPacked()
     * @uses SalesOrderItem::setQuantityPicked()
     * @uses SalesOrderItem::setTax1Amt()
     * @uses SalesOrderItem::setTaxCode()
     * @uses SalesOrderItem::setTaxRate1()
     * @uses SalesOrderItem::setTaxRate2()
     * @uses SalesOrderItem::setGiftCertFrom()
     * @uses SalesOrderItem::setGiftCertRecipientName()
     * @uses SalesOrderItem::setGiftCertRecipientEmail()
     * @uses SalesOrderItem::setGiftCertMessage()
     * @uses SalesOrderItem::setGiftCertNumber()
     * @uses SalesOrderItem::setShipGroup()
     * @uses SalesOrderItem::setItemIsFulfilled()
     * @uses SalesOrderItem::setShipAddress()
     * @uses SalesOrderItem::setShipMethod()
     * @uses SalesOrderItem::setVsoeSopGroup()
     * @uses SalesOrderItem::setVsoeIsEstimate()
     * @uses SalesOrderItem::setVsoePrice()
     * @uses SalesOrderItem::setVsoeAmount()
     * @uses SalesOrderItem::setVsoeAllocation()
     * @uses SalesOrderItem::setVsoeDeferral()
     * @uses SalesOrderItem::setVsoePermitDiscount()
     * @uses SalesOrderItem::setVsoeDelivered()
     * @uses SalesOrderItem::setExpectedShipDate()
     * @uses SalesOrderItem::setNoAutoAssignLocation()
     * @uses SalesOrderItem::setLocationAutoAssigned()
     * @uses SalesOrderItem::setTaxDetailsReference()
     * @uses SalesOrderItem::setChargeType()
     * @uses SalesOrderItem::setOrderAllocationStrategy()
     * @uses SalesOrderItem::setRequestedDate()
     * @uses SalesOrderItem::setCustomFieldList()
     * @param \StructType\RecordRef $job
     * @param \StructType\RecordRef $subscription
     * @param \StructType\RecordRef $item
     * @param float $quantityAvailable
     * @param bool $expandItemGroup
     * @param int $lineUniqueKey
     * @param float $quantityOnHand
     * @param float $quantity
     * @param \StructType\RecordRef $units
     * @param \StructType\InventoryDetail $inventoryDetail
     * @param string $description
     * @param \StructType\RecordRef $price
     * @param string $rate
     * @param string $serialNumbers
     * @param float $amount
     * @param bool $isTaxable
     * @param string $commitInventory
     * @param float $orderPriority
     * @param string $licenseCode
     * @param \StructType\CustomFieldList $options
     * @param \StructType\RecordRef $department
     * @param \StructType\RecordRef $class
     * @param \StructType\RecordRef $location
     * @param string $createPo
     * @param \StructType\RecordRef $createdPo
     * @param float $altSalesAmt
     * @param bool $createWo
     * @param \StructType\RecordRef $poVendor
     * @param string $poCurrency
     * @param float $poRate
     * @param \StructType\RecordRef $revRecSchedule
     * @param string $revRecStartDate
     * @param int $revRecTermInMonths
     * @param string $revRecEndDate
     * @param bool $deferRevRec
     * @param bool $isClosed
     * @param string $itemFulfillmentChoice
     * @param \StructType\RecordRef $catchUpPeriod
     * @param \StructType\RecordRef $billingSchedule
     * @param bool $fromJob
     * @param float $grossAmt
     * @param float $taxAmount
     * @param bool $excludeFromRateRequest
     * @param bool $isEstimate
     * @param \StructType\RecordRef $inventoryLocation
     * @param \StructType\RecordRef $inventorySubsidiary
     * @param int $line
     * @param float $percentComplete
     * @param string $costEstimateType
     * @param float $costEstimate
     * @param float $quantityBackOrdered
     * @param float $quantityBilled
     * @param float $quantityCommitted
     * @param float $quantityFulfilled
     * @param float $quantityPacked
     * @param float $quantityPicked
     * @param float $tax1Amt
     * @param \StructType\RecordRef $taxCode
     * @param float $taxRate1
     * @param float $taxRate2
     * @param string $giftCertFrom
     * @param string $giftCertRecipientName
     * @param string $giftCertRecipientEmail
     * @param string $giftCertMessage
     * @param string $giftCertNumber
     * @param int $shipGroup
     * @param bool $itemIsFulfilled
     * @param \StructType\RecordRef $shipAddress
     * @param \StructType\RecordRef $shipMethod
     * @param string $vsoeSopGroup
     * @param bool $vsoeIsEstimate
     * @param float $vsoePrice
     * @param float $vsoeAmount
     * @param float $vsoeAllocation
     * @param string $vsoeDeferral
     * @param string $vsoePermitDiscount
     * @param bool $vsoeDelivered
     * @param string $expectedShipDate
     * @param bool $noAutoAssignLocation
     * @param bool $locationAutoAssigned
     * @param string $taxDetailsReference
     * @param \StructType\RecordRef $chargeType
     * @param \StructType\RecordRef $orderAllocationStrategy
     * @param string $requestedDate
     * @param \StructType\CustomFieldList $customFieldList
     */
    public function __construct(\StructType\RecordRef $job = null, \StructType\RecordRef $subscription = null, \StructType\RecordRef $item = null, $quantityAvailable = null, $expandItemGroup = null, $lineUniqueKey = null, $quantityOnHand = null, $quantity = null, \StructType\RecordRef $units = null, \StructType\InventoryDetail $inventoryDetail = null, $description = null, \StructType\RecordRef $price = null, $rate = null, $serialNumbers = null, $amount = null, $isTaxable = null, $commitInventory = null, $orderPriority = null, $licenseCode = null, \StructType\CustomFieldList $options = null, \StructType\RecordRef $department = null, \StructType\RecordRef $class = null, \StructType\RecordRef $location = null, $createPo = null, \StructType\RecordRef $createdPo = null, $altSalesAmt = null, $createWo = null, \StructType\RecordRef $poVendor = null, $poCurrency = null, $poRate = null, \StructType\RecordRef $revRecSchedule = null, $revRecStartDate = null, $revRecTermInMonths = null, $revRecEndDate = null, $deferRevRec = null, $isClosed = null, $itemFulfillmentChoice = null, \StructType\RecordRef $catchUpPeriod = null, \StructType\RecordRef $billingSchedule = null, $fromJob = null, $grossAmt = null, $taxAmount = null, $excludeFromRateRequest = null, $isEstimate = null, \StructType\RecordRef $inventoryLocation = null, \StructType\RecordRef $inventorySubsidiary = null, $line = null, $percentComplete = null, $costEstimateType = null, $costEstimate = null, $quantityBackOrdered = null, $quantityBilled = null, $quantityCommitted = null, $quantityFulfilled = null, $quantityPacked = null, $quantityPicked = null, $tax1Amt = null, \StructType\RecordRef $taxCode = null, $taxRate1 = null, $taxRate2 = null, $giftCertFrom = null, $giftCertRecipientName = null, $giftCertRecipientEmail = null, $giftCertMessage = null, $giftCertNumber = null, $shipGroup = null, $itemIsFulfilled = null, \StructType\RecordRef $shipAddress = null, \StructType\RecordRef $shipMethod = null, $vsoeSopGroup = null, $vsoeIsEstimate = null, $vsoePrice = null, $vsoeAmount = null, $vsoeAllocation = null, $vsoeDeferral = null, $vsoePermitDiscount = null, $vsoeDelivered = null, $expectedShipDate = null, $noAutoAssignLocation = null, $locationAutoAssigned = null, $taxDetailsReference = null, \StructType\RecordRef $chargeType = null, \StructType\RecordRef $orderAllocationStrategy = null, $requestedDate = null, \StructType\CustomFieldList $customFieldList = null)
    {
        $this
            ->setJob($job)
            ->setSubscription($subscription)
            ->setItem($item)
            ->setQuantityAvailable($quantityAvailable)
            ->setExpandItemGroup($expandItemGroup)
            ->setLineUniqueKey($lineUniqueKey)
            ->setQuantityOnHand($quantityOnHand)
            ->setQuantity($quantity)
            ->setUnits($units)
            ->setInventoryDetail($inventoryDetail)
            ->setDescription($description)
            ->setPrice($price)
            ->setRate($rate)
            ->setSerialNumbers($serialNumbers)
            ->setAmount($amount)
            ->setIsTaxable($isTaxable)
            ->setCommitInventory($commitInventory)
            ->setOrderPriority($orderPriority)
            ->setLicenseCode($licenseCode)
            ->setOptions($options)
            ->setDepartment($department)
            ->setClass($class)
            ->setLocation($location)
            ->setCreatePo($createPo)
            ->setCreatedPo($createdPo)
            ->setAltSalesAmt($altSalesAmt)
            ->setCreateWo($createWo)
            ->setPoVendor($poVendor)
            ->setPoCurrency($poCurrency)
            ->setPoRate($poRate)
            ->setRevRecSchedule($revRecSchedule)
            ->setRevRecStartDate($revRecStartDate)
            ->setRevRecTermInMonths($revRecTermInMonths)
            ->setRevRecEndDate($revRecEndDate)
            ->setDeferRevRec($deferRevRec)
            ->setIsClosed($isClosed)
            ->setItemFulfillmentChoice($itemFulfillmentChoice)
            ->setCatchUpPeriod($catchUpPeriod)
            ->setBillingSchedule($billingSchedule)
            ->setFromJob($fromJob)
            ->setGrossAmt($grossAmt)
            ->setTaxAmount($taxAmount)
            ->setExcludeFromRateRequest($excludeFromRateRequest)
            ->setIsEstimate($isEstimate)
            ->setInventoryLocation($inventoryLocation)
            ->setInventorySubsidiary($inventorySubsidiary)
            ->setLine($line)
            ->setPercentComplete($percentComplete)
            ->setCostEstimateType($costEstimateType)
            ->setCostEstimate($costEstimate)
            ->setQuantityBackOrdered($quantityBackOrdered)
            ->setQuantityBilled($quantityBilled)
            ->setQuantityCommitted($quantityCommitted)
            ->setQuantityFulfilled($quantityFulfilled)
            ->setQuantityPacked($quantityPacked)
            ->setQuantityPicked($quantityPicked)
            ->setTax1Amt($tax1Amt)
            ->setTaxCode($taxCode)
            ->setTaxRate1($taxRate1)
            ->setTaxRate2($taxRate2)
            ->setGiftCertFrom($giftCertFrom)
            ->setGiftCertRecipientName($giftCertRecipientName)
            ->setGiftCertRecipientEmail($giftCertRecipientEmail)
            ->setGiftCertMessage($giftCertMessage)
            ->setGiftCertNumber($giftCertNumber)
            ->setShipGroup($shipGroup)
            ->setItemIsFulfilled($itemIsFulfilled)
            ->setShipAddress($shipAddress)
            ->setShipMethod($shipMethod)
            ->setVsoeSopGroup($vsoeSopGroup)
            ->setVsoeIsEstimate($vsoeIsEstimate)
            ->setVsoePrice($vsoePrice)
            ->setVsoeAmount($vsoeAmount)
            ->setVsoeAllocation($vsoeAllocation)
            ->setVsoeDeferral($vsoeDeferral)
            ->setVsoePermitDiscount($vsoePermitDiscount)
            ->setVsoeDelivered($vsoeDelivered)
            ->setExpectedShipDate($expectedShipDate)
            ->setNoAutoAssignLocation($noAutoAssignLocation)
            ->setLocationAutoAssigned($locationAutoAssigned)
            ->setTaxDetailsReference($taxDetailsReference)
            ->setChargeType($chargeType)
            ->setOrderAllocationStrategy($orderAllocationStrategy)
            ->setRequestedDate($requestedDate)
            ->setCustomFieldList($customFieldList);
    }
    /**
     * Get job value
     * @return \StructType\RecordRef|null
     */
    public function getJob()
    {
        return $this->job;
    }
    /**
     * Set job value
     * @param \StructType\RecordRef $job
     * @return \StructType\SalesOrderItem
     */
    public function setJob(\StructType\RecordRef $job = null)
    {
        $this->job = $job;
        return $this;
    }
    /**
     * Get subscription value
     * @return \StructType\RecordRef|null
     */
    public function getSubscription()
    {
        return $this->subscription;
    }
    /**
     * Set subscription value
     * @param \StructType\RecordRef $subscription
     * @return \StructType\SalesOrderItem
     */
    public function setSubscription(\StructType\RecordRef $subscription = null)
    {
        $this->subscription = $subscription;
        return $this;
    }
    /**
     * Get item value
     * @return \StructType\RecordRef|null
     */
    public function getItem()
    {
        return $this->item;
    }
    /**
     * Set item value
     * @param \StructType\RecordRef $item
     * @return \StructType\SalesOrderItem
     */
    public function setItem(\StructType\RecordRef $item = null)
    {
        $this->item = $item;
        return $this;
    }
    /**
     * Get quantityAvailable value
     * @return float|null
     */
    public function getQuantityAvailable()
    {
        return $this->quantityAvailable;
    }
    /**
     * Set quantityAvailable value
     * @param float $quantityAvailable
     * @return \StructType\SalesOrderItem
     */
    public function setQuantityAvailable($quantityAvailable = null)
    {
        // validation for constraint: float
        if (!is_null($quantityAvailable) && !(is_float($quantityAvailable) || is_numeric($quantityAvailable))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($quantityAvailable, true), gettype($quantityAvailable)), __LINE__);
        }
        $this->quantityAvailable = $quantityAvailable;
        return $this;
    }
    /**
     * Get expandItemGroup value
     * @return bool|null
     */
    public function getExpandItemGroup()
    {
        return $this->expandItemGroup;
    }
    /**
     * Set expandItemGroup value
     * @param bool $expandItemGroup
     * @return \StructType\SalesOrderItem
     */
    public function setExpandItemGroup($expandItemGroup = null)
    {
        // validation for constraint: boolean
        if (!is_null($expandItemGroup) && !is_bool($expandItemGroup)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($expandItemGroup, true), gettype($expandItemGroup)), __LINE__);
        }
        $this->expandItemGroup = $expandItemGroup;
        return $this;
    }
    /**
     * Get lineUniqueKey value
     * @return int|null
     */
    public function getLineUniqueKey()
    {
        return $this->lineUniqueKey;
    }
    /**
     * Set lineUniqueKey value
     * @param int $lineUniqueKey
     * @return \StructType\SalesOrderItem
     */
    public function setLineUniqueKey($lineUniqueKey = null)
    {
        // validation for constraint: int
        if (!is_null($lineUniqueKey) && !(is_int($lineUniqueKey) || ctype_digit($lineUniqueKey))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($lineUniqueKey, true), gettype($lineUniqueKey)), __LINE__);
        }
        $this->lineUniqueKey = $lineUniqueKey;
        return $this;
    }
    /**
     * Get quantityOnHand value
     * @return float|null
     */
    public function getQuantityOnHand()
    {
        return $this->quantityOnHand;
    }
    /**
     * Set quantityOnHand value
     * @param float $quantityOnHand
     * @return \StructType\SalesOrderItem
     */
    public function setQuantityOnHand($quantityOnHand = null)
    {
        // validation for constraint: float
        if (!is_null($quantityOnHand) && !(is_float($quantityOnHand) || is_numeric($quantityOnHand))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($quantityOnHand, true), gettype($quantityOnHand)), __LINE__);
        }
        $this->quantityOnHand = $quantityOnHand;
        return $this;
    }
    /**
     * Get quantity value
     * @return float|null
     */
    public function getQuantity()
    {
        return $this->quantity;
    }
    /**
     * Set quantity value
     * @param float $quantity
     * @return \StructType\SalesOrderItem
     */
    public function setQuantity($quantity = null)
    {
        // validation for constraint: float
        if (!is_null($quantity) && !(is_float($quantity) || is_numeric($quantity))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($quantity, true), gettype($quantity)), __LINE__);
        }
        $this->quantity = $quantity;
        return $this;
    }
    /**
     * Get units value
     * @return \StructType\RecordRef|null
     */
    public function getUnits()
    {
        return $this->units;
    }
    /**
     * Set units value
     * @param \StructType\RecordRef $units
     * @return \StructType\SalesOrderItem
     */
    public function setUnits(\StructType\RecordRef $units = null)
    {
        $this->units = $units;
        return $this;
    }
    /**
     * Get inventoryDetail value
     * @return \StructType\InventoryDetail|null
     */
    public function getInventoryDetail()
    {
        return $this->inventoryDetail;
    }
    /**
     * Set inventoryDetail value
     * @param \StructType\InventoryDetail $inventoryDetail
     * @return \StructType\SalesOrderItem
     */
    public function setInventoryDetail(\StructType\InventoryDetail $inventoryDetail = null)
    {
        $this->inventoryDetail = $inventoryDetail;
        return $this;
    }
    /**
     * Get description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return \StructType\SalesOrderItem
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        $this->description = $description;
        return $this;
    }
    /**
     * Get price value
     * @return \StructType\RecordRef|null
     */
    public function getPrice()
    {
        return $this->price;
    }
    /**
     * Set price value
     * @param \StructType\RecordRef $price
     * @return \StructType\SalesOrderItem
     */
    public function setPrice(\StructType\RecordRef $price = null)
    {
        $this->price = $price;
        return $this;
    }
    /**
     * Get rate value
     * @return string|null
     */
    public function getRate()
    {
        return $this->rate;
    }
    /**
     * Set rate value
     * @param string $rate
     * @return \StructType\SalesOrderItem
     */
    public function setRate($rate = null)
    {
        // validation for constraint: string
        if (!is_null($rate) && !is_string($rate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($rate, true), gettype($rate)), __LINE__);
        }
        $this->rate = $rate;
        return $this;
    }
    /**
     * Get serialNumbers value
     * @return string|null
     */
    public function getSerialNumbers()
    {
        return $this->serialNumbers;
    }
    /**
     * Set serialNumbers value
     * @param string $serialNumbers
     * @return \StructType\SalesOrderItem
     */
    public function setSerialNumbers($serialNumbers = null)
    {
        // validation for constraint: string
        if (!is_null($serialNumbers) && !is_string($serialNumbers)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($serialNumbers, true), gettype($serialNumbers)), __LINE__);
        }
        $this->serialNumbers = $serialNumbers;
        return $this;
    }
    /**
     * Get amount value
     * @return float|null
     */
    public function getAmount()
    {
        return $this->amount;
    }
    /**
     * Set amount value
     * @param float $amount
     * @return \StructType\SalesOrderItem
     */
    public function setAmount($amount = null)
    {
        // validation for constraint: float
        if (!is_null($amount) && !(is_float($amount) || is_numeric($amount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($amount, true), gettype($amount)), __LINE__);
        }
        $this->amount = $amount;
        return $this;
    }
    /**
     * Get isTaxable value
     * @return bool|null
     */
    public function getIsTaxable()
    {
        return $this->isTaxable;
    }
    /**
     * Set isTaxable value
     * @param bool $isTaxable
     * @return \StructType\SalesOrderItem
     */
    public function setIsTaxable($isTaxable = null)
    {
        // validation for constraint: boolean
        if (!is_null($isTaxable) && !is_bool($isTaxable)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isTaxable, true), gettype($isTaxable)), __LINE__);
        }
        $this->isTaxable = $isTaxable;
        return $this;
    }
    /**
     * Get commitInventory value
     * @return string|null
     */
    public function getCommitInventory()
    {
        return $this->commitInventory;
    }
    /**
     * Set commitInventory value
     * @uses \EnumType\SalesOrderItemCommitInventory::valueIsValid()
     * @uses \EnumType\SalesOrderItemCommitInventory::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $commitInventory
     * @return \StructType\SalesOrderItem
     */
    public function setCommitInventory($commitInventory = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\SalesOrderItemCommitInventory::valueIsValid($commitInventory)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\SalesOrderItemCommitInventory', is_array($commitInventory) ? implode(', ', $commitInventory) : var_export($commitInventory, true), implode(', ', \EnumType\SalesOrderItemCommitInventory::getValidValues())), __LINE__);
        }
        $this->commitInventory = $commitInventory;
        return $this;
    }
    /**
     * Get orderPriority value
     * @return float|null
     */
    public function getOrderPriority()
    {
        return $this->orderPriority;
    }
    /**
     * Set orderPriority value
     * @param float $orderPriority
     * @return \StructType\SalesOrderItem
     */
    public function setOrderPriority($orderPriority = null)
    {
        // validation for constraint: float
        if (!is_null($orderPriority) && !(is_float($orderPriority) || is_numeric($orderPriority))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($orderPriority, true), gettype($orderPriority)), __LINE__);
        }
        $this->orderPriority = $orderPriority;
        return $this;
    }
    /**
     * Get licenseCode value
     * @return string|null
     */
    public function getLicenseCode()
    {
        return $this->licenseCode;
    }
    /**
     * Set licenseCode value
     * @param string $licenseCode
     * @return \StructType\SalesOrderItem
     */
    public function setLicenseCode($licenseCode = null)
    {
        // validation for constraint: string
        if (!is_null($licenseCode) && !is_string($licenseCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($licenseCode, true), gettype($licenseCode)), __LINE__);
        }
        $this->licenseCode = $licenseCode;
        return $this;
    }
    /**
     * Get options value
     * @return \StructType\CustomFieldList|null
     */
    public function getOptions()
    {
        return $this->options;
    }
    /**
     * Set options value
     * @param \StructType\CustomFieldList $options
     * @return \StructType\SalesOrderItem
     */
    public function setOptions(\StructType\CustomFieldList $options = null)
    {
        $this->options = $options;
        return $this;
    }
    /**
     * Get department value
     * @return \StructType\RecordRef|null
     */
    public function getDepartment()
    {
        return $this->department;
    }
    /**
     * Set department value
     * @param \StructType\RecordRef $department
     * @return \StructType\SalesOrderItem
     */
    public function setDepartment(\StructType\RecordRef $department = null)
    {
        $this->department = $department;
        return $this;
    }
    /**
     * Get class value
     * @return \StructType\RecordRef|null
     */
    public function getClass()
    {
        return $this->class;
    }
    /**
     * Set class value
     * @param \StructType\RecordRef $class
     * @return \StructType\SalesOrderItem
     */
    public function setClass(\StructType\RecordRef $class = null)
    {
        $this->class = $class;
        return $this;
    }
    /**
     * Get location value
     * @return \StructType\RecordRef|null
     */
    public function getLocation()
    {
        return $this->location;
    }
    /**
     * Set location value
     * @param \StructType\RecordRef $location
     * @return \StructType\SalesOrderItem
     */
    public function setLocation(\StructType\RecordRef $location = null)
    {
        $this->location = $location;
        return $this;
    }
    /**
     * Get createPo value
     * @return string|null
     */
    public function getCreatePo()
    {
        return $this->createPo;
    }
    /**
     * Set createPo value
     * @uses \EnumType\SalesOrderItemCreatePo::valueIsValid()
     * @uses \EnumType\SalesOrderItemCreatePo::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $createPo
     * @return \StructType\SalesOrderItem
     */
    public function setCreatePo($createPo = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\SalesOrderItemCreatePo::valueIsValid($createPo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\SalesOrderItemCreatePo', is_array($createPo) ? implode(', ', $createPo) : var_export($createPo, true), implode(', ', \EnumType\SalesOrderItemCreatePo::getValidValues())), __LINE__);
        }
        $this->createPo = $createPo;
        return $this;
    }
    /**
     * Get createdPo value
     * @return \StructType\RecordRef|null
     */
    public function getCreatedPo()
    {
        return $this->createdPo;
    }
    /**
     * Set createdPo value
     * @param \StructType\RecordRef $createdPo
     * @return \StructType\SalesOrderItem
     */
    public function setCreatedPo(\StructType\RecordRef $createdPo = null)
    {
        $this->createdPo = $createdPo;
        return $this;
    }
    /**
     * Get altSalesAmt value
     * @return float|null
     */
    public function getAltSalesAmt()
    {
        return $this->altSalesAmt;
    }
    /**
     * Set altSalesAmt value
     * @param float $altSalesAmt
     * @return \StructType\SalesOrderItem
     */
    public function setAltSalesAmt($altSalesAmt = null)
    {
        // validation for constraint: float
        if (!is_null($altSalesAmt) && !(is_float($altSalesAmt) || is_numeric($altSalesAmt))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($altSalesAmt, true), gettype($altSalesAmt)), __LINE__);
        }
        $this->altSalesAmt = $altSalesAmt;
        return $this;
    }
    /**
     * Get createWo value
     * @return bool|null
     */
    public function getCreateWo()
    {
        return $this->createWo;
    }
    /**
     * Set createWo value
     * @param bool $createWo
     * @return \StructType\SalesOrderItem
     */
    public function setCreateWo($createWo = null)
    {
        // validation for constraint: boolean
        if (!is_null($createWo) && !is_bool($createWo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($createWo, true), gettype($createWo)), __LINE__);
        }
        $this->createWo = $createWo;
        return $this;
    }
    /**
     * Get poVendor value
     * @return \StructType\RecordRef|null
     */
    public function getPoVendor()
    {
        return $this->poVendor;
    }
    /**
     * Set poVendor value
     * @param \StructType\RecordRef $poVendor
     * @return \StructType\SalesOrderItem
     */
    public function setPoVendor(\StructType\RecordRef $poVendor = null)
    {
        $this->poVendor = $poVendor;
        return $this;
    }
    /**
     * Get poCurrency value
     * @return string|null
     */
    public function getPoCurrency()
    {
        return $this->poCurrency;
    }
    /**
     * Set poCurrency value
     * @param string $poCurrency
     * @return \StructType\SalesOrderItem
     */
    public function setPoCurrency($poCurrency = null)
    {
        // validation for constraint: string
        if (!is_null($poCurrency) && !is_string($poCurrency)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($poCurrency, true), gettype($poCurrency)), __LINE__);
        }
        $this->poCurrency = $poCurrency;
        return $this;
    }
    /**
     * Get poRate value
     * @return float|null
     */
    public function getPoRate()
    {
        return $this->poRate;
    }
    /**
     * Set poRate value
     * @param float $poRate
     * @return \StructType\SalesOrderItem
     */
    public function setPoRate($poRate = null)
    {
        // validation for constraint: float
        if (!is_null($poRate) && !(is_float($poRate) || is_numeric($poRate))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($poRate, true), gettype($poRate)), __LINE__);
        }
        $this->poRate = $poRate;
        return $this;
    }
    /**
     * Get revRecSchedule value
     * @return \StructType\RecordRef|null
     */
    public function getRevRecSchedule()
    {
        return $this->revRecSchedule;
    }
    /**
     * Set revRecSchedule value
     * @param \StructType\RecordRef $revRecSchedule
     * @return \StructType\SalesOrderItem
     */
    public function setRevRecSchedule(\StructType\RecordRef $revRecSchedule = null)
    {
        $this->revRecSchedule = $revRecSchedule;
        return $this;
    }
    /**
     * Get revRecStartDate value
     * @return string|null
     */
    public function getRevRecStartDate()
    {
        return $this->revRecStartDate;
    }
    /**
     * Set revRecStartDate value
     * @param string $revRecStartDate
     * @return \StructType\SalesOrderItem
     */
    public function setRevRecStartDate($revRecStartDate = null)
    {
        // validation for constraint: string
        if (!is_null($revRecStartDate) && !is_string($revRecStartDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($revRecStartDate, true), gettype($revRecStartDate)), __LINE__);
        }
        $this->revRecStartDate = $revRecStartDate;
        return $this;
    }
    /**
     * Get revRecTermInMonths value
     * @return int|null
     */
    public function getRevRecTermInMonths()
    {
        return $this->revRecTermInMonths;
    }
    /**
     * Set revRecTermInMonths value
     * @param int $revRecTermInMonths
     * @return \StructType\SalesOrderItem
     */
    public function setRevRecTermInMonths($revRecTermInMonths = null)
    {
        // validation for constraint: int
        if (!is_null($revRecTermInMonths) && !(is_int($revRecTermInMonths) || ctype_digit($revRecTermInMonths))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($revRecTermInMonths, true), gettype($revRecTermInMonths)), __LINE__);
        }
        $this->revRecTermInMonths = $revRecTermInMonths;
        return $this;
    }
    /**
     * Get revRecEndDate value
     * @return string|null
     */
    public function getRevRecEndDate()
    {
        return $this->revRecEndDate;
    }
    /**
     * Set revRecEndDate value
     * @param string $revRecEndDate
     * @return \StructType\SalesOrderItem
     */
    public function setRevRecEndDate($revRecEndDate = null)
    {
        // validation for constraint: string
        if (!is_null($revRecEndDate) && !is_string($revRecEndDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($revRecEndDate, true), gettype($revRecEndDate)), __LINE__);
        }
        $this->revRecEndDate = $revRecEndDate;
        return $this;
    }
    /**
     * Get deferRevRec value
     * @return bool|null
     */
    public function getDeferRevRec()
    {
        return $this->deferRevRec;
    }
    /**
     * Set deferRevRec value
     * @param bool $deferRevRec
     * @return \StructType\SalesOrderItem
     */
    public function setDeferRevRec($deferRevRec = null)
    {
        // validation for constraint: boolean
        if (!is_null($deferRevRec) && !is_bool($deferRevRec)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($deferRevRec, true), gettype($deferRevRec)), __LINE__);
        }
        $this->deferRevRec = $deferRevRec;
        return $this;
    }
    /**
     * Get isClosed value
     * @return bool|null
     */
    public function getIsClosed()
    {
        return $this->isClosed;
    }
    /**
     * Set isClosed value
     * @param bool $isClosed
     * @return \StructType\SalesOrderItem
     */
    public function setIsClosed($isClosed = null)
    {
        // validation for constraint: boolean
        if (!is_null($isClosed) && !is_bool($isClosed)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isClosed, true), gettype($isClosed)), __LINE__);
        }
        $this->isClosed = $isClosed;
        return $this;
    }
    /**
     * Get itemFulfillmentChoice value
     * @return string|null
     */
    public function getItemFulfillmentChoice()
    {
        return $this->itemFulfillmentChoice;
    }
    /**
     * Set itemFulfillmentChoice value
     * @uses \EnumType\SalesOrderItemFulfillmentChoice::valueIsValid()
     * @uses \EnumType\SalesOrderItemFulfillmentChoice::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $itemFulfillmentChoice
     * @return \StructType\SalesOrderItem
     */
    public function setItemFulfillmentChoice($itemFulfillmentChoice = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\SalesOrderItemFulfillmentChoice::valueIsValid($itemFulfillmentChoice)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\SalesOrderItemFulfillmentChoice', is_array($itemFulfillmentChoice) ? implode(', ', $itemFulfillmentChoice) : var_export($itemFulfillmentChoice, true), implode(', ', \EnumType\SalesOrderItemFulfillmentChoice::getValidValues())), __LINE__);
        }
        $this->itemFulfillmentChoice = $itemFulfillmentChoice;
        return $this;
    }
    /**
     * Get catchUpPeriod value
     * @return \StructType\RecordRef|null
     */
    public function getCatchUpPeriod()
    {
        return $this->catchUpPeriod;
    }
    /**
     * Set catchUpPeriod value
     * @param \StructType\RecordRef $catchUpPeriod
     * @return \StructType\SalesOrderItem
     */
    public function setCatchUpPeriod(\StructType\RecordRef $catchUpPeriod = null)
    {
        $this->catchUpPeriod = $catchUpPeriod;
        return $this;
    }
    /**
     * Get billingSchedule value
     * @return \StructType\RecordRef|null
     */
    public function getBillingSchedule()
    {
        return $this->billingSchedule;
    }
    /**
     * Set billingSchedule value
     * @param \StructType\RecordRef $billingSchedule
     * @return \StructType\SalesOrderItem
     */
    public function setBillingSchedule(\StructType\RecordRef $billingSchedule = null)
    {
        $this->billingSchedule = $billingSchedule;
        return $this;
    }
    /**
     * Get fromJob value
     * @return bool|null
     */
    public function getFromJob()
    {
        return $this->fromJob;
    }
    /**
     * Set fromJob value
     * @param bool $fromJob
     * @return \StructType\SalesOrderItem
     */
    public function setFromJob($fromJob = null)
    {
        // validation for constraint: boolean
        if (!is_null($fromJob) && !is_bool($fromJob)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($fromJob, true), gettype($fromJob)), __LINE__);
        }
        $this->fromJob = $fromJob;
        return $this;
    }
    /**
     * Get grossAmt value
     * @return float|null
     */
    public function getGrossAmt()
    {
        return $this->grossAmt;
    }
    /**
     * Set grossAmt value
     * @param float $grossAmt
     * @return \StructType\SalesOrderItem
     */
    public function setGrossAmt($grossAmt = null)
    {
        // validation for constraint: float
        if (!is_null($grossAmt) && !(is_float($grossAmt) || is_numeric($grossAmt))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($grossAmt, true), gettype($grossAmt)), __LINE__);
        }
        $this->grossAmt = $grossAmt;
        return $this;
    }
    /**
     * Get taxAmount value
     * @return float|null
     */
    public function getTaxAmount()
    {
        return $this->taxAmount;
    }
    /**
     * Set taxAmount value
     * @param float $taxAmount
     * @return \StructType\SalesOrderItem
     */
    public function setTaxAmount($taxAmount = null)
    {
        // validation for constraint: float
        if (!is_null($taxAmount) && !(is_float($taxAmount) || is_numeric($taxAmount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($taxAmount, true), gettype($taxAmount)), __LINE__);
        }
        $this->taxAmount = $taxAmount;
        return $this;
    }
    /**
     * Get excludeFromRateRequest value
     * @return bool|null
     */
    public function getExcludeFromRateRequest()
    {
        return $this->excludeFromRateRequest;
    }
    /**
     * Set excludeFromRateRequest value
     * @param bool $excludeFromRateRequest
     * @return \StructType\SalesOrderItem
     */
    public function setExcludeFromRateRequest($excludeFromRateRequest = null)
    {
        // validation for constraint: boolean
        if (!is_null($excludeFromRateRequest) && !is_bool($excludeFromRateRequest)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($excludeFromRateRequest, true), gettype($excludeFromRateRequest)), __LINE__);
        }
        $this->excludeFromRateRequest = $excludeFromRateRequest;
        return $this;
    }
    /**
     * Get isEstimate value
     * @return bool|null
     */
    public function getIsEstimate()
    {
        return $this->isEstimate;
    }
    /**
     * Set isEstimate value
     * @param bool $isEstimate
     * @return \StructType\SalesOrderItem
     */
    public function setIsEstimate($isEstimate = null)
    {
        // validation for constraint: boolean
        if (!is_null($isEstimate) && !is_bool($isEstimate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isEstimate, true), gettype($isEstimate)), __LINE__);
        }
        $this->isEstimate = $isEstimate;
        return $this;
    }
    /**
     * Get inventoryLocation value
     * @return \StructType\RecordRef|null
     */
    public function getInventoryLocation()
    {
        return $this->inventoryLocation;
    }
    /**
     * Set inventoryLocation value
     * @param \StructType\RecordRef $inventoryLocation
     * @return \StructType\SalesOrderItem
     */
    public function setInventoryLocation(\StructType\RecordRef $inventoryLocation = null)
    {
        $this->inventoryLocation = $inventoryLocation;
        return $this;
    }
    /**
     * Get inventorySubsidiary value
     * @return \StructType\RecordRef|null
     */
    public function getInventorySubsidiary()
    {
        return $this->inventorySubsidiary;
    }
    /**
     * Set inventorySubsidiary value
     * @param \StructType\RecordRef $inventorySubsidiary
     * @return \StructType\SalesOrderItem
     */
    public function setInventorySubsidiary(\StructType\RecordRef $inventorySubsidiary = null)
    {
        $this->inventorySubsidiary = $inventorySubsidiary;
        return $this;
    }
    /**
     * Get line value
     * @return int|null
     */
    public function getLine()
    {
        return $this->line;
    }
    /**
     * Set line value
     * @param int $line
     * @return \StructType\SalesOrderItem
     */
    public function setLine($line = null)
    {
        // validation for constraint: int
        if (!is_null($line) && !(is_int($line) || ctype_digit($line))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($line, true), gettype($line)), __LINE__);
        }
        $this->line = $line;
        return $this;
    }
    /**
     * Get percentComplete value
     * @return float|null
     */
    public function getPercentComplete()
    {
        return $this->percentComplete;
    }
    /**
     * Set percentComplete value
     * @param float $percentComplete
     * @return \StructType\SalesOrderItem
     */
    public function setPercentComplete($percentComplete = null)
    {
        // validation for constraint: float
        if (!is_null($percentComplete) && !(is_float($percentComplete) || is_numeric($percentComplete))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($percentComplete, true), gettype($percentComplete)), __LINE__);
        }
        $this->percentComplete = $percentComplete;
        return $this;
    }
    /**
     * Get costEstimateType value
     * @return string|null
     */
    public function getCostEstimateType()
    {
        return $this->costEstimateType;
    }
    /**
     * Set costEstimateType value
     * @uses \EnumType\ItemCostEstimateType::valueIsValid()
     * @uses \EnumType\ItemCostEstimateType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $costEstimateType
     * @return \StructType\SalesOrderItem
     */
    public function setCostEstimateType($costEstimateType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\ItemCostEstimateType::valueIsValid($costEstimateType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\ItemCostEstimateType', is_array($costEstimateType) ? implode(', ', $costEstimateType) : var_export($costEstimateType, true), implode(', ', \EnumType\ItemCostEstimateType::getValidValues())), __LINE__);
        }
        $this->costEstimateType = $costEstimateType;
        return $this;
    }
    /**
     * Get costEstimate value
     * @return float|null
     */
    public function getCostEstimate()
    {
        return $this->costEstimate;
    }
    /**
     * Set costEstimate value
     * @param float $costEstimate
     * @return \StructType\SalesOrderItem
     */
    public function setCostEstimate($costEstimate = null)
    {
        // validation for constraint: float
        if (!is_null($costEstimate) && !(is_float($costEstimate) || is_numeric($costEstimate))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($costEstimate, true), gettype($costEstimate)), __LINE__);
        }
        $this->costEstimate = $costEstimate;
        return $this;
    }
    /**
     * Get quantityBackOrdered value
     * @return float|null
     */
    public function getQuantityBackOrdered()
    {
        return $this->quantityBackOrdered;
    }
    /**
     * Set quantityBackOrdered value
     * @param float $quantityBackOrdered
     * @return \StructType\SalesOrderItem
     */
    public function setQuantityBackOrdered($quantityBackOrdered = null)
    {
        // validation for constraint: float
        if (!is_null($quantityBackOrdered) && !(is_float($quantityBackOrdered) || is_numeric($quantityBackOrdered))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($quantityBackOrdered, true), gettype($quantityBackOrdered)), __LINE__);
        }
        $this->quantityBackOrdered = $quantityBackOrdered;
        return $this;
    }
    /**
     * Get quantityBilled value
     * @return float|null
     */
    public function getQuantityBilled()
    {
        return $this->quantityBilled;
    }
    /**
     * Set quantityBilled value
     * @param float $quantityBilled
     * @return \StructType\SalesOrderItem
     */
    public function setQuantityBilled($quantityBilled = null)
    {
        // validation for constraint: float
        if (!is_null($quantityBilled) && !(is_float($quantityBilled) || is_numeric($quantityBilled))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($quantityBilled, true), gettype($quantityBilled)), __LINE__);
        }
        $this->quantityBilled = $quantityBilled;
        return $this;
    }
    /**
     * Get quantityCommitted value
     * @return float|null
     */
    public function getQuantityCommitted()
    {
        return $this->quantityCommitted;
    }
    /**
     * Set quantityCommitted value
     * @param float $quantityCommitted
     * @return \StructType\SalesOrderItem
     */
    public function setQuantityCommitted($quantityCommitted = null)
    {
        // validation for constraint: float
        if (!is_null($quantityCommitted) && !(is_float($quantityCommitted) || is_numeric($quantityCommitted))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($quantityCommitted, true), gettype($quantityCommitted)), __LINE__);
        }
        $this->quantityCommitted = $quantityCommitted;
        return $this;
    }
    /**
     * Get quantityFulfilled value
     * @return float|null
     */
    public function getQuantityFulfilled()
    {
        return $this->quantityFulfilled;
    }
    /**
     * Set quantityFulfilled value
     * @param float $quantityFulfilled
     * @return \StructType\SalesOrderItem
     */
    public function setQuantityFulfilled($quantityFulfilled = null)
    {
        // validation for constraint: float
        if (!is_null($quantityFulfilled) && !(is_float($quantityFulfilled) || is_numeric($quantityFulfilled))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($quantityFulfilled, true), gettype($quantityFulfilled)), __LINE__);
        }
        $this->quantityFulfilled = $quantityFulfilled;
        return $this;
    }
    /**
     * Get quantityPacked value
     * @return float|null
     */
    public function getQuantityPacked()
    {
        return $this->quantityPacked;
    }
    /**
     * Set quantityPacked value
     * @param float $quantityPacked
     * @return \StructType\SalesOrderItem
     */
    public function setQuantityPacked($quantityPacked = null)
    {
        // validation for constraint: float
        if (!is_null($quantityPacked) && !(is_float($quantityPacked) || is_numeric($quantityPacked))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($quantityPacked, true), gettype($quantityPacked)), __LINE__);
        }
        $this->quantityPacked = $quantityPacked;
        return $this;
    }
    /**
     * Get quantityPicked value
     * @return float|null
     */
    public function getQuantityPicked()
    {
        return $this->quantityPicked;
    }
    /**
     * Set quantityPicked value
     * @param float $quantityPicked
     * @return \StructType\SalesOrderItem
     */
    public function setQuantityPicked($quantityPicked = null)
    {
        // validation for constraint: float
        if (!is_null($quantityPicked) && !(is_float($quantityPicked) || is_numeric($quantityPicked))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($quantityPicked, true), gettype($quantityPicked)), __LINE__);
        }
        $this->quantityPicked = $quantityPicked;
        return $this;
    }
    /**
     * Get tax1Amt value
     * @return float|null
     */
    public function getTax1Amt()
    {
        return $this->tax1Amt;
    }
    /**
     * Set tax1Amt value
     * @param float $tax1Amt
     * @return \StructType\SalesOrderItem
     */
    public function setTax1Amt($tax1Amt = null)
    {
        // validation for constraint: float
        if (!is_null($tax1Amt) && !(is_float($tax1Amt) || is_numeric($tax1Amt))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($tax1Amt, true), gettype($tax1Amt)), __LINE__);
        }
        $this->tax1Amt = $tax1Amt;
        return $this;
    }
    /**
     * Get taxCode value
     * @return \StructType\RecordRef|null
     */
    public function getTaxCode()
    {
        return $this->taxCode;
    }
    /**
     * Set taxCode value
     * @param \StructType\RecordRef $taxCode
     * @return \StructType\SalesOrderItem
     */
    public function setTaxCode(\StructType\RecordRef $taxCode = null)
    {
        $this->taxCode = $taxCode;
        return $this;
    }
    /**
     * Get taxRate1 value
     * @return float|null
     */
    public function getTaxRate1()
    {
        return $this->taxRate1;
    }
    /**
     * Set taxRate1 value
     * @param float $taxRate1
     * @return \StructType\SalesOrderItem
     */
    public function setTaxRate1($taxRate1 = null)
    {
        // validation for constraint: float
        if (!is_null($taxRate1) && !(is_float($taxRate1) || is_numeric($taxRate1))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($taxRate1, true), gettype($taxRate1)), __LINE__);
        }
        $this->taxRate1 = $taxRate1;
        return $this;
    }
    /**
     * Get taxRate2 value
     * @return float|null
     */
    public function getTaxRate2()
    {
        return $this->taxRate2;
    }
    /**
     * Set taxRate2 value
     * @param float $taxRate2
     * @return \StructType\SalesOrderItem
     */
    public function setTaxRate2($taxRate2 = null)
    {
        // validation for constraint: float
        if (!is_null($taxRate2) && !(is_float($taxRate2) || is_numeric($taxRate2))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($taxRate2, true), gettype($taxRate2)), __LINE__);
        }
        $this->taxRate2 = $taxRate2;
        return $this;
    }
    /**
     * Get giftCertFrom value
     * @return string|null
     */
    public function getGiftCertFrom()
    {
        return $this->giftCertFrom;
    }
    /**
     * Set giftCertFrom value
     * @param string $giftCertFrom
     * @return \StructType\SalesOrderItem
     */
    public function setGiftCertFrom($giftCertFrom = null)
    {
        // validation for constraint: string
        if (!is_null($giftCertFrom) && !is_string($giftCertFrom)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($giftCertFrom, true), gettype($giftCertFrom)), __LINE__);
        }
        $this->giftCertFrom = $giftCertFrom;
        return $this;
    }
    /**
     * Get giftCertRecipientName value
     * @return string|null
     */
    public function getGiftCertRecipientName()
    {
        return $this->giftCertRecipientName;
    }
    /**
     * Set giftCertRecipientName value
     * @param string $giftCertRecipientName
     * @return \StructType\SalesOrderItem
     */
    public function setGiftCertRecipientName($giftCertRecipientName = null)
    {
        // validation for constraint: string
        if (!is_null($giftCertRecipientName) && !is_string($giftCertRecipientName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($giftCertRecipientName, true), gettype($giftCertRecipientName)), __LINE__);
        }
        $this->giftCertRecipientName = $giftCertRecipientName;
        return $this;
    }
    /**
     * Get giftCertRecipientEmail value
     * @return string|null
     */
    public function getGiftCertRecipientEmail()
    {
        return $this->giftCertRecipientEmail;
    }
    /**
     * Set giftCertRecipientEmail value
     * @param string $giftCertRecipientEmail
     * @return \StructType\SalesOrderItem
     */
    public function setGiftCertRecipientEmail($giftCertRecipientEmail = null)
    {
        // validation for constraint: string
        if (!is_null($giftCertRecipientEmail) && !is_string($giftCertRecipientEmail)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($giftCertRecipientEmail, true), gettype($giftCertRecipientEmail)), __LINE__);
        }
        $this->giftCertRecipientEmail = $giftCertRecipientEmail;
        return $this;
    }
    /**
     * Get giftCertMessage value
     * @return string|null
     */
    public function getGiftCertMessage()
    {
        return $this->giftCertMessage;
    }
    /**
     * Set giftCertMessage value
     * @param string $giftCertMessage
     * @return \StructType\SalesOrderItem
     */
    public function setGiftCertMessage($giftCertMessage = null)
    {
        // validation for constraint: string
        if (!is_null($giftCertMessage) && !is_string($giftCertMessage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($giftCertMessage, true), gettype($giftCertMessage)), __LINE__);
        }
        $this->giftCertMessage = $giftCertMessage;
        return $this;
    }
    /**
     * Get giftCertNumber value
     * @return string|null
     */
    public function getGiftCertNumber()
    {
        return $this->giftCertNumber;
    }
    /**
     * Set giftCertNumber value
     * @param string $giftCertNumber
     * @return \StructType\SalesOrderItem
     */
    public function setGiftCertNumber($giftCertNumber = null)
    {
        // validation for constraint: string
        if (!is_null($giftCertNumber) && !is_string($giftCertNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($giftCertNumber, true), gettype($giftCertNumber)), __LINE__);
        }
        $this->giftCertNumber = $giftCertNumber;
        return $this;
    }
    /**
     * Get shipGroup value
     * @return int|null
     */
    public function getShipGroup()
    {
        return $this->shipGroup;
    }
    /**
     * Set shipGroup value
     * @param int $shipGroup
     * @return \StructType\SalesOrderItem
     */
    public function setShipGroup($shipGroup = null)
    {
        // validation for constraint: int
        if (!is_null($shipGroup) && !(is_int($shipGroup) || ctype_digit($shipGroup))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($shipGroup, true), gettype($shipGroup)), __LINE__);
        }
        $this->shipGroup = $shipGroup;
        return $this;
    }
    /**
     * Get itemIsFulfilled value
     * @return bool|null
     */
    public function getItemIsFulfilled()
    {
        return $this->itemIsFulfilled;
    }
    /**
     * Set itemIsFulfilled value
     * @param bool $itemIsFulfilled
     * @return \StructType\SalesOrderItem
     */
    public function setItemIsFulfilled($itemIsFulfilled = null)
    {
        // validation for constraint: boolean
        if (!is_null($itemIsFulfilled) && !is_bool($itemIsFulfilled)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($itemIsFulfilled, true), gettype($itemIsFulfilled)), __LINE__);
        }
        $this->itemIsFulfilled = $itemIsFulfilled;
        return $this;
    }
    /**
     * Get shipAddress value
     * @return \StructType\RecordRef|null
     */
    public function getShipAddress()
    {
        return $this->shipAddress;
    }
    /**
     * Set shipAddress value
     * @param \StructType\RecordRef $shipAddress
     * @return \StructType\SalesOrderItem
     */
    public function setShipAddress(\StructType\RecordRef $shipAddress = null)
    {
        $this->shipAddress = $shipAddress;
        return $this;
    }
    /**
     * Get shipMethod value
     * @return \StructType\RecordRef|null
     */
    public function getShipMethod()
    {
        return $this->shipMethod;
    }
    /**
     * Set shipMethod value
     * @param \StructType\RecordRef $shipMethod
     * @return \StructType\SalesOrderItem
     */
    public function setShipMethod(\StructType\RecordRef $shipMethod = null)
    {
        $this->shipMethod = $shipMethod;
        return $this;
    }
    /**
     * Get vsoeSopGroup value
     * @return string|null
     */
    public function getVsoeSopGroup()
    {
        return $this->vsoeSopGroup;
    }
    /**
     * Set vsoeSopGroup value
     * @uses \EnumType\VsoeSopGroup::valueIsValid()
     * @uses \EnumType\VsoeSopGroup::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $vsoeSopGroup
     * @return \StructType\SalesOrderItem
     */
    public function setVsoeSopGroup($vsoeSopGroup = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\VsoeSopGroup::valueIsValid($vsoeSopGroup)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\VsoeSopGroup', is_array($vsoeSopGroup) ? implode(', ', $vsoeSopGroup) : var_export($vsoeSopGroup, true), implode(', ', \EnumType\VsoeSopGroup::getValidValues())), __LINE__);
        }
        $this->vsoeSopGroup = $vsoeSopGroup;
        return $this;
    }
    /**
     * Get vsoeIsEstimate value
     * @return bool|null
     */
    public function getVsoeIsEstimate()
    {
        return $this->vsoeIsEstimate;
    }
    /**
     * Set vsoeIsEstimate value
     * @param bool $vsoeIsEstimate
     * @return \StructType\SalesOrderItem
     */
    public function setVsoeIsEstimate($vsoeIsEstimate = null)
    {
        // validation for constraint: boolean
        if (!is_null($vsoeIsEstimate) && !is_bool($vsoeIsEstimate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($vsoeIsEstimate, true), gettype($vsoeIsEstimate)), __LINE__);
        }
        $this->vsoeIsEstimate = $vsoeIsEstimate;
        return $this;
    }
    /**
     * Get vsoePrice value
     * @return float|null
     */
    public function getVsoePrice()
    {
        return $this->vsoePrice;
    }
    /**
     * Set vsoePrice value
     * @param float $vsoePrice
     * @return \StructType\SalesOrderItem
     */
    public function setVsoePrice($vsoePrice = null)
    {
        // validation for constraint: float
        if (!is_null($vsoePrice) && !(is_float($vsoePrice) || is_numeric($vsoePrice))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($vsoePrice, true), gettype($vsoePrice)), __LINE__);
        }
        $this->vsoePrice = $vsoePrice;
        return $this;
    }
    /**
     * Get vsoeAmount value
     * @return float|null
     */
    public function getVsoeAmount()
    {
        return $this->vsoeAmount;
    }
    /**
     * Set vsoeAmount value
     * @param float $vsoeAmount
     * @return \StructType\SalesOrderItem
     */
    public function setVsoeAmount($vsoeAmount = null)
    {
        // validation for constraint: float
        if (!is_null($vsoeAmount) && !(is_float($vsoeAmount) || is_numeric($vsoeAmount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($vsoeAmount, true), gettype($vsoeAmount)), __LINE__);
        }
        $this->vsoeAmount = $vsoeAmount;
        return $this;
    }
    /**
     * Get vsoeAllocation value
     * @return float|null
     */
    public function getVsoeAllocation()
    {
        return $this->vsoeAllocation;
    }
    /**
     * Set vsoeAllocation value
     * @param float $vsoeAllocation
     * @return \StructType\SalesOrderItem
     */
    public function setVsoeAllocation($vsoeAllocation = null)
    {
        // validation for constraint: float
        if (!is_null($vsoeAllocation) && !(is_float($vsoeAllocation) || is_numeric($vsoeAllocation))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($vsoeAllocation, true), gettype($vsoeAllocation)), __LINE__);
        }
        $this->vsoeAllocation = $vsoeAllocation;
        return $this;
    }
    /**
     * Get vsoeDeferral value
     * @return string|null
     */
    public function getVsoeDeferral()
    {
        return $this->vsoeDeferral;
    }
    /**
     * Set vsoeDeferral value
     * @uses \EnumType\VsoeDeferral::valueIsValid()
     * @uses \EnumType\VsoeDeferral::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $vsoeDeferral
     * @return \StructType\SalesOrderItem
     */
    public function setVsoeDeferral($vsoeDeferral = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\VsoeDeferral::valueIsValid($vsoeDeferral)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\VsoeDeferral', is_array($vsoeDeferral) ? implode(', ', $vsoeDeferral) : var_export($vsoeDeferral, true), implode(', ', \EnumType\VsoeDeferral::getValidValues())), __LINE__);
        }
        $this->vsoeDeferral = $vsoeDeferral;
        return $this;
    }
    /**
     * Get vsoePermitDiscount value
     * @return string|null
     */
    public function getVsoePermitDiscount()
    {
        return $this->vsoePermitDiscount;
    }
    /**
     * Set vsoePermitDiscount value
     * @uses \EnumType\VsoePermitDiscount::valueIsValid()
     * @uses \EnumType\VsoePermitDiscount::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $vsoePermitDiscount
     * @return \StructType\SalesOrderItem
     */
    public function setVsoePermitDiscount($vsoePermitDiscount = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\VsoePermitDiscount::valueIsValid($vsoePermitDiscount)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\VsoePermitDiscount', is_array($vsoePermitDiscount) ? implode(', ', $vsoePermitDiscount) : var_export($vsoePermitDiscount, true), implode(', ', \EnumType\VsoePermitDiscount::getValidValues())), __LINE__);
        }
        $this->vsoePermitDiscount = $vsoePermitDiscount;
        return $this;
    }
    /**
     * Get vsoeDelivered value
     * @return bool|null
     */
    public function getVsoeDelivered()
    {
        return $this->vsoeDelivered;
    }
    /**
     * Set vsoeDelivered value
     * @param bool $vsoeDelivered
     * @return \StructType\SalesOrderItem
     */
    public function setVsoeDelivered($vsoeDelivered = null)
    {
        // validation for constraint: boolean
        if (!is_null($vsoeDelivered) && !is_bool($vsoeDelivered)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($vsoeDelivered, true), gettype($vsoeDelivered)), __LINE__);
        }
        $this->vsoeDelivered = $vsoeDelivered;
        return $this;
    }
    /**
     * Get expectedShipDate value
     * @return string|null
     */
    public function getExpectedShipDate()
    {
        return $this->expectedShipDate;
    }
    /**
     * Set expectedShipDate value
     * @param string $expectedShipDate
     * @return \StructType\SalesOrderItem
     */
    public function setExpectedShipDate($expectedShipDate = null)
    {
        // validation for constraint: string
        if (!is_null($expectedShipDate) && !is_string($expectedShipDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($expectedShipDate, true), gettype($expectedShipDate)), __LINE__);
        }
        $this->expectedShipDate = $expectedShipDate;
        return $this;
    }
    /**
     * Get noAutoAssignLocation value
     * @return bool|null
     */
    public function getNoAutoAssignLocation()
    {
        return $this->noAutoAssignLocation;
    }
    /**
     * Set noAutoAssignLocation value
     * @param bool $noAutoAssignLocation
     * @return \StructType\SalesOrderItem
     */
    public function setNoAutoAssignLocation($noAutoAssignLocation = null)
    {
        // validation for constraint: boolean
        if (!is_null($noAutoAssignLocation) && !is_bool($noAutoAssignLocation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($noAutoAssignLocation, true), gettype($noAutoAssignLocation)), __LINE__);
        }
        $this->noAutoAssignLocation = $noAutoAssignLocation;
        return $this;
    }
    /**
     * Get locationAutoAssigned value
     * @return bool|null
     */
    public function getLocationAutoAssigned()
    {
        return $this->locationAutoAssigned;
    }
    /**
     * Set locationAutoAssigned value
     * @param bool $locationAutoAssigned
     * @return \StructType\SalesOrderItem
     */
    public function setLocationAutoAssigned($locationAutoAssigned = null)
    {
        // validation for constraint: boolean
        if (!is_null($locationAutoAssigned) && !is_bool($locationAutoAssigned)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($locationAutoAssigned, true), gettype($locationAutoAssigned)), __LINE__);
        }
        $this->locationAutoAssigned = $locationAutoAssigned;
        return $this;
    }
    /**
     * Get taxDetailsReference value
     * @return string|null
     */
    public function getTaxDetailsReference()
    {
        return $this->taxDetailsReference;
    }
    /**
     * Set taxDetailsReference value
     * @param string $taxDetailsReference
     * @return \StructType\SalesOrderItem
     */
    public function setTaxDetailsReference($taxDetailsReference = null)
    {
        // validation for constraint: string
        if (!is_null($taxDetailsReference) && !is_string($taxDetailsReference)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($taxDetailsReference, true), gettype($taxDetailsReference)), __LINE__);
        }
        $this->taxDetailsReference = $taxDetailsReference;
        return $this;
    }
    /**
     * Get chargeType value
     * @return \StructType\RecordRef|null
     */
    public function getChargeType()
    {
        return $this->chargeType;
    }
    /**
     * Set chargeType value
     * @param \StructType\RecordRef $chargeType
     * @return \StructType\SalesOrderItem
     */
    public function setChargeType(\StructType\RecordRef $chargeType = null)
    {
        $this->chargeType = $chargeType;
        return $this;
    }
    /**
     * Get orderAllocationStrategy value
     * @return \StructType\RecordRef|null
     */
    public function getOrderAllocationStrategy()
    {
        return $this->orderAllocationStrategy;
    }
    /**
     * Set orderAllocationStrategy value
     * @param \StructType\RecordRef $orderAllocationStrategy
     * @return \StructType\SalesOrderItem
     */
    public function setOrderAllocationStrategy(\StructType\RecordRef $orderAllocationStrategy = null)
    {
        $this->orderAllocationStrategy = $orderAllocationStrategy;
        return $this;
    }
    /**
     * Get requestedDate value
     * @return string|null
     */
    public function getRequestedDate()
    {
        return $this->requestedDate;
    }
    /**
     * Set requestedDate value
     * @param string $requestedDate
     * @return \StructType\SalesOrderItem
     */
    public function setRequestedDate($requestedDate = null)
    {
        // validation for constraint: string
        if (!is_null($requestedDate) && !is_string($requestedDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($requestedDate, true), gettype($requestedDate)), __LINE__);
        }
        $this->requestedDate = $requestedDate;
        return $this;
    }
    /**
     * Get customFieldList value
     * @return \StructType\CustomFieldList|null
     */
    public function getCustomFieldList()
    {
        return $this->customFieldList;
    }
    /**
     * Set customFieldList value
     * @param \StructType\CustomFieldList $customFieldList
     * @return \StructType\SalesOrderItem
     */
    public function setCustomFieldList(\StructType\CustomFieldList $customFieldList = null)
    {
        $this->customFieldList = $customFieldList;
        return $this;
    }
}
