<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RevRecScheduleRecurrence StructType
 * @subpackage Structs
 */
class RevRecScheduleRecurrence extends AbstractStructBase
{
    /**
     * The incomeaccount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $incomeaccount;
    /**
     * The periodOffset
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $periodOffset;
    /**
     * The recamount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $recamount;
    /**
     * Constructor method for RevRecScheduleRecurrence
     * @uses RevRecScheduleRecurrence::setIncomeaccount()
     * @uses RevRecScheduleRecurrence::setPeriodOffset()
     * @uses RevRecScheduleRecurrence::setRecamount()
     * @param \StructType\RecordRef $incomeaccount
     * @param int $periodOffset
     * @param string $recamount
     */
    public function __construct(\StructType\RecordRef $incomeaccount = null, $periodOffset = null, $recamount = null)
    {
        $this
            ->setIncomeaccount($incomeaccount)
            ->setPeriodOffset($periodOffset)
            ->setRecamount($recamount);
    }
    /**
     * Get incomeaccount value
     * @return \StructType\RecordRef|null
     */
    public function getIncomeaccount()
    {
        return $this->incomeaccount;
    }
    /**
     * Set incomeaccount value
     * @param \StructType\RecordRef $incomeaccount
     * @return \StructType\RevRecScheduleRecurrence
     */
    public function setIncomeaccount(\StructType\RecordRef $incomeaccount = null)
    {
        $this->incomeaccount = $incomeaccount;
        return $this;
    }
    /**
     * Get periodOffset value
     * @return int|null
     */
    public function getPeriodOffset()
    {
        return $this->periodOffset;
    }
    /**
     * Set periodOffset value
     * @param int $periodOffset
     * @return \StructType\RevRecScheduleRecurrence
     */
    public function setPeriodOffset($periodOffset = null)
    {
        // validation for constraint: int
        if (!is_null($periodOffset) && !(is_int($periodOffset) || ctype_digit($periodOffset))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($periodOffset, true), gettype($periodOffset)), __LINE__);
        }
        $this->periodOffset = $periodOffset;
        return $this;
    }
    /**
     * Get recamount value
     * @return string|null
     */
    public function getRecamount()
    {
        return $this->recamount;
    }
    /**
     * Set recamount value
     * @param string $recamount
     * @return \StructType\RevRecScheduleRecurrence
     */
    public function setRecamount($recamount = null)
    {
        // validation for constraint: string
        if (!is_null($recamount) && !is_string($recamount)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($recamount, true), gettype($recamount)), __LINE__);
        }
        $this->recamount = $recamount;
        return $this;
    }
}
