<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ResourceAllocationSearchAdvanced StructType
 * @subpackage Structs
 */
class ResourceAllocationSearchAdvanced extends SearchRecord
{
    /**
     * The criteria
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\ResourceAllocationSearch
     */
    public $criteria;
    /**
     * The columns
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\ResourceAllocationSearchRow
     */
    public $columns;
    /**
     * The savedSearchId
     * @var string
     */
    public $savedSearchId;
    /**
     * The savedSearchScriptId
     * @var string
     */
    public $savedSearchScriptId;
    /**
     * Constructor method for ResourceAllocationSearchAdvanced
     * @uses ResourceAllocationSearchAdvanced::setCriteria()
     * @uses ResourceAllocationSearchAdvanced::setColumns()
     * @uses ResourceAllocationSearchAdvanced::setSavedSearchId()
     * @uses ResourceAllocationSearchAdvanced::setSavedSearchScriptId()
     * @param \StructType\ResourceAllocationSearch $criteria
     * @param \StructType\ResourceAllocationSearchRow $columns
     * @param string $savedSearchId
     * @param string $savedSearchScriptId
     */
    public function __construct(\StructType\ResourceAllocationSearch $criteria = null, \StructType\ResourceAllocationSearchRow $columns = null, $savedSearchId = null, $savedSearchScriptId = null)
    {
        $this
            ->setCriteria($criteria)
            ->setColumns($columns)
            ->setSavedSearchId($savedSearchId)
            ->setSavedSearchScriptId($savedSearchScriptId);
    }
    /**
     * Get criteria value
     * @return \StructType\ResourceAllocationSearch|null
     */
    public function getCriteria()
    {
        return $this->criteria;
    }
    /**
     * Set criteria value
     * @param \StructType\ResourceAllocationSearch $criteria
     * @return \StructType\ResourceAllocationSearchAdvanced
     */
    public function setCriteria(\StructType\ResourceAllocationSearch $criteria = null)
    {
        $this->criteria = $criteria;
        return $this;
    }
    /**
     * Get columns value
     * @return \StructType\ResourceAllocationSearchRow|null
     */
    public function getColumns()
    {
        return $this->columns;
    }
    /**
     * Set columns value
     * @param \StructType\ResourceAllocationSearchRow $columns
     * @return \StructType\ResourceAllocationSearchAdvanced
     */
    public function setColumns(\StructType\ResourceAllocationSearchRow $columns = null)
    {
        $this->columns = $columns;
        return $this;
    }
    /**
     * Get savedSearchId value
     * @return string|null
     */
    public function getSavedSearchId()
    {
        return $this->savedSearchId;
    }
    /**
     * Set savedSearchId value
     * @param string $savedSearchId
     * @return \StructType\ResourceAllocationSearchAdvanced
     */
    public function setSavedSearchId($savedSearchId = null)
    {
        // validation for constraint: string
        if (!is_null($savedSearchId) && !is_string($savedSearchId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($savedSearchId, true), gettype($savedSearchId)), __LINE__);
        }
        $this->savedSearchId = $savedSearchId;
        return $this;
    }
    /**
     * Get savedSearchScriptId value
     * @return string|null
     */
    public function getSavedSearchScriptId()
    {
        return $this->savedSearchScriptId;
    }
    /**
     * Set savedSearchScriptId value
     * @param string $savedSearchScriptId
     * @return \StructType\ResourceAllocationSearchAdvanced
     */
    public function setSavedSearchScriptId($savedSearchScriptId = null)
    {
        // validation for constraint: string
        if (!is_null($savedSearchScriptId) && !is_string($savedSearchScriptId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($savedSearchScriptId, true), gettype($savedSearchScriptId)), __LINE__);
        }
        $this->savedSearchScriptId = $savedSearchScriptId;
        return $this;
    }
}
