<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ResourceAllocationSearch StructType
 * @subpackage Structs
 */
class ResourceAllocationSearch extends SearchRecord
{
    /**
     * The basic
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\ResourceAllocationSearchBasic
     */
    public $basic;
    /**
     * The customerJoin
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\CustomerSearchBasic
     */
    public $customerJoin;
    /**
     * The employeeJoin
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\EmployeeSearchBasic
     */
    public $employeeJoin;
    /**
     * The jobJoin
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\JobSearchBasic
     */
    public $jobJoin;
    /**
     * The projectTaskJoin
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\ProjectTaskSearchBasic
     */
    public $projectTaskJoin;
    /**
     * The requestedByJoin
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\EntitySearchBasic
     */
    public $requestedByJoin;
    /**
     * The resourceJoin
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\EntitySearchBasic
     */
    public $resourceJoin;
    /**
     * The userJoin
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\EmployeeSearchBasic
     */
    public $userJoin;
    /**
     * The vendorJoin
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\VendorSearchBasic
     */
    public $vendorJoin;
    /**
     * The customSearchJoin
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\CustomSearchJoin[]
     */
    public $customSearchJoin;
    /**
     * Constructor method for ResourceAllocationSearch
     * @uses ResourceAllocationSearch::setBasic()
     * @uses ResourceAllocationSearch::setCustomerJoin()
     * @uses ResourceAllocationSearch::setEmployeeJoin()
     * @uses ResourceAllocationSearch::setJobJoin()
     * @uses ResourceAllocationSearch::setProjectTaskJoin()
     * @uses ResourceAllocationSearch::setRequestedByJoin()
     * @uses ResourceAllocationSearch::setResourceJoin()
     * @uses ResourceAllocationSearch::setUserJoin()
     * @uses ResourceAllocationSearch::setVendorJoin()
     * @uses ResourceAllocationSearch::setCustomSearchJoin()
     * @param \StructType\ResourceAllocationSearchBasic $basic
     * @param \StructType\CustomerSearchBasic $customerJoin
     * @param \StructType\EmployeeSearchBasic $employeeJoin
     * @param \StructType\JobSearchBasic $jobJoin
     * @param \StructType\ProjectTaskSearchBasic $projectTaskJoin
     * @param \StructType\EntitySearchBasic $requestedByJoin
     * @param \StructType\EntitySearchBasic $resourceJoin
     * @param \StructType\EmployeeSearchBasic $userJoin
     * @param \StructType\VendorSearchBasic $vendorJoin
     * @param \StructType\CustomSearchJoin[] $customSearchJoin
     */
    public function __construct(\StructType\ResourceAllocationSearchBasic $basic = null, \StructType\CustomerSearchBasic $customerJoin = null, \StructType\EmployeeSearchBasic $employeeJoin = null, \StructType\JobSearchBasic $jobJoin = null, \StructType\ProjectTaskSearchBasic $projectTaskJoin = null, \StructType\EntitySearchBasic $requestedByJoin = null, \StructType\EntitySearchBasic $resourceJoin = null, \StructType\EmployeeSearchBasic $userJoin = null, \StructType\VendorSearchBasic $vendorJoin = null, array $customSearchJoin = array())
    {
        $this
            ->setBasic($basic)
            ->setCustomerJoin($customerJoin)
            ->setEmployeeJoin($employeeJoin)
            ->setJobJoin($jobJoin)
            ->setProjectTaskJoin($projectTaskJoin)
            ->setRequestedByJoin($requestedByJoin)
            ->setResourceJoin($resourceJoin)
            ->setUserJoin($userJoin)
            ->setVendorJoin($vendorJoin)
            ->setCustomSearchJoin($customSearchJoin);
    }
    /**
     * Get basic value
     * @return \StructType\ResourceAllocationSearchBasic|null
     */
    public function getBasic()
    {
        return $this->basic;
    }
    /**
     * Set basic value
     * @param \StructType\ResourceAllocationSearchBasic $basic
     * @return \StructType\ResourceAllocationSearch
     */
    public function setBasic(\StructType\ResourceAllocationSearchBasic $basic = null)
    {
        $this->basic = $basic;
        return $this;
    }
    /**
     * Get customerJoin value
     * @return \StructType\CustomerSearchBasic|null
     */
    public function getCustomerJoin()
    {
        return $this->customerJoin;
    }
    /**
     * Set customerJoin value
     * @param \StructType\CustomerSearchBasic $customerJoin
     * @return \StructType\ResourceAllocationSearch
     */
    public function setCustomerJoin(\StructType\CustomerSearchBasic $customerJoin = null)
    {
        $this->customerJoin = $customerJoin;
        return $this;
    }
    /**
     * Get employeeJoin value
     * @return \StructType\EmployeeSearchBasic|null
     */
    public function getEmployeeJoin()
    {
        return $this->employeeJoin;
    }
    /**
     * Set employeeJoin value
     * @param \StructType\EmployeeSearchBasic $employeeJoin
     * @return \StructType\ResourceAllocationSearch
     */
    public function setEmployeeJoin(\StructType\EmployeeSearchBasic $employeeJoin = null)
    {
        $this->employeeJoin = $employeeJoin;
        return $this;
    }
    /**
     * Get jobJoin value
     * @return \StructType\JobSearchBasic|null
     */
    public function getJobJoin()
    {
        return $this->jobJoin;
    }
    /**
     * Set jobJoin value
     * @param \StructType\JobSearchBasic $jobJoin
     * @return \StructType\ResourceAllocationSearch
     */
    public function setJobJoin(\StructType\JobSearchBasic $jobJoin = null)
    {
        $this->jobJoin = $jobJoin;
        return $this;
    }
    /**
     * Get projectTaskJoin value
     * @return \StructType\ProjectTaskSearchBasic|null
     */
    public function getProjectTaskJoin()
    {
        return $this->projectTaskJoin;
    }
    /**
     * Set projectTaskJoin value
     * @param \StructType\ProjectTaskSearchBasic $projectTaskJoin
     * @return \StructType\ResourceAllocationSearch
     */
    public function setProjectTaskJoin(\StructType\ProjectTaskSearchBasic $projectTaskJoin = null)
    {
        $this->projectTaskJoin = $projectTaskJoin;
        return $this;
    }
    /**
     * Get requestedByJoin value
     * @return \StructType\EntitySearchBasic|null
     */
    public function getRequestedByJoin()
    {
        return $this->requestedByJoin;
    }
    /**
     * Set requestedByJoin value
     * @param \StructType\EntitySearchBasic $requestedByJoin
     * @return \StructType\ResourceAllocationSearch
     */
    public function setRequestedByJoin(\StructType\EntitySearchBasic $requestedByJoin = null)
    {
        $this->requestedByJoin = $requestedByJoin;
        return $this;
    }
    /**
     * Get resourceJoin value
     * @return \StructType\EntitySearchBasic|null
     */
    public function getResourceJoin()
    {
        return $this->resourceJoin;
    }
    /**
     * Set resourceJoin value
     * @param \StructType\EntitySearchBasic $resourceJoin
     * @return \StructType\ResourceAllocationSearch
     */
    public function setResourceJoin(\StructType\EntitySearchBasic $resourceJoin = null)
    {
        $this->resourceJoin = $resourceJoin;
        return $this;
    }
    /**
     * Get userJoin value
     * @return \StructType\EmployeeSearchBasic|null
     */
    public function getUserJoin()
    {
        return $this->userJoin;
    }
    /**
     * Set userJoin value
     * @param \StructType\EmployeeSearchBasic $userJoin
     * @return \StructType\ResourceAllocationSearch
     */
    public function setUserJoin(\StructType\EmployeeSearchBasic $userJoin = null)
    {
        $this->userJoin = $userJoin;
        return $this;
    }
    /**
     * Get vendorJoin value
     * @return \StructType\VendorSearchBasic|null
     */
    public function getVendorJoin()
    {
        return $this->vendorJoin;
    }
    /**
     * Set vendorJoin value
     * @param \StructType\VendorSearchBasic $vendorJoin
     * @return \StructType\ResourceAllocationSearch
     */
    public function setVendorJoin(\StructType\VendorSearchBasic $vendorJoin = null)
    {
        $this->vendorJoin = $vendorJoin;
        return $this;
    }
    /**
     * Get customSearchJoin value
     * @return \StructType\CustomSearchJoin[]|null
     */
    public function getCustomSearchJoin()
    {
        return $this->customSearchJoin;
    }
    /**
     * This method is responsible for validating the values passed to the setCustomSearchJoin method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCustomSearchJoin method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCustomSearchJoinForArrayConstraintsFromSetCustomSearchJoin(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $resourceAllocationSearchCustomSearchJoinItem) {
            // validation for constraint: itemType
            if (!$resourceAllocationSearchCustomSearchJoinItem instanceof \StructType\CustomSearchJoin) {
                $invalidValues[] = is_object($resourceAllocationSearchCustomSearchJoinItem) ? get_class($resourceAllocationSearchCustomSearchJoinItem) : sprintf('%s(%s)', gettype($resourceAllocationSearchCustomSearchJoinItem), var_export($resourceAllocationSearchCustomSearchJoinItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The customSearchJoin property can only contain items of type \StructType\CustomSearchJoin, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set customSearchJoin value
     * @throws \InvalidArgumentException
     * @param \StructType\CustomSearchJoin[] $customSearchJoin
     * @return \StructType\ResourceAllocationSearch
     */
    public function setCustomSearchJoin(array $customSearchJoin = array())
    {
        // validation for constraint: array
        if ('' !== ($customSearchJoinArrayErrorMessage = self::validateCustomSearchJoinForArrayConstraintsFromSetCustomSearchJoin($customSearchJoin))) {
            throw new \InvalidArgumentException($customSearchJoinArrayErrorMessage, __LINE__);
        }
        $this->customSearchJoin = $customSearchJoin;
        return $this;
    }
    /**
     * Add item to customSearchJoin value
     * @throws \InvalidArgumentException
     * @param \StructType\CustomSearchJoin $item
     * @return \StructType\ResourceAllocationSearch
     */
    public function addToCustomSearchJoin(\StructType\CustomSearchJoin $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\CustomSearchJoin) {
            throw new \InvalidArgumentException(sprintf('The customSearchJoin property can only contain items of type \StructType\CustomSearchJoin, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->customSearchJoin[] = $item;
        return $this;
    }
}
