<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ResourceAllocation StructType
 * @subpackage Structs
 */
class ResourceAllocation extends Record
{
    /**
     * The requestedby
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $requestedby;
    /**
     * The approvalStatus
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $approvalStatus;
    /**
     * The nextApprover
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $nextApprover;
    /**
     * The allocationResource
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $allocationResource;
    /**
     * The project
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $project;
    /**
     * The notes
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $notes;
    /**
     * The startDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $startDate;
    /**
     * The endDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $endDate;
    /**
     * The allocationAmount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $allocationAmount;
    /**
     * The allocationUnit
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $allocationUnit;
    /**
     * The numberHours
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $numberHours;
    /**
     * The percentOfTime
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $percentOfTime;
    /**
     * The allocationType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $allocationType;
    /**
     * The customForm
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $customForm;
    /**
     * The customFieldList
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\CustomFieldList
     */
    public $customFieldList;
    /**
     * The internalId
     * @var string
     */
    public $internalId;
    /**
     * The externalId
     * @var string
     */
    public $externalId;
    /**
     * Constructor method for ResourceAllocation
     * @uses ResourceAllocation::setRequestedby()
     * @uses ResourceAllocation::setApprovalStatus()
     * @uses ResourceAllocation::setNextApprover()
     * @uses ResourceAllocation::setAllocationResource()
     * @uses ResourceAllocation::setProject()
     * @uses ResourceAllocation::setNotes()
     * @uses ResourceAllocation::setStartDate()
     * @uses ResourceAllocation::setEndDate()
     * @uses ResourceAllocation::setAllocationAmount()
     * @uses ResourceAllocation::setAllocationUnit()
     * @uses ResourceAllocation::setNumberHours()
     * @uses ResourceAllocation::setPercentOfTime()
     * @uses ResourceAllocation::setAllocationType()
     * @uses ResourceAllocation::setCustomForm()
     * @uses ResourceAllocation::setCustomFieldList()
     * @uses ResourceAllocation::setInternalId()
     * @uses ResourceAllocation::setExternalId()
     * @param \StructType\RecordRef $requestedby
     * @param string $approvalStatus
     * @param \StructType\RecordRef $nextApprover
     * @param \StructType\RecordRef $allocationResource
     * @param \StructType\RecordRef $project
     * @param string $notes
     * @param string $startDate
     * @param string $endDate
     * @param float $allocationAmount
     * @param string $allocationUnit
     * @param float $numberHours
     * @param float $percentOfTime
     * @param \StructType\RecordRef $allocationType
     * @param \StructType\RecordRef $customForm
     * @param \StructType\CustomFieldList $customFieldList
     * @param string $internalId
     * @param string $externalId
     */
    public function __construct(\StructType\RecordRef $requestedby = null, $approvalStatus = null, \StructType\RecordRef $nextApprover = null, \StructType\RecordRef $allocationResource = null, \StructType\RecordRef $project = null, $notes = null, $startDate = null, $endDate = null, $allocationAmount = null, $allocationUnit = null, $numberHours = null, $percentOfTime = null, \StructType\RecordRef $allocationType = null, \StructType\RecordRef $customForm = null, \StructType\CustomFieldList $customFieldList = null, $internalId = null, $externalId = null)
    {
        $this
            ->setRequestedby($requestedby)
            ->setApprovalStatus($approvalStatus)
            ->setNextApprover($nextApprover)
            ->setAllocationResource($allocationResource)
            ->setProject($project)
            ->setNotes($notes)
            ->setStartDate($startDate)
            ->setEndDate($endDate)
            ->setAllocationAmount($allocationAmount)
            ->setAllocationUnit($allocationUnit)
            ->setNumberHours($numberHours)
            ->setPercentOfTime($percentOfTime)
            ->setAllocationType($allocationType)
            ->setCustomForm($customForm)
            ->setCustomFieldList($customFieldList)
            ->setInternalId($internalId)
            ->setExternalId($externalId);
    }
    /**
     * Get requestedby value
     * @return \StructType\RecordRef|null
     */
    public function getRequestedby()
    {
        return $this->requestedby;
    }
    /**
     * Set requestedby value
     * @param \StructType\RecordRef $requestedby
     * @return \StructType\ResourceAllocation
     */
    public function setRequestedby(\StructType\RecordRef $requestedby = null)
    {
        $this->requestedby = $requestedby;
        return $this;
    }
    /**
     * Get approvalStatus value
     * @return string|null
     */
    public function getApprovalStatus()
    {
        return $this->approvalStatus;
    }
    /**
     * Set approvalStatus value
     * @uses \EnumType\ResourceAllocationApprovalStatus::valueIsValid()
     * @uses \EnumType\ResourceAllocationApprovalStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $approvalStatus
     * @return \StructType\ResourceAllocation
     */
    public function setApprovalStatus($approvalStatus = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\ResourceAllocationApprovalStatus::valueIsValid($approvalStatus)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\ResourceAllocationApprovalStatus', is_array($approvalStatus) ? implode(', ', $approvalStatus) : var_export($approvalStatus, true), implode(', ', \EnumType\ResourceAllocationApprovalStatus::getValidValues())), __LINE__);
        }
        $this->approvalStatus = $approvalStatus;
        return $this;
    }
    /**
     * Get nextApprover value
     * @return \StructType\RecordRef|null
     */
    public function getNextApprover()
    {
        return $this->nextApprover;
    }
    /**
     * Set nextApprover value
     * @param \StructType\RecordRef $nextApprover
     * @return \StructType\ResourceAllocation
     */
    public function setNextApprover(\StructType\RecordRef $nextApprover = null)
    {
        $this->nextApprover = $nextApprover;
        return $this;
    }
    /**
     * Get allocationResource value
     * @return \StructType\RecordRef|null
     */
    public function getAllocationResource()
    {
        return $this->allocationResource;
    }
    /**
     * Set allocationResource value
     * @param \StructType\RecordRef $allocationResource
     * @return \StructType\ResourceAllocation
     */
    public function setAllocationResource(\StructType\RecordRef $allocationResource = null)
    {
        $this->allocationResource = $allocationResource;
        return $this;
    }
    /**
     * Get project value
     * @return \StructType\RecordRef|null
     */
    public function getProject()
    {
        return $this->project;
    }
    /**
     * Set project value
     * @param \StructType\RecordRef $project
     * @return \StructType\ResourceAllocation
     */
    public function setProject(\StructType\RecordRef $project = null)
    {
        $this->project = $project;
        return $this;
    }
    /**
     * Get notes value
     * @return string|null
     */
    public function getNotes()
    {
        return $this->notes;
    }
    /**
     * Set notes value
     * @param string $notes
     * @return \StructType\ResourceAllocation
     */
    public function setNotes($notes = null)
    {
        // validation for constraint: string
        if (!is_null($notes) && !is_string($notes)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($notes, true), gettype($notes)), __LINE__);
        }
        $this->notes = $notes;
        return $this;
    }
    /**
     * Get startDate value
     * @return string|null
     */
    public function getStartDate()
    {
        return $this->startDate;
    }
    /**
     * Set startDate value
     * @param string $startDate
     * @return \StructType\ResourceAllocation
     */
    public function setStartDate($startDate = null)
    {
        // validation for constraint: string
        if (!is_null($startDate) && !is_string($startDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($startDate, true), gettype($startDate)), __LINE__);
        }
        $this->startDate = $startDate;
        return $this;
    }
    /**
     * Get endDate value
     * @return string|null
     */
    public function getEndDate()
    {
        return $this->endDate;
    }
    /**
     * Set endDate value
     * @param string $endDate
     * @return \StructType\ResourceAllocation
     */
    public function setEndDate($endDate = null)
    {
        // validation for constraint: string
        if (!is_null($endDate) && !is_string($endDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($endDate, true), gettype($endDate)), __LINE__);
        }
        $this->endDate = $endDate;
        return $this;
    }
    /**
     * Get allocationAmount value
     * @return float|null
     */
    public function getAllocationAmount()
    {
        return $this->allocationAmount;
    }
    /**
     * Set allocationAmount value
     * @param float $allocationAmount
     * @return \StructType\ResourceAllocation
     */
    public function setAllocationAmount($allocationAmount = null)
    {
        // validation for constraint: float
        if (!is_null($allocationAmount) && !(is_float($allocationAmount) || is_numeric($allocationAmount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($allocationAmount, true), gettype($allocationAmount)), __LINE__);
        }
        $this->allocationAmount = $allocationAmount;
        return $this;
    }
    /**
     * Get allocationUnit value
     * @return string|null
     */
    public function getAllocationUnit()
    {
        return $this->allocationUnit;
    }
    /**
     * Set allocationUnit value
     * @uses \EnumType\ResourceAllocationAllocationUnit::valueIsValid()
     * @uses \EnumType\ResourceAllocationAllocationUnit::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $allocationUnit
     * @return \StructType\ResourceAllocation
     */
    public function setAllocationUnit($allocationUnit = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\ResourceAllocationAllocationUnit::valueIsValid($allocationUnit)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\ResourceAllocationAllocationUnit', is_array($allocationUnit) ? implode(', ', $allocationUnit) : var_export($allocationUnit, true), implode(', ', \EnumType\ResourceAllocationAllocationUnit::getValidValues())), __LINE__);
        }
        $this->allocationUnit = $allocationUnit;
        return $this;
    }
    /**
     * Get numberHours value
     * @return float|null
     */
    public function getNumberHours()
    {
        return $this->numberHours;
    }
    /**
     * Set numberHours value
     * @param float $numberHours
     * @return \StructType\ResourceAllocation
     */
    public function setNumberHours($numberHours = null)
    {
        // validation for constraint: float
        if (!is_null($numberHours) && !(is_float($numberHours) || is_numeric($numberHours))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($numberHours, true), gettype($numberHours)), __LINE__);
        }
        $this->numberHours = $numberHours;
        return $this;
    }
    /**
     * Get percentOfTime value
     * @return float|null
     */
    public function getPercentOfTime()
    {
        return $this->percentOfTime;
    }
    /**
     * Set percentOfTime value
     * @param float $percentOfTime
     * @return \StructType\ResourceAllocation
     */
    public function setPercentOfTime($percentOfTime = null)
    {
        // validation for constraint: float
        if (!is_null($percentOfTime) && !(is_float($percentOfTime) || is_numeric($percentOfTime))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($percentOfTime, true), gettype($percentOfTime)), __LINE__);
        }
        $this->percentOfTime = $percentOfTime;
        return $this;
    }
    /**
     * Get allocationType value
     * @return \StructType\RecordRef|null
     */
    public function getAllocationType()
    {
        return $this->allocationType;
    }
    /**
     * Set allocationType value
     * @param \StructType\RecordRef $allocationType
     * @return \StructType\ResourceAllocation
     */
    public function setAllocationType(\StructType\RecordRef $allocationType = null)
    {
        $this->allocationType = $allocationType;
        return $this;
    }
    /**
     * Get customForm value
     * @return \StructType\RecordRef|null
     */
    public function getCustomForm()
    {
        return $this->customForm;
    }
    /**
     * Set customForm value
     * @param \StructType\RecordRef $customForm
     * @return \StructType\ResourceAllocation
     */
    public function setCustomForm(\StructType\RecordRef $customForm = null)
    {
        $this->customForm = $customForm;
        return $this;
    }
    /**
     * Get customFieldList value
     * @return \StructType\CustomFieldList|null
     */
    public function getCustomFieldList()
    {
        return $this->customFieldList;
    }
    /**
     * Set customFieldList value
     * @param \StructType\CustomFieldList $customFieldList
     * @return \StructType\ResourceAllocation
     */
    public function setCustomFieldList(\StructType\CustomFieldList $customFieldList = null)
    {
        $this->customFieldList = $customFieldList;
        return $this;
    }
    /**
     * Get internalId value
     * @return string|null
     */
    public function getInternalId()
    {
        return $this->internalId;
    }
    /**
     * Set internalId value
     * @param string $internalId
     * @return \StructType\ResourceAllocation
     */
    public function setInternalId($internalId = null)
    {
        // validation for constraint: string
        if (!is_null($internalId) && !is_string($internalId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($internalId, true), gettype($internalId)), __LINE__);
        }
        $this->internalId = $internalId;
        return $this;
    }
    /**
     * Get externalId value
     * @return string|null
     */
    public function getExternalId()
    {
        return $this->externalId;
    }
    /**
     * Set externalId value
     * @param string $externalId
     * @return \StructType\ResourceAllocation
     */
    public function setExternalId($externalId = null)
    {
        // validation for constraint: string
        if (!is_null($externalId) && !is_string($externalId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($externalId, true), gettype($externalId)), __LINE__);
        }
        $this->externalId = $externalId;
        return $this;
    }
}
