<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RecurrenceDowMaskList StructType
 * @subpackage Structs
 */
class RecurrenceDowMaskList extends AbstractStructBase
{
    /**
     * The recurrenceDowMask
     * Meta information extracted from the WSDL
     * - maxOccurs: 7
     * - minOccurs: 1
     * @var string[]
     */
    public $recurrenceDowMask;
    /**
     * Constructor method for RecurrenceDowMaskList
     * @uses RecurrenceDowMaskList::setRecurrenceDowMask()
     * @param string[] $recurrenceDowMask
     */
    public function __construct(array $recurrenceDowMask = array())
    {
        $this
            ->setRecurrenceDowMask($recurrenceDowMask);
    }
    /**
     * Get recurrenceDowMask value
     * @return string[]
     */
    public function getRecurrenceDowMask()
    {
        return $this->recurrenceDowMask;
    }
    /**
     * This method is responsible for validating the values passed to the setRecurrenceDowMask method
     * This method is willingly generated in order to preserve the one-line inline validation within the setRecurrenceDowMask method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateRecurrenceDowMaskForArrayConstraintsFromSetRecurrenceDowMask(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $recurrenceDowMaskListRecurrenceDowMaskItem) {
            // validation for constraint: enumeration
            if (!\EnumType\RecurrenceDow::valueIsValid($recurrenceDowMaskListRecurrenceDowMaskItem)) {
                $invalidValues[] = is_object($recurrenceDowMaskListRecurrenceDowMaskItem) ? get_class($recurrenceDowMaskListRecurrenceDowMaskItem) : sprintf('%s(%s)', gettype($recurrenceDowMaskListRecurrenceDowMaskItem), var_export($recurrenceDowMaskListRecurrenceDowMaskItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\RecurrenceDow', is_array($invalidValues) ? implode(', ', $invalidValues) : var_export($invalidValues, true), implode(', ', \EnumType\RecurrenceDow::getValidValues()));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set recurrenceDowMask value
     * @uses \EnumType\RecurrenceDow::valueIsValid()
     * @uses \EnumType\RecurrenceDow::getValidValues()
     * @throws \InvalidArgumentException
     * @param string[] $recurrenceDowMask
     * @return \StructType\RecurrenceDowMaskList
     */
    public function setRecurrenceDowMask(array $recurrenceDowMask = array())
    {
        // validation for constraint: array
        if ('' !== ($recurrenceDowMaskArrayErrorMessage = self::validateRecurrenceDowMaskForArrayConstraintsFromSetRecurrenceDowMask($recurrenceDowMask))) {
            throw new \InvalidArgumentException($recurrenceDowMaskArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(7)
        if (is_array($recurrenceDowMask) && count($recurrenceDowMask) > 7) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 7', count($recurrenceDowMask)), __LINE__);
        }
        $this->recurrenceDowMask = $recurrenceDowMask;
        return $this;
    }
    /**
     * Add item to recurrenceDowMask value
     * @uses \EnumType\RecurrenceDow::valueIsValid()
     * @uses \EnumType\RecurrenceDow::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \StructType\RecurrenceDowMaskList
     */
    public function addToRecurrenceDowMask($item)
    {
        // validation for constraint: enumeration
        if (!\EnumType\RecurrenceDow::valueIsValid($item)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\RecurrenceDow', is_array($item) ? implode(', ', $item) : var_export($item, true), implode(', ', \EnumType\RecurrenceDow::getValidValues())), __LINE__);
        }
        // validation for constraint: maxOccurs(7)
        if (is_array($this->recurrenceDowMask) && count($this->recurrenceDowMask) >= 7) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 7', count($this->recurrenceDowMask)), __LINE__);
        }
        $this->recurrenceDowMask[] = $item;
        return $this;
    }
}
