<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ReadResponse StructType
 * @subpackage Structs
 */
class ReadResponse extends AbstractStructBase
{
    /**
     * The status
     * Meta information extracted from the WSDL
     * - ref: platformCore:status
     * @var \StructType\Status
     */
    public $status;
    /**
     * The record
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Record
     */
    public $record;
    /**
     * Constructor method for ReadResponse
     * @uses ReadResponse::setStatus()
     * @uses ReadResponse::setRecord()
     * @param \StructType\Status $status
     * @param \StructType\Record $record
     */
    public function __construct(\StructType\Status $status = null, \StructType\Record $record = null)
    {
        $this
            ->setStatus($status)
            ->setRecord($record);
    }
    /**
     * Get status value
     * @return \StructType\Status|null
     */
    public function getStatus()
    {
        return $this->status;
    }
    /**
     * Set status value
     * @param \StructType\Status $status
     * @return \StructType\ReadResponse
     */
    public function setStatus(\StructType\Status $status = null)
    {
        $this->status = $status;
        return $this;
    }
    /**
     * Get record value
     * @return \StructType\Record|null
     */
    public function getRecord()
    {
        return $this->record;
    }
    /**
     * Set record value
     * @param \StructType\Record $record
     * @return \StructType\ReadResponse
     */
    public function setRecord(\StructType\Record $record = null)
    {
        $this->record = $record;
        return $this;
    }
}
