<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Rate StructType
 * @subpackage Structs
 */
class Rate extends AbstractStructBase
{
    /**
     * The value
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $value;
    /**
     * The priceLevel
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $priceLevel;
    /**
     * Constructor method for Rate
     * @uses Rate::setValue()
     * @uses Rate::setPriceLevel()
     * @param float $value
     * @param \StructType\RecordRef $priceLevel
     */
    public function __construct($value = null, \StructType\RecordRef $priceLevel = null)
    {
        $this
            ->setValue($value)
            ->setPriceLevel($priceLevel);
    }
    /**
     * Get value value
     * @return float|null
     */
    public function getValue()
    {
        return $this->value;
    }
    /**
     * Set value value
     * @param float $value
     * @return \StructType\Rate
     */
    public function setValue($value = null)
    {
        // validation for constraint: float
        if (!is_null($value) && !(is_float($value) || is_numeric($value))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($value, true), gettype($value)), __LINE__);
        }
        $this->value = $value;
        return $this;
    }
    /**
     * Get priceLevel value
     * @return \StructType\RecordRef|null
     */
    public function getPriceLevel()
    {
        return $this->priceLevel;
    }
    /**
     * Set priceLevel value
     * @param \StructType\RecordRef $priceLevel
     * @return \StructType\Rate
     */
    public function setPriceLevel(\StructType\RecordRef $priceLevel = null)
    {
        $this->priceLevel = $priceLevel;
        return $this;
    }
}
