<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PurchaseRequisitionItem StructType
 * @subpackage Structs
 */
class PurchaseRequisitionItem extends AbstractStructBase
{
    /**
     * The line
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $line;
    /**
     * The item
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $item;
    /**
     * The vendorName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $vendorName;
    /**
     * The poVendor
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $poVendor;
    /**
     * The quantity
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $quantity;
    /**
     * The units
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $units;
    /**
     * The serialNumbers
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $serialNumbers;
    /**
     * The inventoryDetail
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\InventoryDetail
     */
    public $inventoryDetail;
    /**
     * The description
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $description;
    /**
     * The estimatedRate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $estimatedRate;
    /**
     * The estimatedAmount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $estimatedAmount;
    /**
     * The rate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $rate;
    /**
     * The amount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $amount;
    /**
     * The taxCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $taxCode;
    /**
     * The taxRate1
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $taxRate1;
    /**
     * The taxRate2
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $taxRate2;
    /**
     * The grossAmt
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $grossAmt;
    /**
     * The options
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\CustomFieldList
     */
    public $options;
    /**
     * The department
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $department;
    /**
     * The class
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $class;
    /**
     * The customer
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $customer;
    /**
     * The isBillable
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $isBillable;
    /**
     * The linkedOrderList
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRefList
     */
    public $linkedOrderList;
    /**
     * The linkedOrderStatus
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $linkedOrderStatus;
    /**
     * The expectedReceiptDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $expectedReceiptDate;
    /**
     * The isClosed
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $isClosed;
    /**
     * The expandItemGroup
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $expandItemGroup;
    /**
     * Constructor method for PurchaseRequisitionItem
     * @uses PurchaseRequisitionItem::setLine()
     * @uses PurchaseRequisitionItem::setItem()
     * @uses PurchaseRequisitionItem::setVendorName()
     * @uses PurchaseRequisitionItem::setPoVendor()
     * @uses PurchaseRequisitionItem::setQuantity()
     * @uses PurchaseRequisitionItem::setUnits()
     * @uses PurchaseRequisitionItem::setSerialNumbers()
     * @uses PurchaseRequisitionItem::setInventoryDetail()
     * @uses PurchaseRequisitionItem::setDescription()
     * @uses PurchaseRequisitionItem::setEstimatedRate()
     * @uses PurchaseRequisitionItem::setEstimatedAmount()
     * @uses PurchaseRequisitionItem::setRate()
     * @uses PurchaseRequisitionItem::setAmount()
     * @uses PurchaseRequisitionItem::setTaxCode()
     * @uses PurchaseRequisitionItem::setTaxRate1()
     * @uses PurchaseRequisitionItem::setTaxRate2()
     * @uses PurchaseRequisitionItem::setGrossAmt()
     * @uses PurchaseRequisitionItem::setOptions()
     * @uses PurchaseRequisitionItem::setDepartment()
     * @uses PurchaseRequisitionItem::setClass()
     * @uses PurchaseRequisitionItem::setCustomer()
     * @uses PurchaseRequisitionItem::setIsBillable()
     * @uses PurchaseRequisitionItem::setLinkedOrderList()
     * @uses PurchaseRequisitionItem::setLinkedOrderStatus()
     * @uses PurchaseRequisitionItem::setExpectedReceiptDate()
     * @uses PurchaseRequisitionItem::setIsClosed()
     * @uses PurchaseRequisitionItem::setExpandItemGroup()
     * @param int $line
     * @param \StructType\RecordRef $item
     * @param string $vendorName
     * @param \StructType\RecordRef $poVendor
     * @param float $quantity
     * @param \StructType\RecordRef $units
     * @param string $serialNumbers
     * @param \StructType\InventoryDetail $inventoryDetail
     * @param string $description
     * @param float $estimatedRate
     * @param float $estimatedAmount
     * @param string $rate
     * @param float $amount
     * @param \StructType\RecordRef $taxCode
     * @param float $taxRate1
     * @param float $taxRate2
     * @param float $grossAmt
     * @param \StructType\CustomFieldList $options
     * @param \StructType\RecordRef $department
     * @param \StructType\RecordRef $class
     * @param \StructType\RecordRef $customer
     * @param bool $isBillable
     * @param \StructType\RecordRefList $linkedOrderList
     * @param string $linkedOrderStatus
     * @param string $expectedReceiptDate
     * @param bool $isClosed
     * @param bool $expandItemGroup
     */
    public function __construct($line = null, \StructType\RecordRef $item = null, $vendorName = null, \StructType\RecordRef $poVendor = null, $quantity = null, \StructType\RecordRef $units = null, $serialNumbers = null, \StructType\InventoryDetail $inventoryDetail = null, $description = null, $estimatedRate = null, $estimatedAmount = null, $rate = null, $amount = null, \StructType\RecordRef $taxCode = null, $taxRate1 = null, $taxRate2 = null, $grossAmt = null, \StructType\CustomFieldList $options = null, \StructType\RecordRef $department = null, \StructType\RecordRef $class = null, \StructType\RecordRef $customer = null, $isBillable = null, \StructType\RecordRefList $linkedOrderList = null, $linkedOrderStatus = null, $expectedReceiptDate = null, $isClosed = null, $expandItemGroup = null)
    {
        $this
            ->setLine($line)
            ->setItem($item)
            ->setVendorName($vendorName)
            ->setPoVendor($poVendor)
            ->setQuantity($quantity)
            ->setUnits($units)
            ->setSerialNumbers($serialNumbers)
            ->setInventoryDetail($inventoryDetail)
            ->setDescription($description)
            ->setEstimatedRate($estimatedRate)
            ->setEstimatedAmount($estimatedAmount)
            ->setRate($rate)
            ->setAmount($amount)
            ->setTaxCode($taxCode)
            ->setTaxRate1($taxRate1)
            ->setTaxRate2($taxRate2)
            ->setGrossAmt($grossAmt)
            ->setOptions($options)
            ->setDepartment($department)
            ->setClass($class)
            ->setCustomer($customer)
            ->setIsBillable($isBillable)
            ->setLinkedOrderList($linkedOrderList)
            ->setLinkedOrderStatus($linkedOrderStatus)
            ->setExpectedReceiptDate($expectedReceiptDate)
            ->setIsClosed($isClosed)
            ->setExpandItemGroup($expandItemGroup);
    }
    /**
     * Get line value
     * @return int|null
     */
    public function getLine()
    {
        return $this->line;
    }
    /**
     * Set line value
     * @param int $line
     * @return \StructType\PurchaseRequisitionItem
     */
    public function setLine($line = null)
    {
        // validation for constraint: int
        if (!is_null($line) && !(is_int($line) || ctype_digit($line))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($line, true), gettype($line)), __LINE__);
        }
        $this->line = $line;
        return $this;
    }
    /**
     * Get item value
     * @return \StructType\RecordRef|null
     */
    public function getItem()
    {
        return $this->item;
    }
    /**
     * Set item value
     * @param \StructType\RecordRef $item
     * @return \StructType\PurchaseRequisitionItem
     */
    public function setItem(\StructType\RecordRef $item = null)
    {
        $this->item = $item;
        return $this;
    }
    /**
     * Get vendorName value
     * @return string|null
     */
    public function getVendorName()
    {
        return $this->vendorName;
    }
    /**
     * Set vendorName value
     * @param string $vendorName
     * @return \StructType\PurchaseRequisitionItem
     */
    public function setVendorName($vendorName = null)
    {
        // validation for constraint: string
        if (!is_null($vendorName) && !is_string($vendorName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($vendorName, true), gettype($vendorName)), __LINE__);
        }
        $this->vendorName = $vendorName;
        return $this;
    }
    /**
     * Get poVendor value
     * @return \StructType\RecordRef|null
     */
    public function getPoVendor()
    {
        return $this->poVendor;
    }
    /**
     * Set poVendor value
     * @param \StructType\RecordRef $poVendor
     * @return \StructType\PurchaseRequisitionItem
     */
    public function setPoVendor(\StructType\RecordRef $poVendor = null)
    {
        $this->poVendor = $poVendor;
        return $this;
    }
    /**
     * Get quantity value
     * @return float|null
     */
    public function getQuantity()
    {
        return $this->quantity;
    }
    /**
     * Set quantity value
     * @param float $quantity
     * @return \StructType\PurchaseRequisitionItem
     */
    public function setQuantity($quantity = null)
    {
        // validation for constraint: float
        if (!is_null($quantity) && !(is_float($quantity) || is_numeric($quantity))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($quantity, true), gettype($quantity)), __LINE__);
        }
        $this->quantity = $quantity;
        return $this;
    }
    /**
     * Get units value
     * @return \StructType\RecordRef|null
     */
    public function getUnits()
    {
        return $this->units;
    }
    /**
     * Set units value
     * @param \StructType\RecordRef $units
     * @return \StructType\PurchaseRequisitionItem
     */
    public function setUnits(\StructType\RecordRef $units = null)
    {
        $this->units = $units;
        return $this;
    }
    /**
     * Get serialNumbers value
     * @return string|null
     */
    public function getSerialNumbers()
    {
        return $this->serialNumbers;
    }
    /**
     * Set serialNumbers value
     * @param string $serialNumbers
     * @return \StructType\PurchaseRequisitionItem
     */
    public function setSerialNumbers($serialNumbers = null)
    {
        // validation for constraint: string
        if (!is_null($serialNumbers) && !is_string($serialNumbers)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($serialNumbers, true), gettype($serialNumbers)), __LINE__);
        }
        $this->serialNumbers = $serialNumbers;
        return $this;
    }
    /**
     * Get inventoryDetail value
     * @return \StructType\InventoryDetail|null
     */
    public function getInventoryDetail()
    {
        return $this->inventoryDetail;
    }
    /**
     * Set inventoryDetail value
     * @param \StructType\InventoryDetail $inventoryDetail
     * @return \StructType\PurchaseRequisitionItem
     */
    public function setInventoryDetail(\StructType\InventoryDetail $inventoryDetail = null)
    {
        $this->inventoryDetail = $inventoryDetail;
        return $this;
    }
    /**
     * Get description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return \StructType\PurchaseRequisitionItem
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        $this->description = $description;
        return $this;
    }
    /**
     * Get estimatedRate value
     * @return float|null
     */
    public function getEstimatedRate()
    {
        return $this->estimatedRate;
    }
    /**
     * Set estimatedRate value
     * @param float $estimatedRate
     * @return \StructType\PurchaseRequisitionItem
     */
    public function setEstimatedRate($estimatedRate = null)
    {
        // validation for constraint: float
        if (!is_null($estimatedRate) && !(is_float($estimatedRate) || is_numeric($estimatedRate))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($estimatedRate, true), gettype($estimatedRate)), __LINE__);
        }
        $this->estimatedRate = $estimatedRate;
        return $this;
    }
    /**
     * Get estimatedAmount value
     * @return float|null
     */
    public function getEstimatedAmount()
    {
        return $this->estimatedAmount;
    }
    /**
     * Set estimatedAmount value
     * @param float $estimatedAmount
     * @return \StructType\PurchaseRequisitionItem
     */
    public function setEstimatedAmount($estimatedAmount = null)
    {
        // validation for constraint: float
        if (!is_null($estimatedAmount) && !(is_float($estimatedAmount) || is_numeric($estimatedAmount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($estimatedAmount, true), gettype($estimatedAmount)), __LINE__);
        }
        $this->estimatedAmount = $estimatedAmount;
        return $this;
    }
    /**
     * Get rate value
     * @return string|null
     */
    public function getRate()
    {
        return $this->rate;
    }
    /**
     * Set rate value
     * @param string $rate
     * @return \StructType\PurchaseRequisitionItem
     */
    public function setRate($rate = null)
    {
        // validation for constraint: string
        if (!is_null($rate) && !is_string($rate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($rate, true), gettype($rate)), __LINE__);
        }
        $this->rate = $rate;
        return $this;
    }
    /**
     * Get amount value
     * @return float|null
     */
    public function getAmount()
    {
        return $this->amount;
    }
    /**
     * Set amount value
     * @param float $amount
     * @return \StructType\PurchaseRequisitionItem
     */
    public function setAmount($amount = null)
    {
        // validation for constraint: float
        if (!is_null($amount) && !(is_float($amount) || is_numeric($amount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($amount, true), gettype($amount)), __LINE__);
        }
        $this->amount = $amount;
        return $this;
    }
    /**
     * Get taxCode value
     * @return \StructType\RecordRef|null
     */
    public function getTaxCode()
    {
        return $this->taxCode;
    }
    /**
     * Set taxCode value
     * @param \StructType\RecordRef $taxCode
     * @return \StructType\PurchaseRequisitionItem
     */
    public function setTaxCode(\StructType\RecordRef $taxCode = null)
    {
        $this->taxCode = $taxCode;
        return $this;
    }
    /**
     * Get taxRate1 value
     * @return float|null
     */
    public function getTaxRate1()
    {
        return $this->taxRate1;
    }
    /**
     * Set taxRate1 value
     * @param float $taxRate1
     * @return \StructType\PurchaseRequisitionItem
     */
    public function setTaxRate1($taxRate1 = null)
    {
        // validation for constraint: float
        if (!is_null($taxRate1) && !(is_float($taxRate1) || is_numeric($taxRate1))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($taxRate1, true), gettype($taxRate1)), __LINE__);
        }
        $this->taxRate1 = $taxRate1;
        return $this;
    }
    /**
     * Get taxRate2 value
     * @return float|null
     */
    public function getTaxRate2()
    {
        return $this->taxRate2;
    }
    /**
     * Set taxRate2 value
     * @param float $taxRate2
     * @return \StructType\PurchaseRequisitionItem
     */
    public function setTaxRate2($taxRate2 = null)
    {
        // validation for constraint: float
        if (!is_null($taxRate2) && !(is_float($taxRate2) || is_numeric($taxRate2))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($taxRate2, true), gettype($taxRate2)), __LINE__);
        }
        $this->taxRate2 = $taxRate2;
        return $this;
    }
    /**
     * Get grossAmt value
     * @return float|null
     */
    public function getGrossAmt()
    {
        return $this->grossAmt;
    }
    /**
     * Set grossAmt value
     * @param float $grossAmt
     * @return \StructType\PurchaseRequisitionItem
     */
    public function setGrossAmt($grossAmt = null)
    {
        // validation for constraint: float
        if (!is_null($grossAmt) && !(is_float($grossAmt) || is_numeric($grossAmt))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($grossAmt, true), gettype($grossAmt)), __LINE__);
        }
        $this->grossAmt = $grossAmt;
        return $this;
    }
    /**
     * Get options value
     * @return \StructType\CustomFieldList|null
     */
    public function getOptions()
    {
        return $this->options;
    }
    /**
     * Set options value
     * @param \StructType\CustomFieldList $options
     * @return \StructType\PurchaseRequisitionItem
     */
    public function setOptions(\StructType\CustomFieldList $options = null)
    {
        $this->options = $options;
        return $this;
    }
    /**
     * Get department value
     * @return \StructType\RecordRef|null
     */
    public function getDepartment()
    {
        return $this->department;
    }
    /**
     * Set department value
     * @param \StructType\RecordRef $department
     * @return \StructType\PurchaseRequisitionItem
     */
    public function setDepartment(\StructType\RecordRef $department = null)
    {
        $this->department = $department;
        return $this;
    }
    /**
     * Get class value
     * @return \StructType\RecordRef|null
     */
    public function getClass()
    {
        return $this->class;
    }
    /**
     * Set class value
     * @param \StructType\RecordRef $class
     * @return \StructType\PurchaseRequisitionItem
     */
    public function setClass(\StructType\RecordRef $class = null)
    {
        $this->class = $class;
        return $this;
    }
    /**
     * Get customer value
     * @return \StructType\RecordRef|null
     */
    public function getCustomer()
    {
        return $this->customer;
    }
    /**
     * Set customer value
     * @param \StructType\RecordRef $customer
     * @return \StructType\PurchaseRequisitionItem
     */
    public function setCustomer(\StructType\RecordRef $customer = null)
    {
        $this->customer = $customer;
        return $this;
    }
    /**
     * Get isBillable value
     * @return bool|null
     */
    public function getIsBillable()
    {
        return $this->isBillable;
    }
    /**
     * Set isBillable value
     * @param bool $isBillable
     * @return \StructType\PurchaseRequisitionItem
     */
    public function setIsBillable($isBillable = null)
    {
        // validation for constraint: boolean
        if (!is_null($isBillable) && !is_bool($isBillable)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isBillable, true), gettype($isBillable)), __LINE__);
        }
        $this->isBillable = $isBillable;
        return $this;
    }
    /**
     * Get linkedOrderList value
     * @return \StructType\RecordRefList|null
     */
    public function getLinkedOrderList()
    {
        return $this->linkedOrderList;
    }
    /**
     * Set linkedOrderList value
     * @param \StructType\RecordRefList $linkedOrderList
     * @return \StructType\PurchaseRequisitionItem
     */
    public function setLinkedOrderList(\StructType\RecordRefList $linkedOrderList = null)
    {
        $this->linkedOrderList = $linkedOrderList;
        return $this;
    }
    /**
     * Get linkedOrderStatus value
     * @return string|null
     */
    public function getLinkedOrderStatus()
    {
        return $this->linkedOrderStatus;
    }
    /**
     * Set linkedOrderStatus value
     * @param string $linkedOrderStatus
     * @return \StructType\PurchaseRequisitionItem
     */
    public function setLinkedOrderStatus($linkedOrderStatus = null)
    {
        // validation for constraint: string
        if (!is_null($linkedOrderStatus) && !is_string($linkedOrderStatus)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($linkedOrderStatus, true), gettype($linkedOrderStatus)), __LINE__);
        }
        $this->linkedOrderStatus = $linkedOrderStatus;
        return $this;
    }
    /**
     * Get expectedReceiptDate value
     * @return string|null
     */
    public function getExpectedReceiptDate()
    {
        return $this->expectedReceiptDate;
    }
    /**
     * Set expectedReceiptDate value
     * @param string $expectedReceiptDate
     * @return \StructType\PurchaseRequisitionItem
     */
    public function setExpectedReceiptDate($expectedReceiptDate = null)
    {
        // validation for constraint: string
        if (!is_null($expectedReceiptDate) && !is_string($expectedReceiptDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($expectedReceiptDate, true), gettype($expectedReceiptDate)), __LINE__);
        }
        $this->expectedReceiptDate = $expectedReceiptDate;
        return $this;
    }
    /**
     * Get isClosed value
     * @return bool|null
     */
    public function getIsClosed()
    {
        return $this->isClosed;
    }
    /**
     * Set isClosed value
     * @param bool $isClosed
     * @return \StructType\PurchaseRequisitionItem
     */
    public function setIsClosed($isClosed = null)
    {
        // validation for constraint: boolean
        if (!is_null($isClosed) && !is_bool($isClosed)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isClosed, true), gettype($isClosed)), __LINE__);
        }
        $this->isClosed = $isClosed;
        return $this;
    }
    /**
     * Get expandItemGroup value
     * @return bool|null
     */
    public function getExpandItemGroup()
    {
        return $this->expandItemGroup;
    }
    /**
     * Set expandItemGroup value
     * @param bool $expandItemGroup
     * @return \StructType\PurchaseRequisitionItem
     */
    public function setExpandItemGroup($expandItemGroup = null)
    {
        // validation for constraint: boolean
        if (!is_null($expandItemGroup) && !is_bool($expandItemGroup)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($expandItemGroup, true), gettype($expandItemGroup)), __LINE__);
        }
        $this->expandItemGroup = $expandItemGroup;
        return $this;
    }
}
