<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PurchaseOrderItem StructType
 * @subpackage Structs
 */
class PurchaseOrderItem extends AbstractStructBase
{
    /**
     * The item
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $item;
    /**
     * The line
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $line;
    /**
     * The quantityOnShipments
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $quantityOnShipments;
    /**
     * The vendorName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $vendorName;
    /**
     * The quantityReceived
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $quantityReceived;
    /**
     * The quantityBilled
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $quantityBilled;
    /**
     * The quantityAvailable
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $quantityAvailable;
    /**
     * The quantityOnHand
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $quantityOnHand;
    /**
     * The taxCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $taxCode;
    /**
     * The taxRate1
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $taxRate1;
    /**
     * The taxRate2
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $taxRate2;
    /**
     * The quantity
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $quantity;
    /**
     * The tax1Amt
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $tax1Amt;
    /**
     * The grossAmt
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $grossAmt;
    /**
     * The units
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $units;
    /**
     * The inventoryDetail
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\InventoryDetail
     */
    public $inventoryDetail;
    /**
     * The serialNumbers
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $serialNumbers;
    /**
     * The description
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $description;
    /**
     * The purchaseContract
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $purchaseContract;
    /**
     * The rate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $rate;
    /**
     * The amount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $amount;
    /**
     * The options
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\CustomFieldList
     */
    public $options;
    /**
     * The taxAmount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $taxAmount;
    /**
     * The department
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $department;
    /**
     * The class
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $class;
    /**
     * The location
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $location;
    /**
     * The landedCostCategory
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $landedCostCategory;
    /**
     * The customer
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $customer;
    /**
     * The isBillable
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $isBillable;
    /**
     * The billVarianceStatus
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $billVarianceStatus;
    /**
     * The matchBillToReceipt
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $matchBillToReceipt;
    /**
     * The expectedReceiptDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $expectedReceiptDate;
    /**
     * The isClosed
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $isClosed;
    /**
     * The taxDetailsReference
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $taxDetailsReference;
    /**
     * The createdFrom
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $createdFrom;
    /**
     * The linkedOrderList
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRefList
     */
    public $linkedOrderList;
    /**
     * The customFieldList
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\CustomFieldList
     */
    public $customFieldList;
    /**
     * Constructor method for PurchaseOrderItem
     * @uses PurchaseOrderItem::setItem()
     * @uses PurchaseOrderItem::setLine()
     * @uses PurchaseOrderItem::setQuantityOnShipments()
     * @uses PurchaseOrderItem::setVendorName()
     * @uses PurchaseOrderItem::setQuantityReceived()
     * @uses PurchaseOrderItem::setQuantityBilled()
     * @uses PurchaseOrderItem::setQuantityAvailable()
     * @uses PurchaseOrderItem::setQuantityOnHand()
     * @uses PurchaseOrderItem::setTaxCode()
     * @uses PurchaseOrderItem::setTaxRate1()
     * @uses PurchaseOrderItem::setTaxRate2()
     * @uses PurchaseOrderItem::setQuantity()
     * @uses PurchaseOrderItem::setTax1Amt()
     * @uses PurchaseOrderItem::setGrossAmt()
     * @uses PurchaseOrderItem::setUnits()
     * @uses PurchaseOrderItem::setInventoryDetail()
     * @uses PurchaseOrderItem::setSerialNumbers()
     * @uses PurchaseOrderItem::setDescription()
     * @uses PurchaseOrderItem::setPurchaseContract()
     * @uses PurchaseOrderItem::setRate()
     * @uses PurchaseOrderItem::setAmount()
     * @uses PurchaseOrderItem::setOptions()
     * @uses PurchaseOrderItem::setTaxAmount()
     * @uses PurchaseOrderItem::setDepartment()
     * @uses PurchaseOrderItem::setClass()
     * @uses PurchaseOrderItem::setLocation()
     * @uses PurchaseOrderItem::setLandedCostCategory()
     * @uses PurchaseOrderItem::setCustomer()
     * @uses PurchaseOrderItem::setIsBillable()
     * @uses PurchaseOrderItem::setBillVarianceStatus()
     * @uses PurchaseOrderItem::setMatchBillToReceipt()
     * @uses PurchaseOrderItem::setExpectedReceiptDate()
     * @uses PurchaseOrderItem::setIsClosed()
     * @uses PurchaseOrderItem::setTaxDetailsReference()
     * @uses PurchaseOrderItem::setCreatedFrom()
     * @uses PurchaseOrderItem::setLinkedOrderList()
     * @uses PurchaseOrderItem::setCustomFieldList()
     * @param \StructType\RecordRef $item
     * @param int $line
     * @param float $quantityOnShipments
     * @param string $vendorName
     * @param float $quantityReceived
     * @param float $quantityBilled
     * @param float $quantityAvailable
     * @param float $quantityOnHand
     * @param \StructType\RecordRef $taxCode
     * @param float $taxRate1
     * @param float $taxRate2
     * @param float $quantity
     * @param float $tax1Amt
     * @param float $grossAmt
     * @param \StructType\RecordRef $units
     * @param \StructType\InventoryDetail $inventoryDetail
     * @param string $serialNumbers
     * @param string $description
     * @param \StructType\RecordRef $purchaseContract
     * @param string $rate
     * @param float $amount
     * @param \StructType\CustomFieldList $options
     * @param float $taxAmount
     * @param \StructType\RecordRef $department
     * @param \StructType\RecordRef $class
     * @param \StructType\RecordRef $location
     * @param \StructType\RecordRef $landedCostCategory
     * @param \StructType\RecordRef $customer
     * @param bool $isBillable
     * @param string $billVarianceStatus
     * @param bool $matchBillToReceipt
     * @param string $expectedReceiptDate
     * @param bool $isClosed
     * @param string $taxDetailsReference
     * @param \StructType\RecordRef $createdFrom
     * @param \StructType\RecordRefList $linkedOrderList
     * @param \StructType\CustomFieldList $customFieldList
     */
    public function __construct(\StructType\RecordRef $item = null, $line = null, $quantityOnShipments = null, $vendorName = null, $quantityReceived = null, $quantityBilled = null, $quantityAvailable = null, $quantityOnHand = null, \StructType\RecordRef $taxCode = null, $taxRate1 = null, $taxRate2 = null, $quantity = null, $tax1Amt = null, $grossAmt = null, \StructType\RecordRef $units = null, \StructType\InventoryDetail $inventoryDetail = null, $serialNumbers = null, $description = null, \StructType\RecordRef $purchaseContract = null, $rate = null, $amount = null, \StructType\CustomFieldList $options = null, $taxAmount = null, \StructType\RecordRef $department = null, \StructType\RecordRef $class = null, \StructType\RecordRef $location = null, \StructType\RecordRef $landedCostCategory = null, \StructType\RecordRef $customer = null, $isBillable = null, $billVarianceStatus = null, $matchBillToReceipt = null, $expectedReceiptDate = null, $isClosed = null, $taxDetailsReference = null, \StructType\RecordRef $createdFrom = null, \StructType\RecordRefList $linkedOrderList = null, \StructType\CustomFieldList $customFieldList = null)
    {
        $this
            ->setItem($item)
            ->setLine($line)
            ->setQuantityOnShipments($quantityOnShipments)
            ->setVendorName($vendorName)
            ->setQuantityReceived($quantityReceived)
            ->setQuantityBilled($quantityBilled)
            ->setQuantityAvailable($quantityAvailable)
            ->setQuantityOnHand($quantityOnHand)
            ->setTaxCode($taxCode)
            ->setTaxRate1($taxRate1)
            ->setTaxRate2($taxRate2)
            ->setQuantity($quantity)
            ->setTax1Amt($tax1Amt)
            ->setGrossAmt($grossAmt)
            ->setUnits($units)
            ->setInventoryDetail($inventoryDetail)
            ->setSerialNumbers($serialNumbers)
            ->setDescription($description)
            ->setPurchaseContract($purchaseContract)
            ->setRate($rate)
            ->setAmount($amount)
            ->setOptions($options)
            ->setTaxAmount($taxAmount)
            ->setDepartment($department)
            ->setClass($class)
            ->setLocation($location)
            ->setLandedCostCategory($landedCostCategory)
            ->setCustomer($customer)
            ->setIsBillable($isBillable)
            ->setBillVarianceStatus($billVarianceStatus)
            ->setMatchBillToReceipt($matchBillToReceipt)
            ->setExpectedReceiptDate($expectedReceiptDate)
            ->setIsClosed($isClosed)
            ->setTaxDetailsReference($taxDetailsReference)
            ->setCreatedFrom($createdFrom)
            ->setLinkedOrderList($linkedOrderList)
            ->setCustomFieldList($customFieldList);
    }
    /**
     * Get item value
     * @return \StructType\RecordRef|null
     */
    public function getItem()
    {
        return $this->item;
    }
    /**
     * Set item value
     * @param \StructType\RecordRef $item
     * @return \StructType\PurchaseOrderItem
     */
    public function setItem(\StructType\RecordRef $item = null)
    {
        $this->item = $item;
        return $this;
    }
    /**
     * Get line value
     * @return int|null
     */
    public function getLine()
    {
        return $this->line;
    }
    /**
     * Set line value
     * @param int $line
     * @return \StructType\PurchaseOrderItem
     */
    public function setLine($line = null)
    {
        // validation for constraint: int
        if (!is_null($line) && !(is_int($line) || ctype_digit($line))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($line, true), gettype($line)), __LINE__);
        }
        $this->line = $line;
        return $this;
    }
    /**
     * Get quantityOnShipments value
     * @return float|null
     */
    public function getQuantityOnShipments()
    {
        return $this->quantityOnShipments;
    }
    /**
     * Set quantityOnShipments value
     * @param float $quantityOnShipments
     * @return \StructType\PurchaseOrderItem
     */
    public function setQuantityOnShipments($quantityOnShipments = null)
    {
        // validation for constraint: float
        if (!is_null($quantityOnShipments) && !(is_float($quantityOnShipments) || is_numeric($quantityOnShipments))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($quantityOnShipments, true), gettype($quantityOnShipments)), __LINE__);
        }
        $this->quantityOnShipments = $quantityOnShipments;
        return $this;
    }
    /**
     * Get vendorName value
     * @return string|null
     */
    public function getVendorName()
    {
        return $this->vendorName;
    }
    /**
     * Set vendorName value
     * @param string $vendorName
     * @return \StructType\PurchaseOrderItem
     */
    public function setVendorName($vendorName = null)
    {
        // validation for constraint: string
        if (!is_null($vendorName) && !is_string($vendorName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($vendorName, true), gettype($vendorName)), __LINE__);
        }
        $this->vendorName = $vendorName;
        return $this;
    }
    /**
     * Get quantityReceived value
     * @return float|null
     */
    public function getQuantityReceived()
    {
        return $this->quantityReceived;
    }
    /**
     * Set quantityReceived value
     * @param float $quantityReceived
     * @return \StructType\PurchaseOrderItem
     */
    public function setQuantityReceived($quantityReceived = null)
    {
        // validation for constraint: float
        if (!is_null($quantityReceived) && !(is_float($quantityReceived) || is_numeric($quantityReceived))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($quantityReceived, true), gettype($quantityReceived)), __LINE__);
        }
        $this->quantityReceived = $quantityReceived;
        return $this;
    }
    /**
     * Get quantityBilled value
     * @return float|null
     */
    public function getQuantityBilled()
    {
        return $this->quantityBilled;
    }
    /**
     * Set quantityBilled value
     * @param float $quantityBilled
     * @return \StructType\PurchaseOrderItem
     */
    public function setQuantityBilled($quantityBilled = null)
    {
        // validation for constraint: float
        if (!is_null($quantityBilled) && !(is_float($quantityBilled) || is_numeric($quantityBilled))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($quantityBilled, true), gettype($quantityBilled)), __LINE__);
        }
        $this->quantityBilled = $quantityBilled;
        return $this;
    }
    /**
     * Get quantityAvailable value
     * @return float|null
     */
    public function getQuantityAvailable()
    {
        return $this->quantityAvailable;
    }
    /**
     * Set quantityAvailable value
     * @param float $quantityAvailable
     * @return \StructType\PurchaseOrderItem
     */
    public function setQuantityAvailable($quantityAvailable = null)
    {
        // validation for constraint: float
        if (!is_null($quantityAvailable) && !(is_float($quantityAvailable) || is_numeric($quantityAvailable))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($quantityAvailable, true), gettype($quantityAvailable)), __LINE__);
        }
        $this->quantityAvailable = $quantityAvailable;
        return $this;
    }
    /**
     * Get quantityOnHand value
     * @return float|null
     */
    public function getQuantityOnHand()
    {
        return $this->quantityOnHand;
    }
    /**
     * Set quantityOnHand value
     * @param float $quantityOnHand
     * @return \StructType\PurchaseOrderItem
     */
    public function setQuantityOnHand($quantityOnHand = null)
    {
        // validation for constraint: float
        if (!is_null($quantityOnHand) && !(is_float($quantityOnHand) || is_numeric($quantityOnHand))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($quantityOnHand, true), gettype($quantityOnHand)), __LINE__);
        }
        $this->quantityOnHand = $quantityOnHand;
        return $this;
    }
    /**
     * Get taxCode value
     * @return \StructType\RecordRef|null
     */
    public function getTaxCode()
    {
        return $this->taxCode;
    }
    /**
     * Set taxCode value
     * @param \StructType\RecordRef $taxCode
     * @return \StructType\PurchaseOrderItem
     */
    public function setTaxCode(\StructType\RecordRef $taxCode = null)
    {
        $this->taxCode = $taxCode;
        return $this;
    }
    /**
     * Get taxRate1 value
     * @return float|null
     */
    public function getTaxRate1()
    {
        return $this->taxRate1;
    }
    /**
     * Set taxRate1 value
     * @param float $taxRate1
     * @return \StructType\PurchaseOrderItem
     */
    public function setTaxRate1($taxRate1 = null)
    {
        // validation for constraint: float
        if (!is_null($taxRate1) && !(is_float($taxRate1) || is_numeric($taxRate1))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($taxRate1, true), gettype($taxRate1)), __LINE__);
        }
        $this->taxRate1 = $taxRate1;
        return $this;
    }
    /**
     * Get taxRate2 value
     * @return float|null
     */
    public function getTaxRate2()
    {
        return $this->taxRate2;
    }
    /**
     * Set taxRate2 value
     * @param float $taxRate2
     * @return \StructType\PurchaseOrderItem
     */
    public function setTaxRate2($taxRate2 = null)
    {
        // validation for constraint: float
        if (!is_null($taxRate2) && !(is_float($taxRate2) || is_numeric($taxRate2))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($taxRate2, true), gettype($taxRate2)), __LINE__);
        }
        $this->taxRate2 = $taxRate2;
        return $this;
    }
    /**
     * Get quantity value
     * @return float|null
     */
    public function getQuantity()
    {
        return $this->quantity;
    }
    /**
     * Set quantity value
     * @param float $quantity
     * @return \StructType\PurchaseOrderItem
     */
    public function setQuantity($quantity = null)
    {
        // validation for constraint: float
        if (!is_null($quantity) && !(is_float($quantity) || is_numeric($quantity))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($quantity, true), gettype($quantity)), __LINE__);
        }
        $this->quantity = $quantity;
        return $this;
    }
    /**
     * Get tax1Amt value
     * @return float|null
     */
    public function getTax1Amt()
    {
        return $this->tax1Amt;
    }
    /**
     * Set tax1Amt value
     * @param float $tax1Amt
     * @return \StructType\PurchaseOrderItem
     */
    public function setTax1Amt($tax1Amt = null)
    {
        // validation for constraint: float
        if (!is_null($tax1Amt) && !(is_float($tax1Amt) || is_numeric($tax1Amt))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($tax1Amt, true), gettype($tax1Amt)), __LINE__);
        }
        $this->tax1Amt = $tax1Amt;
        return $this;
    }
    /**
     * Get grossAmt value
     * @return float|null
     */
    public function getGrossAmt()
    {
        return $this->grossAmt;
    }
    /**
     * Set grossAmt value
     * @param float $grossAmt
     * @return \StructType\PurchaseOrderItem
     */
    public function setGrossAmt($grossAmt = null)
    {
        // validation for constraint: float
        if (!is_null($grossAmt) && !(is_float($grossAmt) || is_numeric($grossAmt))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($grossAmt, true), gettype($grossAmt)), __LINE__);
        }
        $this->grossAmt = $grossAmt;
        return $this;
    }
    /**
     * Get units value
     * @return \StructType\RecordRef|null
     */
    public function getUnits()
    {
        return $this->units;
    }
    /**
     * Set units value
     * @param \StructType\RecordRef $units
     * @return \StructType\PurchaseOrderItem
     */
    public function setUnits(\StructType\RecordRef $units = null)
    {
        $this->units = $units;
        return $this;
    }
    /**
     * Get inventoryDetail value
     * @return \StructType\InventoryDetail|null
     */
    public function getInventoryDetail()
    {
        return $this->inventoryDetail;
    }
    /**
     * Set inventoryDetail value
     * @param \StructType\InventoryDetail $inventoryDetail
     * @return \StructType\PurchaseOrderItem
     */
    public function setInventoryDetail(\StructType\InventoryDetail $inventoryDetail = null)
    {
        $this->inventoryDetail = $inventoryDetail;
        return $this;
    }
    /**
     * Get serialNumbers value
     * @return string|null
     */
    public function getSerialNumbers()
    {
        return $this->serialNumbers;
    }
    /**
     * Set serialNumbers value
     * @param string $serialNumbers
     * @return \StructType\PurchaseOrderItem
     */
    public function setSerialNumbers($serialNumbers = null)
    {
        // validation for constraint: string
        if (!is_null($serialNumbers) && !is_string($serialNumbers)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($serialNumbers, true), gettype($serialNumbers)), __LINE__);
        }
        $this->serialNumbers = $serialNumbers;
        return $this;
    }
    /**
     * Get description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return \StructType\PurchaseOrderItem
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        $this->description = $description;
        return $this;
    }
    /**
     * Get purchaseContract value
     * @return \StructType\RecordRef|null
     */
    public function getPurchaseContract()
    {
        return $this->purchaseContract;
    }
    /**
     * Set purchaseContract value
     * @param \StructType\RecordRef $purchaseContract
     * @return \StructType\PurchaseOrderItem
     */
    public function setPurchaseContract(\StructType\RecordRef $purchaseContract = null)
    {
        $this->purchaseContract = $purchaseContract;
        return $this;
    }
    /**
     * Get rate value
     * @return string|null
     */
    public function getRate()
    {
        return $this->rate;
    }
    /**
     * Set rate value
     * @param string $rate
     * @return \StructType\PurchaseOrderItem
     */
    public function setRate($rate = null)
    {
        // validation for constraint: string
        if (!is_null($rate) && !is_string($rate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($rate, true), gettype($rate)), __LINE__);
        }
        $this->rate = $rate;
        return $this;
    }
    /**
     * Get amount value
     * @return float|null
     */
    public function getAmount()
    {
        return $this->amount;
    }
    /**
     * Set amount value
     * @param float $amount
     * @return \StructType\PurchaseOrderItem
     */
    public function setAmount($amount = null)
    {
        // validation for constraint: float
        if (!is_null($amount) && !(is_float($amount) || is_numeric($amount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($amount, true), gettype($amount)), __LINE__);
        }
        $this->amount = $amount;
        return $this;
    }
    /**
     * Get options value
     * @return \StructType\CustomFieldList|null
     */
    public function getOptions()
    {
        return $this->options;
    }
    /**
     * Set options value
     * @param \StructType\CustomFieldList $options
     * @return \StructType\PurchaseOrderItem
     */
    public function setOptions(\StructType\CustomFieldList $options = null)
    {
        $this->options = $options;
        return $this;
    }
    /**
     * Get taxAmount value
     * @return float|null
     */
    public function getTaxAmount()
    {
        return $this->taxAmount;
    }
    /**
     * Set taxAmount value
     * @param float $taxAmount
     * @return \StructType\PurchaseOrderItem
     */
    public function setTaxAmount($taxAmount = null)
    {
        // validation for constraint: float
        if (!is_null($taxAmount) && !(is_float($taxAmount) || is_numeric($taxAmount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($taxAmount, true), gettype($taxAmount)), __LINE__);
        }
        $this->taxAmount = $taxAmount;
        return $this;
    }
    /**
     * Get department value
     * @return \StructType\RecordRef|null
     */
    public function getDepartment()
    {
        return $this->department;
    }
    /**
     * Set department value
     * @param \StructType\RecordRef $department
     * @return \StructType\PurchaseOrderItem
     */
    public function setDepartment(\StructType\RecordRef $department = null)
    {
        $this->department = $department;
        return $this;
    }
    /**
     * Get class value
     * @return \StructType\RecordRef|null
     */
    public function getClass()
    {
        return $this->class;
    }
    /**
     * Set class value
     * @param \StructType\RecordRef $class
     * @return \StructType\PurchaseOrderItem
     */
    public function setClass(\StructType\RecordRef $class = null)
    {
        $this->class = $class;
        return $this;
    }
    /**
     * Get location value
     * @return \StructType\RecordRef|null
     */
    public function getLocation()
    {
        return $this->location;
    }
    /**
     * Set location value
     * @param \StructType\RecordRef $location
     * @return \StructType\PurchaseOrderItem
     */
    public function setLocation(\StructType\RecordRef $location = null)
    {
        $this->location = $location;
        return $this;
    }
    /**
     * Get landedCostCategory value
     * @return \StructType\RecordRef|null
     */
    public function getLandedCostCategory()
    {
        return $this->landedCostCategory;
    }
    /**
     * Set landedCostCategory value
     * @param \StructType\RecordRef $landedCostCategory
     * @return \StructType\PurchaseOrderItem
     */
    public function setLandedCostCategory(\StructType\RecordRef $landedCostCategory = null)
    {
        $this->landedCostCategory = $landedCostCategory;
        return $this;
    }
    /**
     * Get customer value
     * @return \StructType\RecordRef|null
     */
    public function getCustomer()
    {
        return $this->customer;
    }
    /**
     * Set customer value
     * @param \StructType\RecordRef $customer
     * @return \StructType\PurchaseOrderItem
     */
    public function setCustomer(\StructType\RecordRef $customer = null)
    {
        $this->customer = $customer;
        return $this;
    }
    /**
     * Get isBillable value
     * @return bool|null
     */
    public function getIsBillable()
    {
        return $this->isBillable;
    }
    /**
     * Set isBillable value
     * @param bool $isBillable
     * @return \StructType\PurchaseOrderItem
     */
    public function setIsBillable($isBillable = null)
    {
        // validation for constraint: boolean
        if (!is_null($isBillable) && !is_bool($isBillable)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isBillable, true), gettype($isBillable)), __LINE__);
        }
        $this->isBillable = $isBillable;
        return $this;
    }
    /**
     * Get billVarianceStatus value
     * @return string|null
     */
    public function getBillVarianceStatus()
    {
        return $this->billVarianceStatus;
    }
    /**
     * Set billVarianceStatus value
     * @uses \EnumType\TransactionBillVarianceStatus::valueIsValid()
     * @uses \EnumType\TransactionBillVarianceStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $billVarianceStatus
     * @return \StructType\PurchaseOrderItem
     */
    public function setBillVarianceStatus($billVarianceStatus = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\TransactionBillVarianceStatus::valueIsValid($billVarianceStatus)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\TransactionBillVarianceStatus', is_array($billVarianceStatus) ? implode(', ', $billVarianceStatus) : var_export($billVarianceStatus, true), implode(', ', \EnumType\TransactionBillVarianceStatus::getValidValues())), __LINE__);
        }
        $this->billVarianceStatus = $billVarianceStatus;
        return $this;
    }
    /**
     * Get matchBillToReceipt value
     * @return bool|null
     */
    public function getMatchBillToReceipt()
    {
        return $this->matchBillToReceipt;
    }
    /**
     * Set matchBillToReceipt value
     * @param bool $matchBillToReceipt
     * @return \StructType\PurchaseOrderItem
     */
    public function setMatchBillToReceipt($matchBillToReceipt = null)
    {
        // validation for constraint: boolean
        if (!is_null($matchBillToReceipt) && !is_bool($matchBillToReceipt)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($matchBillToReceipt, true), gettype($matchBillToReceipt)), __LINE__);
        }
        $this->matchBillToReceipt = $matchBillToReceipt;
        return $this;
    }
    /**
     * Get expectedReceiptDate value
     * @return string|null
     */
    public function getExpectedReceiptDate()
    {
        return $this->expectedReceiptDate;
    }
    /**
     * Set expectedReceiptDate value
     * @param string $expectedReceiptDate
     * @return \StructType\PurchaseOrderItem
     */
    public function setExpectedReceiptDate($expectedReceiptDate = null)
    {
        // validation for constraint: string
        if (!is_null($expectedReceiptDate) && !is_string($expectedReceiptDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($expectedReceiptDate, true), gettype($expectedReceiptDate)), __LINE__);
        }
        $this->expectedReceiptDate = $expectedReceiptDate;
        return $this;
    }
    /**
     * Get isClosed value
     * @return bool|null
     */
    public function getIsClosed()
    {
        return $this->isClosed;
    }
    /**
     * Set isClosed value
     * @param bool $isClosed
     * @return \StructType\PurchaseOrderItem
     */
    public function setIsClosed($isClosed = null)
    {
        // validation for constraint: boolean
        if (!is_null($isClosed) && !is_bool($isClosed)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isClosed, true), gettype($isClosed)), __LINE__);
        }
        $this->isClosed = $isClosed;
        return $this;
    }
    /**
     * Get taxDetailsReference value
     * @return string|null
     */
    public function getTaxDetailsReference()
    {
        return $this->taxDetailsReference;
    }
    /**
     * Set taxDetailsReference value
     * @param string $taxDetailsReference
     * @return \StructType\PurchaseOrderItem
     */
    public function setTaxDetailsReference($taxDetailsReference = null)
    {
        // validation for constraint: string
        if (!is_null($taxDetailsReference) && !is_string($taxDetailsReference)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($taxDetailsReference, true), gettype($taxDetailsReference)), __LINE__);
        }
        $this->taxDetailsReference = $taxDetailsReference;
        return $this;
    }
    /**
     * Get createdFrom value
     * @return \StructType\RecordRef|null
     */
    public function getCreatedFrom()
    {
        return $this->createdFrom;
    }
    /**
     * Set createdFrom value
     * @param \StructType\RecordRef $createdFrom
     * @return \StructType\PurchaseOrderItem
     */
    public function setCreatedFrom(\StructType\RecordRef $createdFrom = null)
    {
        $this->createdFrom = $createdFrom;
        return $this;
    }
    /**
     * Get linkedOrderList value
     * @return \StructType\RecordRefList|null
     */
    public function getLinkedOrderList()
    {
        return $this->linkedOrderList;
    }
    /**
     * Set linkedOrderList value
     * @param \StructType\RecordRefList $linkedOrderList
     * @return \StructType\PurchaseOrderItem
     */
    public function setLinkedOrderList(\StructType\RecordRefList $linkedOrderList = null)
    {
        $this->linkedOrderList = $linkedOrderList;
        return $this;
    }
    /**
     * Get customFieldList value
     * @return \StructType\CustomFieldList|null
     */
    public function getCustomFieldList()
    {
        return $this->customFieldList;
    }
    /**
     * Set customFieldList value
     * @param \StructType\CustomFieldList $customFieldList
     * @return \StructType\PurchaseOrderItem
     */
    public function setCustomFieldList(\StructType\CustomFieldList $customFieldList = null)
    {
        $this->customFieldList = $customFieldList;
        return $this;
    }
}
