<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PromotionCodeItemsList StructType
 * @subpackage Structs
 */
class PromotionCodeItemsList extends AbstractStructBase
{
    /**
     * The items
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\PromotionCodeItems[]
     */
    public $items;
    /**
     * The replaceAll
     * Meta information extracted from the WSDL
     * - default: true
     * @var bool
     */
    public $replaceAll;
    /**
     * Constructor method for PromotionCodeItemsList
     * @uses PromotionCodeItemsList::setItems()
     * @uses PromotionCodeItemsList::setReplaceAll()
     * @param \StructType\PromotionCodeItems[] $items
     * @param bool $replaceAll
     */
    public function __construct(array $items = array(), $replaceAll = true)
    {
        $this
            ->setItems($items)
            ->setReplaceAll($replaceAll);
    }
    /**
     * Get items value
     * @return \StructType\PromotionCodeItems[]|null
     */
    public function getItems()
    {
        return $this->items;
    }
    /**
     * This method is responsible for validating the values passed to the setItems method
     * This method is willingly generated in order to preserve the one-line inline validation within the setItems method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateItemsForArrayConstraintsFromSetItems(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $promotionCodeItemsListItemsItem) {
            // validation for constraint: itemType
            if (!$promotionCodeItemsListItemsItem instanceof \StructType\PromotionCodeItems) {
                $invalidValues[] = is_object($promotionCodeItemsListItemsItem) ? get_class($promotionCodeItemsListItemsItem) : sprintf('%s(%s)', gettype($promotionCodeItemsListItemsItem), var_export($promotionCodeItemsListItemsItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The items property can only contain items of type \StructType\PromotionCodeItems, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set items value
     * @throws \InvalidArgumentException
     * @param \StructType\PromotionCodeItems[] $items
     * @return \StructType\PromotionCodeItemsList
     */
    public function setItems(array $items = array())
    {
        // validation for constraint: array
        if ('' !== ($itemsArrayErrorMessage = self::validateItemsForArrayConstraintsFromSetItems($items))) {
            throw new \InvalidArgumentException($itemsArrayErrorMessage, __LINE__);
        }
        $this->items = $items;
        return $this;
    }
    /**
     * Add item to items value
     * @throws \InvalidArgumentException
     * @param \StructType\PromotionCodeItems $item
     * @return \StructType\PromotionCodeItemsList
     */
    public function addToItems(\StructType\PromotionCodeItems $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\PromotionCodeItems) {
            throw new \InvalidArgumentException(sprintf('The items property can only contain items of type \StructType\PromotionCodeItems, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->items[] = $item;
        return $this;
    }
    /**
     * Get replaceAll value
     * @return bool|null
     */
    public function getReplaceAll()
    {
        return $this->replaceAll;
    }
    /**
     * Set replaceAll value
     * @param bool $replaceAll
     * @return \StructType\PromotionCodeItemsList
     */
    public function setReplaceAll($replaceAll = true)
    {
        // validation for constraint: boolean
        if (!is_null($replaceAll) && !is_bool($replaceAll)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($replaceAll, true), gettype($replaceAll)), __LINE__);
        }
        $this->replaceAll = $replaceAll;
        return $this;
    }
}
