<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PromotionCode StructType
 * @subpackage Structs
 */
class PromotionCode extends Record
{
    /**
     * The implementation
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $implementation;
    /**
     * The customForm
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $customForm;
    /**
     * The useType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $useType;
    /**
     * The displayLineDiscounts
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $displayLineDiscounts;
    /**
     * The code
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $code;
    /**
     * The codePattern
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $codePattern;
    /**
     * The numberToGenerate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $numberToGenerate;
    /**
     * The description
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $description;
    /**
     * The locationList
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRefList
     */
    public $locationList;
    /**
     * The isInactive
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $isInactive;
    /**
     * The discount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $discount;
    /**
     * The rate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $rate;
    /**
     * The discountType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $discountType;
    /**
     * The applyDiscountTo
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $applyDiscountTo;
    /**
     * The freeShipMethod
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $freeShipMethod;
    /**
     * The minimumOrderAmount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $minimumOrderAmount;
    /**
     * The startDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $startDate;
    /**
     * The endDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $endDate;
    /**
     * The isPublic
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $isPublic;
    /**
     * The currencyList
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\PromotionCodeCurrencyList
     */
    public $currencyList;
    /**
     * The excludeItems
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $excludeItems;
    /**
     * The name
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $name;
    /**
     * The itemsList
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\PromotionCodeItemsList
     */
    public $itemsList;
    /**
     * The partnersList
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\PromotionCodePartnersList
     */
    public $partnersList;
    /**
     * The customFieldList
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\CustomFieldList
     */
    public $customFieldList;
    /**
     * The internalId
     * @var string
     */
    public $internalId;
    /**
     * The externalId
     * @var string
     */
    public $externalId;
    /**
     * Constructor method for PromotionCode
     * @uses PromotionCode::setImplementation()
     * @uses PromotionCode::setCustomForm()
     * @uses PromotionCode::setUseType()
     * @uses PromotionCode::setDisplayLineDiscounts()
     * @uses PromotionCode::setCode()
     * @uses PromotionCode::setCodePattern()
     * @uses PromotionCode::setNumberToGenerate()
     * @uses PromotionCode::setDescription()
     * @uses PromotionCode::setLocationList()
     * @uses PromotionCode::setIsInactive()
     * @uses PromotionCode::setDiscount()
     * @uses PromotionCode::setRate()
     * @uses PromotionCode::setDiscountType()
     * @uses PromotionCode::setApplyDiscountTo()
     * @uses PromotionCode::setFreeShipMethod()
     * @uses PromotionCode::setMinimumOrderAmount()
     * @uses PromotionCode::setStartDate()
     * @uses PromotionCode::setEndDate()
     * @uses PromotionCode::setIsPublic()
     * @uses PromotionCode::setCurrencyList()
     * @uses PromotionCode::setExcludeItems()
     * @uses PromotionCode::setName()
     * @uses PromotionCode::setItemsList()
     * @uses PromotionCode::setPartnersList()
     * @uses PromotionCode::setCustomFieldList()
     * @uses PromotionCode::setInternalId()
     * @uses PromotionCode::setExternalId()
     * @param \StructType\RecordRef $implementation
     * @param \StructType\RecordRef $customForm
     * @param string $useType
     * @param bool $displayLineDiscounts
     * @param string $code
     * @param string $codePattern
     * @param int $numberToGenerate
     * @param string $description
     * @param \StructType\RecordRefList $locationList
     * @param bool $isInactive
     * @param \StructType\RecordRef $discount
     * @param string $rate
     * @param bool $discountType
     * @param string $applyDiscountTo
     * @param \StructType\RecordRef $freeShipMethod
     * @param float $minimumOrderAmount
     * @param string $startDate
     * @param string $endDate
     * @param bool $isPublic
     * @param \StructType\PromotionCodeCurrencyList $currencyList
     * @param bool $excludeItems
     * @param string $name
     * @param \StructType\PromotionCodeItemsList $itemsList
     * @param \StructType\PromotionCodePartnersList $partnersList
     * @param \StructType\CustomFieldList $customFieldList
     * @param string $internalId
     * @param string $externalId
     */
    public function __construct(\StructType\RecordRef $implementation = null, \StructType\RecordRef $customForm = null, $useType = null, $displayLineDiscounts = null, $code = null, $codePattern = null, $numberToGenerate = null, $description = null, \StructType\RecordRefList $locationList = null, $isInactive = null, \StructType\RecordRef $discount = null, $rate = null, $discountType = null, $applyDiscountTo = null, \StructType\RecordRef $freeShipMethod = null, $minimumOrderAmount = null, $startDate = null, $endDate = null, $isPublic = null, \StructType\PromotionCodeCurrencyList $currencyList = null, $excludeItems = null, $name = null, \StructType\PromotionCodeItemsList $itemsList = null, \StructType\PromotionCodePartnersList $partnersList = null, \StructType\CustomFieldList $customFieldList = null, $internalId = null, $externalId = null)
    {
        $this
            ->setImplementation($implementation)
            ->setCustomForm($customForm)
            ->setUseType($useType)
            ->setDisplayLineDiscounts($displayLineDiscounts)
            ->setCode($code)
            ->setCodePattern($codePattern)
            ->setNumberToGenerate($numberToGenerate)
            ->setDescription($description)
            ->setLocationList($locationList)
            ->setIsInactive($isInactive)
            ->setDiscount($discount)
            ->setRate($rate)
            ->setDiscountType($discountType)
            ->setApplyDiscountTo($applyDiscountTo)
            ->setFreeShipMethod($freeShipMethod)
            ->setMinimumOrderAmount($minimumOrderAmount)
            ->setStartDate($startDate)
            ->setEndDate($endDate)
            ->setIsPublic($isPublic)
            ->setCurrencyList($currencyList)
            ->setExcludeItems($excludeItems)
            ->setName($name)
            ->setItemsList($itemsList)
            ->setPartnersList($partnersList)
            ->setCustomFieldList($customFieldList)
            ->setInternalId($internalId)
            ->setExternalId($externalId);
    }
    /**
     * Get implementation value
     * @return \StructType\RecordRef|null
     */
    public function getImplementation()
    {
        return $this->implementation;
    }
    /**
     * Set implementation value
     * @param \StructType\RecordRef $implementation
     * @return \StructType\PromotionCode
     */
    public function setImplementation(\StructType\RecordRef $implementation = null)
    {
        $this->implementation = $implementation;
        return $this;
    }
    /**
     * Get customForm value
     * @return \StructType\RecordRef|null
     */
    public function getCustomForm()
    {
        return $this->customForm;
    }
    /**
     * Set customForm value
     * @param \StructType\RecordRef $customForm
     * @return \StructType\PromotionCode
     */
    public function setCustomForm(\StructType\RecordRef $customForm = null)
    {
        $this->customForm = $customForm;
        return $this;
    }
    /**
     * Get useType value
     * @return string|null
     */
    public function getUseType()
    {
        return $this->useType;
    }
    /**
     * Set useType value
     * @uses \EnumType\PromotionCodeUseType::valueIsValid()
     * @uses \EnumType\PromotionCodeUseType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $useType
     * @return \StructType\PromotionCode
     */
    public function setUseType($useType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\PromotionCodeUseType::valueIsValid($useType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\PromotionCodeUseType', is_array($useType) ? implode(', ', $useType) : var_export($useType, true), implode(', ', \EnumType\PromotionCodeUseType::getValidValues())), __LINE__);
        }
        $this->useType = $useType;
        return $this;
    }
    /**
     * Get displayLineDiscounts value
     * @return bool|null
     */
    public function getDisplayLineDiscounts()
    {
        return $this->displayLineDiscounts;
    }
    /**
     * Set displayLineDiscounts value
     * @param bool $displayLineDiscounts
     * @return \StructType\PromotionCode
     */
    public function setDisplayLineDiscounts($displayLineDiscounts = null)
    {
        // validation for constraint: boolean
        if (!is_null($displayLineDiscounts) && !is_bool($displayLineDiscounts)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($displayLineDiscounts, true), gettype($displayLineDiscounts)), __LINE__);
        }
        $this->displayLineDiscounts = $displayLineDiscounts;
        return $this;
    }
    /**
     * Get code value
     * @return string|null
     */
    public function getCode()
    {
        return $this->code;
    }
    /**
     * Set code value
     * @param string $code
     * @return \StructType\PromotionCode
     */
    public function setCode($code = null)
    {
        // validation for constraint: string
        if (!is_null($code) && !is_string($code)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($code, true), gettype($code)), __LINE__);
        }
        $this->code = $code;
        return $this;
    }
    /**
     * Get codePattern value
     * @return string|null
     */
    public function getCodePattern()
    {
        return $this->codePattern;
    }
    /**
     * Set codePattern value
     * @param string $codePattern
     * @return \StructType\PromotionCode
     */
    public function setCodePattern($codePattern = null)
    {
        // validation for constraint: string
        if (!is_null($codePattern) && !is_string($codePattern)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($codePattern, true), gettype($codePattern)), __LINE__);
        }
        $this->codePattern = $codePattern;
        return $this;
    }
    /**
     * Get numberToGenerate value
     * @return int|null
     */
    public function getNumberToGenerate()
    {
        return $this->numberToGenerate;
    }
    /**
     * Set numberToGenerate value
     * @param int $numberToGenerate
     * @return \StructType\PromotionCode
     */
    public function setNumberToGenerate($numberToGenerate = null)
    {
        // validation for constraint: int
        if (!is_null($numberToGenerate) && !(is_int($numberToGenerate) || ctype_digit($numberToGenerate))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($numberToGenerate, true), gettype($numberToGenerate)), __LINE__);
        }
        $this->numberToGenerate = $numberToGenerate;
        return $this;
    }
    /**
     * Get description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return \StructType\PromotionCode
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        $this->description = $description;
        return $this;
    }
    /**
     * Get locationList value
     * @return \StructType\RecordRefList|null
     */
    public function getLocationList()
    {
        return $this->locationList;
    }
    /**
     * Set locationList value
     * @param \StructType\RecordRefList $locationList
     * @return \StructType\PromotionCode
     */
    public function setLocationList(\StructType\RecordRefList $locationList = null)
    {
        $this->locationList = $locationList;
        return $this;
    }
    /**
     * Get isInactive value
     * @return bool|null
     */
    public function getIsInactive()
    {
        return $this->isInactive;
    }
    /**
     * Set isInactive value
     * @param bool $isInactive
     * @return \StructType\PromotionCode
     */
    public function setIsInactive($isInactive = null)
    {
        // validation for constraint: boolean
        if (!is_null($isInactive) && !is_bool($isInactive)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isInactive, true), gettype($isInactive)), __LINE__);
        }
        $this->isInactive = $isInactive;
        return $this;
    }
    /**
     * Get discount value
     * @return \StructType\RecordRef|null
     */
    public function getDiscount()
    {
        return $this->discount;
    }
    /**
     * Set discount value
     * @param \StructType\RecordRef $discount
     * @return \StructType\PromotionCode
     */
    public function setDiscount(\StructType\RecordRef $discount = null)
    {
        $this->discount = $discount;
        return $this;
    }
    /**
     * Get rate value
     * @return string|null
     */
    public function getRate()
    {
        return $this->rate;
    }
    /**
     * Set rate value
     * @param string $rate
     * @return \StructType\PromotionCode
     */
    public function setRate($rate = null)
    {
        // validation for constraint: string
        if (!is_null($rate) && !is_string($rate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($rate, true), gettype($rate)), __LINE__);
        }
        $this->rate = $rate;
        return $this;
    }
    /**
     * Get discountType value
     * @return bool|null
     */
    public function getDiscountType()
    {
        return $this->discountType;
    }
    /**
     * Set discountType value
     * @param bool $discountType
     * @return \StructType\PromotionCode
     */
    public function setDiscountType($discountType = null)
    {
        // validation for constraint: boolean
        if (!is_null($discountType) && !is_bool($discountType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($discountType, true), gettype($discountType)), __LINE__);
        }
        $this->discountType = $discountType;
        return $this;
    }
    /**
     * Get applyDiscountTo value
     * @return string|null
     */
    public function getApplyDiscountTo()
    {
        return $this->applyDiscountTo;
    }
    /**
     * Set applyDiscountTo value
     * @uses \EnumType\PromotionCodeApplyDiscountTo::valueIsValid()
     * @uses \EnumType\PromotionCodeApplyDiscountTo::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $applyDiscountTo
     * @return \StructType\PromotionCode
     */
    public function setApplyDiscountTo($applyDiscountTo = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\PromotionCodeApplyDiscountTo::valueIsValid($applyDiscountTo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\PromotionCodeApplyDiscountTo', is_array($applyDiscountTo) ? implode(', ', $applyDiscountTo) : var_export($applyDiscountTo, true), implode(', ', \EnumType\PromotionCodeApplyDiscountTo::getValidValues())), __LINE__);
        }
        $this->applyDiscountTo = $applyDiscountTo;
        return $this;
    }
    /**
     * Get freeShipMethod value
     * @return \StructType\RecordRef|null
     */
    public function getFreeShipMethod()
    {
        return $this->freeShipMethod;
    }
    /**
     * Set freeShipMethod value
     * @param \StructType\RecordRef $freeShipMethod
     * @return \StructType\PromotionCode
     */
    public function setFreeShipMethod(\StructType\RecordRef $freeShipMethod = null)
    {
        $this->freeShipMethod = $freeShipMethod;
        return $this;
    }
    /**
     * Get minimumOrderAmount value
     * @return float|null
     */
    public function getMinimumOrderAmount()
    {
        return $this->minimumOrderAmount;
    }
    /**
     * Set minimumOrderAmount value
     * @param float $minimumOrderAmount
     * @return \StructType\PromotionCode
     */
    public function setMinimumOrderAmount($minimumOrderAmount = null)
    {
        // validation for constraint: float
        if (!is_null($minimumOrderAmount) && !(is_float($minimumOrderAmount) || is_numeric($minimumOrderAmount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($minimumOrderAmount, true), gettype($minimumOrderAmount)), __LINE__);
        }
        $this->minimumOrderAmount = $minimumOrderAmount;
        return $this;
    }
    /**
     * Get startDate value
     * @return string|null
     */
    public function getStartDate()
    {
        return $this->startDate;
    }
    /**
     * Set startDate value
     * @param string $startDate
     * @return \StructType\PromotionCode
     */
    public function setStartDate($startDate = null)
    {
        // validation for constraint: string
        if (!is_null($startDate) && !is_string($startDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($startDate, true), gettype($startDate)), __LINE__);
        }
        $this->startDate = $startDate;
        return $this;
    }
    /**
     * Get endDate value
     * @return string|null
     */
    public function getEndDate()
    {
        return $this->endDate;
    }
    /**
     * Set endDate value
     * @param string $endDate
     * @return \StructType\PromotionCode
     */
    public function setEndDate($endDate = null)
    {
        // validation for constraint: string
        if (!is_null($endDate) && !is_string($endDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($endDate, true), gettype($endDate)), __LINE__);
        }
        $this->endDate = $endDate;
        return $this;
    }
    /**
     * Get isPublic value
     * @return bool|null
     */
    public function getIsPublic()
    {
        return $this->isPublic;
    }
    /**
     * Set isPublic value
     * @param bool $isPublic
     * @return \StructType\PromotionCode
     */
    public function setIsPublic($isPublic = null)
    {
        // validation for constraint: boolean
        if (!is_null($isPublic) && !is_bool($isPublic)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isPublic, true), gettype($isPublic)), __LINE__);
        }
        $this->isPublic = $isPublic;
        return $this;
    }
    /**
     * Get currencyList value
     * @return \StructType\PromotionCodeCurrencyList|null
     */
    public function getCurrencyList()
    {
        return $this->currencyList;
    }
    /**
     * Set currencyList value
     * @param \StructType\PromotionCodeCurrencyList $currencyList
     * @return \StructType\PromotionCode
     */
    public function setCurrencyList(\StructType\PromotionCodeCurrencyList $currencyList = null)
    {
        $this->currencyList = $currencyList;
        return $this;
    }
    /**
     * Get excludeItems value
     * @return bool|null
     */
    public function getExcludeItems()
    {
        return $this->excludeItems;
    }
    /**
     * Set excludeItems value
     * @param bool $excludeItems
     * @return \StructType\PromotionCode
     */
    public function setExcludeItems($excludeItems = null)
    {
        // validation for constraint: boolean
        if (!is_null($excludeItems) && !is_bool($excludeItems)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($excludeItems, true), gettype($excludeItems)), __LINE__);
        }
        $this->excludeItems = $excludeItems;
        return $this;
    }
    /**
     * Get name value
     * @return string|null
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return \StructType\PromotionCode
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        $this->name = $name;
        return $this;
    }
    /**
     * Get itemsList value
     * @return \StructType\PromotionCodeItemsList|null
     */
    public function getItemsList()
    {
        return $this->itemsList;
    }
    /**
     * Set itemsList value
     * @param \StructType\PromotionCodeItemsList $itemsList
     * @return \StructType\PromotionCode
     */
    public function setItemsList(\StructType\PromotionCodeItemsList $itemsList = null)
    {
        $this->itemsList = $itemsList;
        return $this;
    }
    /**
     * Get partnersList value
     * @return \StructType\PromotionCodePartnersList|null
     */
    public function getPartnersList()
    {
        return $this->partnersList;
    }
    /**
     * Set partnersList value
     * @param \StructType\PromotionCodePartnersList $partnersList
     * @return \StructType\PromotionCode
     */
    public function setPartnersList(\StructType\PromotionCodePartnersList $partnersList = null)
    {
        $this->partnersList = $partnersList;
        return $this;
    }
    /**
     * Get customFieldList value
     * @return \StructType\CustomFieldList|null
     */
    public function getCustomFieldList()
    {
        return $this->customFieldList;
    }
    /**
     * Set customFieldList value
     * @param \StructType\CustomFieldList $customFieldList
     * @return \StructType\PromotionCode
     */
    public function setCustomFieldList(\StructType\CustomFieldList $customFieldList = null)
    {
        $this->customFieldList = $customFieldList;
        return $this;
    }
    /**
     * Get internalId value
     * @return string|null
     */
    public function getInternalId()
    {
        return $this->internalId;
    }
    /**
     * Set internalId value
     * @param string $internalId
     * @return \StructType\PromotionCode
     */
    public function setInternalId($internalId = null)
    {
        // validation for constraint: string
        if (!is_null($internalId) && !is_string($internalId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($internalId, true), gettype($internalId)), __LINE__);
        }
        $this->internalId = $internalId;
        return $this;
    }
    /**
     * Get externalId value
     * @return string|null
     */
    public function getExternalId()
    {
        return $this->externalId;
    }
    /**
     * Set externalId value
     * @param string $externalId
     * @return \StructType\PromotionCode
     */
    public function setExternalId($externalId = null)
    {
        // validation for constraint: string
        if (!is_null($externalId) && !is_string($externalId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($externalId, true), gettype($externalId)), __LINE__);
        }
        $this->externalId = $externalId;
        return $this;
    }
}
