<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ProjectTaskSearchRowBasic StructType
 * @subpackage Structs
 */
class ProjectTaskSearchRowBasic extends SearchRowBasic
{
    /**
     * The actualWork
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SearchColumnDoubleField[]
     */
    public $actualWork;
    /**
     * The company
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SearchColumnSelectField[]
     */
    public $company;
    /**
     * The constraintType
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SearchColumnEnumSelectField[]
     */
    public $constraintType;
    /**
     * The contact
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SearchColumnSelectField[]
     */
    public $contact;
    /**
     * The cost
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SearchColumnDoubleField[]
     */
    public $cost;
    /**
     * The costBase
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SearchColumnDoubleField[]
     */
    public $costBase;
    /**
     * The costBaseBaseline
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SearchColumnDoubleField[]
     */
    public $costBaseBaseline;
    /**
     * The costBaseline
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SearchColumnDoubleField[]
     */
    public $costBaseline;
    /**
     * The costBaseVariance
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SearchColumnDoubleField[]
     */
    public $costBaseVariance;
    /**
     * The costVariance
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SearchColumnDoubleField[]
     */
    public $costVariance;
    /**
     * The costVariancePercent
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SearchColumnDoubleField[]
     */
    public $costVariancePercent;
    /**
     * The createdDate
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SearchColumnDateField[]
     */
    public $createdDate;
    /**
     * The endDate
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SearchColumnDateField[]
     */
    public $endDate;
    /**
     * The endDateBaseline
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SearchColumnDateField[]
     */
    public $endDateBaseline;
    /**
     * The endDateVariance
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SearchColumnDoubleField[]
     */
    public $endDateVariance;
    /**
     * The estimatedWork
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SearchColumnDoubleField[]
     */
    public $estimatedWork;
    /**
     * The estimatedWorkBaseline
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SearchColumnDoubleField[]
     */
    public $estimatedWorkBaseline;
    /**
     * The estimatedWorkVariance
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SearchColumnDoubleField[]
     */
    public $estimatedWorkVariance;
    /**
     * The estimatedWorkVariancePercent
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SearchColumnDoubleField[]
     */
    public $estimatedWorkVariancePercent;
    /**
     * The externalId
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SearchColumnSelectField[]
     */
    public $externalId;
    /**
     * The finishByDate
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SearchColumnDateField[]
     */
    public $finishByDate;
    /**
     * The id
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SearchColumnLongField[]
     */
    public $id;
    /**
     * The internalId
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SearchColumnSelectField[]
     */
    public $internalId;
    /**
     * The isMilestone
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SearchColumnBooleanField[]
     */
    public $isMilestone;
    /**
     * The isSummaryTask
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SearchColumnBooleanField[]
     */
    public $isSummaryTask;
    /**
     * The lastModifiedDate
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SearchColumnDateField[]
     */
    public $lastModifiedDate;
    /**
     * The message
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SearchColumnStringField[]
     */
    public $message;
    /**
     * The nonBillableTask
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SearchColumnBooleanField[]
     */
    public $nonBillableTask;
    /**
     * The owner
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SearchColumnSelectField[]
     */
    public $owner;
    /**
     * The parent
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SearchColumnSelectField[]
     */
    public $parent;
    /**
     * The percentWorkComplete
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SearchColumnDoubleField[]
     */
    public $percentWorkComplete;
    /**
     * The plannedWork
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SearchColumnDoubleField[]
     */
    public $plannedWork;
    /**
     * The plannedWorkBaseline
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SearchColumnDoubleField[]
     */
    public $plannedWorkBaseline;
    /**
     * The predecessor
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SearchColumnSelectField[]
     */
    public $predecessor;
    /**
     * The predecessorLagDays
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SearchColumnDoubleField[]
     */
    public $predecessorLagDays;
    /**
     * The predecessors
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SearchColumnStringField[]
     */
    public $predecessors;
    /**
     * The predecessorType
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SearchColumnStringField[]
     */
    public $predecessorType;
    /**
     * The priority
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SearchColumnEnumSelectField[]
     */
    public $priority;
    /**
     * The remainingWork
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SearchColumnDoubleField[]
     */
    public $remainingWork;
    /**
     * The startDate
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SearchColumnDateField[]
     */
    public $startDate;
    /**
     * The startDateBaseline
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SearchColumnDateField[]
     */
    public $startDateBaseline;
    /**
     * The startDateVariance
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SearchColumnDoubleField[]
     */
    public $startDateVariance;
    /**
     * The status
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SearchColumnEnumSelectField[]
     */
    public $status;
    /**
     * The successor
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SearchColumnSelectField[]
     */
    public $successor;
    /**
     * The successorType
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SearchColumnStringField[]
     */
    public $successorType;
    /**
     * The title
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SearchColumnStringField[]
     */
    public $title;
    /**
     * The customFieldList
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\SearchColumnCustomFieldList
     */
    public $customFieldList;
    /**
     * Constructor method for ProjectTaskSearchRowBasic
     * @uses ProjectTaskSearchRowBasic::setActualWork()
     * @uses ProjectTaskSearchRowBasic::setCompany()
     * @uses ProjectTaskSearchRowBasic::setConstraintType()
     * @uses ProjectTaskSearchRowBasic::setContact()
     * @uses ProjectTaskSearchRowBasic::setCost()
     * @uses ProjectTaskSearchRowBasic::setCostBase()
     * @uses ProjectTaskSearchRowBasic::setCostBaseBaseline()
     * @uses ProjectTaskSearchRowBasic::setCostBaseline()
     * @uses ProjectTaskSearchRowBasic::setCostBaseVariance()
     * @uses ProjectTaskSearchRowBasic::setCostVariance()
     * @uses ProjectTaskSearchRowBasic::setCostVariancePercent()
     * @uses ProjectTaskSearchRowBasic::setCreatedDate()
     * @uses ProjectTaskSearchRowBasic::setEndDate()
     * @uses ProjectTaskSearchRowBasic::setEndDateBaseline()
     * @uses ProjectTaskSearchRowBasic::setEndDateVariance()
     * @uses ProjectTaskSearchRowBasic::setEstimatedWork()
     * @uses ProjectTaskSearchRowBasic::setEstimatedWorkBaseline()
     * @uses ProjectTaskSearchRowBasic::setEstimatedWorkVariance()
     * @uses ProjectTaskSearchRowBasic::setEstimatedWorkVariancePercent()
     * @uses ProjectTaskSearchRowBasic::setExternalId()
     * @uses ProjectTaskSearchRowBasic::setFinishByDate()
     * @uses ProjectTaskSearchRowBasic::setId()
     * @uses ProjectTaskSearchRowBasic::setInternalId()
     * @uses ProjectTaskSearchRowBasic::setIsMilestone()
     * @uses ProjectTaskSearchRowBasic::setIsSummaryTask()
     * @uses ProjectTaskSearchRowBasic::setLastModifiedDate()
     * @uses ProjectTaskSearchRowBasic::setMessage()
     * @uses ProjectTaskSearchRowBasic::setNonBillableTask()
     * @uses ProjectTaskSearchRowBasic::setOwner()
     * @uses ProjectTaskSearchRowBasic::setParent()
     * @uses ProjectTaskSearchRowBasic::setPercentWorkComplete()
     * @uses ProjectTaskSearchRowBasic::setPlannedWork()
     * @uses ProjectTaskSearchRowBasic::setPlannedWorkBaseline()
     * @uses ProjectTaskSearchRowBasic::setPredecessor()
     * @uses ProjectTaskSearchRowBasic::setPredecessorLagDays()
     * @uses ProjectTaskSearchRowBasic::setPredecessors()
     * @uses ProjectTaskSearchRowBasic::setPredecessorType()
     * @uses ProjectTaskSearchRowBasic::setPriority()
     * @uses ProjectTaskSearchRowBasic::setRemainingWork()
     * @uses ProjectTaskSearchRowBasic::setStartDate()
     * @uses ProjectTaskSearchRowBasic::setStartDateBaseline()
     * @uses ProjectTaskSearchRowBasic::setStartDateVariance()
     * @uses ProjectTaskSearchRowBasic::setStatus()
     * @uses ProjectTaskSearchRowBasic::setSuccessor()
     * @uses ProjectTaskSearchRowBasic::setSuccessorType()
     * @uses ProjectTaskSearchRowBasic::setTitle()
     * @uses ProjectTaskSearchRowBasic::setCustomFieldList()
     * @param \StructType\SearchColumnDoubleField[] $actualWork
     * @param \StructType\SearchColumnSelectField[] $company
     * @param \StructType\SearchColumnEnumSelectField[] $constraintType
     * @param \StructType\SearchColumnSelectField[] $contact
     * @param \StructType\SearchColumnDoubleField[] $cost
     * @param \StructType\SearchColumnDoubleField[] $costBase
     * @param \StructType\SearchColumnDoubleField[] $costBaseBaseline
     * @param \StructType\SearchColumnDoubleField[] $costBaseline
     * @param \StructType\SearchColumnDoubleField[] $costBaseVariance
     * @param \StructType\SearchColumnDoubleField[] $costVariance
     * @param \StructType\SearchColumnDoubleField[] $costVariancePercent
     * @param \StructType\SearchColumnDateField[] $createdDate
     * @param \StructType\SearchColumnDateField[] $endDate
     * @param \StructType\SearchColumnDateField[] $endDateBaseline
     * @param \StructType\SearchColumnDoubleField[] $endDateVariance
     * @param \StructType\SearchColumnDoubleField[] $estimatedWork
     * @param \StructType\SearchColumnDoubleField[] $estimatedWorkBaseline
     * @param \StructType\SearchColumnDoubleField[] $estimatedWorkVariance
     * @param \StructType\SearchColumnDoubleField[] $estimatedWorkVariancePercent
     * @param \StructType\SearchColumnSelectField[] $externalId
     * @param \StructType\SearchColumnDateField[] $finishByDate
     * @param \StructType\SearchColumnLongField[] $id
     * @param \StructType\SearchColumnSelectField[] $internalId
     * @param \StructType\SearchColumnBooleanField[] $isMilestone
     * @param \StructType\SearchColumnBooleanField[] $isSummaryTask
     * @param \StructType\SearchColumnDateField[] $lastModifiedDate
     * @param \StructType\SearchColumnStringField[] $message
     * @param \StructType\SearchColumnBooleanField[] $nonBillableTask
     * @param \StructType\SearchColumnSelectField[] $owner
     * @param \StructType\SearchColumnSelectField[] $parent
     * @param \StructType\SearchColumnDoubleField[] $percentWorkComplete
     * @param \StructType\SearchColumnDoubleField[] $plannedWork
     * @param \StructType\SearchColumnDoubleField[] $plannedWorkBaseline
     * @param \StructType\SearchColumnSelectField[] $predecessor
     * @param \StructType\SearchColumnDoubleField[] $predecessorLagDays
     * @param \StructType\SearchColumnStringField[] $predecessors
     * @param \StructType\SearchColumnStringField[] $predecessorType
     * @param \StructType\SearchColumnEnumSelectField[] $priority
     * @param \StructType\SearchColumnDoubleField[] $remainingWork
     * @param \StructType\SearchColumnDateField[] $startDate
     * @param \StructType\SearchColumnDateField[] $startDateBaseline
     * @param \StructType\SearchColumnDoubleField[] $startDateVariance
     * @param \StructType\SearchColumnEnumSelectField[] $status
     * @param \StructType\SearchColumnSelectField[] $successor
     * @param \StructType\SearchColumnStringField[] $successorType
     * @param \StructType\SearchColumnStringField[] $title
     * @param \StructType\SearchColumnCustomFieldList $customFieldList
     */
    public function __construct(array $actualWork = array(), array $company = array(), array $constraintType = array(), array $contact = array(), array $cost = array(), array $costBase = array(), array $costBaseBaseline = array(), array $costBaseline = array(), array $costBaseVariance = array(), array $costVariance = array(), array $costVariancePercent = array(), array $createdDate = array(), array $endDate = array(), array $endDateBaseline = array(), array $endDateVariance = array(), array $estimatedWork = array(), array $estimatedWorkBaseline = array(), array $estimatedWorkVariance = array(), array $estimatedWorkVariancePercent = array(), array $externalId = array(), array $finishByDate = array(), array $id = array(), array $internalId = array(), array $isMilestone = array(), array $isSummaryTask = array(), array $lastModifiedDate = array(), array $message = array(), array $nonBillableTask = array(), array $owner = array(), array $parent = array(), array $percentWorkComplete = array(), array $plannedWork = array(), array $plannedWorkBaseline = array(), array $predecessor = array(), array $predecessorLagDays = array(), array $predecessors = array(), array $predecessorType = array(), array $priority = array(), array $remainingWork = array(), array $startDate = array(), array $startDateBaseline = array(), array $startDateVariance = array(), array $status = array(), array $successor = array(), array $successorType = array(), array $title = array(), \StructType\SearchColumnCustomFieldList $customFieldList = null)
    {
        $this
            ->setActualWork($actualWork)
            ->setCompany($company)
            ->setConstraintType($constraintType)
            ->setContact($contact)
            ->setCost($cost)
            ->setCostBase($costBase)
            ->setCostBaseBaseline($costBaseBaseline)
            ->setCostBaseline($costBaseline)
            ->setCostBaseVariance($costBaseVariance)
            ->setCostVariance($costVariance)
            ->setCostVariancePercent($costVariancePercent)
            ->setCreatedDate($createdDate)
            ->setEndDate($endDate)
            ->setEndDateBaseline($endDateBaseline)
            ->setEndDateVariance($endDateVariance)
            ->setEstimatedWork($estimatedWork)
            ->setEstimatedWorkBaseline($estimatedWorkBaseline)
            ->setEstimatedWorkVariance($estimatedWorkVariance)
            ->setEstimatedWorkVariancePercent($estimatedWorkVariancePercent)
            ->setExternalId($externalId)
            ->setFinishByDate($finishByDate)
            ->setId($id)
            ->setInternalId($internalId)
            ->setIsMilestone($isMilestone)
            ->setIsSummaryTask($isSummaryTask)
            ->setLastModifiedDate($lastModifiedDate)
            ->setMessage($message)
            ->setNonBillableTask($nonBillableTask)
            ->setOwner($owner)
            ->setParent($parent)
            ->setPercentWorkComplete($percentWorkComplete)
            ->setPlannedWork($plannedWork)
            ->setPlannedWorkBaseline($plannedWorkBaseline)
            ->setPredecessor($predecessor)
            ->setPredecessorLagDays($predecessorLagDays)
            ->setPredecessors($predecessors)
            ->setPredecessorType($predecessorType)
            ->setPriority($priority)
            ->setRemainingWork($remainingWork)
            ->setStartDate($startDate)
            ->setStartDateBaseline($startDateBaseline)
            ->setStartDateVariance($startDateVariance)
            ->setStatus($status)
            ->setSuccessor($successor)
            ->setSuccessorType($successorType)
            ->setTitle($title)
            ->setCustomFieldList($customFieldList);
    }
    /**
     * Get actualWork value
     * @return \StructType\SearchColumnDoubleField[]|null
     */
    public function getActualWork()
    {
        return $this->actualWork;
    }
    /**
     * This method is responsible for validating the values passed to the setActualWork method
     * This method is willingly generated in order to preserve the one-line inline validation within the setActualWork method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateActualWorkForArrayConstraintsFromSetActualWork(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $projectTaskSearchRowBasicActualWorkItem) {
            // validation for constraint: itemType
            if (!$projectTaskSearchRowBasicActualWorkItem instanceof \StructType\SearchColumnDoubleField) {
                $invalidValues[] = is_object($projectTaskSearchRowBasicActualWorkItem) ? get_class($projectTaskSearchRowBasicActualWorkItem) : sprintf('%s(%s)', gettype($projectTaskSearchRowBasicActualWorkItem), var_export($projectTaskSearchRowBasicActualWorkItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The actualWork property can only contain items of type \StructType\SearchColumnDoubleField, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set actualWork value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnDoubleField[] $actualWork
     * @return \StructType\ProjectTaskSearchRowBasic
     */
    public function setActualWork(array $actualWork = array())
    {
        // validation for constraint: array
        if ('' !== ($actualWorkArrayErrorMessage = self::validateActualWorkForArrayConstraintsFromSetActualWork($actualWork))) {
            throw new \InvalidArgumentException($actualWorkArrayErrorMessage, __LINE__);
        }
        $this->actualWork = $actualWork;
        return $this;
    }
    /**
     * Add item to actualWork value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnDoubleField $item
     * @return \StructType\ProjectTaskSearchRowBasic
     */
    public function addToActualWork(\StructType\SearchColumnDoubleField $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SearchColumnDoubleField) {
            throw new \InvalidArgumentException(sprintf('The actualWork property can only contain items of type \StructType\SearchColumnDoubleField, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->actualWork[] = $item;
        return $this;
    }
    /**
     * Get company value
     * @return \StructType\SearchColumnSelectField[]|null
     */
    public function getCompany()
    {
        return $this->company;
    }
    /**
     * This method is responsible for validating the values passed to the setCompany method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCompany method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCompanyForArrayConstraintsFromSetCompany(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $projectTaskSearchRowBasicCompanyItem) {
            // validation for constraint: itemType
            if (!$projectTaskSearchRowBasicCompanyItem instanceof \StructType\SearchColumnSelectField) {
                $invalidValues[] = is_object($projectTaskSearchRowBasicCompanyItem) ? get_class($projectTaskSearchRowBasicCompanyItem) : sprintf('%s(%s)', gettype($projectTaskSearchRowBasicCompanyItem), var_export($projectTaskSearchRowBasicCompanyItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The company property can only contain items of type \StructType\SearchColumnSelectField, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set company value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnSelectField[] $company
     * @return \StructType\ProjectTaskSearchRowBasic
     */
    public function setCompany(array $company = array())
    {
        // validation for constraint: array
        if ('' !== ($companyArrayErrorMessage = self::validateCompanyForArrayConstraintsFromSetCompany($company))) {
            throw new \InvalidArgumentException($companyArrayErrorMessage, __LINE__);
        }
        $this->company = $company;
        return $this;
    }
    /**
     * Add item to company value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnSelectField $item
     * @return \StructType\ProjectTaskSearchRowBasic
     */
    public function addToCompany(\StructType\SearchColumnSelectField $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SearchColumnSelectField) {
            throw new \InvalidArgumentException(sprintf('The company property can only contain items of type \StructType\SearchColumnSelectField, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->company[] = $item;
        return $this;
    }
    /**
     * Get constraintType value
     * @return \StructType\SearchColumnEnumSelectField[]|null
     */
    public function getConstraintType()
    {
        return $this->constraintType;
    }
    /**
     * This method is responsible for validating the values passed to the setConstraintType method
     * This method is willingly generated in order to preserve the one-line inline validation within the setConstraintType method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateConstraintTypeForArrayConstraintsFromSetConstraintType(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $projectTaskSearchRowBasicConstraintTypeItem) {
            // validation for constraint: itemType
            if (!$projectTaskSearchRowBasicConstraintTypeItem instanceof \StructType\SearchColumnEnumSelectField) {
                $invalidValues[] = is_object($projectTaskSearchRowBasicConstraintTypeItem) ? get_class($projectTaskSearchRowBasicConstraintTypeItem) : sprintf('%s(%s)', gettype($projectTaskSearchRowBasicConstraintTypeItem), var_export($projectTaskSearchRowBasicConstraintTypeItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The constraintType property can only contain items of type \StructType\SearchColumnEnumSelectField, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set constraintType value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnEnumSelectField[] $constraintType
     * @return \StructType\ProjectTaskSearchRowBasic
     */
    public function setConstraintType(array $constraintType = array())
    {
        // validation for constraint: array
        if ('' !== ($constraintTypeArrayErrorMessage = self::validateConstraintTypeForArrayConstraintsFromSetConstraintType($constraintType))) {
            throw new \InvalidArgumentException($constraintTypeArrayErrorMessage, __LINE__);
        }
        $this->constraintType = $constraintType;
        return $this;
    }
    /**
     * Add item to constraintType value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnEnumSelectField $item
     * @return \StructType\ProjectTaskSearchRowBasic
     */
    public function addToConstraintType(\StructType\SearchColumnEnumSelectField $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SearchColumnEnumSelectField) {
            throw new \InvalidArgumentException(sprintf('The constraintType property can only contain items of type \StructType\SearchColumnEnumSelectField, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->constraintType[] = $item;
        return $this;
    }
    /**
     * Get contact value
     * @return \StructType\SearchColumnSelectField[]|null
     */
    public function getContact()
    {
        return $this->contact;
    }
    /**
     * This method is responsible for validating the values passed to the setContact method
     * This method is willingly generated in order to preserve the one-line inline validation within the setContact method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateContactForArrayConstraintsFromSetContact(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $projectTaskSearchRowBasicContactItem) {
            // validation for constraint: itemType
            if (!$projectTaskSearchRowBasicContactItem instanceof \StructType\SearchColumnSelectField) {
                $invalidValues[] = is_object($projectTaskSearchRowBasicContactItem) ? get_class($projectTaskSearchRowBasicContactItem) : sprintf('%s(%s)', gettype($projectTaskSearchRowBasicContactItem), var_export($projectTaskSearchRowBasicContactItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The contact property can only contain items of type \StructType\SearchColumnSelectField, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set contact value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnSelectField[] $contact
     * @return \StructType\ProjectTaskSearchRowBasic
     */
    public function setContact(array $contact = array())
    {
        // validation for constraint: array
        if ('' !== ($contactArrayErrorMessage = self::validateContactForArrayConstraintsFromSetContact($contact))) {
            throw new \InvalidArgumentException($contactArrayErrorMessage, __LINE__);
        }
        $this->contact = $contact;
        return $this;
    }
    /**
     * Add item to contact value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnSelectField $item
     * @return \StructType\ProjectTaskSearchRowBasic
     */
    public function addToContact(\StructType\SearchColumnSelectField $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SearchColumnSelectField) {
            throw new \InvalidArgumentException(sprintf('The contact property can only contain items of type \StructType\SearchColumnSelectField, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->contact[] = $item;
        return $this;
    }
    /**
     * Get cost value
     * @return \StructType\SearchColumnDoubleField[]|null
     */
    public function getCost()
    {
        return $this->cost;
    }
    /**
     * This method is responsible for validating the values passed to the setCost method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCost method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCostForArrayConstraintsFromSetCost(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $projectTaskSearchRowBasicCostItem) {
            // validation for constraint: itemType
            if (!$projectTaskSearchRowBasicCostItem instanceof \StructType\SearchColumnDoubleField) {
                $invalidValues[] = is_object($projectTaskSearchRowBasicCostItem) ? get_class($projectTaskSearchRowBasicCostItem) : sprintf('%s(%s)', gettype($projectTaskSearchRowBasicCostItem), var_export($projectTaskSearchRowBasicCostItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The cost property can only contain items of type \StructType\SearchColumnDoubleField, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set cost value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnDoubleField[] $cost
     * @return \StructType\ProjectTaskSearchRowBasic
     */
    public function setCost(array $cost = array())
    {
        // validation for constraint: array
        if ('' !== ($costArrayErrorMessage = self::validateCostForArrayConstraintsFromSetCost($cost))) {
            throw new \InvalidArgumentException($costArrayErrorMessage, __LINE__);
        }
        $this->cost = $cost;
        return $this;
    }
    /**
     * Add item to cost value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnDoubleField $item
     * @return \StructType\ProjectTaskSearchRowBasic
     */
    public function addToCost(\StructType\SearchColumnDoubleField $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SearchColumnDoubleField) {
            throw new \InvalidArgumentException(sprintf('The cost property can only contain items of type \StructType\SearchColumnDoubleField, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->cost[] = $item;
        return $this;
    }
    /**
     * Get costBase value
     * @return \StructType\SearchColumnDoubleField[]|null
     */
    public function getCostBase()
    {
        return $this->costBase;
    }
    /**
     * This method is responsible for validating the values passed to the setCostBase method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCostBase method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCostBaseForArrayConstraintsFromSetCostBase(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $projectTaskSearchRowBasicCostBaseItem) {
            // validation for constraint: itemType
            if (!$projectTaskSearchRowBasicCostBaseItem instanceof \StructType\SearchColumnDoubleField) {
                $invalidValues[] = is_object($projectTaskSearchRowBasicCostBaseItem) ? get_class($projectTaskSearchRowBasicCostBaseItem) : sprintf('%s(%s)', gettype($projectTaskSearchRowBasicCostBaseItem), var_export($projectTaskSearchRowBasicCostBaseItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The costBase property can only contain items of type \StructType\SearchColumnDoubleField, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set costBase value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnDoubleField[] $costBase
     * @return \StructType\ProjectTaskSearchRowBasic
     */
    public function setCostBase(array $costBase = array())
    {
        // validation for constraint: array
        if ('' !== ($costBaseArrayErrorMessage = self::validateCostBaseForArrayConstraintsFromSetCostBase($costBase))) {
            throw new \InvalidArgumentException($costBaseArrayErrorMessage, __LINE__);
        }
        $this->costBase = $costBase;
        return $this;
    }
    /**
     * Add item to costBase value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnDoubleField $item
     * @return \StructType\ProjectTaskSearchRowBasic
     */
    public function addToCostBase(\StructType\SearchColumnDoubleField $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SearchColumnDoubleField) {
            throw new \InvalidArgumentException(sprintf('The costBase property can only contain items of type \StructType\SearchColumnDoubleField, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->costBase[] = $item;
        return $this;
    }
    /**
     * Get costBaseBaseline value
     * @return \StructType\SearchColumnDoubleField[]|null
     */
    public function getCostBaseBaseline()
    {
        return $this->costBaseBaseline;
    }
    /**
     * This method is responsible for validating the values passed to the setCostBaseBaseline method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCostBaseBaseline method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCostBaseBaselineForArrayConstraintsFromSetCostBaseBaseline(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $projectTaskSearchRowBasicCostBaseBaselineItem) {
            // validation for constraint: itemType
            if (!$projectTaskSearchRowBasicCostBaseBaselineItem instanceof \StructType\SearchColumnDoubleField) {
                $invalidValues[] = is_object($projectTaskSearchRowBasicCostBaseBaselineItem) ? get_class($projectTaskSearchRowBasicCostBaseBaselineItem) : sprintf('%s(%s)', gettype($projectTaskSearchRowBasicCostBaseBaselineItem), var_export($projectTaskSearchRowBasicCostBaseBaselineItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The costBaseBaseline property can only contain items of type \StructType\SearchColumnDoubleField, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set costBaseBaseline value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnDoubleField[] $costBaseBaseline
     * @return \StructType\ProjectTaskSearchRowBasic
     */
    public function setCostBaseBaseline(array $costBaseBaseline = array())
    {
        // validation for constraint: array
        if ('' !== ($costBaseBaselineArrayErrorMessage = self::validateCostBaseBaselineForArrayConstraintsFromSetCostBaseBaseline($costBaseBaseline))) {
            throw new \InvalidArgumentException($costBaseBaselineArrayErrorMessage, __LINE__);
        }
        $this->costBaseBaseline = $costBaseBaseline;
        return $this;
    }
    /**
     * Add item to costBaseBaseline value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnDoubleField $item
     * @return \StructType\ProjectTaskSearchRowBasic
     */
    public function addToCostBaseBaseline(\StructType\SearchColumnDoubleField $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SearchColumnDoubleField) {
            throw new \InvalidArgumentException(sprintf('The costBaseBaseline property can only contain items of type \StructType\SearchColumnDoubleField, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->costBaseBaseline[] = $item;
        return $this;
    }
    /**
     * Get costBaseline value
     * @return \StructType\SearchColumnDoubleField[]|null
     */
    public function getCostBaseline()
    {
        return $this->costBaseline;
    }
    /**
     * This method is responsible for validating the values passed to the setCostBaseline method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCostBaseline method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCostBaselineForArrayConstraintsFromSetCostBaseline(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $projectTaskSearchRowBasicCostBaselineItem) {
            // validation for constraint: itemType
            if (!$projectTaskSearchRowBasicCostBaselineItem instanceof \StructType\SearchColumnDoubleField) {
                $invalidValues[] = is_object($projectTaskSearchRowBasicCostBaselineItem) ? get_class($projectTaskSearchRowBasicCostBaselineItem) : sprintf('%s(%s)', gettype($projectTaskSearchRowBasicCostBaselineItem), var_export($projectTaskSearchRowBasicCostBaselineItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The costBaseline property can only contain items of type \StructType\SearchColumnDoubleField, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set costBaseline value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnDoubleField[] $costBaseline
     * @return \StructType\ProjectTaskSearchRowBasic
     */
    public function setCostBaseline(array $costBaseline = array())
    {
        // validation for constraint: array
        if ('' !== ($costBaselineArrayErrorMessage = self::validateCostBaselineForArrayConstraintsFromSetCostBaseline($costBaseline))) {
            throw new \InvalidArgumentException($costBaselineArrayErrorMessage, __LINE__);
        }
        $this->costBaseline = $costBaseline;
        return $this;
    }
    /**
     * Add item to costBaseline value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnDoubleField $item
     * @return \StructType\ProjectTaskSearchRowBasic
     */
    public function addToCostBaseline(\StructType\SearchColumnDoubleField $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SearchColumnDoubleField) {
            throw new \InvalidArgumentException(sprintf('The costBaseline property can only contain items of type \StructType\SearchColumnDoubleField, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->costBaseline[] = $item;
        return $this;
    }
    /**
     * Get costBaseVariance value
     * @return \StructType\SearchColumnDoubleField[]|null
     */
    public function getCostBaseVariance()
    {
        return $this->costBaseVariance;
    }
    /**
     * This method is responsible for validating the values passed to the setCostBaseVariance method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCostBaseVariance method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCostBaseVarianceForArrayConstraintsFromSetCostBaseVariance(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $projectTaskSearchRowBasicCostBaseVarianceItem) {
            // validation for constraint: itemType
            if (!$projectTaskSearchRowBasicCostBaseVarianceItem instanceof \StructType\SearchColumnDoubleField) {
                $invalidValues[] = is_object($projectTaskSearchRowBasicCostBaseVarianceItem) ? get_class($projectTaskSearchRowBasicCostBaseVarianceItem) : sprintf('%s(%s)', gettype($projectTaskSearchRowBasicCostBaseVarianceItem), var_export($projectTaskSearchRowBasicCostBaseVarianceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The costBaseVariance property can only contain items of type \StructType\SearchColumnDoubleField, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set costBaseVariance value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnDoubleField[] $costBaseVariance
     * @return \StructType\ProjectTaskSearchRowBasic
     */
    public function setCostBaseVariance(array $costBaseVariance = array())
    {
        // validation for constraint: array
        if ('' !== ($costBaseVarianceArrayErrorMessage = self::validateCostBaseVarianceForArrayConstraintsFromSetCostBaseVariance($costBaseVariance))) {
            throw new \InvalidArgumentException($costBaseVarianceArrayErrorMessage, __LINE__);
        }
        $this->costBaseVariance = $costBaseVariance;
        return $this;
    }
    /**
     * Add item to costBaseVariance value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnDoubleField $item
     * @return \StructType\ProjectTaskSearchRowBasic
     */
    public function addToCostBaseVariance(\StructType\SearchColumnDoubleField $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SearchColumnDoubleField) {
            throw new \InvalidArgumentException(sprintf('The costBaseVariance property can only contain items of type \StructType\SearchColumnDoubleField, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->costBaseVariance[] = $item;
        return $this;
    }
    /**
     * Get costVariance value
     * @return \StructType\SearchColumnDoubleField[]|null
     */
    public function getCostVariance()
    {
        return $this->costVariance;
    }
    /**
     * This method is responsible for validating the values passed to the setCostVariance method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCostVariance method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCostVarianceForArrayConstraintsFromSetCostVariance(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $projectTaskSearchRowBasicCostVarianceItem) {
            // validation for constraint: itemType
            if (!$projectTaskSearchRowBasicCostVarianceItem instanceof \StructType\SearchColumnDoubleField) {
                $invalidValues[] = is_object($projectTaskSearchRowBasicCostVarianceItem) ? get_class($projectTaskSearchRowBasicCostVarianceItem) : sprintf('%s(%s)', gettype($projectTaskSearchRowBasicCostVarianceItem), var_export($projectTaskSearchRowBasicCostVarianceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The costVariance property can only contain items of type \StructType\SearchColumnDoubleField, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set costVariance value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnDoubleField[] $costVariance
     * @return \StructType\ProjectTaskSearchRowBasic
     */
    public function setCostVariance(array $costVariance = array())
    {
        // validation for constraint: array
        if ('' !== ($costVarianceArrayErrorMessage = self::validateCostVarianceForArrayConstraintsFromSetCostVariance($costVariance))) {
            throw new \InvalidArgumentException($costVarianceArrayErrorMessage, __LINE__);
        }
        $this->costVariance = $costVariance;
        return $this;
    }
    /**
     * Add item to costVariance value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnDoubleField $item
     * @return \StructType\ProjectTaskSearchRowBasic
     */
    public function addToCostVariance(\StructType\SearchColumnDoubleField $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SearchColumnDoubleField) {
            throw new \InvalidArgumentException(sprintf('The costVariance property can only contain items of type \StructType\SearchColumnDoubleField, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->costVariance[] = $item;
        return $this;
    }
    /**
     * Get costVariancePercent value
     * @return \StructType\SearchColumnDoubleField[]|null
     */
    public function getCostVariancePercent()
    {
        return $this->costVariancePercent;
    }
    /**
     * This method is responsible for validating the values passed to the setCostVariancePercent method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCostVariancePercent method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCostVariancePercentForArrayConstraintsFromSetCostVariancePercent(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $projectTaskSearchRowBasicCostVariancePercentItem) {
            // validation for constraint: itemType
            if (!$projectTaskSearchRowBasicCostVariancePercentItem instanceof \StructType\SearchColumnDoubleField) {
                $invalidValues[] = is_object($projectTaskSearchRowBasicCostVariancePercentItem) ? get_class($projectTaskSearchRowBasicCostVariancePercentItem) : sprintf('%s(%s)', gettype($projectTaskSearchRowBasicCostVariancePercentItem), var_export($projectTaskSearchRowBasicCostVariancePercentItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The costVariancePercent property can only contain items of type \StructType\SearchColumnDoubleField, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set costVariancePercent value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnDoubleField[] $costVariancePercent
     * @return \StructType\ProjectTaskSearchRowBasic
     */
    public function setCostVariancePercent(array $costVariancePercent = array())
    {
        // validation for constraint: array
        if ('' !== ($costVariancePercentArrayErrorMessage = self::validateCostVariancePercentForArrayConstraintsFromSetCostVariancePercent($costVariancePercent))) {
            throw new \InvalidArgumentException($costVariancePercentArrayErrorMessage, __LINE__);
        }
        $this->costVariancePercent = $costVariancePercent;
        return $this;
    }
    /**
     * Add item to costVariancePercent value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnDoubleField $item
     * @return \StructType\ProjectTaskSearchRowBasic
     */
    public function addToCostVariancePercent(\StructType\SearchColumnDoubleField $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SearchColumnDoubleField) {
            throw new \InvalidArgumentException(sprintf('The costVariancePercent property can only contain items of type \StructType\SearchColumnDoubleField, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->costVariancePercent[] = $item;
        return $this;
    }
    /**
     * Get createdDate value
     * @return \StructType\SearchColumnDateField[]|null
     */
    public function getCreatedDate()
    {
        return $this->createdDate;
    }
    /**
     * This method is responsible for validating the values passed to the setCreatedDate method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCreatedDate method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCreatedDateForArrayConstraintsFromSetCreatedDate(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $projectTaskSearchRowBasicCreatedDateItem) {
            // validation for constraint: itemType
            if (!$projectTaskSearchRowBasicCreatedDateItem instanceof \StructType\SearchColumnDateField) {
                $invalidValues[] = is_object($projectTaskSearchRowBasicCreatedDateItem) ? get_class($projectTaskSearchRowBasicCreatedDateItem) : sprintf('%s(%s)', gettype($projectTaskSearchRowBasicCreatedDateItem), var_export($projectTaskSearchRowBasicCreatedDateItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The createdDate property can only contain items of type \StructType\SearchColumnDateField, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set createdDate value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnDateField[] $createdDate
     * @return \StructType\ProjectTaskSearchRowBasic
     */
    public function setCreatedDate(array $createdDate = array())
    {
        // validation for constraint: array
        if ('' !== ($createdDateArrayErrorMessage = self::validateCreatedDateForArrayConstraintsFromSetCreatedDate($createdDate))) {
            throw new \InvalidArgumentException($createdDateArrayErrorMessage, __LINE__);
        }
        $this->createdDate = $createdDate;
        return $this;
    }
    /**
     * Add item to createdDate value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnDateField $item
     * @return \StructType\ProjectTaskSearchRowBasic
     */
    public function addToCreatedDate(\StructType\SearchColumnDateField $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SearchColumnDateField) {
            throw new \InvalidArgumentException(sprintf('The createdDate property can only contain items of type \StructType\SearchColumnDateField, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->createdDate[] = $item;
        return $this;
    }
    /**
     * Get endDate value
     * @return \StructType\SearchColumnDateField[]|null
     */
    public function getEndDate()
    {
        return $this->endDate;
    }
    /**
     * This method is responsible for validating the values passed to the setEndDate method
     * This method is willingly generated in order to preserve the one-line inline validation within the setEndDate method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateEndDateForArrayConstraintsFromSetEndDate(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $projectTaskSearchRowBasicEndDateItem) {
            // validation for constraint: itemType
            if (!$projectTaskSearchRowBasicEndDateItem instanceof \StructType\SearchColumnDateField) {
                $invalidValues[] = is_object($projectTaskSearchRowBasicEndDateItem) ? get_class($projectTaskSearchRowBasicEndDateItem) : sprintf('%s(%s)', gettype($projectTaskSearchRowBasicEndDateItem), var_export($projectTaskSearchRowBasicEndDateItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The endDate property can only contain items of type \StructType\SearchColumnDateField, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set endDate value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnDateField[] $endDate
     * @return \StructType\ProjectTaskSearchRowBasic
     */
    public function setEndDate(array $endDate = array())
    {
        // validation for constraint: array
        if ('' !== ($endDateArrayErrorMessage = self::validateEndDateForArrayConstraintsFromSetEndDate($endDate))) {
            throw new \InvalidArgumentException($endDateArrayErrorMessage, __LINE__);
        }
        $this->endDate = $endDate;
        return $this;
    }
    /**
     * Add item to endDate value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnDateField $item
     * @return \StructType\ProjectTaskSearchRowBasic
     */
    public function addToEndDate(\StructType\SearchColumnDateField $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SearchColumnDateField) {
            throw new \InvalidArgumentException(sprintf('The endDate property can only contain items of type \StructType\SearchColumnDateField, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->endDate[] = $item;
        return $this;
    }
    /**
     * Get endDateBaseline value
     * @return \StructType\SearchColumnDateField[]|null
     */
    public function getEndDateBaseline()
    {
        return $this->endDateBaseline;
    }
    /**
     * This method is responsible for validating the values passed to the setEndDateBaseline method
     * This method is willingly generated in order to preserve the one-line inline validation within the setEndDateBaseline method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateEndDateBaselineForArrayConstraintsFromSetEndDateBaseline(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $projectTaskSearchRowBasicEndDateBaselineItem) {
            // validation for constraint: itemType
            if (!$projectTaskSearchRowBasicEndDateBaselineItem instanceof \StructType\SearchColumnDateField) {
                $invalidValues[] = is_object($projectTaskSearchRowBasicEndDateBaselineItem) ? get_class($projectTaskSearchRowBasicEndDateBaselineItem) : sprintf('%s(%s)', gettype($projectTaskSearchRowBasicEndDateBaselineItem), var_export($projectTaskSearchRowBasicEndDateBaselineItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The endDateBaseline property can only contain items of type \StructType\SearchColumnDateField, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set endDateBaseline value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnDateField[] $endDateBaseline
     * @return \StructType\ProjectTaskSearchRowBasic
     */
    public function setEndDateBaseline(array $endDateBaseline = array())
    {
        // validation for constraint: array
        if ('' !== ($endDateBaselineArrayErrorMessage = self::validateEndDateBaselineForArrayConstraintsFromSetEndDateBaseline($endDateBaseline))) {
            throw new \InvalidArgumentException($endDateBaselineArrayErrorMessage, __LINE__);
        }
        $this->endDateBaseline = $endDateBaseline;
        return $this;
    }
    /**
     * Add item to endDateBaseline value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnDateField $item
     * @return \StructType\ProjectTaskSearchRowBasic
     */
    public function addToEndDateBaseline(\StructType\SearchColumnDateField $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SearchColumnDateField) {
            throw new \InvalidArgumentException(sprintf('The endDateBaseline property can only contain items of type \StructType\SearchColumnDateField, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->endDateBaseline[] = $item;
        return $this;
    }
    /**
     * Get endDateVariance value
     * @return \StructType\SearchColumnDoubleField[]|null
     */
    public function getEndDateVariance()
    {
        return $this->endDateVariance;
    }
    /**
     * This method is responsible for validating the values passed to the setEndDateVariance method
     * This method is willingly generated in order to preserve the one-line inline validation within the setEndDateVariance method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateEndDateVarianceForArrayConstraintsFromSetEndDateVariance(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $projectTaskSearchRowBasicEndDateVarianceItem) {
            // validation for constraint: itemType
            if (!$projectTaskSearchRowBasicEndDateVarianceItem instanceof \StructType\SearchColumnDoubleField) {
                $invalidValues[] = is_object($projectTaskSearchRowBasicEndDateVarianceItem) ? get_class($projectTaskSearchRowBasicEndDateVarianceItem) : sprintf('%s(%s)', gettype($projectTaskSearchRowBasicEndDateVarianceItem), var_export($projectTaskSearchRowBasicEndDateVarianceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The endDateVariance property can only contain items of type \StructType\SearchColumnDoubleField, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set endDateVariance value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnDoubleField[] $endDateVariance
     * @return \StructType\ProjectTaskSearchRowBasic
     */
    public function setEndDateVariance(array $endDateVariance = array())
    {
        // validation for constraint: array
        if ('' !== ($endDateVarianceArrayErrorMessage = self::validateEndDateVarianceForArrayConstraintsFromSetEndDateVariance($endDateVariance))) {
            throw new \InvalidArgumentException($endDateVarianceArrayErrorMessage, __LINE__);
        }
        $this->endDateVariance = $endDateVariance;
        return $this;
    }
    /**
     * Add item to endDateVariance value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnDoubleField $item
     * @return \StructType\ProjectTaskSearchRowBasic
     */
    public function addToEndDateVariance(\StructType\SearchColumnDoubleField $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SearchColumnDoubleField) {
            throw new \InvalidArgumentException(sprintf('The endDateVariance property can only contain items of type \StructType\SearchColumnDoubleField, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->endDateVariance[] = $item;
        return $this;
    }
    /**
     * Get estimatedWork value
     * @return \StructType\SearchColumnDoubleField[]|null
     */
    public function getEstimatedWork()
    {
        return $this->estimatedWork;
    }
    /**
     * This method is responsible for validating the values passed to the setEstimatedWork method
     * This method is willingly generated in order to preserve the one-line inline validation within the setEstimatedWork method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateEstimatedWorkForArrayConstraintsFromSetEstimatedWork(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $projectTaskSearchRowBasicEstimatedWorkItem) {
            // validation for constraint: itemType
            if (!$projectTaskSearchRowBasicEstimatedWorkItem instanceof \StructType\SearchColumnDoubleField) {
                $invalidValues[] = is_object($projectTaskSearchRowBasicEstimatedWorkItem) ? get_class($projectTaskSearchRowBasicEstimatedWorkItem) : sprintf('%s(%s)', gettype($projectTaskSearchRowBasicEstimatedWorkItem), var_export($projectTaskSearchRowBasicEstimatedWorkItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The estimatedWork property can only contain items of type \StructType\SearchColumnDoubleField, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set estimatedWork value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnDoubleField[] $estimatedWork
     * @return \StructType\ProjectTaskSearchRowBasic
     */
    public function setEstimatedWork(array $estimatedWork = array())
    {
        // validation for constraint: array
        if ('' !== ($estimatedWorkArrayErrorMessage = self::validateEstimatedWorkForArrayConstraintsFromSetEstimatedWork($estimatedWork))) {
            throw new \InvalidArgumentException($estimatedWorkArrayErrorMessage, __LINE__);
        }
        $this->estimatedWork = $estimatedWork;
        return $this;
    }
    /**
     * Add item to estimatedWork value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnDoubleField $item
     * @return \StructType\ProjectTaskSearchRowBasic
     */
    public function addToEstimatedWork(\StructType\SearchColumnDoubleField $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SearchColumnDoubleField) {
            throw new \InvalidArgumentException(sprintf('The estimatedWork property can only contain items of type \StructType\SearchColumnDoubleField, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->estimatedWork[] = $item;
        return $this;
    }
    /**
     * Get estimatedWorkBaseline value
     * @return \StructType\SearchColumnDoubleField[]|null
     */
    public function getEstimatedWorkBaseline()
    {
        return $this->estimatedWorkBaseline;
    }
    /**
     * This method is responsible for validating the values passed to the setEstimatedWorkBaseline method
     * This method is willingly generated in order to preserve the one-line inline validation within the setEstimatedWorkBaseline method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateEstimatedWorkBaselineForArrayConstraintsFromSetEstimatedWorkBaseline(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $projectTaskSearchRowBasicEstimatedWorkBaselineItem) {
            // validation for constraint: itemType
            if (!$projectTaskSearchRowBasicEstimatedWorkBaselineItem instanceof \StructType\SearchColumnDoubleField) {
                $invalidValues[] = is_object($projectTaskSearchRowBasicEstimatedWorkBaselineItem) ? get_class($projectTaskSearchRowBasicEstimatedWorkBaselineItem) : sprintf('%s(%s)', gettype($projectTaskSearchRowBasicEstimatedWorkBaselineItem), var_export($projectTaskSearchRowBasicEstimatedWorkBaselineItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The estimatedWorkBaseline property can only contain items of type \StructType\SearchColumnDoubleField, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set estimatedWorkBaseline value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnDoubleField[] $estimatedWorkBaseline
     * @return \StructType\ProjectTaskSearchRowBasic
     */
    public function setEstimatedWorkBaseline(array $estimatedWorkBaseline = array())
    {
        // validation for constraint: array
        if ('' !== ($estimatedWorkBaselineArrayErrorMessage = self::validateEstimatedWorkBaselineForArrayConstraintsFromSetEstimatedWorkBaseline($estimatedWorkBaseline))) {
            throw new \InvalidArgumentException($estimatedWorkBaselineArrayErrorMessage, __LINE__);
        }
        $this->estimatedWorkBaseline = $estimatedWorkBaseline;
        return $this;
    }
    /**
     * Add item to estimatedWorkBaseline value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnDoubleField $item
     * @return \StructType\ProjectTaskSearchRowBasic
     */
    public function addToEstimatedWorkBaseline(\StructType\SearchColumnDoubleField $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SearchColumnDoubleField) {
            throw new \InvalidArgumentException(sprintf('The estimatedWorkBaseline property can only contain items of type \StructType\SearchColumnDoubleField, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->estimatedWorkBaseline[] = $item;
        return $this;
    }
    /**
     * Get estimatedWorkVariance value
     * @return \StructType\SearchColumnDoubleField[]|null
     */
    public function getEstimatedWorkVariance()
    {
        return $this->estimatedWorkVariance;
    }
    /**
     * This method is responsible for validating the values passed to the setEstimatedWorkVariance method
     * This method is willingly generated in order to preserve the one-line inline validation within the setEstimatedWorkVariance method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateEstimatedWorkVarianceForArrayConstraintsFromSetEstimatedWorkVariance(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $projectTaskSearchRowBasicEstimatedWorkVarianceItem) {
            // validation for constraint: itemType
            if (!$projectTaskSearchRowBasicEstimatedWorkVarianceItem instanceof \StructType\SearchColumnDoubleField) {
                $invalidValues[] = is_object($projectTaskSearchRowBasicEstimatedWorkVarianceItem) ? get_class($projectTaskSearchRowBasicEstimatedWorkVarianceItem) : sprintf('%s(%s)', gettype($projectTaskSearchRowBasicEstimatedWorkVarianceItem), var_export($projectTaskSearchRowBasicEstimatedWorkVarianceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The estimatedWorkVariance property can only contain items of type \StructType\SearchColumnDoubleField, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set estimatedWorkVariance value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnDoubleField[] $estimatedWorkVariance
     * @return \StructType\ProjectTaskSearchRowBasic
     */
    public function setEstimatedWorkVariance(array $estimatedWorkVariance = array())
    {
        // validation for constraint: array
        if ('' !== ($estimatedWorkVarianceArrayErrorMessage = self::validateEstimatedWorkVarianceForArrayConstraintsFromSetEstimatedWorkVariance($estimatedWorkVariance))) {
            throw new \InvalidArgumentException($estimatedWorkVarianceArrayErrorMessage, __LINE__);
        }
        $this->estimatedWorkVariance = $estimatedWorkVariance;
        return $this;
    }
    /**
     * Add item to estimatedWorkVariance value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnDoubleField $item
     * @return \StructType\ProjectTaskSearchRowBasic
     */
    public function addToEstimatedWorkVariance(\StructType\SearchColumnDoubleField $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SearchColumnDoubleField) {
            throw new \InvalidArgumentException(sprintf('The estimatedWorkVariance property can only contain items of type \StructType\SearchColumnDoubleField, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->estimatedWorkVariance[] = $item;
        return $this;
    }
    /**
     * Get estimatedWorkVariancePercent value
     * @return \StructType\SearchColumnDoubleField[]|null
     */
    public function getEstimatedWorkVariancePercent()
    {
        return $this->estimatedWorkVariancePercent;
    }
    /**
     * This method is responsible for validating the values passed to the setEstimatedWorkVariancePercent method
     * This method is willingly generated in order to preserve the one-line inline validation within the setEstimatedWorkVariancePercent method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateEstimatedWorkVariancePercentForArrayConstraintsFromSetEstimatedWorkVariancePercent(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $projectTaskSearchRowBasicEstimatedWorkVariancePercentItem) {
            // validation for constraint: itemType
            if (!$projectTaskSearchRowBasicEstimatedWorkVariancePercentItem instanceof \StructType\SearchColumnDoubleField) {
                $invalidValues[] = is_object($projectTaskSearchRowBasicEstimatedWorkVariancePercentItem) ? get_class($projectTaskSearchRowBasicEstimatedWorkVariancePercentItem) : sprintf('%s(%s)', gettype($projectTaskSearchRowBasicEstimatedWorkVariancePercentItem), var_export($projectTaskSearchRowBasicEstimatedWorkVariancePercentItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The estimatedWorkVariancePercent property can only contain items of type \StructType\SearchColumnDoubleField, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set estimatedWorkVariancePercent value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnDoubleField[] $estimatedWorkVariancePercent
     * @return \StructType\ProjectTaskSearchRowBasic
     */
    public function setEstimatedWorkVariancePercent(array $estimatedWorkVariancePercent = array())
    {
        // validation for constraint: array
        if ('' !== ($estimatedWorkVariancePercentArrayErrorMessage = self::validateEstimatedWorkVariancePercentForArrayConstraintsFromSetEstimatedWorkVariancePercent($estimatedWorkVariancePercent))) {
            throw new \InvalidArgumentException($estimatedWorkVariancePercentArrayErrorMessage, __LINE__);
        }
        $this->estimatedWorkVariancePercent = $estimatedWorkVariancePercent;
        return $this;
    }
    /**
     * Add item to estimatedWorkVariancePercent value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnDoubleField $item
     * @return \StructType\ProjectTaskSearchRowBasic
     */
    public function addToEstimatedWorkVariancePercent(\StructType\SearchColumnDoubleField $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SearchColumnDoubleField) {
            throw new \InvalidArgumentException(sprintf('The estimatedWorkVariancePercent property can only contain items of type \StructType\SearchColumnDoubleField, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->estimatedWorkVariancePercent[] = $item;
        return $this;
    }
    /**
     * Get externalId value
     * @return \StructType\SearchColumnSelectField[]|null
     */
    public function getExternalId()
    {
        return $this->externalId;
    }
    /**
     * This method is responsible for validating the values passed to the setExternalId method
     * This method is willingly generated in order to preserve the one-line inline validation within the setExternalId method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateExternalIdForArrayConstraintsFromSetExternalId(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $projectTaskSearchRowBasicExternalIdItem) {
            // validation for constraint: itemType
            if (!$projectTaskSearchRowBasicExternalIdItem instanceof \StructType\SearchColumnSelectField) {
                $invalidValues[] = is_object($projectTaskSearchRowBasicExternalIdItem) ? get_class($projectTaskSearchRowBasicExternalIdItem) : sprintf('%s(%s)', gettype($projectTaskSearchRowBasicExternalIdItem), var_export($projectTaskSearchRowBasicExternalIdItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The externalId property can only contain items of type \StructType\SearchColumnSelectField, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set externalId value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnSelectField[] $externalId
     * @return \StructType\ProjectTaskSearchRowBasic
     */
    public function setExternalId(array $externalId = array())
    {
        // validation for constraint: array
        if ('' !== ($externalIdArrayErrorMessage = self::validateExternalIdForArrayConstraintsFromSetExternalId($externalId))) {
            throw new \InvalidArgumentException($externalIdArrayErrorMessage, __LINE__);
        }
        $this->externalId = $externalId;
        return $this;
    }
    /**
     * Add item to externalId value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnSelectField $item
     * @return \StructType\ProjectTaskSearchRowBasic
     */
    public function addToExternalId(\StructType\SearchColumnSelectField $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SearchColumnSelectField) {
            throw new \InvalidArgumentException(sprintf('The externalId property can only contain items of type \StructType\SearchColumnSelectField, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->externalId[] = $item;
        return $this;
    }
    /**
     * Get finishByDate value
     * @return \StructType\SearchColumnDateField[]|null
     */
    public function getFinishByDate()
    {
        return $this->finishByDate;
    }
    /**
     * This method is responsible for validating the values passed to the setFinishByDate method
     * This method is willingly generated in order to preserve the one-line inline validation within the setFinishByDate method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateFinishByDateForArrayConstraintsFromSetFinishByDate(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $projectTaskSearchRowBasicFinishByDateItem) {
            // validation for constraint: itemType
            if (!$projectTaskSearchRowBasicFinishByDateItem instanceof \StructType\SearchColumnDateField) {
                $invalidValues[] = is_object($projectTaskSearchRowBasicFinishByDateItem) ? get_class($projectTaskSearchRowBasicFinishByDateItem) : sprintf('%s(%s)', gettype($projectTaskSearchRowBasicFinishByDateItem), var_export($projectTaskSearchRowBasicFinishByDateItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The finishByDate property can only contain items of type \StructType\SearchColumnDateField, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set finishByDate value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnDateField[] $finishByDate
     * @return \StructType\ProjectTaskSearchRowBasic
     */
    public function setFinishByDate(array $finishByDate = array())
    {
        // validation for constraint: array
        if ('' !== ($finishByDateArrayErrorMessage = self::validateFinishByDateForArrayConstraintsFromSetFinishByDate($finishByDate))) {
            throw new \InvalidArgumentException($finishByDateArrayErrorMessage, __LINE__);
        }
        $this->finishByDate = $finishByDate;
        return $this;
    }
    /**
     * Add item to finishByDate value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnDateField $item
     * @return \StructType\ProjectTaskSearchRowBasic
     */
    public function addToFinishByDate(\StructType\SearchColumnDateField $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SearchColumnDateField) {
            throw new \InvalidArgumentException(sprintf('The finishByDate property can only contain items of type \StructType\SearchColumnDateField, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->finishByDate[] = $item;
        return $this;
    }
    /**
     * Get id value
     * @return \StructType\SearchColumnLongField[]|null
     */
    public function getId()
    {
        return $this->id;
    }
    /**
     * This method is responsible for validating the values passed to the setId method
     * This method is willingly generated in order to preserve the one-line inline validation within the setId method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateIdForArrayConstraintsFromSetId(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $projectTaskSearchRowBasicIdItem) {
            // validation for constraint: itemType
            if (!$projectTaskSearchRowBasicIdItem instanceof \StructType\SearchColumnLongField) {
                $invalidValues[] = is_object($projectTaskSearchRowBasicIdItem) ? get_class($projectTaskSearchRowBasicIdItem) : sprintf('%s(%s)', gettype($projectTaskSearchRowBasicIdItem), var_export($projectTaskSearchRowBasicIdItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The id property can only contain items of type \StructType\SearchColumnLongField, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set id value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnLongField[] $id
     * @return \StructType\ProjectTaskSearchRowBasic
     */
    public function setId(array $id = array())
    {
        // validation for constraint: array
        if ('' !== ($idArrayErrorMessage = self::validateIdForArrayConstraintsFromSetId($id))) {
            throw new \InvalidArgumentException($idArrayErrorMessage, __LINE__);
        }
        $this->id = $id;
        return $this;
    }
    /**
     * Add item to id value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnLongField $item
     * @return \StructType\ProjectTaskSearchRowBasic
     */
    public function addToId(\StructType\SearchColumnLongField $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SearchColumnLongField) {
            throw new \InvalidArgumentException(sprintf('The id property can only contain items of type \StructType\SearchColumnLongField, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->id[] = $item;
        return $this;
    }
    /**
     * Get internalId value
     * @return \StructType\SearchColumnSelectField[]|null
     */
    public function getInternalId()
    {
        return $this->internalId;
    }
    /**
     * This method is responsible for validating the values passed to the setInternalId method
     * This method is willingly generated in order to preserve the one-line inline validation within the setInternalId method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateInternalIdForArrayConstraintsFromSetInternalId(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $projectTaskSearchRowBasicInternalIdItem) {
            // validation for constraint: itemType
            if (!$projectTaskSearchRowBasicInternalIdItem instanceof \StructType\SearchColumnSelectField) {
                $invalidValues[] = is_object($projectTaskSearchRowBasicInternalIdItem) ? get_class($projectTaskSearchRowBasicInternalIdItem) : sprintf('%s(%s)', gettype($projectTaskSearchRowBasicInternalIdItem), var_export($projectTaskSearchRowBasicInternalIdItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The internalId property can only contain items of type \StructType\SearchColumnSelectField, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set internalId value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnSelectField[] $internalId
     * @return \StructType\ProjectTaskSearchRowBasic
     */
    public function setInternalId(array $internalId = array())
    {
        // validation for constraint: array
        if ('' !== ($internalIdArrayErrorMessage = self::validateInternalIdForArrayConstraintsFromSetInternalId($internalId))) {
            throw new \InvalidArgumentException($internalIdArrayErrorMessage, __LINE__);
        }
        $this->internalId = $internalId;
        return $this;
    }
    /**
     * Add item to internalId value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnSelectField $item
     * @return \StructType\ProjectTaskSearchRowBasic
     */
    public function addToInternalId(\StructType\SearchColumnSelectField $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SearchColumnSelectField) {
            throw new \InvalidArgumentException(sprintf('The internalId property can only contain items of type \StructType\SearchColumnSelectField, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->internalId[] = $item;
        return $this;
    }
    /**
     * Get isMilestone value
     * @return \StructType\SearchColumnBooleanField[]|null
     */
    public function getIsMilestone()
    {
        return $this->isMilestone;
    }
    /**
     * This method is responsible for validating the values passed to the setIsMilestone method
     * This method is willingly generated in order to preserve the one-line inline validation within the setIsMilestone method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateIsMilestoneForArrayConstraintsFromSetIsMilestone(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $projectTaskSearchRowBasicIsMilestoneItem) {
            // validation for constraint: itemType
            if (!$projectTaskSearchRowBasicIsMilestoneItem instanceof \StructType\SearchColumnBooleanField) {
                $invalidValues[] = is_object($projectTaskSearchRowBasicIsMilestoneItem) ? get_class($projectTaskSearchRowBasicIsMilestoneItem) : sprintf('%s(%s)', gettype($projectTaskSearchRowBasicIsMilestoneItem), var_export($projectTaskSearchRowBasicIsMilestoneItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The isMilestone property can only contain items of type \StructType\SearchColumnBooleanField, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set isMilestone value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnBooleanField[] $isMilestone
     * @return \StructType\ProjectTaskSearchRowBasic
     */
    public function setIsMilestone(array $isMilestone = array())
    {
        // validation for constraint: array
        if ('' !== ($isMilestoneArrayErrorMessage = self::validateIsMilestoneForArrayConstraintsFromSetIsMilestone($isMilestone))) {
            throw new \InvalidArgumentException($isMilestoneArrayErrorMessage, __LINE__);
        }
        $this->isMilestone = $isMilestone;
        return $this;
    }
    /**
     * Add item to isMilestone value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnBooleanField $item
     * @return \StructType\ProjectTaskSearchRowBasic
     */
    public function addToIsMilestone(\StructType\SearchColumnBooleanField $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SearchColumnBooleanField) {
            throw new \InvalidArgumentException(sprintf('The isMilestone property can only contain items of type \StructType\SearchColumnBooleanField, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->isMilestone[] = $item;
        return $this;
    }
    /**
     * Get isSummaryTask value
     * @return \StructType\SearchColumnBooleanField[]|null
     */
    public function getIsSummaryTask()
    {
        return $this->isSummaryTask;
    }
    /**
     * This method is responsible for validating the values passed to the setIsSummaryTask method
     * This method is willingly generated in order to preserve the one-line inline validation within the setIsSummaryTask method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateIsSummaryTaskForArrayConstraintsFromSetIsSummaryTask(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $projectTaskSearchRowBasicIsSummaryTaskItem) {
            // validation for constraint: itemType
            if (!$projectTaskSearchRowBasicIsSummaryTaskItem instanceof \StructType\SearchColumnBooleanField) {
                $invalidValues[] = is_object($projectTaskSearchRowBasicIsSummaryTaskItem) ? get_class($projectTaskSearchRowBasicIsSummaryTaskItem) : sprintf('%s(%s)', gettype($projectTaskSearchRowBasicIsSummaryTaskItem), var_export($projectTaskSearchRowBasicIsSummaryTaskItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The isSummaryTask property can only contain items of type \StructType\SearchColumnBooleanField, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set isSummaryTask value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnBooleanField[] $isSummaryTask
     * @return \StructType\ProjectTaskSearchRowBasic
     */
    public function setIsSummaryTask(array $isSummaryTask = array())
    {
        // validation for constraint: array
        if ('' !== ($isSummaryTaskArrayErrorMessage = self::validateIsSummaryTaskForArrayConstraintsFromSetIsSummaryTask($isSummaryTask))) {
            throw new \InvalidArgumentException($isSummaryTaskArrayErrorMessage, __LINE__);
        }
        $this->isSummaryTask = $isSummaryTask;
        return $this;
    }
    /**
     * Add item to isSummaryTask value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnBooleanField $item
     * @return \StructType\ProjectTaskSearchRowBasic
     */
    public function addToIsSummaryTask(\StructType\SearchColumnBooleanField $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SearchColumnBooleanField) {
            throw new \InvalidArgumentException(sprintf('The isSummaryTask property can only contain items of type \StructType\SearchColumnBooleanField, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->isSummaryTask[] = $item;
        return $this;
    }
    /**
     * Get lastModifiedDate value
     * @return \StructType\SearchColumnDateField[]|null
     */
    public function getLastModifiedDate()
    {
        return $this->lastModifiedDate;
    }
    /**
     * This method is responsible for validating the values passed to the setLastModifiedDate method
     * This method is willingly generated in order to preserve the one-line inline validation within the setLastModifiedDate method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateLastModifiedDateForArrayConstraintsFromSetLastModifiedDate(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $projectTaskSearchRowBasicLastModifiedDateItem) {
            // validation for constraint: itemType
            if (!$projectTaskSearchRowBasicLastModifiedDateItem instanceof \StructType\SearchColumnDateField) {
                $invalidValues[] = is_object($projectTaskSearchRowBasicLastModifiedDateItem) ? get_class($projectTaskSearchRowBasicLastModifiedDateItem) : sprintf('%s(%s)', gettype($projectTaskSearchRowBasicLastModifiedDateItem), var_export($projectTaskSearchRowBasicLastModifiedDateItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The lastModifiedDate property can only contain items of type \StructType\SearchColumnDateField, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set lastModifiedDate value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnDateField[] $lastModifiedDate
     * @return \StructType\ProjectTaskSearchRowBasic
     */
    public function setLastModifiedDate(array $lastModifiedDate = array())
    {
        // validation for constraint: array
        if ('' !== ($lastModifiedDateArrayErrorMessage = self::validateLastModifiedDateForArrayConstraintsFromSetLastModifiedDate($lastModifiedDate))) {
            throw new \InvalidArgumentException($lastModifiedDateArrayErrorMessage, __LINE__);
        }
        $this->lastModifiedDate = $lastModifiedDate;
        return $this;
    }
    /**
     * Add item to lastModifiedDate value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnDateField $item
     * @return \StructType\ProjectTaskSearchRowBasic
     */
    public function addToLastModifiedDate(\StructType\SearchColumnDateField $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SearchColumnDateField) {
            throw new \InvalidArgumentException(sprintf('The lastModifiedDate property can only contain items of type \StructType\SearchColumnDateField, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->lastModifiedDate[] = $item;
        return $this;
    }
    /**
     * Get message value
     * @return \StructType\SearchColumnStringField[]|null
     */
    public function getMessage()
    {
        return $this->message;
    }
    /**
     * This method is responsible for validating the values passed to the setMessage method
     * This method is willingly generated in order to preserve the one-line inline validation within the setMessage method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateMessageForArrayConstraintsFromSetMessage(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $projectTaskSearchRowBasicMessageItem) {
            // validation for constraint: itemType
            if (!$projectTaskSearchRowBasicMessageItem instanceof \StructType\SearchColumnStringField) {
                $invalidValues[] = is_object($projectTaskSearchRowBasicMessageItem) ? get_class($projectTaskSearchRowBasicMessageItem) : sprintf('%s(%s)', gettype($projectTaskSearchRowBasicMessageItem), var_export($projectTaskSearchRowBasicMessageItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The message property can only contain items of type \StructType\SearchColumnStringField, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set message value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnStringField[] $message
     * @return \StructType\ProjectTaskSearchRowBasic
     */
    public function setMessage(array $message = array())
    {
        // validation for constraint: array
        if ('' !== ($messageArrayErrorMessage = self::validateMessageForArrayConstraintsFromSetMessage($message))) {
            throw new \InvalidArgumentException($messageArrayErrorMessage, __LINE__);
        }
        $this->message = $message;
        return $this;
    }
    /**
     * Add item to message value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnStringField $item
     * @return \StructType\ProjectTaskSearchRowBasic
     */
    public function addToMessage(\StructType\SearchColumnStringField $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SearchColumnStringField) {
            throw new \InvalidArgumentException(sprintf('The message property can only contain items of type \StructType\SearchColumnStringField, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->message[] = $item;
        return $this;
    }
    /**
     * Get nonBillableTask value
     * @return \StructType\SearchColumnBooleanField[]|null
     */
    public function getNonBillableTask()
    {
        return $this->nonBillableTask;
    }
    /**
     * This method is responsible for validating the values passed to the setNonBillableTask method
     * This method is willingly generated in order to preserve the one-line inline validation within the setNonBillableTask method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateNonBillableTaskForArrayConstraintsFromSetNonBillableTask(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $projectTaskSearchRowBasicNonBillableTaskItem) {
            // validation for constraint: itemType
            if (!$projectTaskSearchRowBasicNonBillableTaskItem instanceof \StructType\SearchColumnBooleanField) {
                $invalidValues[] = is_object($projectTaskSearchRowBasicNonBillableTaskItem) ? get_class($projectTaskSearchRowBasicNonBillableTaskItem) : sprintf('%s(%s)', gettype($projectTaskSearchRowBasicNonBillableTaskItem), var_export($projectTaskSearchRowBasicNonBillableTaskItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The nonBillableTask property can only contain items of type \StructType\SearchColumnBooleanField, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set nonBillableTask value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnBooleanField[] $nonBillableTask
     * @return \StructType\ProjectTaskSearchRowBasic
     */
    public function setNonBillableTask(array $nonBillableTask = array())
    {
        // validation for constraint: array
        if ('' !== ($nonBillableTaskArrayErrorMessage = self::validateNonBillableTaskForArrayConstraintsFromSetNonBillableTask($nonBillableTask))) {
            throw new \InvalidArgumentException($nonBillableTaskArrayErrorMessage, __LINE__);
        }
        $this->nonBillableTask = $nonBillableTask;
        return $this;
    }
    /**
     * Add item to nonBillableTask value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnBooleanField $item
     * @return \StructType\ProjectTaskSearchRowBasic
     */
    public function addToNonBillableTask(\StructType\SearchColumnBooleanField $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SearchColumnBooleanField) {
            throw new \InvalidArgumentException(sprintf('The nonBillableTask property can only contain items of type \StructType\SearchColumnBooleanField, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->nonBillableTask[] = $item;
        return $this;
    }
    /**
     * Get owner value
     * @return \StructType\SearchColumnSelectField[]|null
     */
    public function getOwner()
    {
        return $this->owner;
    }
    /**
     * This method is responsible for validating the values passed to the setOwner method
     * This method is willingly generated in order to preserve the one-line inline validation within the setOwner method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateOwnerForArrayConstraintsFromSetOwner(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $projectTaskSearchRowBasicOwnerItem) {
            // validation for constraint: itemType
            if (!$projectTaskSearchRowBasicOwnerItem instanceof \StructType\SearchColumnSelectField) {
                $invalidValues[] = is_object($projectTaskSearchRowBasicOwnerItem) ? get_class($projectTaskSearchRowBasicOwnerItem) : sprintf('%s(%s)', gettype($projectTaskSearchRowBasicOwnerItem), var_export($projectTaskSearchRowBasicOwnerItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The owner property can only contain items of type \StructType\SearchColumnSelectField, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set owner value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnSelectField[] $owner
     * @return \StructType\ProjectTaskSearchRowBasic
     */
    public function setOwner(array $owner = array())
    {
        // validation for constraint: array
        if ('' !== ($ownerArrayErrorMessage = self::validateOwnerForArrayConstraintsFromSetOwner($owner))) {
            throw new \InvalidArgumentException($ownerArrayErrorMessage, __LINE__);
        }
        $this->owner = $owner;
        return $this;
    }
    /**
     * Add item to owner value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnSelectField $item
     * @return \StructType\ProjectTaskSearchRowBasic
     */
    public function addToOwner(\StructType\SearchColumnSelectField $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SearchColumnSelectField) {
            throw new \InvalidArgumentException(sprintf('The owner property can only contain items of type \StructType\SearchColumnSelectField, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->owner[] = $item;
        return $this;
    }
    /**
     * Get parent value
     * @return \StructType\SearchColumnSelectField[]|null
     */
    public function getParent()
    {
        return $this->parent;
    }
    /**
     * This method is responsible for validating the values passed to the setParent method
     * This method is willingly generated in order to preserve the one-line inline validation within the setParent method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateParentForArrayConstraintsFromSetParent(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $projectTaskSearchRowBasicParentItem) {
            // validation for constraint: itemType
            if (!$projectTaskSearchRowBasicParentItem instanceof \StructType\SearchColumnSelectField) {
                $invalidValues[] = is_object($projectTaskSearchRowBasicParentItem) ? get_class($projectTaskSearchRowBasicParentItem) : sprintf('%s(%s)', gettype($projectTaskSearchRowBasicParentItem), var_export($projectTaskSearchRowBasicParentItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The parent property can only contain items of type \StructType\SearchColumnSelectField, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set parent value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnSelectField[] $parent
     * @return \StructType\ProjectTaskSearchRowBasic
     */
    public function setParent(array $parent = array())
    {
        // validation for constraint: array
        if ('' !== ($parentArrayErrorMessage = self::validateParentForArrayConstraintsFromSetParent($parent))) {
            throw new \InvalidArgumentException($parentArrayErrorMessage, __LINE__);
        }
        $this->parent = $parent;
        return $this;
    }
    /**
     * Add item to parent value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnSelectField $item
     * @return \StructType\ProjectTaskSearchRowBasic
     */
    public function addToParent(\StructType\SearchColumnSelectField $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SearchColumnSelectField) {
            throw new \InvalidArgumentException(sprintf('The parent property can only contain items of type \StructType\SearchColumnSelectField, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->parent[] = $item;
        return $this;
    }
    /**
     * Get percentWorkComplete value
     * @return \StructType\SearchColumnDoubleField[]|null
     */
    public function getPercentWorkComplete()
    {
        return $this->percentWorkComplete;
    }
    /**
     * This method is responsible for validating the values passed to the setPercentWorkComplete method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPercentWorkComplete method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePercentWorkCompleteForArrayConstraintsFromSetPercentWorkComplete(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $projectTaskSearchRowBasicPercentWorkCompleteItem) {
            // validation for constraint: itemType
            if (!$projectTaskSearchRowBasicPercentWorkCompleteItem instanceof \StructType\SearchColumnDoubleField) {
                $invalidValues[] = is_object($projectTaskSearchRowBasicPercentWorkCompleteItem) ? get_class($projectTaskSearchRowBasicPercentWorkCompleteItem) : sprintf('%s(%s)', gettype($projectTaskSearchRowBasicPercentWorkCompleteItem), var_export($projectTaskSearchRowBasicPercentWorkCompleteItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The percentWorkComplete property can only contain items of type \StructType\SearchColumnDoubleField, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set percentWorkComplete value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnDoubleField[] $percentWorkComplete
     * @return \StructType\ProjectTaskSearchRowBasic
     */
    public function setPercentWorkComplete(array $percentWorkComplete = array())
    {
        // validation for constraint: array
        if ('' !== ($percentWorkCompleteArrayErrorMessage = self::validatePercentWorkCompleteForArrayConstraintsFromSetPercentWorkComplete($percentWorkComplete))) {
            throw new \InvalidArgumentException($percentWorkCompleteArrayErrorMessage, __LINE__);
        }
        $this->percentWorkComplete = $percentWorkComplete;
        return $this;
    }
    /**
     * Add item to percentWorkComplete value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnDoubleField $item
     * @return \StructType\ProjectTaskSearchRowBasic
     */
    public function addToPercentWorkComplete(\StructType\SearchColumnDoubleField $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SearchColumnDoubleField) {
            throw new \InvalidArgumentException(sprintf('The percentWorkComplete property can only contain items of type \StructType\SearchColumnDoubleField, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->percentWorkComplete[] = $item;
        return $this;
    }
    /**
     * Get plannedWork value
     * @return \StructType\SearchColumnDoubleField[]|null
     */
    public function getPlannedWork()
    {
        return $this->plannedWork;
    }
    /**
     * This method is responsible for validating the values passed to the setPlannedWork method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPlannedWork method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePlannedWorkForArrayConstraintsFromSetPlannedWork(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $projectTaskSearchRowBasicPlannedWorkItem) {
            // validation for constraint: itemType
            if (!$projectTaskSearchRowBasicPlannedWorkItem instanceof \StructType\SearchColumnDoubleField) {
                $invalidValues[] = is_object($projectTaskSearchRowBasicPlannedWorkItem) ? get_class($projectTaskSearchRowBasicPlannedWorkItem) : sprintf('%s(%s)', gettype($projectTaskSearchRowBasicPlannedWorkItem), var_export($projectTaskSearchRowBasicPlannedWorkItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The plannedWork property can only contain items of type \StructType\SearchColumnDoubleField, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set plannedWork value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnDoubleField[] $plannedWork
     * @return \StructType\ProjectTaskSearchRowBasic
     */
    public function setPlannedWork(array $plannedWork = array())
    {
        // validation for constraint: array
        if ('' !== ($plannedWorkArrayErrorMessage = self::validatePlannedWorkForArrayConstraintsFromSetPlannedWork($plannedWork))) {
            throw new \InvalidArgumentException($plannedWorkArrayErrorMessage, __LINE__);
        }
        $this->plannedWork = $plannedWork;
        return $this;
    }
    /**
     * Add item to plannedWork value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnDoubleField $item
     * @return \StructType\ProjectTaskSearchRowBasic
     */
    public function addToPlannedWork(\StructType\SearchColumnDoubleField $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SearchColumnDoubleField) {
            throw new \InvalidArgumentException(sprintf('The plannedWork property can only contain items of type \StructType\SearchColumnDoubleField, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->plannedWork[] = $item;
        return $this;
    }
    /**
     * Get plannedWorkBaseline value
     * @return \StructType\SearchColumnDoubleField[]|null
     */
    public function getPlannedWorkBaseline()
    {
        return $this->plannedWorkBaseline;
    }
    /**
     * This method is responsible for validating the values passed to the setPlannedWorkBaseline method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPlannedWorkBaseline method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePlannedWorkBaselineForArrayConstraintsFromSetPlannedWorkBaseline(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $projectTaskSearchRowBasicPlannedWorkBaselineItem) {
            // validation for constraint: itemType
            if (!$projectTaskSearchRowBasicPlannedWorkBaselineItem instanceof \StructType\SearchColumnDoubleField) {
                $invalidValues[] = is_object($projectTaskSearchRowBasicPlannedWorkBaselineItem) ? get_class($projectTaskSearchRowBasicPlannedWorkBaselineItem) : sprintf('%s(%s)', gettype($projectTaskSearchRowBasicPlannedWorkBaselineItem), var_export($projectTaskSearchRowBasicPlannedWorkBaselineItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The plannedWorkBaseline property can only contain items of type \StructType\SearchColumnDoubleField, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set plannedWorkBaseline value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnDoubleField[] $plannedWorkBaseline
     * @return \StructType\ProjectTaskSearchRowBasic
     */
    public function setPlannedWorkBaseline(array $plannedWorkBaseline = array())
    {
        // validation for constraint: array
        if ('' !== ($plannedWorkBaselineArrayErrorMessage = self::validatePlannedWorkBaselineForArrayConstraintsFromSetPlannedWorkBaseline($plannedWorkBaseline))) {
            throw new \InvalidArgumentException($plannedWorkBaselineArrayErrorMessage, __LINE__);
        }
        $this->plannedWorkBaseline = $plannedWorkBaseline;
        return $this;
    }
    /**
     * Add item to plannedWorkBaseline value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnDoubleField $item
     * @return \StructType\ProjectTaskSearchRowBasic
     */
    public function addToPlannedWorkBaseline(\StructType\SearchColumnDoubleField $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SearchColumnDoubleField) {
            throw new \InvalidArgumentException(sprintf('The plannedWorkBaseline property can only contain items of type \StructType\SearchColumnDoubleField, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->plannedWorkBaseline[] = $item;
        return $this;
    }
    /**
     * Get predecessor value
     * @return \StructType\SearchColumnSelectField[]|null
     */
    public function getPredecessor()
    {
        return $this->predecessor;
    }
    /**
     * This method is responsible for validating the values passed to the setPredecessor method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPredecessor method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePredecessorForArrayConstraintsFromSetPredecessor(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $projectTaskSearchRowBasicPredecessorItem) {
            // validation for constraint: itemType
            if (!$projectTaskSearchRowBasicPredecessorItem instanceof \StructType\SearchColumnSelectField) {
                $invalidValues[] = is_object($projectTaskSearchRowBasicPredecessorItem) ? get_class($projectTaskSearchRowBasicPredecessorItem) : sprintf('%s(%s)', gettype($projectTaskSearchRowBasicPredecessorItem), var_export($projectTaskSearchRowBasicPredecessorItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The predecessor property can only contain items of type \StructType\SearchColumnSelectField, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set predecessor value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnSelectField[] $predecessor
     * @return \StructType\ProjectTaskSearchRowBasic
     */
    public function setPredecessor(array $predecessor = array())
    {
        // validation for constraint: array
        if ('' !== ($predecessorArrayErrorMessage = self::validatePredecessorForArrayConstraintsFromSetPredecessor($predecessor))) {
            throw new \InvalidArgumentException($predecessorArrayErrorMessage, __LINE__);
        }
        $this->predecessor = $predecessor;
        return $this;
    }
    /**
     * Add item to predecessor value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnSelectField $item
     * @return \StructType\ProjectTaskSearchRowBasic
     */
    public function addToPredecessor(\StructType\SearchColumnSelectField $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SearchColumnSelectField) {
            throw new \InvalidArgumentException(sprintf('The predecessor property can only contain items of type \StructType\SearchColumnSelectField, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->predecessor[] = $item;
        return $this;
    }
    /**
     * Get predecessorLagDays value
     * @return \StructType\SearchColumnDoubleField[]|null
     */
    public function getPredecessorLagDays()
    {
        return $this->predecessorLagDays;
    }
    /**
     * This method is responsible for validating the values passed to the setPredecessorLagDays method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPredecessorLagDays method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePredecessorLagDaysForArrayConstraintsFromSetPredecessorLagDays(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $projectTaskSearchRowBasicPredecessorLagDaysItem) {
            // validation for constraint: itemType
            if (!$projectTaskSearchRowBasicPredecessorLagDaysItem instanceof \StructType\SearchColumnDoubleField) {
                $invalidValues[] = is_object($projectTaskSearchRowBasicPredecessorLagDaysItem) ? get_class($projectTaskSearchRowBasicPredecessorLagDaysItem) : sprintf('%s(%s)', gettype($projectTaskSearchRowBasicPredecessorLagDaysItem), var_export($projectTaskSearchRowBasicPredecessorLagDaysItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The predecessorLagDays property can only contain items of type \StructType\SearchColumnDoubleField, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set predecessorLagDays value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnDoubleField[] $predecessorLagDays
     * @return \StructType\ProjectTaskSearchRowBasic
     */
    public function setPredecessorLagDays(array $predecessorLagDays = array())
    {
        // validation for constraint: array
        if ('' !== ($predecessorLagDaysArrayErrorMessage = self::validatePredecessorLagDaysForArrayConstraintsFromSetPredecessorLagDays($predecessorLagDays))) {
            throw new \InvalidArgumentException($predecessorLagDaysArrayErrorMessage, __LINE__);
        }
        $this->predecessorLagDays = $predecessorLagDays;
        return $this;
    }
    /**
     * Add item to predecessorLagDays value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnDoubleField $item
     * @return \StructType\ProjectTaskSearchRowBasic
     */
    public function addToPredecessorLagDays(\StructType\SearchColumnDoubleField $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SearchColumnDoubleField) {
            throw new \InvalidArgumentException(sprintf('The predecessorLagDays property can only contain items of type \StructType\SearchColumnDoubleField, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->predecessorLagDays[] = $item;
        return $this;
    }
    /**
     * Get predecessors value
     * @return \StructType\SearchColumnStringField[]|null
     */
    public function getPredecessors()
    {
        return $this->predecessors;
    }
    /**
     * This method is responsible for validating the values passed to the setPredecessors method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPredecessors method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePredecessorsForArrayConstraintsFromSetPredecessors(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $projectTaskSearchRowBasicPredecessorsItem) {
            // validation for constraint: itemType
            if (!$projectTaskSearchRowBasicPredecessorsItem instanceof \StructType\SearchColumnStringField) {
                $invalidValues[] = is_object($projectTaskSearchRowBasicPredecessorsItem) ? get_class($projectTaskSearchRowBasicPredecessorsItem) : sprintf('%s(%s)', gettype($projectTaskSearchRowBasicPredecessorsItem), var_export($projectTaskSearchRowBasicPredecessorsItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The predecessors property can only contain items of type \StructType\SearchColumnStringField, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set predecessors value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnStringField[] $predecessors
     * @return \StructType\ProjectTaskSearchRowBasic
     */
    public function setPredecessors(array $predecessors = array())
    {
        // validation for constraint: array
        if ('' !== ($predecessorsArrayErrorMessage = self::validatePredecessorsForArrayConstraintsFromSetPredecessors($predecessors))) {
            throw new \InvalidArgumentException($predecessorsArrayErrorMessage, __LINE__);
        }
        $this->predecessors = $predecessors;
        return $this;
    }
    /**
     * Add item to predecessors value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnStringField $item
     * @return \StructType\ProjectTaskSearchRowBasic
     */
    public function addToPredecessors(\StructType\SearchColumnStringField $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SearchColumnStringField) {
            throw new \InvalidArgumentException(sprintf('The predecessors property can only contain items of type \StructType\SearchColumnStringField, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->predecessors[] = $item;
        return $this;
    }
    /**
     * Get predecessorType value
     * @return \StructType\SearchColumnStringField[]|null
     */
    public function getPredecessorType()
    {
        return $this->predecessorType;
    }
    /**
     * This method is responsible for validating the values passed to the setPredecessorType method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPredecessorType method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePredecessorTypeForArrayConstraintsFromSetPredecessorType(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $projectTaskSearchRowBasicPredecessorTypeItem) {
            // validation for constraint: itemType
            if (!$projectTaskSearchRowBasicPredecessorTypeItem instanceof \StructType\SearchColumnStringField) {
                $invalidValues[] = is_object($projectTaskSearchRowBasicPredecessorTypeItem) ? get_class($projectTaskSearchRowBasicPredecessorTypeItem) : sprintf('%s(%s)', gettype($projectTaskSearchRowBasicPredecessorTypeItem), var_export($projectTaskSearchRowBasicPredecessorTypeItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The predecessorType property can only contain items of type \StructType\SearchColumnStringField, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set predecessorType value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnStringField[] $predecessorType
     * @return \StructType\ProjectTaskSearchRowBasic
     */
    public function setPredecessorType(array $predecessorType = array())
    {
        // validation for constraint: array
        if ('' !== ($predecessorTypeArrayErrorMessage = self::validatePredecessorTypeForArrayConstraintsFromSetPredecessorType($predecessorType))) {
            throw new \InvalidArgumentException($predecessorTypeArrayErrorMessage, __LINE__);
        }
        $this->predecessorType = $predecessorType;
        return $this;
    }
    /**
     * Add item to predecessorType value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnStringField $item
     * @return \StructType\ProjectTaskSearchRowBasic
     */
    public function addToPredecessorType(\StructType\SearchColumnStringField $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SearchColumnStringField) {
            throw new \InvalidArgumentException(sprintf('The predecessorType property can only contain items of type \StructType\SearchColumnStringField, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->predecessorType[] = $item;
        return $this;
    }
    /**
     * Get priority value
     * @return \StructType\SearchColumnEnumSelectField[]|null
     */
    public function getPriority()
    {
        return $this->priority;
    }
    /**
     * This method is responsible for validating the values passed to the setPriority method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPriority method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePriorityForArrayConstraintsFromSetPriority(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $projectTaskSearchRowBasicPriorityItem) {
            // validation for constraint: itemType
            if (!$projectTaskSearchRowBasicPriorityItem instanceof \StructType\SearchColumnEnumSelectField) {
                $invalidValues[] = is_object($projectTaskSearchRowBasicPriorityItem) ? get_class($projectTaskSearchRowBasicPriorityItem) : sprintf('%s(%s)', gettype($projectTaskSearchRowBasicPriorityItem), var_export($projectTaskSearchRowBasicPriorityItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The priority property can only contain items of type \StructType\SearchColumnEnumSelectField, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set priority value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnEnumSelectField[] $priority
     * @return \StructType\ProjectTaskSearchRowBasic
     */
    public function setPriority(array $priority = array())
    {
        // validation for constraint: array
        if ('' !== ($priorityArrayErrorMessage = self::validatePriorityForArrayConstraintsFromSetPriority($priority))) {
            throw new \InvalidArgumentException($priorityArrayErrorMessage, __LINE__);
        }
        $this->priority = $priority;
        return $this;
    }
    /**
     * Add item to priority value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnEnumSelectField $item
     * @return \StructType\ProjectTaskSearchRowBasic
     */
    public function addToPriority(\StructType\SearchColumnEnumSelectField $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SearchColumnEnumSelectField) {
            throw new \InvalidArgumentException(sprintf('The priority property can only contain items of type \StructType\SearchColumnEnumSelectField, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->priority[] = $item;
        return $this;
    }
    /**
     * Get remainingWork value
     * @return \StructType\SearchColumnDoubleField[]|null
     */
    public function getRemainingWork()
    {
        return $this->remainingWork;
    }
    /**
     * This method is responsible for validating the values passed to the setRemainingWork method
     * This method is willingly generated in order to preserve the one-line inline validation within the setRemainingWork method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateRemainingWorkForArrayConstraintsFromSetRemainingWork(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $projectTaskSearchRowBasicRemainingWorkItem) {
            // validation for constraint: itemType
            if (!$projectTaskSearchRowBasicRemainingWorkItem instanceof \StructType\SearchColumnDoubleField) {
                $invalidValues[] = is_object($projectTaskSearchRowBasicRemainingWorkItem) ? get_class($projectTaskSearchRowBasicRemainingWorkItem) : sprintf('%s(%s)', gettype($projectTaskSearchRowBasicRemainingWorkItem), var_export($projectTaskSearchRowBasicRemainingWorkItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The remainingWork property can only contain items of type \StructType\SearchColumnDoubleField, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set remainingWork value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnDoubleField[] $remainingWork
     * @return \StructType\ProjectTaskSearchRowBasic
     */
    public function setRemainingWork(array $remainingWork = array())
    {
        // validation for constraint: array
        if ('' !== ($remainingWorkArrayErrorMessage = self::validateRemainingWorkForArrayConstraintsFromSetRemainingWork($remainingWork))) {
            throw new \InvalidArgumentException($remainingWorkArrayErrorMessage, __LINE__);
        }
        $this->remainingWork = $remainingWork;
        return $this;
    }
    /**
     * Add item to remainingWork value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnDoubleField $item
     * @return \StructType\ProjectTaskSearchRowBasic
     */
    public function addToRemainingWork(\StructType\SearchColumnDoubleField $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SearchColumnDoubleField) {
            throw new \InvalidArgumentException(sprintf('The remainingWork property can only contain items of type \StructType\SearchColumnDoubleField, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->remainingWork[] = $item;
        return $this;
    }
    /**
     * Get startDate value
     * @return \StructType\SearchColumnDateField[]|null
     */
    public function getStartDate()
    {
        return $this->startDate;
    }
    /**
     * This method is responsible for validating the values passed to the setStartDate method
     * This method is willingly generated in order to preserve the one-line inline validation within the setStartDate method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateStartDateForArrayConstraintsFromSetStartDate(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $projectTaskSearchRowBasicStartDateItem) {
            // validation for constraint: itemType
            if (!$projectTaskSearchRowBasicStartDateItem instanceof \StructType\SearchColumnDateField) {
                $invalidValues[] = is_object($projectTaskSearchRowBasicStartDateItem) ? get_class($projectTaskSearchRowBasicStartDateItem) : sprintf('%s(%s)', gettype($projectTaskSearchRowBasicStartDateItem), var_export($projectTaskSearchRowBasicStartDateItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The startDate property can only contain items of type \StructType\SearchColumnDateField, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set startDate value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnDateField[] $startDate
     * @return \StructType\ProjectTaskSearchRowBasic
     */
    public function setStartDate(array $startDate = array())
    {
        // validation for constraint: array
        if ('' !== ($startDateArrayErrorMessage = self::validateStartDateForArrayConstraintsFromSetStartDate($startDate))) {
            throw new \InvalidArgumentException($startDateArrayErrorMessage, __LINE__);
        }
        $this->startDate = $startDate;
        return $this;
    }
    /**
     * Add item to startDate value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnDateField $item
     * @return \StructType\ProjectTaskSearchRowBasic
     */
    public function addToStartDate(\StructType\SearchColumnDateField $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SearchColumnDateField) {
            throw new \InvalidArgumentException(sprintf('The startDate property can only contain items of type \StructType\SearchColumnDateField, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->startDate[] = $item;
        return $this;
    }
    /**
     * Get startDateBaseline value
     * @return \StructType\SearchColumnDateField[]|null
     */
    public function getStartDateBaseline()
    {
        return $this->startDateBaseline;
    }
    /**
     * This method is responsible for validating the values passed to the setStartDateBaseline method
     * This method is willingly generated in order to preserve the one-line inline validation within the setStartDateBaseline method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateStartDateBaselineForArrayConstraintsFromSetStartDateBaseline(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $projectTaskSearchRowBasicStartDateBaselineItem) {
            // validation for constraint: itemType
            if (!$projectTaskSearchRowBasicStartDateBaselineItem instanceof \StructType\SearchColumnDateField) {
                $invalidValues[] = is_object($projectTaskSearchRowBasicStartDateBaselineItem) ? get_class($projectTaskSearchRowBasicStartDateBaselineItem) : sprintf('%s(%s)', gettype($projectTaskSearchRowBasicStartDateBaselineItem), var_export($projectTaskSearchRowBasicStartDateBaselineItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The startDateBaseline property can only contain items of type \StructType\SearchColumnDateField, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set startDateBaseline value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnDateField[] $startDateBaseline
     * @return \StructType\ProjectTaskSearchRowBasic
     */
    public function setStartDateBaseline(array $startDateBaseline = array())
    {
        // validation for constraint: array
        if ('' !== ($startDateBaselineArrayErrorMessage = self::validateStartDateBaselineForArrayConstraintsFromSetStartDateBaseline($startDateBaseline))) {
            throw new \InvalidArgumentException($startDateBaselineArrayErrorMessage, __LINE__);
        }
        $this->startDateBaseline = $startDateBaseline;
        return $this;
    }
    /**
     * Add item to startDateBaseline value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnDateField $item
     * @return \StructType\ProjectTaskSearchRowBasic
     */
    public function addToStartDateBaseline(\StructType\SearchColumnDateField $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SearchColumnDateField) {
            throw new \InvalidArgumentException(sprintf('The startDateBaseline property can only contain items of type \StructType\SearchColumnDateField, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->startDateBaseline[] = $item;
        return $this;
    }
    /**
     * Get startDateVariance value
     * @return \StructType\SearchColumnDoubleField[]|null
     */
    public function getStartDateVariance()
    {
        return $this->startDateVariance;
    }
    /**
     * This method is responsible for validating the values passed to the setStartDateVariance method
     * This method is willingly generated in order to preserve the one-line inline validation within the setStartDateVariance method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateStartDateVarianceForArrayConstraintsFromSetStartDateVariance(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $projectTaskSearchRowBasicStartDateVarianceItem) {
            // validation for constraint: itemType
            if (!$projectTaskSearchRowBasicStartDateVarianceItem instanceof \StructType\SearchColumnDoubleField) {
                $invalidValues[] = is_object($projectTaskSearchRowBasicStartDateVarianceItem) ? get_class($projectTaskSearchRowBasicStartDateVarianceItem) : sprintf('%s(%s)', gettype($projectTaskSearchRowBasicStartDateVarianceItem), var_export($projectTaskSearchRowBasicStartDateVarianceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The startDateVariance property can only contain items of type \StructType\SearchColumnDoubleField, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set startDateVariance value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnDoubleField[] $startDateVariance
     * @return \StructType\ProjectTaskSearchRowBasic
     */
    public function setStartDateVariance(array $startDateVariance = array())
    {
        // validation for constraint: array
        if ('' !== ($startDateVarianceArrayErrorMessage = self::validateStartDateVarianceForArrayConstraintsFromSetStartDateVariance($startDateVariance))) {
            throw new \InvalidArgumentException($startDateVarianceArrayErrorMessage, __LINE__);
        }
        $this->startDateVariance = $startDateVariance;
        return $this;
    }
    /**
     * Add item to startDateVariance value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnDoubleField $item
     * @return \StructType\ProjectTaskSearchRowBasic
     */
    public function addToStartDateVariance(\StructType\SearchColumnDoubleField $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SearchColumnDoubleField) {
            throw new \InvalidArgumentException(sprintf('The startDateVariance property can only contain items of type \StructType\SearchColumnDoubleField, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->startDateVariance[] = $item;
        return $this;
    }
    /**
     * Get status value
     * @return \StructType\SearchColumnEnumSelectField[]|null
     */
    public function getStatus()
    {
        return $this->status;
    }
    /**
     * This method is responsible for validating the values passed to the setStatus method
     * This method is willingly generated in order to preserve the one-line inline validation within the setStatus method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateStatusForArrayConstraintsFromSetStatus(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $projectTaskSearchRowBasicStatusItem) {
            // validation for constraint: itemType
            if (!$projectTaskSearchRowBasicStatusItem instanceof \StructType\SearchColumnEnumSelectField) {
                $invalidValues[] = is_object($projectTaskSearchRowBasicStatusItem) ? get_class($projectTaskSearchRowBasicStatusItem) : sprintf('%s(%s)', gettype($projectTaskSearchRowBasicStatusItem), var_export($projectTaskSearchRowBasicStatusItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The status property can only contain items of type \StructType\SearchColumnEnumSelectField, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set status value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnEnumSelectField[] $status
     * @return \StructType\ProjectTaskSearchRowBasic
     */
    public function setStatus(array $status = array())
    {
        // validation for constraint: array
        if ('' !== ($statusArrayErrorMessage = self::validateStatusForArrayConstraintsFromSetStatus($status))) {
            throw new \InvalidArgumentException($statusArrayErrorMessage, __LINE__);
        }
        $this->status = $status;
        return $this;
    }
    /**
     * Add item to status value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnEnumSelectField $item
     * @return \StructType\ProjectTaskSearchRowBasic
     */
    public function addToStatus(\StructType\SearchColumnEnumSelectField $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SearchColumnEnumSelectField) {
            throw new \InvalidArgumentException(sprintf('The status property can only contain items of type \StructType\SearchColumnEnumSelectField, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->status[] = $item;
        return $this;
    }
    /**
     * Get successor value
     * @return \StructType\SearchColumnSelectField[]|null
     */
    public function getSuccessor()
    {
        return $this->successor;
    }
    /**
     * This method is responsible for validating the values passed to the setSuccessor method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSuccessor method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateSuccessorForArrayConstraintsFromSetSuccessor(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $projectTaskSearchRowBasicSuccessorItem) {
            // validation for constraint: itemType
            if (!$projectTaskSearchRowBasicSuccessorItem instanceof \StructType\SearchColumnSelectField) {
                $invalidValues[] = is_object($projectTaskSearchRowBasicSuccessorItem) ? get_class($projectTaskSearchRowBasicSuccessorItem) : sprintf('%s(%s)', gettype($projectTaskSearchRowBasicSuccessorItem), var_export($projectTaskSearchRowBasicSuccessorItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The successor property can only contain items of type \StructType\SearchColumnSelectField, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set successor value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnSelectField[] $successor
     * @return \StructType\ProjectTaskSearchRowBasic
     */
    public function setSuccessor(array $successor = array())
    {
        // validation for constraint: array
        if ('' !== ($successorArrayErrorMessage = self::validateSuccessorForArrayConstraintsFromSetSuccessor($successor))) {
            throw new \InvalidArgumentException($successorArrayErrorMessage, __LINE__);
        }
        $this->successor = $successor;
        return $this;
    }
    /**
     * Add item to successor value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnSelectField $item
     * @return \StructType\ProjectTaskSearchRowBasic
     */
    public function addToSuccessor(\StructType\SearchColumnSelectField $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SearchColumnSelectField) {
            throw new \InvalidArgumentException(sprintf('The successor property can only contain items of type \StructType\SearchColumnSelectField, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->successor[] = $item;
        return $this;
    }
    /**
     * Get successorType value
     * @return \StructType\SearchColumnStringField[]|null
     */
    public function getSuccessorType()
    {
        return $this->successorType;
    }
    /**
     * This method is responsible for validating the values passed to the setSuccessorType method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSuccessorType method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateSuccessorTypeForArrayConstraintsFromSetSuccessorType(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $projectTaskSearchRowBasicSuccessorTypeItem) {
            // validation for constraint: itemType
            if (!$projectTaskSearchRowBasicSuccessorTypeItem instanceof \StructType\SearchColumnStringField) {
                $invalidValues[] = is_object($projectTaskSearchRowBasicSuccessorTypeItem) ? get_class($projectTaskSearchRowBasicSuccessorTypeItem) : sprintf('%s(%s)', gettype($projectTaskSearchRowBasicSuccessorTypeItem), var_export($projectTaskSearchRowBasicSuccessorTypeItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The successorType property can only contain items of type \StructType\SearchColumnStringField, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set successorType value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnStringField[] $successorType
     * @return \StructType\ProjectTaskSearchRowBasic
     */
    public function setSuccessorType(array $successorType = array())
    {
        // validation for constraint: array
        if ('' !== ($successorTypeArrayErrorMessage = self::validateSuccessorTypeForArrayConstraintsFromSetSuccessorType($successorType))) {
            throw new \InvalidArgumentException($successorTypeArrayErrorMessage, __LINE__);
        }
        $this->successorType = $successorType;
        return $this;
    }
    /**
     * Add item to successorType value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnStringField $item
     * @return \StructType\ProjectTaskSearchRowBasic
     */
    public function addToSuccessorType(\StructType\SearchColumnStringField $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SearchColumnStringField) {
            throw new \InvalidArgumentException(sprintf('The successorType property can only contain items of type \StructType\SearchColumnStringField, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->successorType[] = $item;
        return $this;
    }
    /**
     * Get title value
     * @return \StructType\SearchColumnStringField[]|null
     */
    public function getTitle()
    {
        return $this->title;
    }
    /**
     * This method is responsible for validating the values passed to the setTitle method
     * This method is willingly generated in order to preserve the one-line inline validation within the setTitle method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateTitleForArrayConstraintsFromSetTitle(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $projectTaskSearchRowBasicTitleItem) {
            // validation for constraint: itemType
            if (!$projectTaskSearchRowBasicTitleItem instanceof \StructType\SearchColumnStringField) {
                $invalidValues[] = is_object($projectTaskSearchRowBasicTitleItem) ? get_class($projectTaskSearchRowBasicTitleItem) : sprintf('%s(%s)', gettype($projectTaskSearchRowBasicTitleItem), var_export($projectTaskSearchRowBasicTitleItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The title property can only contain items of type \StructType\SearchColumnStringField, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set title value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnStringField[] $title
     * @return \StructType\ProjectTaskSearchRowBasic
     */
    public function setTitle(array $title = array())
    {
        // validation for constraint: array
        if ('' !== ($titleArrayErrorMessage = self::validateTitleForArrayConstraintsFromSetTitle($title))) {
            throw new \InvalidArgumentException($titleArrayErrorMessage, __LINE__);
        }
        $this->title = $title;
        return $this;
    }
    /**
     * Add item to title value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnStringField $item
     * @return \StructType\ProjectTaskSearchRowBasic
     */
    public function addToTitle(\StructType\SearchColumnStringField $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SearchColumnStringField) {
            throw new \InvalidArgumentException(sprintf('The title property can only contain items of type \StructType\SearchColumnStringField, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->title[] = $item;
        return $this;
    }
    /**
     * Get customFieldList value
     * @return \StructType\SearchColumnCustomFieldList|null
     */
    public function getCustomFieldList()
    {
        return $this->customFieldList;
    }
    /**
     * Set customFieldList value
     * @param \StructType\SearchColumnCustomFieldList $customFieldList
     * @return \StructType\ProjectTaskSearchRowBasic
     */
    public function setCustomFieldList(\StructType\SearchColumnCustomFieldList $customFieldList = null)
    {
        $this->customFieldList = $customFieldList;
        return $this;
    }
}
