<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ProjectTaskSearch StructType
 * @subpackage Structs
 */
class ProjectTaskSearch extends SearchRecord
{
    /**
     * The basic
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\ProjectTaskSearchBasic
     */
    public $basic;
    /**
     * The jobJoin
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\JobSearchBasic
     */
    public $jobJoin;
    /**
     * The predecessorJoin
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\ProjectTaskSearchBasic
     */
    public $predecessorJoin;
    /**
     * The projectTaskAssignmentJoin
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\ProjectTaskAssignmentSearchBasic
     */
    public $projectTaskAssignmentJoin;
    /**
     * The resourceAllocationJoin
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\ResourceAllocationSearchBasic
     */
    public $resourceAllocationJoin;
    /**
     * The successorJoin
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\ProjectTaskSearchBasic
     */
    public $successorJoin;
    /**
     * The timeJoin
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\TimeBillSearchBasic
     */
    public $timeJoin;
    /**
     * The transactionJoin
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\TransactionSearchBasic
     */
    public $transactionJoin;
    /**
     * The userJoin
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\EmployeeSearchBasic
     */
    public $userJoin;
    /**
     * The userNotesJoin
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\NoteSearchBasic
     */
    public $userNotesJoin;
    /**
     * The customSearchJoin
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\CustomSearchJoin[]
     */
    public $customSearchJoin;
    /**
     * Constructor method for ProjectTaskSearch
     * @uses ProjectTaskSearch::setBasic()
     * @uses ProjectTaskSearch::setJobJoin()
     * @uses ProjectTaskSearch::setPredecessorJoin()
     * @uses ProjectTaskSearch::setProjectTaskAssignmentJoin()
     * @uses ProjectTaskSearch::setResourceAllocationJoin()
     * @uses ProjectTaskSearch::setSuccessorJoin()
     * @uses ProjectTaskSearch::setTimeJoin()
     * @uses ProjectTaskSearch::setTransactionJoin()
     * @uses ProjectTaskSearch::setUserJoin()
     * @uses ProjectTaskSearch::setUserNotesJoin()
     * @uses ProjectTaskSearch::setCustomSearchJoin()
     * @param \StructType\ProjectTaskSearchBasic $basic
     * @param \StructType\JobSearchBasic $jobJoin
     * @param \StructType\ProjectTaskSearchBasic $predecessorJoin
     * @param \StructType\ProjectTaskAssignmentSearchBasic $projectTaskAssignmentJoin
     * @param \StructType\ResourceAllocationSearchBasic $resourceAllocationJoin
     * @param \StructType\ProjectTaskSearchBasic $successorJoin
     * @param \StructType\TimeBillSearchBasic $timeJoin
     * @param \StructType\TransactionSearchBasic $transactionJoin
     * @param \StructType\EmployeeSearchBasic $userJoin
     * @param \StructType\NoteSearchBasic $userNotesJoin
     * @param \StructType\CustomSearchJoin[] $customSearchJoin
     */
    public function __construct(\StructType\ProjectTaskSearchBasic $basic = null, \StructType\JobSearchBasic $jobJoin = null, \StructType\ProjectTaskSearchBasic $predecessorJoin = null, \StructType\ProjectTaskAssignmentSearchBasic $projectTaskAssignmentJoin = null, \StructType\ResourceAllocationSearchBasic $resourceAllocationJoin = null, \StructType\ProjectTaskSearchBasic $successorJoin = null, \StructType\TimeBillSearchBasic $timeJoin = null, \StructType\TransactionSearchBasic $transactionJoin = null, \StructType\EmployeeSearchBasic $userJoin = null, \StructType\NoteSearchBasic $userNotesJoin = null, array $customSearchJoin = array())
    {
        $this
            ->setBasic($basic)
            ->setJobJoin($jobJoin)
            ->setPredecessorJoin($predecessorJoin)
            ->setProjectTaskAssignmentJoin($projectTaskAssignmentJoin)
            ->setResourceAllocationJoin($resourceAllocationJoin)
            ->setSuccessorJoin($successorJoin)
            ->setTimeJoin($timeJoin)
            ->setTransactionJoin($transactionJoin)
            ->setUserJoin($userJoin)
            ->setUserNotesJoin($userNotesJoin)
            ->setCustomSearchJoin($customSearchJoin);
    }
    /**
     * Get basic value
     * @return \StructType\ProjectTaskSearchBasic|null
     */
    public function getBasic()
    {
        return $this->basic;
    }
    /**
     * Set basic value
     * @param \StructType\ProjectTaskSearchBasic $basic
     * @return \StructType\ProjectTaskSearch
     */
    public function setBasic(\StructType\ProjectTaskSearchBasic $basic = null)
    {
        $this->basic = $basic;
        return $this;
    }
    /**
     * Get jobJoin value
     * @return \StructType\JobSearchBasic|null
     */
    public function getJobJoin()
    {
        return $this->jobJoin;
    }
    /**
     * Set jobJoin value
     * @param \StructType\JobSearchBasic $jobJoin
     * @return \StructType\ProjectTaskSearch
     */
    public function setJobJoin(\StructType\JobSearchBasic $jobJoin = null)
    {
        $this->jobJoin = $jobJoin;
        return $this;
    }
    /**
     * Get predecessorJoin value
     * @return \StructType\ProjectTaskSearchBasic|null
     */
    public function getPredecessorJoin()
    {
        return $this->predecessorJoin;
    }
    /**
     * Set predecessorJoin value
     * @param \StructType\ProjectTaskSearchBasic $predecessorJoin
     * @return \StructType\ProjectTaskSearch
     */
    public function setPredecessorJoin(\StructType\ProjectTaskSearchBasic $predecessorJoin = null)
    {
        $this->predecessorJoin = $predecessorJoin;
        return $this;
    }
    /**
     * Get projectTaskAssignmentJoin value
     * @return \StructType\ProjectTaskAssignmentSearchBasic|null
     */
    public function getProjectTaskAssignmentJoin()
    {
        return $this->projectTaskAssignmentJoin;
    }
    /**
     * Set projectTaskAssignmentJoin value
     * @param \StructType\ProjectTaskAssignmentSearchBasic $projectTaskAssignmentJoin
     * @return \StructType\ProjectTaskSearch
     */
    public function setProjectTaskAssignmentJoin(\StructType\ProjectTaskAssignmentSearchBasic $projectTaskAssignmentJoin = null)
    {
        $this->projectTaskAssignmentJoin = $projectTaskAssignmentJoin;
        return $this;
    }
    /**
     * Get resourceAllocationJoin value
     * @return \StructType\ResourceAllocationSearchBasic|null
     */
    public function getResourceAllocationJoin()
    {
        return $this->resourceAllocationJoin;
    }
    /**
     * Set resourceAllocationJoin value
     * @param \StructType\ResourceAllocationSearchBasic $resourceAllocationJoin
     * @return \StructType\ProjectTaskSearch
     */
    public function setResourceAllocationJoin(\StructType\ResourceAllocationSearchBasic $resourceAllocationJoin = null)
    {
        $this->resourceAllocationJoin = $resourceAllocationJoin;
        return $this;
    }
    /**
     * Get successorJoin value
     * @return \StructType\ProjectTaskSearchBasic|null
     */
    public function getSuccessorJoin()
    {
        return $this->successorJoin;
    }
    /**
     * Set successorJoin value
     * @param \StructType\ProjectTaskSearchBasic $successorJoin
     * @return \StructType\ProjectTaskSearch
     */
    public function setSuccessorJoin(\StructType\ProjectTaskSearchBasic $successorJoin = null)
    {
        $this->successorJoin = $successorJoin;
        return $this;
    }
    /**
     * Get timeJoin value
     * @return \StructType\TimeBillSearchBasic|null
     */
    public function getTimeJoin()
    {
        return $this->timeJoin;
    }
    /**
     * Set timeJoin value
     * @param \StructType\TimeBillSearchBasic $timeJoin
     * @return \StructType\ProjectTaskSearch
     */
    public function setTimeJoin(\StructType\TimeBillSearchBasic $timeJoin = null)
    {
        $this->timeJoin = $timeJoin;
        return $this;
    }
    /**
     * Get transactionJoin value
     * @return \StructType\TransactionSearchBasic|null
     */
    public function getTransactionJoin()
    {
        return $this->transactionJoin;
    }
    /**
     * Set transactionJoin value
     * @param \StructType\TransactionSearchBasic $transactionJoin
     * @return \StructType\ProjectTaskSearch
     */
    public function setTransactionJoin(\StructType\TransactionSearchBasic $transactionJoin = null)
    {
        $this->transactionJoin = $transactionJoin;
        return $this;
    }
    /**
     * Get userJoin value
     * @return \StructType\EmployeeSearchBasic|null
     */
    public function getUserJoin()
    {
        return $this->userJoin;
    }
    /**
     * Set userJoin value
     * @param \StructType\EmployeeSearchBasic $userJoin
     * @return \StructType\ProjectTaskSearch
     */
    public function setUserJoin(\StructType\EmployeeSearchBasic $userJoin = null)
    {
        $this->userJoin = $userJoin;
        return $this;
    }
    /**
     * Get userNotesJoin value
     * @return \StructType\NoteSearchBasic|null
     */
    public function getUserNotesJoin()
    {
        return $this->userNotesJoin;
    }
    /**
     * Set userNotesJoin value
     * @param \StructType\NoteSearchBasic $userNotesJoin
     * @return \StructType\ProjectTaskSearch
     */
    public function setUserNotesJoin(\StructType\NoteSearchBasic $userNotesJoin = null)
    {
        $this->userNotesJoin = $userNotesJoin;
        return $this;
    }
    /**
     * Get customSearchJoin value
     * @return \StructType\CustomSearchJoin[]|null
     */
    public function getCustomSearchJoin()
    {
        return $this->customSearchJoin;
    }
    /**
     * This method is responsible for validating the values passed to the setCustomSearchJoin method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCustomSearchJoin method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCustomSearchJoinForArrayConstraintsFromSetCustomSearchJoin(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $projectTaskSearchCustomSearchJoinItem) {
            // validation for constraint: itemType
            if (!$projectTaskSearchCustomSearchJoinItem instanceof \StructType\CustomSearchJoin) {
                $invalidValues[] = is_object($projectTaskSearchCustomSearchJoinItem) ? get_class($projectTaskSearchCustomSearchJoinItem) : sprintf('%s(%s)', gettype($projectTaskSearchCustomSearchJoinItem), var_export($projectTaskSearchCustomSearchJoinItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The customSearchJoin property can only contain items of type \StructType\CustomSearchJoin, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set customSearchJoin value
     * @throws \InvalidArgumentException
     * @param \StructType\CustomSearchJoin[] $customSearchJoin
     * @return \StructType\ProjectTaskSearch
     */
    public function setCustomSearchJoin(array $customSearchJoin = array())
    {
        // validation for constraint: array
        if ('' !== ($customSearchJoinArrayErrorMessage = self::validateCustomSearchJoinForArrayConstraintsFromSetCustomSearchJoin($customSearchJoin))) {
            throw new \InvalidArgumentException($customSearchJoinArrayErrorMessage, __LINE__);
        }
        $this->customSearchJoin = $customSearchJoin;
        return $this;
    }
    /**
     * Add item to customSearchJoin value
     * @throws \InvalidArgumentException
     * @param \StructType\CustomSearchJoin $item
     * @return \StructType\ProjectTaskSearch
     */
    public function addToCustomSearchJoin(\StructType\CustomSearchJoin $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\CustomSearchJoin) {
            throw new \InvalidArgumentException(sprintf('The customSearchJoin property can only contain items of type \StructType\CustomSearchJoin, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->customSearchJoin[] = $item;
        return $this;
    }
}
