<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ProjectTaskPredecessor StructType
 * @subpackage Structs
 */
class ProjectTaskPredecessor extends AbstractStructBase
{
    /**
     * The task
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $task;
    /**
     * The type
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $type;
    /**
     * The lagDays
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $lagDays;
    /**
     * The startDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $startDate;
    /**
     * The endDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $endDate;
    /**
     * Constructor method for ProjectTaskPredecessor
     * @uses ProjectTaskPredecessor::setTask()
     * @uses ProjectTaskPredecessor::setType()
     * @uses ProjectTaskPredecessor::setLagDays()
     * @uses ProjectTaskPredecessor::setStartDate()
     * @uses ProjectTaskPredecessor::setEndDate()
     * @param \StructType\RecordRef $task
     * @param string $type
     * @param float $lagDays
     * @param string $startDate
     * @param string $endDate
     */
    public function __construct(\StructType\RecordRef $task = null, $type = null, $lagDays = null, $startDate = null, $endDate = null)
    {
        $this
            ->setTask($task)
            ->setType($type)
            ->setLagDays($lagDays)
            ->setStartDate($startDate)
            ->setEndDate($endDate);
    }
    /**
     * Get task value
     * @return \StructType\RecordRef|null
     */
    public function getTask()
    {
        return $this->task;
    }
    /**
     * Set task value
     * @param \StructType\RecordRef $task
     * @return \StructType\ProjectTaskPredecessor
     */
    public function setTask(\StructType\RecordRef $task = null)
    {
        $this->task = $task;
        return $this;
    }
    /**
     * Get type value
     * @return string|null
     */
    public function getType()
    {
        return $this->type;
    }
    /**
     * Set type value
     * @uses \EnumType\ProjectTaskPredecessorPredecessorType::valueIsValid()
     * @uses \EnumType\ProjectTaskPredecessorPredecessorType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $type
     * @return \StructType\ProjectTaskPredecessor
     */
    public function setType($type = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\ProjectTaskPredecessorPredecessorType::valueIsValid($type)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\ProjectTaskPredecessorPredecessorType', is_array($type) ? implode(', ', $type) : var_export($type, true), implode(', ', \EnumType\ProjectTaskPredecessorPredecessorType::getValidValues())), __LINE__);
        }
        $this->type = $type;
        return $this;
    }
    /**
     * Get lagDays value
     * @return float|null
     */
    public function getLagDays()
    {
        return $this->lagDays;
    }
    /**
     * Set lagDays value
     * @param float $lagDays
     * @return \StructType\ProjectTaskPredecessor
     */
    public function setLagDays($lagDays = null)
    {
        // validation for constraint: float
        if (!is_null($lagDays) && !(is_float($lagDays) || is_numeric($lagDays))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($lagDays, true), gettype($lagDays)), __LINE__);
        }
        $this->lagDays = $lagDays;
        return $this;
    }
    /**
     * Get startDate value
     * @return string|null
     */
    public function getStartDate()
    {
        return $this->startDate;
    }
    /**
     * Set startDate value
     * @param string $startDate
     * @return \StructType\ProjectTaskPredecessor
     */
    public function setStartDate($startDate = null)
    {
        // validation for constraint: string
        if (!is_null($startDate) && !is_string($startDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($startDate, true), gettype($startDate)), __LINE__);
        }
        $this->startDate = $startDate;
        return $this;
    }
    /**
     * Get endDate value
     * @return string|null
     */
    public function getEndDate()
    {
        return $this->endDate;
    }
    /**
     * Set endDate value
     * @param string $endDate
     * @return \StructType\ProjectTaskPredecessor
     */
    public function setEndDate($endDate = null)
    {
        // validation for constraint: string
        if (!is_null($endDate) && !is_string($endDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($endDate, true), gettype($endDate)), __LINE__);
        }
        $this->endDate = $endDate;
        return $this;
    }
}
