<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ProjectTaskAssignmentSearchRowBasic StructType
 * @subpackage Structs
 */
class ProjectTaskAssignmentSearchRowBasic extends SearchRowBasic
{
    /**
     * The actualWork
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SearchColumnDoubleField[]
     */
    public $actualWork;
    /**
     * The cost
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SearchColumnDoubleField[]
     */
    public $cost;
    /**
     * The costBase
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SearchColumnDoubleField[]
     */
    public $costBase;
    /**
     * The endDate
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SearchColumnDateField[]
     */
    public $endDate;
    /**
     * The estimatedWork
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SearchColumnDoubleField[]
     */
    public $estimatedWork;
    /**
     * The estimatedWorkBaseline
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SearchColumnDoubleField[]
     */
    public $estimatedWorkBaseline;
    /**
     * The grossProfit
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SearchColumnDoubleField[]
     */
    public $grossProfit;
    /**
     * The grossProfitBase
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SearchColumnDoubleField[]
     */
    public $grossProfitBase;
    /**
     * The internalId
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SearchColumnSelectField[]
     */
    public $internalId;
    /**
     * The plannedWork
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SearchColumnDoubleField[]
     */
    public $plannedWork;
    /**
     * The plannedWorkBaseline
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SearchColumnDoubleField[]
     */
    public $plannedWorkBaseline;
    /**
     * The price
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SearchColumnDoubleField[]
     */
    public $price;
    /**
     * The priceBase
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SearchColumnDoubleField[]
     */
    public $priceBase;
    /**
     * The resource
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SearchColumnSelectField[]
     */
    public $resource;
    /**
     * The resourceName
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SearchColumnStringField[]
     */
    public $resourceName;
    /**
     * The serviceItem
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SearchColumnStringField[]
     */
    public $serviceItem;
    /**
     * The serviceItemDesc
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SearchColumnStringField[]
     */
    public $serviceItemDesc;
    /**
     * The startDate
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SearchColumnDateField[]
     */
    public $startDate;
    /**
     * The unitCost
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SearchColumnDoubleField[]
     */
    public $unitCost;
    /**
     * The unitCostBase
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SearchColumnDoubleField[]
     */
    public $unitCostBase;
    /**
     * The unitPrice
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SearchColumnDoubleField[]
     */
    public $unitPrice;
    /**
     * The unitPriceBase
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SearchColumnDoubleField[]
     */
    public $unitPriceBase;
    /**
     * The units
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SearchColumnDoubleField[]
     */
    public $units;
    /**
     * The workCalendar
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SearchColumnSelectField[]
     */
    public $workCalendar;
    /**
     * Constructor method for ProjectTaskAssignmentSearchRowBasic
     * @uses ProjectTaskAssignmentSearchRowBasic::setActualWork()
     * @uses ProjectTaskAssignmentSearchRowBasic::setCost()
     * @uses ProjectTaskAssignmentSearchRowBasic::setCostBase()
     * @uses ProjectTaskAssignmentSearchRowBasic::setEndDate()
     * @uses ProjectTaskAssignmentSearchRowBasic::setEstimatedWork()
     * @uses ProjectTaskAssignmentSearchRowBasic::setEstimatedWorkBaseline()
     * @uses ProjectTaskAssignmentSearchRowBasic::setGrossProfit()
     * @uses ProjectTaskAssignmentSearchRowBasic::setGrossProfitBase()
     * @uses ProjectTaskAssignmentSearchRowBasic::setInternalId()
     * @uses ProjectTaskAssignmentSearchRowBasic::setPlannedWork()
     * @uses ProjectTaskAssignmentSearchRowBasic::setPlannedWorkBaseline()
     * @uses ProjectTaskAssignmentSearchRowBasic::setPrice()
     * @uses ProjectTaskAssignmentSearchRowBasic::setPriceBase()
     * @uses ProjectTaskAssignmentSearchRowBasic::setResource()
     * @uses ProjectTaskAssignmentSearchRowBasic::setResourceName()
     * @uses ProjectTaskAssignmentSearchRowBasic::setServiceItem()
     * @uses ProjectTaskAssignmentSearchRowBasic::setServiceItemDesc()
     * @uses ProjectTaskAssignmentSearchRowBasic::setStartDate()
     * @uses ProjectTaskAssignmentSearchRowBasic::setUnitCost()
     * @uses ProjectTaskAssignmentSearchRowBasic::setUnitCostBase()
     * @uses ProjectTaskAssignmentSearchRowBasic::setUnitPrice()
     * @uses ProjectTaskAssignmentSearchRowBasic::setUnitPriceBase()
     * @uses ProjectTaskAssignmentSearchRowBasic::setUnits()
     * @uses ProjectTaskAssignmentSearchRowBasic::setWorkCalendar()
     * @param \StructType\SearchColumnDoubleField[] $actualWork
     * @param \StructType\SearchColumnDoubleField[] $cost
     * @param \StructType\SearchColumnDoubleField[] $costBase
     * @param \StructType\SearchColumnDateField[] $endDate
     * @param \StructType\SearchColumnDoubleField[] $estimatedWork
     * @param \StructType\SearchColumnDoubleField[] $estimatedWorkBaseline
     * @param \StructType\SearchColumnDoubleField[] $grossProfit
     * @param \StructType\SearchColumnDoubleField[] $grossProfitBase
     * @param \StructType\SearchColumnSelectField[] $internalId
     * @param \StructType\SearchColumnDoubleField[] $plannedWork
     * @param \StructType\SearchColumnDoubleField[] $plannedWorkBaseline
     * @param \StructType\SearchColumnDoubleField[] $price
     * @param \StructType\SearchColumnDoubleField[] $priceBase
     * @param \StructType\SearchColumnSelectField[] $resource
     * @param \StructType\SearchColumnStringField[] $resourceName
     * @param \StructType\SearchColumnStringField[] $serviceItem
     * @param \StructType\SearchColumnStringField[] $serviceItemDesc
     * @param \StructType\SearchColumnDateField[] $startDate
     * @param \StructType\SearchColumnDoubleField[] $unitCost
     * @param \StructType\SearchColumnDoubleField[] $unitCostBase
     * @param \StructType\SearchColumnDoubleField[] $unitPrice
     * @param \StructType\SearchColumnDoubleField[] $unitPriceBase
     * @param \StructType\SearchColumnDoubleField[] $units
     * @param \StructType\SearchColumnSelectField[] $workCalendar
     */
    public function __construct(array $actualWork = array(), array $cost = array(), array $costBase = array(), array $endDate = array(), array $estimatedWork = array(), array $estimatedWorkBaseline = array(), array $grossProfit = array(), array $grossProfitBase = array(), array $internalId = array(), array $plannedWork = array(), array $plannedWorkBaseline = array(), array $price = array(), array $priceBase = array(), array $resource = array(), array $resourceName = array(), array $serviceItem = array(), array $serviceItemDesc = array(), array $startDate = array(), array $unitCost = array(), array $unitCostBase = array(), array $unitPrice = array(), array $unitPriceBase = array(), array $units = array(), array $workCalendar = array())
    {
        $this
            ->setActualWork($actualWork)
            ->setCost($cost)
            ->setCostBase($costBase)
            ->setEndDate($endDate)
            ->setEstimatedWork($estimatedWork)
            ->setEstimatedWorkBaseline($estimatedWorkBaseline)
            ->setGrossProfit($grossProfit)
            ->setGrossProfitBase($grossProfitBase)
            ->setInternalId($internalId)
            ->setPlannedWork($plannedWork)
            ->setPlannedWorkBaseline($plannedWorkBaseline)
            ->setPrice($price)
            ->setPriceBase($priceBase)
            ->setResource($resource)
            ->setResourceName($resourceName)
            ->setServiceItem($serviceItem)
            ->setServiceItemDesc($serviceItemDesc)
            ->setStartDate($startDate)
            ->setUnitCost($unitCost)
            ->setUnitCostBase($unitCostBase)
            ->setUnitPrice($unitPrice)
            ->setUnitPriceBase($unitPriceBase)
            ->setUnits($units)
            ->setWorkCalendar($workCalendar);
    }
    /**
     * Get actualWork value
     * @return \StructType\SearchColumnDoubleField[]|null
     */
    public function getActualWork()
    {
        return $this->actualWork;
    }
    /**
     * This method is responsible for validating the values passed to the setActualWork method
     * This method is willingly generated in order to preserve the one-line inline validation within the setActualWork method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateActualWorkForArrayConstraintsFromSetActualWork(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $projectTaskAssignmentSearchRowBasicActualWorkItem) {
            // validation for constraint: itemType
            if (!$projectTaskAssignmentSearchRowBasicActualWorkItem instanceof \StructType\SearchColumnDoubleField) {
                $invalidValues[] = is_object($projectTaskAssignmentSearchRowBasicActualWorkItem) ? get_class($projectTaskAssignmentSearchRowBasicActualWorkItem) : sprintf('%s(%s)', gettype($projectTaskAssignmentSearchRowBasicActualWorkItem), var_export($projectTaskAssignmentSearchRowBasicActualWorkItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The actualWork property can only contain items of type \StructType\SearchColumnDoubleField, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set actualWork value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnDoubleField[] $actualWork
     * @return \StructType\ProjectTaskAssignmentSearchRowBasic
     */
    public function setActualWork(array $actualWork = array())
    {
        // validation for constraint: array
        if ('' !== ($actualWorkArrayErrorMessage = self::validateActualWorkForArrayConstraintsFromSetActualWork($actualWork))) {
            throw new \InvalidArgumentException($actualWorkArrayErrorMessage, __LINE__);
        }
        $this->actualWork = $actualWork;
        return $this;
    }
    /**
     * Add item to actualWork value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnDoubleField $item
     * @return \StructType\ProjectTaskAssignmentSearchRowBasic
     */
    public function addToActualWork(\StructType\SearchColumnDoubleField $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SearchColumnDoubleField) {
            throw new \InvalidArgumentException(sprintf('The actualWork property can only contain items of type \StructType\SearchColumnDoubleField, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->actualWork[] = $item;
        return $this;
    }
    /**
     * Get cost value
     * @return \StructType\SearchColumnDoubleField[]|null
     */
    public function getCost()
    {
        return $this->cost;
    }
    /**
     * This method is responsible for validating the values passed to the setCost method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCost method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCostForArrayConstraintsFromSetCost(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $projectTaskAssignmentSearchRowBasicCostItem) {
            // validation for constraint: itemType
            if (!$projectTaskAssignmentSearchRowBasicCostItem instanceof \StructType\SearchColumnDoubleField) {
                $invalidValues[] = is_object($projectTaskAssignmentSearchRowBasicCostItem) ? get_class($projectTaskAssignmentSearchRowBasicCostItem) : sprintf('%s(%s)', gettype($projectTaskAssignmentSearchRowBasicCostItem), var_export($projectTaskAssignmentSearchRowBasicCostItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The cost property can only contain items of type \StructType\SearchColumnDoubleField, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set cost value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnDoubleField[] $cost
     * @return \StructType\ProjectTaskAssignmentSearchRowBasic
     */
    public function setCost(array $cost = array())
    {
        // validation for constraint: array
        if ('' !== ($costArrayErrorMessage = self::validateCostForArrayConstraintsFromSetCost($cost))) {
            throw new \InvalidArgumentException($costArrayErrorMessage, __LINE__);
        }
        $this->cost = $cost;
        return $this;
    }
    /**
     * Add item to cost value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnDoubleField $item
     * @return \StructType\ProjectTaskAssignmentSearchRowBasic
     */
    public function addToCost(\StructType\SearchColumnDoubleField $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SearchColumnDoubleField) {
            throw new \InvalidArgumentException(sprintf('The cost property can only contain items of type \StructType\SearchColumnDoubleField, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->cost[] = $item;
        return $this;
    }
    /**
     * Get costBase value
     * @return \StructType\SearchColumnDoubleField[]|null
     */
    public function getCostBase()
    {
        return $this->costBase;
    }
    /**
     * This method is responsible for validating the values passed to the setCostBase method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCostBase method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCostBaseForArrayConstraintsFromSetCostBase(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $projectTaskAssignmentSearchRowBasicCostBaseItem) {
            // validation for constraint: itemType
            if (!$projectTaskAssignmentSearchRowBasicCostBaseItem instanceof \StructType\SearchColumnDoubleField) {
                $invalidValues[] = is_object($projectTaskAssignmentSearchRowBasicCostBaseItem) ? get_class($projectTaskAssignmentSearchRowBasicCostBaseItem) : sprintf('%s(%s)', gettype($projectTaskAssignmentSearchRowBasicCostBaseItem), var_export($projectTaskAssignmentSearchRowBasicCostBaseItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The costBase property can only contain items of type \StructType\SearchColumnDoubleField, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set costBase value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnDoubleField[] $costBase
     * @return \StructType\ProjectTaskAssignmentSearchRowBasic
     */
    public function setCostBase(array $costBase = array())
    {
        // validation for constraint: array
        if ('' !== ($costBaseArrayErrorMessage = self::validateCostBaseForArrayConstraintsFromSetCostBase($costBase))) {
            throw new \InvalidArgumentException($costBaseArrayErrorMessage, __LINE__);
        }
        $this->costBase = $costBase;
        return $this;
    }
    /**
     * Add item to costBase value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnDoubleField $item
     * @return \StructType\ProjectTaskAssignmentSearchRowBasic
     */
    public function addToCostBase(\StructType\SearchColumnDoubleField $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SearchColumnDoubleField) {
            throw new \InvalidArgumentException(sprintf('The costBase property can only contain items of type \StructType\SearchColumnDoubleField, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->costBase[] = $item;
        return $this;
    }
    /**
     * Get endDate value
     * @return \StructType\SearchColumnDateField[]|null
     */
    public function getEndDate()
    {
        return $this->endDate;
    }
    /**
     * This method is responsible for validating the values passed to the setEndDate method
     * This method is willingly generated in order to preserve the one-line inline validation within the setEndDate method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateEndDateForArrayConstraintsFromSetEndDate(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $projectTaskAssignmentSearchRowBasicEndDateItem) {
            // validation for constraint: itemType
            if (!$projectTaskAssignmentSearchRowBasicEndDateItem instanceof \StructType\SearchColumnDateField) {
                $invalidValues[] = is_object($projectTaskAssignmentSearchRowBasicEndDateItem) ? get_class($projectTaskAssignmentSearchRowBasicEndDateItem) : sprintf('%s(%s)', gettype($projectTaskAssignmentSearchRowBasicEndDateItem), var_export($projectTaskAssignmentSearchRowBasicEndDateItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The endDate property can only contain items of type \StructType\SearchColumnDateField, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set endDate value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnDateField[] $endDate
     * @return \StructType\ProjectTaskAssignmentSearchRowBasic
     */
    public function setEndDate(array $endDate = array())
    {
        // validation for constraint: array
        if ('' !== ($endDateArrayErrorMessage = self::validateEndDateForArrayConstraintsFromSetEndDate($endDate))) {
            throw new \InvalidArgumentException($endDateArrayErrorMessage, __LINE__);
        }
        $this->endDate = $endDate;
        return $this;
    }
    /**
     * Add item to endDate value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnDateField $item
     * @return \StructType\ProjectTaskAssignmentSearchRowBasic
     */
    public function addToEndDate(\StructType\SearchColumnDateField $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SearchColumnDateField) {
            throw new \InvalidArgumentException(sprintf('The endDate property can only contain items of type \StructType\SearchColumnDateField, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->endDate[] = $item;
        return $this;
    }
    /**
     * Get estimatedWork value
     * @return \StructType\SearchColumnDoubleField[]|null
     */
    public function getEstimatedWork()
    {
        return $this->estimatedWork;
    }
    /**
     * This method is responsible for validating the values passed to the setEstimatedWork method
     * This method is willingly generated in order to preserve the one-line inline validation within the setEstimatedWork method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateEstimatedWorkForArrayConstraintsFromSetEstimatedWork(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $projectTaskAssignmentSearchRowBasicEstimatedWorkItem) {
            // validation for constraint: itemType
            if (!$projectTaskAssignmentSearchRowBasicEstimatedWorkItem instanceof \StructType\SearchColumnDoubleField) {
                $invalidValues[] = is_object($projectTaskAssignmentSearchRowBasicEstimatedWorkItem) ? get_class($projectTaskAssignmentSearchRowBasicEstimatedWorkItem) : sprintf('%s(%s)', gettype($projectTaskAssignmentSearchRowBasicEstimatedWorkItem), var_export($projectTaskAssignmentSearchRowBasicEstimatedWorkItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The estimatedWork property can only contain items of type \StructType\SearchColumnDoubleField, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set estimatedWork value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnDoubleField[] $estimatedWork
     * @return \StructType\ProjectTaskAssignmentSearchRowBasic
     */
    public function setEstimatedWork(array $estimatedWork = array())
    {
        // validation for constraint: array
        if ('' !== ($estimatedWorkArrayErrorMessage = self::validateEstimatedWorkForArrayConstraintsFromSetEstimatedWork($estimatedWork))) {
            throw new \InvalidArgumentException($estimatedWorkArrayErrorMessage, __LINE__);
        }
        $this->estimatedWork = $estimatedWork;
        return $this;
    }
    /**
     * Add item to estimatedWork value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnDoubleField $item
     * @return \StructType\ProjectTaskAssignmentSearchRowBasic
     */
    public function addToEstimatedWork(\StructType\SearchColumnDoubleField $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SearchColumnDoubleField) {
            throw new \InvalidArgumentException(sprintf('The estimatedWork property can only contain items of type \StructType\SearchColumnDoubleField, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->estimatedWork[] = $item;
        return $this;
    }
    /**
     * Get estimatedWorkBaseline value
     * @return \StructType\SearchColumnDoubleField[]|null
     */
    public function getEstimatedWorkBaseline()
    {
        return $this->estimatedWorkBaseline;
    }
    /**
     * This method is responsible for validating the values passed to the setEstimatedWorkBaseline method
     * This method is willingly generated in order to preserve the one-line inline validation within the setEstimatedWorkBaseline method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateEstimatedWorkBaselineForArrayConstraintsFromSetEstimatedWorkBaseline(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $projectTaskAssignmentSearchRowBasicEstimatedWorkBaselineItem) {
            // validation for constraint: itemType
            if (!$projectTaskAssignmentSearchRowBasicEstimatedWorkBaselineItem instanceof \StructType\SearchColumnDoubleField) {
                $invalidValues[] = is_object($projectTaskAssignmentSearchRowBasicEstimatedWorkBaselineItem) ? get_class($projectTaskAssignmentSearchRowBasicEstimatedWorkBaselineItem) : sprintf('%s(%s)', gettype($projectTaskAssignmentSearchRowBasicEstimatedWorkBaselineItem), var_export($projectTaskAssignmentSearchRowBasicEstimatedWorkBaselineItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The estimatedWorkBaseline property can only contain items of type \StructType\SearchColumnDoubleField, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set estimatedWorkBaseline value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnDoubleField[] $estimatedWorkBaseline
     * @return \StructType\ProjectTaskAssignmentSearchRowBasic
     */
    public function setEstimatedWorkBaseline(array $estimatedWorkBaseline = array())
    {
        // validation for constraint: array
        if ('' !== ($estimatedWorkBaselineArrayErrorMessage = self::validateEstimatedWorkBaselineForArrayConstraintsFromSetEstimatedWorkBaseline($estimatedWorkBaseline))) {
            throw new \InvalidArgumentException($estimatedWorkBaselineArrayErrorMessage, __LINE__);
        }
        $this->estimatedWorkBaseline = $estimatedWorkBaseline;
        return $this;
    }
    /**
     * Add item to estimatedWorkBaseline value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnDoubleField $item
     * @return \StructType\ProjectTaskAssignmentSearchRowBasic
     */
    public function addToEstimatedWorkBaseline(\StructType\SearchColumnDoubleField $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SearchColumnDoubleField) {
            throw new \InvalidArgumentException(sprintf('The estimatedWorkBaseline property can only contain items of type \StructType\SearchColumnDoubleField, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->estimatedWorkBaseline[] = $item;
        return $this;
    }
    /**
     * Get grossProfit value
     * @return \StructType\SearchColumnDoubleField[]|null
     */
    public function getGrossProfit()
    {
        return $this->grossProfit;
    }
    /**
     * This method is responsible for validating the values passed to the setGrossProfit method
     * This method is willingly generated in order to preserve the one-line inline validation within the setGrossProfit method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateGrossProfitForArrayConstraintsFromSetGrossProfit(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $projectTaskAssignmentSearchRowBasicGrossProfitItem) {
            // validation for constraint: itemType
            if (!$projectTaskAssignmentSearchRowBasicGrossProfitItem instanceof \StructType\SearchColumnDoubleField) {
                $invalidValues[] = is_object($projectTaskAssignmentSearchRowBasicGrossProfitItem) ? get_class($projectTaskAssignmentSearchRowBasicGrossProfitItem) : sprintf('%s(%s)', gettype($projectTaskAssignmentSearchRowBasicGrossProfitItem), var_export($projectTaskAssignmentSearchRowBasicGrossProfitItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The grossProfit property can only contain items of type \StructType\SearchColumnDoubleField, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set grossProfit value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnDoubleField[] $grossProfit
     * @return \StructType\ProjectTaskAssignmentSearchRowBasic
     */
    public function setGrossProfit(array $grossProfit = array())
    {
        // validation for constraint: array
        if ('' !== ($grossProfitArrayErrorMessage = self::validateGrossProfitForArrayConstraintsFromSetGrossProfit($grossProfit))) {
            throw new \InvalidArgumentException($grossProfitArrayErrorMessage, __LINE__);
        }
        $this->grossProfit = $grossProfit;
        return $this;
    }
    /**
     * Add item to grossProfit value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnDoubleField $item
     * @return \StructType\ProjectTaskAssignmentSearchRowBasic
     */
    public function addToGrossProfit(\StructType\SearchColumnDoubleField $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SearchColumnDoubleField) {
            throw new \InvalidArgumentException(sprintf('The grossProfit property can only contain items of type \StructType\SearchColumnDoubleField, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->grossProfit[] = $item;
        return $this;
    }
    /**
     * Get grossProfitBase value
     * @return \StructType\SearchColumnDoubleField[]|null
     */
    public function getGrossProfitBase()
    {
        return $this->grossProfitBase;
    }
    /**
     * This method is responsible for validating the values passed to the setGrossProfitBase method
     * This method is willingly generated in order to preserve the one-line inline validation within the setGrossProfitBase method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateGrossProfitBaseForArrayConstraintsFromSetGrossProfitBase(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $projectTaskAssignmentSearchRowBasicGrossProfitBaseItem) {
            // validation for constraint: itemType
            if (!$projectTaskAssignmentSearchRowBasicGrossProfitBaseItem instanceof \StructType\SearchColumnDoubleField) {
                $invalidValues[] = is_object($projectTaskAssignmentSearchRowBasicGrossProfitBaseItem) ? get_class($projectTaskAssignmentSearchRowBasicGrossProfitBaseItem) : sprintf('%s(%s)', gettype($projectTaskAssignmentSearchRowBasicGrossProfitBaseItem), var_export($projectTaskAssignmentSearchRowBasicGrossProfitBaseItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The grossProfitBase property can only contain items of type \StructType\SearchColumnDoubleField, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set grossProfitBase value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnDoubleField[] $grossProfitBase
     * @return \StructType\ProjectTaskAssignmentSearchRowBasic
     */
    public function setGrossProfitBase(array $grossProfitBase = array())
    {
        // validation for constraint: array
        if ('' !== ($grossProfitBaseArrayErrorMessage = self::validateGrossProfitBaseForArrayConstraintsFromSetGrossProfitBase($grossProfitBase))) {
            throw new \InvalidArgumentException($grossProfitBaseArrayErrorMessage, __LINE__);
        }
        $this->grossProfitBase = $grossProfitBase;
        return $this;
    }
    /**
     * Add item to grossProfitBase value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnDoubleField $item
     * @return \StructType\ProjectTaskAssignmentSearchRowBasic
     */
    public function addToGrossProfitBase(\StructType\SearchColumnDoubleField $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SearchColumnDoubleField) {
            throw new \InvalidArgumentException(sprintf('The grossProfitBase property can only contain items of type \StructType\SearchColumnDoubleField, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->grossProfitBase[] = $item;
        return $this;
    }
    /**
     * Get internalId value
     * @return \StructType\SearchColumnSelectField[]|null
     */
    public function getInternalId()
    {
        return $this->internalId;
    }
    /**
     * This method is responsible for validating the values passed to the setInternalId method
     * This method is willingly generated in order to preserve the one-line inline validation within the setInternalId method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateInternalIdForArrayConstraintsFromSetInternalId(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $projectTaskAssignmentSearchRowBasicInternalIdItem) {
            // validation for constraint: itemType
            if (!$projectTaskAssignmentSearchRowBasicInternalIdItem instanceof \StructType\SearchColumnSelectField) {
                $invalidValues[] = is_object($projectTaskAssignmentSearchRowBasicInternalIdItem) ? get_class($projectTaskAssignmentSearchRowBasicInternalIdItem) : sprintf('%s(%s)', gettype($projectTaskAssignmentSearchRowBasicInternalIdItem), var_export($projectTaskAssignmentSearchRowBasicInternalIdItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The internalId property can only contain items of type \StructType\SearchColumnSelectField, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set internalId value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnSelectField[] $internalId
     * @return \StructType\ProjectTaskAssignmentSearchRowBasic
     */
    public function setInternalId(array $internalId = array())
    {
        // validation for constraint: array
        if ('' !== ($internalIdArrayErrorMessage = self::validateInternalIdForArrayConstraintsFromSetInternalId($internalId))) {
            throw new \InvalidArgumentException($internalIdArrayErrorMessage, __LINE__);
        }
        $this->internalId = $internalId;
        return $this;
    }
    /**
     * Add item to internalId value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnSelectField $item
     * @return \StructType\ProjectTaskAssignmentSearchRowBasic
     */
    public function addToInternalId(\StructType\SearchColumnSelectField $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SearchColumnSelectField) {
            throw new \InvalidArgumentException(sprintf('The internalId property can only contain items of type \StructType\SearchColumnSelectField, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->internalId[] = $item;
        return $this;
    }
    /**
     * Get plannedWork value
     * @return \StructType\SearchColumnDoubleField[]|null
     */
    public function getPlannedWork()
    {
        return $this->plannedWork;
    }
    /**
     * This method is responsible for validating the values passed to the setPlannedWork method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPlannedWork method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePlannedWorkForArrayConstraintsFromSetPlannedWork(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $projectTaskAssignmentSearchRowBasicPlannedWorkItem) {
            // validation for constraint: itemType
            if (!$projectTaskAssignmentSearchRowBasicPlannedWorkItem instanceof \StructType\SearchColumnDoubleField) {
                $invalidValues[] = is_object($projectTaskAssignmentSearchRowBasicPlannedWorkItem) ? get_class($projectTaskAssignmentSearchRowBasicPlannedWorkItem) : sprintf('%s(%s)', gettype($projectTaskAssignmentSearchRowBasicPlannedWorkItem), var_export($projectTaskAssignmentSearchRowBasicPlannedWorkItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The plannedWork property can only contain items of type \StructType\SearchColumnDoubleField, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set plannedWork value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnDoubleField[] $plannedWork
     * @return \StructType\ProjectTaskAssignmentSearchRowBasic
     */
    public function setPlannedWork(array $plannedWork = array())
    {
        // validation for constraint: array
        if ('' !== ($plannedWorkArrayErrorMessage = self::validatePlannedWorkForArrayConstraintsFromSetPlannedWork($plannedWork))) {
            throw new \InvalidArgumentException($plannedWorkArrayErrorMessage, __LINE__);
        }
        $this->plannedWork = $plannedWork;
        return $this;
    }
    /**
     * Add item to plannedWork value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnDoubleField $item
     * @return \StructType\ProjectTaskAssignmentSearchRowBasic
     */
    public function addToPlannedWork(\StructType\SearchColumnDoubleField $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SearchColumnDoubleField) {
            throw new \InvalidArgumentException(sprintf('The plannedWork property can only contain items of type \StructType\SearchColumnDoubleField, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->plannedWork[] = $item;
        return $this;
    }
    /**
     * Get plannedWorkBaseline value
     * @return \StructType\SearchColumnDoubleField[]|null
     */
    public function getPlannedWorkBaseline()
    {
        return $this->plannedWorkBaseline;
    }
    /**
     * This method is responsible for validating the values passed to the setPlannedWorkBaseline method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPlannedWorkBaseline method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePlannedWorkBaselineForArrayConstraintsFromSetPlannedWorkBaseline(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $projectTaskAssignmentSearchRowBasicPlannedWorkBaselineItem) {
            // validation for constraint: itemType
            if (!$projectTaskAssignmentSearchRowBasicPlannedWorkBaselineItem instanceof \StructType\SearchColumnDoubleField) {
                $invalidValues[] = is_object($projectTaskAssignmentSearchRowBasicPlannedWorkBaselineItem) ? get_class($projectTaskAssignmentSearchRowBasicPlannedWorkBaselineItem) : sprintf('%s(%s)', gettype($projectTaskAssignmentSearchRowBasicPlannedWorkBaselineItem), var_export($projectTaskAssignmentSearchRowBasicPlannedWorkBaselineItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The plannedWorkBaseline property can only contain items of type \StructType\SearchColumnDoubleField, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set plannedWorkBaseline value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnDoubleField[] $plannedWorkBaseline
     * @return \StructType\ProjectTaskAssignmentSearchRowBasic
     */
    public function setPlannedWorkBaseline(array $plannedWorkBaseline = array())
    {
        // validation for constraint: array
        if ('' !== ($plannedWorkBaselineArrayErrorMessage = self::validatePlannedWorkBaselineForArrayConstraintsFromSetPlannedWorkBaseline($plannedWorkBaseline))) {
            throw new \InvalidArgumentException($plannedWorkBaselineArrayErrorMessage, __LINE__);
        }
        $this->plannedWorkBaseline = $plannedWorkBaseline;
        return $this;
    }
    /**
     * Add item to plannedWorkBaseline value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnDoubleField $item
     * @return \StructType\ProjectTaskAssignmentSearchRowBasic
     */
    public function addToPlannedWorkBaseline(\StructType\SearchColumnDoubleField $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SearchColumnDoubleField) {
            throw new \InvalidArgumentException(sprintf('The plannedWorkBaseline property can only contain items of type \StructType\SearchColumnDoubleField, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->plannedWorkBaseline[] = $item;
        return $this;
    }
    /**
     * Get price value
     * @return \StructType\SearchColumnDoubleField[]|null
     */
    public function getPrice()
    {
        return $this->price;
    }
    /**
     * This method is responsible for validating the values passed to the setPrice method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPrice method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePriceForArrayConstraintsFromSetPrice(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $projectTaskAssignmentSearchRowBasicPriceItem) {
            // validation for constraint: itemType
            if (!$projectTaskAssignmentSearchRowBasicPriceItem instanceof \StructType\SearchColumnDoubleField) {
                $invalidValues[] = is_object($projectTaskAssignmentSearchRowBasicPriceItem) ? get_class($projectTaskAssignmentSearchRowBasicPriceItem) : sprintf('%s(%s)', gettype($projectTaskAssignmentSearchRowBasicPriceItem), var_export($projectTaskAssignmentSearchRowBasicPriceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The price property can only contain items of type \StructType\SearchColumnDoubleField, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set price value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnDoubleField[] $price
     * @return \StructType\ProjectTaskAssignmentSearchRowBasic
     */
    public function setPrice(array $price = array())
    {
        // validation for constraint: array
        if ('' !== ($priceArrayErrorMessage = self::validatePriceForArrayConstraintsFromSetPrice($price))) {
            throw new \InvalidArgumentException($priceArrayErrorMessage, __LINE__);
        }
        $this->price = $price;
        return $this;
    }
    /**
     * Add item to price value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnDoubleField $item
     * @return \StructType\ProjectTaskAssignmentSearchRowBasic
     */
    public function addToPrice(\StructType\SearchColumnDoubleField $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SearchColumnDoubleField) {
            throw new \InvalidArgumentException(sprintf('The price property can only contain items of type \StructType\SearchColumnDoubleField, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->price[] = $item;
        return $this;
    }
    /**
     * Get priceBase value
     * @return \StructType\SearchColumnDoubleField[]|null
     */
    public function getPriceBase()
    {
        return $this->priceBase;
    }
    /**
     * This method is responsible for validating the values passed to the setPriceBase method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPriceBase method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePriceBaseForArrayConstraintsFromSetPriceBase(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $projectTaskAssignmentSearchRowBasicPriceBaseItem) {
            // validation for constraint: itemType
            if (!$projectTaskAssignmentSearchRowBasicPriceBaseItem instanceof \StructType\SearchColumnDoubleField) {
                $invalidValues[] = is_object($projectTaskAssignmentSearchRowBasicPriceBaseItem) ? get_class($projectTaskAssignmentSearchRowBasicPriceBaseItem) : sprintf('%s(%s)', gettype($projectTaskAssignmentSearchRowBasicPriceBaseItem), var_export($projectTaskAssignmentSearchRowBasicPriceBaseItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The priceBase property can only contain items of type \StructType\SearchColumnDoubleField, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set priceBase value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnDoubleField[] $priceBase
     * @return \StructType\ProjectTaskAssignmentSearchRowBasic
     */
    public function setPriceBase(array $priceBase = array())
    {
        // validation for constraint: array
        if ('' !== ($priceBaseArrayErrorMessage = self::validatePriceBaseForArrayConstraintsFromSetPriceBase($priceBase))) {
            throw new \InvalidArgumentException($priceBaseArrayErrorMessage, __LINE__);
        }
        $this->priceBase = $priceBase;
        return $this;
    }
    /**
     * Add item to priceBase value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnDoubleField $item
     * @return \StructType\ProjectTaskAssignmentSearchRowBasic
     */
    public function addToPriceBase(\StructType\SearchColumnDoubleField $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SearchColumnDoubleField) {
            throw new \InvalidArgumentException(sprintf('The priceBase property can only contain items of type \StructType\SearchColumnDoubleField, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->priceBase[] = $item;
        return $this;
    }
    /**
     * Get resource value
     * @return \StructType\SearchColumnSelectField[]|null
     */
    public function getResource()
    {
        return $this->resource;
    }
    /**
     * This method is responsible for validating the values passed to the setResource method
     * This method is willingly generated in order to preserve the one-line inline validation within the setResource method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateResourceForArrayConstraintsFromSetResource(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $projectTaskAssignmentSearchRowBasicResourceItem) {
            // validation for constraint: itemType
            if (!$projectTaskAssignmentSearchRowBasicResourceItem instanceof \StructType\SearchColumnSelectField) {
                $invalidValues[] = is_object($projectTaskAssignmentSearchRowBasicResourceItem) ? get_class($projectTaskAssignmentSearchRowBasicResourceItem) : sprintf('%s(%s)', gettype($projectTaskAssignmentSearchRowBasicResourceItem), var_export($projectTaskAssignmentSearchRowBasicResourceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The resource property can only contain items of type \StructType\SearchColumnSelectField, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set resource value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnSelectField[] $resource
     * @return \StructType\ProjectTaskAssignmentSearchRowBasic
     */
    public function setResource(array $resource = array())
    {
        // validation for constraint: array
        if ('' !== ($resourceArrayErrorMessage = self::validateResourceForArrayConstraintsFromSetResource($resource))) {
            throw new \InvalidArgumentException($resourceArrayErrorMessage, __LINE__);
        }
        $this->resource = $resource;
        return $this;
    }
    /**
     * Add item to resource value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnSelectField $item
     * @return \StructType\ProjectTaskAssignmentSearchRowBasic
     */
    public function addToResource(\StructType\SearchColumnSelectField $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SearchColumnSelectField) {
            throw new \InvalidArgumentException(sprintf('The resource property can only contain items of type \StructType\SearchColumnSelectField, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->resource[] = $item;
        return $this;
    }
    /**
     * Get resourceName value
     * @return \StructType\SearchColumnStringField[]|null
     */
    public function getResourceName()
    {
        return $this->resourceName;
    }
    /**
     * This method is responsible for validating the values passed to the setResourceName method
     * This method is willingly generated in order to preserve the one-line inline validation within the setResourceName method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateResourceNameForArrayConstraintsFromSetResourceName(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $projectTaskAssignmentSearchRowBasicResourceNameItem) {
            // validation for constraint: itemType
            if (!$projectTaskAssignmentSearchRowBasicResourceNameItem instanceof \StructType\SearchColumnStringField) {
                $invalidValues[] = is_object($projectTaskAssignmentSearchRowBasicResourceNameItem) ? get_class($projectTaskAssignmentSearchRowBasicResourceNameItem) : sprintf('%s(%s)', gettype($projectTaskAssignmentSearchRowBasicResourceNameItem), var_export($projectTaskAssignmentSearchRowBasicResourceNameItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The resourceName property can only contain items of type \StructType\SearchColumnStringField, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set resourceName value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnStringField[] $resourceName
     * @return \StructType\ProjectTaskAssignmentSearchRowBasic
     */
    public function setResourceName(array $resourceName = array())
    {
        // validation for constraint: array
        if ('' !== ($resourceNameArrayErrorMessage = self::validateResourceNameForArrayConstraintsFromSetResourceName($resourceName))) {
            throw new \InvalidArgumentException($resourceNameArrayErrorMessage, __LINE__);
        }
        $this->resourceName = $resourceName;
        return $this;
    }
    /**
     * Add item to resourceName value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnStringField $item
     * @return \StructType\ProjectTaskAssignmentSearchRowBasic
     */
    public function addToResourceName(\StructType\SearchColumnStringField $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SearchColumnStringField) {
            throw new \InvalidArgumentException(sprintf('The resourceName property can only contain items of type \StructType\SearchColumnStringField, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->resourceName[] = $item;
        return $this;
    }
    /**
     * Get serviceItem value
     * @return \StructType\SearchColumnStringField[]|null
     */
    public function getServiceItem()
    {
        return $this->serviceItem;
    }
    /**
     * This method is responsible for validating the values passed to the setServiceItem method
     * This method is willingly generated in order to preserve the one-line inline validation within the setServiceItem method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateServiceItemForArrayConstraintsFromSetServiceItem(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $projectTaskAssignmentSearchRowBasicServiceItemItem) {
            // validation for constraint: itemType
            if (!$projectTaskAssignmentSearchRowBasicServiceItemItem instanceof \StructType\SearchColumnStringField) {
                $invalidValues[] = is_object($projectTaskAssignmentSearchRowBasicServiceItemItem) ? get_class($projectTaskAssignmentSearchRowBasicServiceItemItem) : sprintf('%s(%s)', gettype($projectTaskAssignmentSearchRowBasicServiceItemItem), var_export($projectTaskAssignmentSearchRowBasicServiceItemItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The serviceItem property can only contain items of type \StructType\SearchColumnStringField, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set serviceItem value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnStringField[] $serviceItem
     * @return \StructType\ProjectTaskAssignmentSearchRowBasic
     */
    public function setServiceItem(array $serviceItem = array())
    {
        // validation for constraint: array
        if ('' !== ($serviceItemArrayErrorMessage = self::validateServiceItemForArrayConstraintsFromSetServiceItem($serviceItem))) {
            throw new \InvalidArgumentException($serviceItemArrayErrorMessage, __LINE__);
        }
        $this->serviceItem = $serviceItem;
        return $this;
    }
    /**
     * Add item to serviceItem value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnStringField $item
     * @return \StructType\ProjectTaskAssignmentSearchRowBasic
     */
    public function addToServiceItem(\StructType\SearchColumnStringField $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SearchColumnStringField) {
            throw new \InvalidArgumentException(sprintf('The serviceItem property can only contain items of type \StructType\SearchColumnStringField, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->serviceItem[] = $item;
        return $this;
    }
    /**
     * Get serviceItemDesc value
     * @return \StructType\SearchColumnStringField[]|null
     */
    public function getServiceItemDesc()
    {
        return $this->serviceItemDesc;
    }
    /**
     * This method is responsible for validating the values passed to the setServiceItemDesc method
     * This method is willingly generated in order to preserve the one-line inline validation within the setServiceItemDesc method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateServiceItemDescForArrayConstraintsFromSetServiceItemDesc(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $projectTaskAssignmentSearchRowBasicServiceItemDescItem) {
            // validation for constraint: itemType
            if (!$projectTaskAssignmentSearchRowBasicServiceItemDescItem instanceof \StructType\SearchColumnStringField) {
                $invalidValues[] = is_object($projectTaskAssignmentSearchRowBasicServiceItemDescItem) ? get_class($projectTaskAssignmentSearchRowBasicServiceItemDescItem) : sprintf('%s(%s)', gettype($projectTaskAssignmentSearchRowBasicServiceItemDescItem), var_export($projectTaskAssignmentSearchRowBasicServiceItemDescItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The serviceItemDesc property can only contain items of type \StructType\SearchColumnStringField, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set serviceItemDesc value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnStringField[] $serviceItemDesc
     * @return \StructType\ProjectTaskAssignmentSearchRowBasic
     */
    public function setServiceItemDesc(array $serviceItemDesc = array())
    {
        // validation for constraint: array
        if ('' !== ($serviceItemDescArrayErrorMessage = self::validateServiceItemDescForArrayConstraintsFromSetServiceItemDesc($serviceItemDesc))) {
            throw new \InvalidArgumentException($serviceItemDescArrayErrorMessage, __LINE__);
        }
        $this->serviceItemDesc = $serviceItemDesc;
        return $this;
    }
    /**
     * Add item to serviceItemDesc value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnStringField $item
     * @return \StructType\ProjectTaskAssignmentSearchRowBasic
     */
    public function addToServiceItemDesc(\StructType\SearchColumnStringField $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SearchColumnStringField) {
            throw new \InvalidArgumentException(sprintf('The serviceItemDesc property can only contain items of type \StructType\SearchColumnStringField, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->serviceItemDesc[] = $item;
        return $this;
    }
    /**
     * Get startDate value
     * @return \StructType\SearchColumnDateField[]|null
     */
    public function getStartDate()
    {
        return $this->startDate;
    }
    /**
     * This method is responsible for validating the values passed to the setStartDate method
     * This method is willingly generated in order to preserve the one-line inline validation within the setStartDate method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateStartDateForArrayConstraintsFromSetStartDate(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $projectTaskAssignmentSearchRowBasicStartDateItem) {
            // validation for constraint: itemType
            if (!$projectTaskAssignmentSearchRowBasicStartDateItem instanceof \StructType\SearchColumnDateField) {
                $invalidValues[] = is_object($projectTaskAssignmentSearchRowBasicStartDateItem) ? get_class($projectTaskAssignmentSearchRowBasicStartDateItem) : sprintf('%s(%s)', gettype($projectTaskAssignmentSearchRowBasicStartDateItem), var_export($projectTaskAssignmentSearchRowBasicStartDateItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The startDate property can only contain items of type \StructType\SearchColumnDateField, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set startDate value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnDateField[] $startDate
     * @return \StructType\ProjectTaskAssignmentSearchRowBasic
     */
    public function setStartDate(array $startDate = array())
    {
        // validation for constraint: array
        if ('' !== ($startDateArrayErrorMessage = self::validateStartDateForArrayConstraintsFromSetStartDate($startDate))) {
            throw new \InvalidArgumentException($startDateArrayErrorMessage, __LINE__);
        }
        $this->startDate = $startDate;
        return $this;
    }
    /**
     * Add item to startDate value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnDateField $item
     * @return \StructType\ProjectTaskAssignmentSearchRowBasic
     */
    public function addToStartDate(\StructType\SearchColumnDateField $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SearchColumnDateField) {
            throw new \InvalidArgumentException(sprintf('The startDate property can only contain items of type \StructType\SearchColumnDateField, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->startDate[] = $item;
        return $this;
    }
    /**
     * Get unitCost value
     * @return \StructType\SearchColumnDoubleField[]|null
     */
    public function getUnitCost()
    {
        return $this->unitCost;
    }
    /**
     * This method is responsible for validating the values passed to the setUnitCost method
     * This method is willingly generated in order to preserve the one-line inline validation within the setUnitCost method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateUnitCostForArrayConstraintsFromSetUnitCost(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $projectTaskAssignmentSearchRowBasicUnitCostItem) {
            // validation for constraint: itemType
            if (!$projectTaskAssignmentSearchRowBasicUnitCostItem instanceof \StructType\SearchColumnDoubleField) {
                $invalidValues[] = is_object($projectTaskAssignmentSearchRowBasicUnitCostItem) ? get_class($projectTaskAssignmentSearchRowBasicUnitCostItem) : sprintf('%s(%s)', gettype($projectTaskAssignmentSearchRowBasicUnitCostItem), var_export($projectTaskAssignmentSearchRowBasicUnitCostItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The unitCost property can only contain items of type \StructType\SearchColumnDoubleField, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set unitCost value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnDoubleField[] $unitCost
     * @return \StructType\ProjectTaskAssignmentSearchRowBasic
     */
    public function setUnitCost(array $unitCost = array())
    {
        // validation for constraint: array
        if ('' !== ($unitCostArrayErrorMessage = self::validateUnitCostForArrayConstraintsFromSetUnitCost($unitCost))) {
            throw new \InvalidArgumentException($unitCostArrayErrorMessage, __LINE__);
        }
        $this->unitCost = $unitCost;
        return $this;
    }
    /**
     * Add item to unitCost value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnDoubleField $item
     * @return \StructType\ProjectTaskAssignmentSearchRowBasic
     */
    public function addToUnitCost(\StructType\SearchColumnDoubleField $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SearchColumnDoubleField) {
            throw new \InvalidArgumentException(sprintf('The unitCost property can only contain items of type \StructType\SearchColumnDoubleField, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->unitCost[] = $item;
        return $this;
    }
    /**
     * Get unitCostBase value
     * @return \StructType\SearchColumnDoubleField[]|null
     */
    public function getUnitCostBase()
    {
        return $this->unitCostBase;
    }
    /**
     * This method is responsible for validating the values passed to the setUnitCostBase method
     * This method is willingly generated in order to preserve the one-line inline validation within the setUnitCostBase method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateUnitCostBaseForArrayConstraintsFromSetUnitCostBase(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $projectTaskAssignmentSearchRowBasicUnitCostBaseItem) {
            // validation for constraint: itemType
            if (!$projectTaskAssignmentSearchRowBasicUnitCostBaseItem instanceof \StructType\SearchColumnDoubleField) {
                $invalidValues[] = is_object($projectTaskAssignmentSearchRowBasicUnitCostBaseItem) ? get_class($projectTaskAssignmentSearchRowBasicUnitCostBaseItem) : sprintf('%s(%s)', gettype($projectTaskAssignmentSearchRowBasicUnitCostBaseItem), var_export($projectTaskAssignmentSearchRowBasicUnitCostBaseItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The unitCostBase property can only contain items of type \StructType\SearchColumnDoubleField, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set unitCostBase value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnDoubleField[] $unitCostBase
     * @return \StructType\ProjectTaskAssignmentSearchRowBasic
     */
    public function setUnitCostBase(array $unitCostBase = array())
    {
        // validation for constraint: array
        if ('' !== ($unitCostBaseArrayErrorMessage = self::validateUnitCostBaseForArrayConstraintsFromSetUnitCostBase($unitCostBase))) {
            throw new \InvalidArgumentException($unitCostBaseArrayErrorMessage, __LINE__);
        }
        $this->unitCostBase = $unitCostBase;
        return $this;
    }
    /**
     * Add item to unitCostBase value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnDoubleField $item
     * @return \StructType\ProjectTaskAssignmentSearchRowBasic
     */
    public function addToUnitCostBase(\StructType\SearchColumnDoubleField $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SearchColumnDoubleField) {
            throw new \InvalidArgumentException(sprintf('The unitCostBase property can only contain items of type \StructType\SearchColumnDoubleField, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->unitCostBase[] = $item;
        return $this;
    }
    /**
     * Get unitPrice value
     * @return \StructType\SearchColumnDoubleField[]|null
     */
    public function getUnitPrice()
    {
        return $this->unitPrice;
    }
    /**
     * This method is responsible for validating the values passed to the setUnitPrice method
     * This method is willingly generated in order to preserve the one-line inline validation within the setUnitPrice method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateUnitPriceForArrayConstraintsFromSetUnitPrice(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $projectTaskAssignmentSearchRowBasicUnitPriceItem) {
            // validation for constraint: itemType
            if (!$projectTaskAssignmentSearchRowBasicUnitPriceItem instanceof \StructType\SearchColumnDoubleField) {
                $invalidValues[] = is_object($projectTaskAssignmentSearchRowBasicUnitPriceItem) ? get_class($projectTaskAssignmentSearchRowBasicUnitPriceItem) : sprintf('%s(%s)', gettype($projectTaskAssignmentSearchRowBasicUnitPriceItem), var_export($projectTaskAssignmentSearchRowBasicUnitPriceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The unitPrice property can only contain items of type \StructType\SearchColumnDoubleField, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set unitPrice value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnDoubleField[] $unitPrice
     * @return \StructType\ProjectTaskAssignmentSearchRowBasic
     */
    public function setUnitPrice(array $unitPrice = array())
    {
        // validation for constraint: array
        if ('' !== ($unitPriceArrayErrorMessage = self::validateUnitPriceForArrayConstraintsFromSetUnitPrice($unitPrice))) {
            throw new \InvalidArgumentException($unitPriceArrayErrorMessage, __LINE__);
        }
        $this->unitPrice = $unitPrice;
        return $this;
    }
    /**
     * Add item to unitPrice value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnDoubleField $item
     * @return \StructType\ProjectTaskAssignmentSearchRowBasic
     */
    public function addToUnitPrice(\StructType\SearchColumnDoubleField $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SearchColumnDoubleField) {
            throw new \InvalidArgumentException(sprintf('The unitPrice property can only contain items of type \StructType\SearchColumnDoubleField, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->unitPrice[] = $item;
        return $this;
    }
    /**
     * Get unitPriceBase value
     * @return \StructType\SearchColumnDoubleField[]|null
     */
    public function getUnitPriceBase()
    {
        return $this->unitPriceBase;
    }
    /**
     * This method is responsible for validating the values passed to the setUnitPriceBase method
     * This method is willingly generated in order to preserve the one-line inline validation within the setUnitPriceBase method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateUnitPriceBaseForArrayConstraintsFromSetUnitPriceBase(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $projectTaskAssignmentSearchRowBasicUnitPriceBaseItem) {
            // validation for constraint: itemType
            if (!$projectTaskAssignmentSearchRowBasicUnitPriceBaseItem instanceof \StructType\SearchColumnDoubleField) {
                $invalidValues[] = is_object($projectTaskAssignmentSearchRowBasicUnitPriceBaseItem) ? get_class($projectTaskAssignmentSearchRowBasicUnitPriceBaseItem) : sprintf('%s(%s)', gettype($projectTaskAssignmentSearchRowBasicUnitPriceBaseItem), var_export($projectTaskAssignmentSearchRowBasicUnitPriceBaseItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The unitPriceBase property can only contain items of type \StructType\SearchColumnDoubleField, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set unitPriceBase value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnDoubleField[] $unitPriceBase
     * @return \StructType\ProjectTaskAssignmentSearchRowBasic
     */
    public function setUnitPriceBase(array $unitPriceBase = array())
    {
        // validation for constraint: array
        if ('' !== ($unitPriceBaseArrayErrorMessage = self::validateUnitPriceBaseForArrayConstraintsFromSetUnitPriceBase($unitPriceBase))) {
            throw new \InvalidArgumentException($unitPriceBaseArrayErrorMessage, __LINE__);
        }
        $this->unitPriceBase = $unitPriceBase;
        return $this;
    }
    /**
     * Add item to unitPriceBase value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnDoubleField $item
     * @return \StructType\ProjectTaskAssignmentSearchRowBasic
     */
    public function addToUnitPriceBase(\StructType\SearchColumnDoubleField $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SearchColumnDoubleField) {
            throw new \InvalidArgumentException(sprintf('The unitPriceBase property can only contain items of type \StructType\SearchColumnDoubleField, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->unitPriceBase[] = $item;
        return $this;
    }
    /**
     * Get units value
     * @return \StructType\SearchColumnDoubleField[]|null
     */
    public function getUnits()
    {
        return $this->units;
    }
    /**
     * This method is responsible for validating the values passed to the setUnits method
     * This method is willingly generated in order to preserve the one-line inline validation within the setUnits method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateUnitsForArrayConstraintsFromSetUnits(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $projectTaskAssignmentSearchRowBasicUnitsItem) {
            // validation for constraint: itemType
            if (!$projectTaskAssignmentSearchRowBasicUnitsItem instanceof \StructType\SearchColumnDoubleField) {
                $invalidValues[] = is_object($projectTaskAssignmentSearchRowBasicUnitsItem) ? get_class($projectTaskAssignmentSearchRowBasicUnitsItem) : sprintf('%s(%s)', gettype($projectTaskAssignmentSearchRowBasicUnitsItem), var_export($projectTaskAssignmentSearchRowBasicUnitsItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The units property can only contain items of type \StructType\SearchColumnDoubleField, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set units value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnDoubleField[] $units
     * @return \StructType\ProjectTaskAssignmentSearchRowBasic
     */
    public function setUnits(array $units = array())
    {
        // validation for constraint: array
        if ('' !== ($unitsArrayErrorMessage = self::validateUnitsForArrayConstraintsFromSetUnits($units))) {
            throw new \InvalidArgumentException($unitsArrayErrorMessage, __LINE__);
        }
        $this->units = $units;
        return $this;
    }
    /**
     * Add item to units value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnDoubleField $item
     * @return \StructType\ProjectTaskAssignmentSearchRowBasic
     */
    public function addToUnits(\StructType\SearchColumnDoubleField $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SearchColumnDoubleField) {
            throw new \InvalidArgumentException(sprintf('The units property can only contain items of type \StructType\SearchColumnDoubleField, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->units[] = $item;
        return $this;
    }
    /**
     * Get workCalendar value
     * @return \StructType\SearchColumnSelectField[]|null
     */
    public function getWorkCalendar()
    {
        return $this->workCalendar;
    }
    /**
     * This method is responsible for validating the values passed to the setWorkCalendar method
     * This method is willingly generated in order to preserve the one-line inline validation within the setWorkCalendar method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateWorkCalendarForArrayConstraintsFromSetWorkCalendar(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $projectTaskAssignmentSearchRowBasicWorkCalendarItem) {
            // validation for constraint: itemType
            if (!$projectTaskAssignmentSearchRowBasicWorkCalendarItem instanceof \StructType\SearchColumnSelectField) {
                $invalidValues[] = is_object($projectTaskAssignmentSearchRowBasicWorkCalendarItem) ? get_class($projectTaskAssignmentSearchRowBasicWorkCalendarItem) : sprintf('%s(%s)', gettype($projectTaskAssignmentSearchRowBasicWorkCalendarItem), var_export($projectTaskAssignmentSearchRowBasicWorkCalendarItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The workCalendar property can only contain items of type \StructType\SearchColumnSelectField, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set workCalendar value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnSelectField[] $workCalendar
     * @return \StructType\ProjectTaskAssignmentSearchRowBasic
     */
    public function setWorkCalendar(array $workCalendar = array())
    {
        // validation for constraint: array
        if ('' !== ($workCalendarArrayErrorMessage = self::validateWorkCalendarForArrayConstraintsFromSetWorkCalendar($workCalendar))) {
            throw new \InvalidArgumentException($workCalendarArrayErrorMessage, __LINE__);
        }
        $this->workCalendar = $workCalendar;
        return $this;
    }
    /**
     * Add item to workCalendar value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnSelectField $item
     * @return \StructType\ProjectTaskAssignmentSearchRowBasic
     */
    public function addToWorkCalendar(\StructType\SearchColumnSelectField $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SearchColumnSelectField) {
            throw new \InvalidArgumentException(sprintf('The workCalendar property can only contain items of type \StructType\SearchColumnSelectField, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->workCalendar[] = $item;
        return $this;
    }
}
