<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ProjectTaskAssigneeList StructType
 * @subpackage Structs
 */
class ProjectTaskAssigneeList extends AbstractStructBase
{
    /**
     * The projectTaskAssignee
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\ProjectTaskAssignee[]
     */
    public $projectTaskAssignee;
    /**
     * The replaceAll
     * Meta information extracted from the WSDL
     * - default: true
     * @var bool
     */
    public $replaceAll;
    /**
     * Constructor method for ProjectTaskAssigneeList
     * @uses ProjectTaskAssigneeList::setProjectTaskAssignee()
     * @uses ProjectTaskAssigneeList::setReplaceAll()
     * @param \StructType\ProjectTaskAssignee[] $projectTaskAssignee
     * @param bool $replaceAll
     */
    public function __construct(array $projectTaskAssignee = array(), $replaceAll = true)
    {
        $this
            ->setProjectTaskAssignee($projectTaskAssignee)
            ->setReplaceAll($replaceAll);
    }
    /**
     * Get projectTaskAssignee value
     * @return \StructType\ProjectTaskAssignee[]|null
     */
    public function getProjectTaskAssignee()
    {
        return $this->projectTaskAssignee;
    }
    /**
     * This method is responsible for validating the values passed to the setProjectTaskAssignee method
     * This method is willingly generated in order to preserve the one-line inline validation within the setProjectTaskAssignee method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateProjectTaskAssigneeForArrayConstraintsFromSetProjectTaskAssignee(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $projectTaskAssigneeListProjectTaskAssigneeItem) {
            // validation for constraint: itemType
            if (!$projectTaskAssigneeListProjectTaskAssigneeItem instanceof \StructType\ProjectTaskAssignee) {
                $invalidValues[] = is_object($projectTaskAssigneeListProjectTaskAssigneeItem) ? get_class($projectTaskAssigneeListProjectTaskAssigneeItem) : sprintf('%s(%s)', gettype($projectTaskAssigneeListProjectTaskAssigneeItem), var_export($projectTaskAssigneeListProjectTaskAssigneeItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The projectTaskAssignee property can only contain items of type \StructType\ProjectTaskAssignee, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set projectTaskAssignee value
     * @throws \InvalidArgumentException
     * @param \StructType\ProjectTaskAssignee[] $projectTaskAssignee
     * @return \StructType\ProjectTaskAssigneeList
     */
    public function setProjectTaskAssignee(array $projectTaskAssignee = array())
    {
        // validation for constraint: array
        if ('' !== ($projectTaskAssigneeArrayErrorMessage = self::validateProjectTaskAssigneeForArrayConstraintsFromSetProjectTaskAssignee($projectTaskAssignee))) {
            throw new \InvalidArgumentException($projectTaskAssigneeArrayErrorMessage, __LINE__);
        }
        $this->projectTaskAssignee = $projectTaskAssignee;
        return $this;
    }
    /**
     * Add item to projectTaskAssignee value
     * @throws \InvalidArgumentException
     * @param \StructType\ProjectTaskAssignee $item
     * @return \StructType\ProjectTaskAssigneeList
     */
    public function addToProjectTaskAssignee(\StructType\ProjectTaskAssignee $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ProjectTaskAssignee) {
            throw new \InvalidArgumentException(sprintf('The projectTaskAssignee property can only contain items of type \StructType\ProjectTaskAssignee, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->projectTaskAssignee[] = $item;
        return $this;
    }
    /**
     * Get replaceAll value
     * @return bool|null
     */
    public function getReplaceAll()
    {
        return $this->replaceAll;
    }
    /**
     * Set replaceAll value
     * @param bool $replaceAll
     * @return \StructType\ProjectTaskAssigneeList
     */
    public function setReplaceAll($replaceAll = true)
    {
        // validation for constraint: boolean
        if (!is_null($replaceAll) && !is_bool($replaceAll)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($replaceAll, true), gettype($replaceAll)), __LINE__);
        }
        $this->replaceAll = $replaceAll;
        return $this;
    }
}
