<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ProductFeedList StructType
 * @subpackage Structs
 */
class ProductFeedList extends AbstractStructBase
{
    /**
     * The productFeed
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * @var string[]
     */
    public $productFeed;
    /**
     * Constructor method for ProductFeedList
     * @uses ProductFeedList::setProductFeed()
     * @param string[] $productFeed
     */
    public function __construct(array $productFeed = array())
    {
        $this
            ->setProductFeed($productFeed);
    }
    /**
     * Get productFeed value
     * @return string[]|null
     */
    public function getProductFeed()
    {
        return $this->productFeed;
    }
    /**
     * This method is responsible for validating the values passed to the setProductFeed method
     * This method is willingly generated in order to preserve the one-line inline validation within the setProductFeed method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateProductFeedForArrayConstraintsFromSetProductFeed(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $productFeedListProductFeedItem) {
            // validation for constraint: enumeration
            if (!\EnumType\ItemProductFeed::valueIsValid($productFeedListProductFeedItem)) {
                $invalidValues[] = is_object($productFeedListProductFeedItem) ? get_class($productFeedListProductFeedItem) : sprintf('%s(%s)', gettype($productFeedListProductFeedItem), var_export($productFeedListProductFeedItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\ItemProductFeed', is_array($invalidValues) ? implode(', ', $invalidValues) : var_export($invalidValues, true), implode(', ', \EnumType\ItemProductFeed::getValidValues()));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set productFeed value
     * @uses \EnumType\ItemProductFeed::valueIsValid()
     * @uses \EnumType\ItemProductFeed::getValidValues()
     * @throws \InvalidArgumentException
     * @param string[] $productFeed
     * @return \StructType\ProductFeedList
     */
    public function setProductFeed(array $productFeed = array())
    {
        // validation for constraint: array
        if ('' !== ($productFeedArrayErrorMessage = self::validateProductFeedForArrayConstraintsFromSetProductFeed($productFeed))) {
            throw new \InvalidArgumentException($productFeedArrayErrorMessage, __LINE__);
        }
        $this->productFeed = $productFeed;
        return $this;
    }
    /**
     * Add item to productFeed value
     * @uses \EnumType\ItemProductFeed::valueIsValid()
     * @uses \EnumType\ItemProductFeed::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \StructType\ProductFeedList
     */
    public function addToProductFeed($item)
    {
        // validation for constraint: enumeration
        if (!\EnumType\ItemProductFeed::valueIsValid($item)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\ItemProductFeed', is_array($item) ? implode(', ', $item) : var_export($item, true), implode(', ', \EnumType\ItemProductFeed::getValidValues())), __LINE__);
        }
        $this->productFeed[] = $item;
        return $this;
    }
}
