<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PricingSearchRowBasic StructType
 * @subpackage Structs
 */
class PricingSearchRowBasic extends SearchRowBasic
{
    /**
     * The currency
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SearchColumnSelectField[]
     */
    public $currency;
    /**
     * The customer
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SearchColumnSelectField[]
     */
    public $customer;
    /**
     * The internalId
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SearchColumnSelectField[]
     */
    public $internalId;
    /**
     * The item
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SearchColumnSelectField[]
     */
    public $item;
    /**
     * The maximumQuantity
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SearchColumnDoubleField[]
     */
    public $maximumQuantity;
    /**
     * The minimumQuantity
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SearchColumnDoubleField[]
     */
    public $minimumQuantity;
    /**
     * The priceLevel
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SearchColumnSelectField[]
     */
    public $priceLevel;
    /**
     * The quantityRange
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SearchColumnStringField[]
     */
    public $quantityRange;
    /**
     * The saleUnit
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SearchColumnSelectField[]
     */
    public $saleUnit;
    /**
     * The unitPrice
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SearchColumnDoubleField[]
     */
    public $unitPrice;
    /**
     * Constructor method for PricingSearchRowBasic
     * @uses PricingSearchRowBasic::setCurrency()
     * @uses PricingSearchRowBasic::setCustomer()
     * @uses PricingSearchRowBasic::setInternalId()
     * @uses PricingSearchRowBasic::setItem()
     * @uses PricingSearchRowBasic::setMaximumQuantity()
     * @uses PricingSearchRowBasic::setMinimumQuantity()
     * @uses PricingSearchRowBasic::setPriceLevel()
     * @uses PricingSearchRowBasic::setQuantityRange()
     * @uses PricingSearchRowBasic::setSaleUnit()
     * @uses PricingSearchRowBasic::setUnitPrice()
     * @param \StructType\SearchColumnSelectField[] $currency
     * @param \StructType\SearchColumnSelectField[] $customer
     * @param \StructType\SearchColumnSelectField[] $internalId
     * @param \StructType\SearchColumnSelectField[] $item
     * @param \StructType\SearchColumnDoubleField[] $maximumQuantity
     * @param \StructType\SearchColumnDoubleField[] $minimumQuantity
     * @param \StructType\SearchColumnSelectField[] $priceLevel
     * @param \StructType\SearchColumnStringField[] $quantityRange
     * @param \StructType\SearchColumnSelectField[] $saleUnit
     * @param \StructType\SearchColumnDoubleField[] $unitPrice
     */
    public function __construct(array $currency = array(), array $customer = array(), array $internalId = array(), array $item = array(), array $maximumQuantity = array(), array $minimumQuantity = array(), array $priceLevel = array(), array $quantityRange = array(), array $saleUnit = array(), array $unitPrice = array())
    {
        $this
            ->setCurrency($currency)
            ->setCustomer($customer)
            ->setInternalId($internalId)
            ->setItem($item)
            ->setMaximumQuantity($maximumQuantity)
            ->setMinimumQuantity($minimumQuantity)
            ->setPriceLevel($priceLevel)
            ->setQuantityRange($quantityRange)
            ->setSaleUnit($saleUnit)
            ->setUnitPrice($unitPrice);
    }
    /**
     * Get currency value
     * @return \StructType\SearchColumnSelectField[]|null
     */
    public function getCurrency()
    {
        return $this->currency;
    }
    /**
     * This method is responsible for validating the values passed to the setCurrency method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCurrency method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCurrencyForArrayConstraintsFromSetCurrency(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $pricingSearchRowBasicCurrencyItem) {
            // validation for constraint: itemType
            if (!$pricingSearchRowBasicCurrencyItem instanceof \StructType\SearchColumnSelectField) {
                $invalidValues[] = is_object($pricingSearchRowBasicCurrencyItem) ? get_class($pricingSearchRowBasicCurrencyItem) : sprintf('%s(%s)', gettype($pricingSearchRowBasicCurrencyItem), var_export($pricingSearchRowBasicCurrencyItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The currency property can only contain items of type \StructType\SearchColumnSelectField, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set currency value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnSelectField[] $currency
     * @return \StructType\PricingSearchRowBasic
     */
    public function setCurrency(array $currency = array())
    {
        // validation for constraint: array
        if ('' !== ($currencyArrayErrorMessage = self::validateCurrencyForArrayConstraintsFromSetCurrency($currency))) {
            throw new \InvalidArgumentException($currencyArrayErrorMessage, __LINE__);
        }
        $this->currency = $currency;
        return $this;
    }
    /**
     * Add item to currency value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnSelectField $item
     * @return \StructType\PricingSearchRowBasic
     */
    public function addToCurrency(\StructType\SearchColumnSelectField $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SearchColumnSelectField) {
            throw new \InvalidArgumentException(sprintf('The currency property can only contain items of type \StructType\SearchColumnSelectField, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->currency[] = $item;
        return $this;
    }
    /**
     * Get customer value
     * @return \StructType\SearchColumnSelectField[]|null
     */
    public function getCustomer()
    {
        return $this->customer;
    }
    /**
     * This method is responsible for validating the values passed to the setCustomer method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCustomer method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCustomerForArrayConstraintsFromSetCustomer(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $pricingSearchRowBasicCustomerItem) {
            // validation for constraint: itemType
            if (!$pricingSearchRowBasicCustomerItem instanceof \StructType\SearchColumnSelectField) {
                $invalidValues[] = is_object($pricingSearchRowBasicCustomerItem) ? get_class($pricingSearchRowBasicCustomerItem) : sprintf('%s(%s)', gettype($pricingSearchRowBasicCustomerItem), var_export($pricingSearchRowBasicCustomerItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The customer property can only contain items of type \StructType\SearchColumnSelectField, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set customer value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnSelectField[] $customer
     * @return \StructType\PricingSearchRowBasic
     */
    public function setCustomer(array $customer = array())
    {
        // validation for constraint: array
        if ('' !== ($customerArrayErrorMessage = self::validateCustomerForArrayConstraintsFromSetCustomer($customer))) {
            throw new \InvalidArgumentException($customerArrayErrorMessage, __LINE__);
        }
        $this->customer = $customer;
        return $this;
    }
    /**
     * Add item to customer value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnSelectField $item
     * @return \StructType\PricingSearchRowBasic
     */
    public function addToCustomer(\StructType\SearchColumnSelectField $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SearchColumnSelectField) {
            throw new \InvalidArgumentException(sprintf('The customer property can only contain items of type \StructType\SearchColumnSelectField, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->customer[] = $item;
        return $this;
    }
    /**
     * Get internalId value
     * @return \StructType\SearchColumnSelectField[]|null
     */
    public function getInternalId()
    {
        return $this->internalId;
    }
    /**
     * This method is responsible for validating the values passed to the setInternalId method
     * This method is willingly generated in order to preserve the one-line inline validation within the setInternalId method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateInternalIdForArrayConstraintsFromSetInternalId(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $pricingSearchRowBasicInternalIdItem) {
            // validation for constraint: itemType
            if (!$pricingSearchRowBasicInternalIdItem instanceof \StructType\SearchColumnSelectField) {
                $invalidValues[] = is_object($pricingSearchRowBasicInternalIdItem) ? get_class($pricingSearchRowBasicInternalIdItem) : sprintf('%s(%s)', gettype($pricingSearchRowBasicInternalIdItem), var_export($pricingSearchRowBasicInternalIdItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The internalId property can only contain items of type \StructType\SearchColumnSelectField, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set internalId value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnSelectField[] $internalId
     * @return \StructType\PricingSearchRowBasic
     */
    public function setInternalId(array $internalId = array())
    {
        // validation for constraint: array
        if ('' !== ($internalIdArrayErrorMessage = self::validateInternalIdForArrayConstraintsFromSetInternalId($internalId))) {
            throw new \InvalidArgumentException($internalIdArrayErrorMessage, __LINE__);
        }
        $this->internalId = $internalId;
        return $this;
    }
    /**
     * Add item to internalId value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnSelectField $item
     * @return \StructType\PricingSearchRowBasic
     */
    public function addToInternalId(\StructType\SearchColumnSelectField $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SearchColumnSelectField) {
            throw new \InvalidArgumentException(sprintf('The internalId property can only contain items of type \StructType\SearchColumnSelectField, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->internalId[] = $item;
        return $this;
    }
    /**
     * Get item value
     * @return \StructType\SearchColumnSelectField[]|null
     */
    public function getItem()
    {
        return $this->item;
    }
    /**
     * This method is responsible for validating the values passed to the setItem method
     * This method is willingly generated in order to preserve the one-line inline validation within the setItem method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateItemForArrayConstraintsFromSetItem(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $pricingSearchRowBasicItemItem) {
            // validation for constraint: itemType
            if (!$pricingSearchRowBasicItemItem instanceof \StructType\SearchColumnSelectField) {
                $invalidValues[] = is_object($pricingSearchRowBasicItemItem) ? get_class($pricingSearchRowBasicItemItem) : sprintf('%s(%s)', gettype($pricingSearchRowBasicItemItem), var_export($pricingSearchRowBasicItemItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The item property can only contain items of type \StructType\SearchColumnSelectField, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set item value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnSelectField[] $item
     * @return \StructType\PricingSearchRowBasic
     */
    public function setItem(array $item = array())
    {
        // validation for constraint: array
        if ('' !== ($itemArrayErrorMessage = self::validateItemForArrayConstraintsFromSetItem($item))) {
            throw new \InvalidArgumentException($itemArrayErrorMessage, __LINE__);
        }
        $this->item = $item;
        return $this;
    }
    /**
     * Add item to item value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnSelectField $item
     * @return \StructType\PricingSearchRowBasic
     */
    public function addToItem(\StructType\SearchColumnSelectField $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SearchColumnSelectField) {
            throw new \InvalidArgumentException(sprintf('The item property can only contain items of type \StructType\SearchColumnSelectField, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->item[] = $item;
        return $this;
    }
    /**
     * Get maximumQuantity value
     * @return \StructType\SearchColumnDoubleField[]|null
     */
    public function getMaximumQuantity()
    {
        return $this->maximumQuantity;
    }
    /**
     * This method is responsible for validating the values passed to the setMaximumQuantity method
     * This method is willingly generated in order to preserve the one-line inline validation within the setMaximumQuantity method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateMaximumQuantityForArrayConstraintsFromSetMaximumQuantity(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $pricingSearchRowBasicMaximumQuantityItem) {
            // validation for constraint: itemType
            if (!$pricingSearchRowBasicMaximumQuantityItem instanceof \StructType\SearchColumnDoubleField) {
                $invalidValues[] = is_object($pricingSearchRowBasicMaximumQuantityItem) ? get_class($pricingSearchRowBasicMaximumQuantityItem) : sprintf('%s(%s)', gettype($pricingSearchRowBasicMaximumQuantityItem), var_export($pricingSearchRowBasicMaximumQuantityItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The maximumQuantity property can only contain items of type \StructType\SearchColumnDoubleField, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set maximumQuantity value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnDoubleField[] $maximumQuantity
     * @return \StructType\PricingSearchRowBasic
     */
    public function setMaximumQuantity(array $maximumQuantity = array())
    {
        // validation for constraint: array
        if ('' !== ($maximumQuantityArrayErrorMessage = self::validateMaximumQuantityForArrayConstraintsFromSetMaximumQuantity($maximumQuantity))) {
            throw new \InvalidArgumentException($maximumQuantityArrayErrorMessage, __LINE__);
        }
        $this->maximumQuantity = $maximumQuantity;
        return $this;
    }
    /**
     * Add item to maximumQuantity value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnDoubleField $item
     * @return \StructType\PricingSearchRowBasic
     */
    public function addToMaximumQuantity(\StructType\SearchColumnDoubleField $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SearchColumnDoubleField) {
            throw new \InvalidArgumentException(sprintf('The maximumQuantity property can only contain items of type \StructType\SearchColumnDoubleField, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->maximumQuantity[] = $item;
        return $this;
    }
    /**
     * Get minimumQuantity value
     * @return \StructType\SearchColumnDoubleField[]|null
     */
    public function getMinimumQuantity()
    {
        return $this->minimumQuantity;
    }
    /**
     * This method is responsible for validating the values passed to the setMinimumQuantity method
     * This method is willingly generated in order to preserve the one-line inline validation within the setMinimumQuantity method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateMinimumQuantityForArrayConstraintsFromSetMinimumQuantity(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $pricingSearchRowBasicMinimumQuantityItem) {
            // validation for constraint: itemType
            if (!$pricingSearchRowBasicMinimumQuantityItem instanceof \StructType\SearchColumnDoubleField) {
                $invalidValues[] = is_object($pricingSearchRowBasicMinimumQuantityItem) ? get_class($pricingSearchRowBasicMinimumQuantityItem) : sprintf('%s(%s)', gettype($pricingSearchRowBasicMinimumQuantityItem), var_export($pricingSearchRowBasicMinimumQuantityItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The minimumQuantity property can only contain items of type \StructType\SearchColumnDoubleField, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set minimumQuantity value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnDoubleField[] $minimumQuantity
     * @return \StructType\PricingSearchRowBasic
     */
    public function setMinimumQuantity(array $minimumQuantity = array())
    {
        // validation for constraint: array
        if ('' !== ($minimumQuantityArrayErrorMessage = self::validateMinimumQuantityForArrayConstraintsFromSetMinimumQuantity($minimumQuantity))) {
            throw new \InvalidArgumentException($minimumQuantityArrayErrorMessage, __LINE__);
        }
        $this->minimumQuantity = $minimumQuantity;
        return $this;
    }
    /**
     * Add item to minimumQuantity value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnDoubleField $item
     * @return \StructType\PricingSearchRowBasic
     */
    public function addToMinimumQuantity(\StructType\SearchColumnDoubleField $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SearchColumnDoubleField) {
            throw new \InvalidArgumentException(sprintf('The minimumQuantity property can only contain items of type \StructType\SearchColumnDoubleField, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->minimumQuantity[] = $item;
        return $this;
    }
    /**
     * Get priceLevel value
     * @return \StructType\SearchColumnSelectField[]|null
     */
    public function getPriceLevel()
    {
        return $this->priceLevel;
    }
    /**
     * This method is responsible for validating the values passed to the setPriceLevel method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPriceLevel method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePriceLevelForArrayConstraintsFromSetPriceLevel(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $pricingSearchRowBasicPriceLevelItem) {
            // validation for constraint: itemType
            if (!$pricingSearchRowBasicPriceLevelItem instanceof \StructType\SearchColumnSelectField) {
                $invalidValues[] = is_object($pricingSearchRowBasicPriceLevelItem) ? get_class($pricingSearchRowBasicPriceLevelItem) : sprintf('%s(%s)', gettype($pricingSearchRowBasicPriceLevelItem), var_export($pricingSearchRowBasicPriceLevelItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The priceLevel property can only contain items of type \StructType\SearchColumnSelectField, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set priceLevel value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnSelectField[] $priceLevel
     * @return \StructType\PricingSearchRowBasic
     */
    public function setPriceLevel(array $priceLevel = array())
    {
        // validation for constraint: array
        if ('' !== ($priceLevelArrayErrorMessage = self::validatePriceLevelForArrayConstraintsFromSetPriceLevel($priceLevel))) {
            throw new \InvalidArgumentException($priceLevelArrayErrorMessage, __LINE__);
        }
        $this->priceLevel = $priceLevel;
        return $this;
    }
    /**
     * Add item to priceLevel value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnSelectField $item
     * @return \StructType\PricingSearchRowBasic
     */
    public function addToPriceLevel(\StructType\SearchColumnSelectField $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SearchColumnSelectField) {
            throw new \InvalidArgumentException(sprintf('The priceLevel property can only contain items of type \StructType\SearchColumnSelectField, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->priceLevel[] = $item;
        return $this;
    }
    /**
     * Get quantityRange value
     * @return \StructType\SearchColumnStringField[]|null
     */
    public function getQuantityRange()
    {
        return $this->quantityRange;
    }
    /**
     * This method is responsible for validating the values passed to the setQuantityRange method
     * This method is willingly generated in order to preserve the one-line inline validation within the setQuantityRange method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateQuantityRangeForArrayConstraintsFromSetQuantityRange(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $pricingSearchRowBasicQuantityRangeItem) {
            // validation for constraint: itemType
            if (!$pricingSearchRowBasicQuantityRangeItem instanceof \StructType\SearchColumnStringField) {
                $invalidValues[] = is_object($pricingSearchRowBasicQuantityRangeItem) ? get_class($pricingSearchRowBasicQuantityRangeItem) : sprintf('%s(%s)', gettype($pricingSearchRowBasicQuantityRangeItem), var_export($pricingSearchRowBasicQuantityRangeItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The quantityRange property can only contain items of type \StructType\SearchColumnStringField, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set quantityRange value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnStringField[] $quantityRange
     * @return \StructType\PricingSearchRowBasic
     */
    public function setQuantityRange(array $quantityRange = array())
    {
        // validation for constraint: array
        if ('' !== ($quantityRangeArrayErrorMessage = self::validateQuantityRangeForArrayConstraintsFromSetQuantityRange($quantityRange))) {
            throw new \InvalidArgumentException($quantityRangeArrayErrorMessage, __LINE__);
        }
        $this->quantityRange = $quantityRange;
        return $this;
    }
    /**
     * Add item to quantityRange value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnStringField $item
     * @return \StructType\PricingSearchRowBasic
     */
    public function addToQuantityRange(\StructType\SearchColumnStringField $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SearchColumnStringField) {
            throw new \InvalidArgumentException(sprintf('The quantityRange property can only contain items of type \StructType\SearchColumnStringField, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->quantityRange[] = $item;
        return $this;
    }
    /**
     * Get saleUnit value
     * @return \StructType\SearchColumnSelectField[]|null
     */
    public function getSaleUnit()
    {
        return $this->saleUnit;
    }
    /**
     * This method is responsible for validating the values passed to the setSaleUnit method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSaleUnit method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateSaleUnitForArrayConstraintsFromSetSaleUnit(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $pricingSearchRowBasicSaleUnitItem) {
            // validation for constraint: itemType
            if (!$pricingSearchRowBasicSaleUnitItem instanceof \StructType\SearchColumnSelectField) {
                $invalidValues[] = is_object($pricingSearchRowBasicSaleUnitItem) ? get_class($pricingSearchRowBasicSaleUnitItem) : sprintf('%s(%s)', gettype($pricingSearchRowBasicSaleUnitItem), var_export($pricingSearchRowBasicSaleUnitItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The saleUnit property can only contain items of type \StructType\SearchColumnSelectField, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set saleUnit value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnSelectField[] $saleUnit
     * @return \StructType\PricingSearchRowBasic
     */
    public function setSaleUnit(array $saleUnit = array())
    {
        // validation for constraint: array
        if ('' !== ($saleUnitArrayErrorMessage = self::validateSaleUnitForArrayConstraintsFromSetSaleUnit($saleUnit))) {
            throw new \InvalidArgumentException($saleUnitArrayErrorMessage, __LINE__);
        }
        $this->saleUnit = $saleUnit;
        return $this;
    }
    /**
     * Add item to saleUnit value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnSelectField $item
     * @return \StructType\PricingSearchRowBasic
     */
    public function addToSaleUnit(\StructType\SearchColumnSelectField $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SearchColumnSelectField) {
            throw new \InvalidArgumentException(sprintf('The saleUnit property can only contain items of type \StructType\SearchColumnSelectField, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->saleUnit[] = $item;
        return $this;
    }
    /**
     * Get unitPrice value
     * @return \StructType\SearchColumnDoubleField[]|null
     */
    public function getUnitPrice()
    {
        return $this->unitPrice;
    }
    /**
     * This method is responsible for validating the values passed to the setUnitPrice method
     * This method is willingly generated in order to preserve the one-line inline validation within the setUnitPrice method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateUnitPriceForArrayConstraintsFromSetUnitPrice(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $pricingSearchRowBasicUnitPriceItem) {
            // validation for constraint: itemType
            if (!$pricingSearchRowBasicUnitPriceItem instanceof \StructType\SearchColumnDoubleField) {
                $invalidValues[] = is_object($pricingSearchRowBasicUnitPriceItem) ? get_class($pricingSearchRowBasicUnitPriceItem) : sprintf('%s(%s)', gettype($pricingSearchRowBasicUnitPriceItem), var_export($pricingSearchRowBasicUnitPriceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The unitPrice property can only contain items of type \StructType\SearchColumnDoubleField, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set unitPrice value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnDoubleField[] $unitPrice
     * @return \StructType\PricingSearchRowBasic
     */
    public function setUnitPrice(array $unitPrice = array())
    {
        // validation for constraint: array
        if ('' !== ($unitPriceArrayErrorMessage = self::validateUnitPriceForArrayConstraintsFromSetUnitPrice($unitPrice))) {
            throw new \InvalidArgumentException($unitPriceArrayErrorMessage, __LINE__);
        }
        $this->unitPrice = $unitPrice;
        return $this;
    }
    /**
     * Add item to unitPrice value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnDoubleField $item
     * @return \StructType\PricingSearchRowBasic
     */
    public function addToUnitPrice(\StructType\SearchColumnDoubleField $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SearchColumnDoubleField) {
            throw new \InvalidArgumentException(sprintf('The unitPrice property can only contain items of type \StructType\SearchColumnDoubleField, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->unitPrice[] = $item;
        return $this;
    }
}
