<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PricingMatrix StructType
 * @subpackage Structs
 */
class PricingMatrix extends AbstractStructBase
{
    /**
     * The pricing
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Pricing[]
     */
    public $pricing;
    /**
     * The replaceAll
     * Meta information extracted from the WSDL
     * - default: false
     * @var bool
     */
    public $replaceAll;
    /**
     * Constructor method for PricingMatrix
     * @uses PricingMatrix::setPricing()
     * @uses PricingMatrix::setReplaceAll()
     * @param \StructType\Pricing[] $pricing
     * @param bool $replaceAll
     */
    public function __construct(array $pricing = array(), $replaceAll = false)
    {
        $this
            ->setPricing($pricing)
            ->setReplaceAll($replaceAll);
    }
    /**
     * Get pricing value
     * @return \StructType\Pricing[]|null
     */
    public function getPricing()
    {
        return $this->pricing;
    }
    /**
     * This method is responsible for validating the values passed to the setPricing method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPricing method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePricingForArrayConstraintsFromSetPricing(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $pricingMatrixPricingItem) {
            // validation for constraint: itemType
            if (!$pricingMatrixPricingItem instanceof \StructType\Pricing) {
                $invalidValues[] = is_object($pricingMatrixPricingItem) ? get_class($pricingMatrixPricingItem) : sprintf('%s(%s)', gettype($pricingMatrixPricingItem), var_export($pricingMatrixPricingItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The pricing property can only contain items of type \StructType\Pricing, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set pricing value
     * @throws \InvalidArgumentException
     * @param \StructType\Pricing[] $pricing
     * @return \StructType\PricingMatrix
     */
    public function setPricing(array $pricing = array())
    {
        // validation for constraint: array
        if ('' !== ($pricingArrayErrorMessage = self::validatePricingForArrayConstraintsFromSetPricing($pricing))) {
            throw new \InvalidArgumentException($pricingArrayErrorMessage, __LINE__);
        }
        $this->pricing = $pricing;
        return $this;
    }
    /**
     * Add item to pricing value
     * @throws \InvalidArgumentException
     * @param \StructType\Pricing $item
     * @return \StructType\PricingMatrix
     */
    public function addToPricing(\StructType\Pricing $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Pricing) {
            throw new \InvalidArgumentException(sprintf('The pricing property can only contain items of type \StructType\Pricing, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->pricing[] = $item;
        return $this;
    }
    /**
     * Get replaceAll value
     * @return bool|null
     */
    public function getReplaceAll()
    {
        return $this->replaceAll;
    }
    /**
     * Set replaceAll value
     * @param bool $replaceAll
     * @return \StructType\PricingMatrix
     */
    public function setReplaceAll($replaceAll = false)
    {
        // validation for constraint: boolean
        if (!is_null($replaceAll) && !is_bool($replaceAll)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($replaceAll, true), gettype($replaceAll)), __LINE__);
        }
        $this->replaceAll = $replaceAll;
        return $this;
    }
}
