<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Pricing StructType
 * @subpackage Structs
 */
class Pricing extends AbstractStructBase
{
    /**
     * The currency
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $currency;
    /**
     * The priceLevel
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $priceLevel;
    /**
     * The discount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $discount;
    /**
     * The priceList
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\PriceList
     */
    public $priceList;
    /**
     * Constructor method for Pricing
     * @uses Pricing::setCurrency()
     * @uses Pricing::setPriceLevel()
     * @uses Pricing::setDiscount()
     * @uses Pricing::setPriceList()
     * @param \StructType\RecordRef $currency
     * @param \StructType\RecordRef $priceLevel
     * @param float $discount
     * @param \StructType\PriceList $priceList
     */
    public function __construct(\StructType\RecordRef $currency = null, \StructType\RecordRef $priceLevel = null, $discount = null, \StructType\PriceList $priceList = null)
    {
        $this
            ->setCurrency($currency)
            ->setPriceLevel($priceLevel)
            ->setDiscount($discount)
            ->setPriceList($priceList);
    }
    /**
     * Get currency value
     * @return \StructType\RecordRef|null
     */
    public function getCurrency()
    {
        return $this->currency;
    }
    /**
     * Set currency value
     * @param \StructType\RecordRef $currency
     * @return \StructType\Pricing
     */
    public function setCurrency(\StructType\RecordRef $currency = null)
    {
        $this->currency = $currency;
        return $this;
    }
    /**
     * Get priceLevel value
     * @return \StructType\RecordRef|null
     */
    public function getPriceLevel()
    {
        return $this->priceLevel;
    }
    /**
     * Set priceLevel value
     * @param \StructType\RecordRef $priceLevel
     * @return \StructType\Pricing
     */
    public function setPriceLevel(\StructType\RecordRef $priceLevel = null)
    {
        $this->priceLevel = $priceLevel;
        return $this;
    }
    /**
     * Get discount value
     * @return float|null
     */
    public function getDiscount()
    {
        return $this->discount;
    }
    /**
     * Set discount value
     * @param float $discount
     * @return \StructType\Pricing
     */
    public function setDiscount($discount = null)
    {
        // validation for constraint: float
        if (!is_null($discount) && !(is_float($discount) || is_numeric($discount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($discount, true), gettype($discount)), __LINE__);
        }
        $this->discount = $discount;
        return $this;
    }
    /**
     * Get priceList value
     * @return \StructType\PriceList|null
     */
    public function getPriceList()
    {
        return $this->priceList;
    }
    /**
     * Set priceList value
     * @param \StructType\PriceList $priceList
     * @return \StructType\Pricing
     */
    public function setPriceList(\StructType\PriceList $priceList = null)
    {
        $this->priceList = $priceList;
        return $this;
    }
}
