<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PriceList StructType
 * @subpackage Structs
 */
class PriceList extends AbstractStructBase
{
    /**
     * The price
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Price[]
     */
    public $price;
    /**
     * Constructor method for PriceList
     * @uses PriceList::setPrice()
     * @param \StructType\Price[] $price
     */
    public function __construct(array $price = array())
    {
        $this
            ->setPrice($price);
    }
    /**
     * Get price value
     * @return \StructType\Price[]|null
     */
    public function getPrice()
    {
        return $this->price;
    }
    /**
     * This method is responsible for validating the values passed to the setPrice method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPrice method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePriceForArrayConstraintsFromSetPrice(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $priceListPriceItem) {
            // validation for constraint: itemType
            if (!$priceListPriceItem instanceof \StructType\Price) {
                $invalidValues[] = is_object($priceListPriceItem) ? get_class($priceListPriceItem) : sprintf('%s(%s)', gettype($priceListPriceItem), var_export($priceListPriceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The price property can only contain items of type \StructType\Price, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set price value
     * @throws \InvalidArgumentException
     * @param \StructType\Price[] $price
     * @return \StructType\PriceList
     */
    public function setPrice(array $price = array())
    {
        // validation for constraint: array
        if ('' !== ($priceArrayErrorMessage = self::validatePriceForArrayConstraintsFromSetPrice($price))) {
            throw new \InvalidArgumentException($priceArrayErrorMessage, __LINE__);
        }
        $this->price = $price;
        return $this;
    }
    /**
     * Add item to price value
     * @throws \InvalidArgumentException
     * @param \StructType\Price $item
     * @return \StructType\PriceList
     */
    public function addToPrice(\StructType\Price $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Price) {
            throw new \InvalidArgumentException(sprintf('The price property can only contain items of type \StructType\Price, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->price[] = $item;
        return $this;
    }
}
