<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PriceLevel StructType
 * Meta information extracted from the WSDL
 * - type: listAcct:PriceLevel
 * @subpackage Structs
 */
class PriceLevel extends Record
{
    /**
     * The name
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $name;
    /**
     * The discountpct
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $discountpct;
    /**
     * The updateExistingPrices
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $updateExistingPrices;
    /**
     * The isOnline
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $isOnline;
    /**
     * The isInactive
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $isInactive;
    /**
     * The internalId
     * @var string
     */
    public $internalId;
    /**
     * The externalId
     * @var string
     */
    public $externalId;
    /**
     * Constructor method for PriceLevel
     * @uses PriceLevel::setName()
     * @uses PriceLevel::setDiscountpct()
     * @uses PriceLevel::setUpdateExistingPrices()
     * @uses PriceLevel::setIsOnline()
     * @uses PriceLevel::setIsInactive()
     * @uses PriceLevel::setInternalId()
     * @uses PriceLevel::setExternalId()
     * @param string $name
     * @param float $discountpct
     * @param bool $updateExistingPrices
     * @param bool $isOnline
     * @param bool $isInactive
     * @param string $internalId
     * @param string $externalId
     */
    public function __construct($name = null, $discountpct = null, $updateExistingPrices = null, $isOnline = null, $isInactive = null, $internalId = null, $externalId = null)
    {
        $this
            ->setName($name)
            ->setDiscountpct($discountpct)
            ->setUpdateExistingPrices($updateExistingPrices)
            ->setIsOnline($isOnline)
            ->setIsInactive($isInactive)
            ->setInternalId($internalId)
            ->setExternalId($externalId);
    }
    /**
     * Get name value
     * @return string|null
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return \StructType\PriceLevel
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        $this->name = $name;
        return $this;
    }
    /**
     * Get discountpct value
     * @return float|null
     */
    public function getDiscountpct()
    {
        return $this->discountpct;
    }
    /**
     * Set discountpct value
     * @param float $discountpct
     * @return \StructType\PriceLevel
     */
    public function setDiscountpct($discountpct = null)
    {
        // validation for constraint: float
        if (!is_null($discountpct) && !(is_float($discountpct) || is_numeric($discountpct))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($discountpct, true), gettype($discountpct)), __LINE__);
        }
        $this->discountpct = $discountpct;
        return $this;
    }
    /**
     * Get updateExistingPrices value
     * @return bool|null
     */
    public function getUpdateExistingPrices()
    {
        return $this->updateExistingPrices;
    }
    /**
     * Set updateExistingPrices value
     * @param bool $updateExistingPrices
     * @return \StructType\PriceLevel
     */
    public function setUpdateExistingPrices($updateExistingPrices = null)
    {
        // validation for constraint: boolean
        if (!is_null($updateExistingPrices) && !is_bool($updateExistingPrices)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($updateExistingPrices, true), gettype($updateExistingPrices)), __LINE__);
        }
        $this->updateExistingPrices = $updateExistingPrices;
        return $this;
    }
    /**
     * Get isOnline value
     * @return bool|null
     */
    public function getIsOnline()
    {
        return $this->isOnline;
    }
    /**
     * Set isOnline value
     * @param bool $isOnline
     * @return \StructType\PriceLevel
     */
    public function setIsOnline($isOnline = null)
    {
        // validation for constraint: boolean
        if (!is_null($isOnline) && !is_bool($isOnline)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isOnline, true), gettype($isOnline)), __LINE__);
        }
        $this->isOnline = $isOnline;
        return $this;
    }
    /**
     * Get isInactive value
     * @return bool|null
     */
    public function getIsInactive()
    {
        return $this->isInactive;
    }
    /**
     * Set isInactive value
     * @param bool $isInactive
     * @return \StructType\PriceLevel
     */
    public function setIsInactive($isInactive = null)
    {
        // validation for constraint: boolean
        if (!is_null($isInactive) && !is_bool($isInactive)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isInactive, true), gettype($isInactive)), __LINE__);
        }
        $this->isInactive = $isInactive;
        return $this;
    }
    /**
     * Get internalId value
     * @return string|null
     */
    public function getInternalId()
    {
        return $this->internalId;
    }
    /**
     * Set internalId value
     * @param string $internalId
     * @return \StructType\PriceLevel
     */
    public function setInternalId($internalId = null)
    {
        // validation for constraint: string
        if (!is_null($internalId) && !is_string($internalId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($internalId, true), gettype($internalId)), __LINE__);
        }
        $this->internalId = $internalId;
        return $this;
    }
    /**
     * Get externalId value
     * @return string|null
     */
    public function getExternalId()
    {
        return $this->externalId;
    }
    /**
     * Set externalId value
     * @param string $externalId
     * @return \StructType\PriceLevel
     */
    public function setExternalId($externalId = null)
    {
        // validation for constraint: string
        if (!is_null($externalId) && !is_string($externalId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($externalId, true), gettype($externalId)), __LINE__);
        }
        $this->externalId = $externalId;
        return $this;
    }
}
