<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PresentationItem StructType
 * @subpackage Structs
 */
class PresentationItem extends AbstractStructBase
{
    /**
     * The item
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $item;
    /**
     * The itemType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $itemType;
    /**
     * The description
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $description;
    /**
     * The onlinePrice
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $onlinePrice;
    /**
     * The basePrice
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $basePrice;
    /**
     * Constructor method for PresentationItem
     * @uses PresentationItem::setItem()
     * @uses PresentationItem::setItemType()
     * @uses PresentationItem::setDescription()
     * @uses PresentationItem::setOnlinePrice()
     * @uses PresentationItem::setBasePrice()
     * @param \StructType\RecordRef $item
     * @param string $itemType
     * @param string $description
     * @param float $onlinePrice
     * @param float $basePrice
     */
    public function __construct(\StructType\RecordRef $item = null, $itemType = null, $description = null, $onlinePrice = null, $basePrice = null)
    {
        $this
            ->setItem($item)
            ->setItemType($itemType)
            ->setDescription($description)
            ->setOnlinePrice($onlinePrice)
            ->setBasePrice($basePrice);
    }
    /**
     * Get item value
     * @return \StructType\RecordRef|null
     */
    public function getItem()
    {
        return $this->item;
    }
    /**
     * Set item value
     * @param \StructType\RecordRef $item
     * @return \StructType\PresentationItem
     */
    public function setItem(\StructType\RecordRef $item = null)
    {
        $this->item = $item;
        return $this;
    }
    /**
     * Get itemType value
     * @return string|null
     */
    public function getItemType()
    {
        return $this->itemType;
    }
    /**
     * Set itemType value
     * @uses \EnumType\PresentationItemType::valueIsValid()
     * @uses \EnumType\PresentationItemType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $itemType
     * @return \StructType\PresentationItem
     */
    public function setItemType($itemType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\PresentationItemType::valueIsValid($itemType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\PresentationItemType', is_array($itemType) ? implode(', ', $itemType) : var_export($itemType, true), implode(', ', \EnumType\PresentationItemType::getValidValues())), __LINE__);
        }
        $this->itemType = $itemType;
        return $this;
    }
    /**
     * Get description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return \StructType\PresentationItem
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        $this->description = $description;
        return $this;
    }
    /**
     * Get onlinePrice value
     * @return float|null
     */
    public function getOnlinePrice()
    {
        return $this->onlinePrice;
    }
    /**
     * Set onlinePrice value
     * @param float $onlinePrice
     * @return \StructType\PresentationItem
     */
    public function setOnlinePrice($onlinePrice = null)
    {
        // validation for constraint: float
        if (!is_null($onlinePrice) && !(is_float($onlinePrice) || is_numeric($onlinePrice))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($onlinePrice, true), gettype($onlinePrice)), __LINE__);
        }
        $this->onlinePrice = $onlinePrice;
        return $this;
    }
    /**
     * Get basePrice value
     * @return float|null
     */
    public function getBasePrice()
    {
        return $this->basePrice;
    }
    /**
     * Set basePrice value
     * @param float $basePrice
     * @return \StructType\PresentationItem
     */
    public function setBasePrice($basePrice = null)
    {
        // validation for constraint: float
        if (!is_null($basePrice) && !(is_float($basePrice) || is_numeric($basePrice))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($basePrice, true), gettype($basePrice)), __LINE__);
        }
        $this->basePrice = $basePrice;
        return $this;
    }
}
