<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PeriodEndJournalLine StructType
 * @subpackage Structs
 */
class PeriodEndJournalLine extends AbstractStructBase
{
    /**
     * The account
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $account;
    /**
     * The debit
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $debit;
    /**
     * The credit
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $credit;
    /**
     * The memo
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $memo;
    /**
     * The line
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $line;
    /**
     * The customFieldList
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\CustomFieldList
     */
    public $customFieldList;
    /**
     * Constructor method for PeriodEndJournalLine
     * @uses PeriodEndJournalLine::setAccount()
     * @uses PeriodEndJournalLine::setDebit()
     * @uses PeriodEndJournalLine::setCredit()
     * @uses PeriodEndJournalLine::setMemo()
     * @uses PeriodEndJournalLine::setLine()
     * @uses PeriodEndJournalLine::setCustomFieldList()
     * @param \StructType\RecordRef $account
     * @param float $debit
     * @param float $credit
     * @param string $memo
     * @param int $line
     * @param \StructType\CustomFieldList $customFieldList
     */
    public function __construct(\StructType\RecordRef $account = null, $debit = null, $credit = null, $memo = null, $line = null, \StructType\CustomFieldList $customFieldList = null)
    {
        $this
            ->setAccount($account)
            ->setDebit($debit)
            ->setCredit($credit)
            ->setMemo($memo)
            ->setLine($line)
            ->setCustomFieldList($customFieldList);
    }
    /**
     * Get account value
     * @return \StructType\RecordRef|null
     */
    public function getAccount()
    {
        return $this->account;
    }
    /**
     * Set account value
     * @param \StructType\RecordRef $account
     * @return \StructType\PeriodEndJournalLine
     */
    public function setAccount(\StructType\RecordRef $account = null)
    {
        $this->account = $account;
        return $this;
    }
    /**
     * Get debit value
     * @return float|null
     */
    public function getDebit()
    {
        return $this->debit;
    }
    /**
     * Set debit value
     * @param float $debit
     * @return \StructType\PeriodEndJournalLine
     */
    public function setDebit($debit = null)
    {
        // validation for constraint: float
        if (!is_null($debit) && !(is_float($debit) || is_numeric($debit))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($debit, true), gettype($debit)), __LINE__);
        }
        $this->debit = $debit;
        return $this;
    }
    /**
     * Get credit value
     * @return float|null
     */
    public function getCredit()
    {
        return $this->credit;
    }
    /**
     * Set credit value
     * @param float $credit
     * @return \StructType\PeriodEndJournalLine
     */
    public function setCredit($credit = null)
    {
        // validation for constraint: float
        if (!is_null($credit) && !(is_float($credit) || is_numeric($credit))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($credit, true), gettype($credit)), __LINE__);
        }
        $this->credit = $credit;
        return $this;
    }
    /**
     * Get memo value
     * @return string|null
     */
    public function getMemo()
    {
        return $this->memo;
    }
    /**
     * Set memo value
     * @param string $memo
     * @return \StructType\PeriodEndJournalLine
     */
    public function setMemo($memo = null)
    {
        // validation for constraint: string
        if (!is_null($memo) && !is_string($memo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($memo, true), gettype($memo)), __LINE__);
        }
        $this->memo = $memo;
        return $this;
    }
    /**
     * Get line value
     * @return int|null
     */
    public function getLine()
    {
        return $this->line;
    }
    /**
     * Set line value
     * @param int $line
     * @return \StructType\PeriodEndJournalLine
     */
    public function setLine($line = null)
    {
        // validation for constraint: int
        if (!is_null($line) && !(is_int($line) || ctype_digit($line))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($line, true), gettype($line)), __LINE__);
        }
        $this->line = $line;
        return $this;
    }
    /**
     * Get customFieldList value
     * @return \StructType\CustomFieldList|null
     */
    public function getCustomFieldList()
    {
        return $this->customFieldList;
    }
    /**
     * Set customFieldList value
     * @param \StructType\CustomFieldList $customFieldList
     * @return \StructType\PeriodEndJournalLine
     */
    public function setCustomFieldList(\StructType\CustomFieldList $customFieldList = null)
    {
        $this->customFieldList = $customFieldList;
        return $this;
    }
}
