<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PayrollItemSearchRowBasic StructType
 * @subpackage Structs
 */
class PayrollItemSearchRowBasic extends SearchRowBasic
{
    /**
     * The expenseAccount
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SearchColumnStringField[]
     */
    public $expenseAccount;
    /**
     * The externalId
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SearchColumnSelectField[]
     */
    public $externalId;
    /**
     * The internalId
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SearchColumnSelectField[]
     */
    public $internalId;
    /**
     * The isInactive
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SearchColumnBooleanField[]
     */
    public $isInactive;
    /**
     * The itemTypeNoHierarchy
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SearchColumnStringField[]
     */
    public $itemTypeNoHierarchy;
    /**
     * The liabilityAccount
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SearchColumnStringField[]
     */
    public $liabilityAccount;
    /**
     * The name
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SearchColumnStringField[]
     */
    public $name;
    /**
     * The subsidiary
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SearchColumnStringField[]
     */
    public $subsidiary;
    /**
     * The vendor
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SearchColumnStringField[]
     */
    public $vendor;
    /**
     * The customFieldList
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\SearchColumnCustomFieldList
     */
    public $customFieldList;
    /**
     * Constructor method for PayrollItemSearchRowBasic
     * @uses PayrollItemSearchRowBasic::setExpenseAccount()
     * @uses PayrollItemSearchRowBasic::setExternalId()
     * @uses PayrollItemSearchRowBasic::setInternalId()
     * @uses PayrollItemSearchRowBasic::setIsInactive()
     * @uses PayrollItemSearchRowBasic::setItemTypeNoHierarchy()
     * @uses PayrollItemSearchRowBasic::setLiabilityAccount()
     * @uses PayrollItemSearchRowBasic::setName()
     * @uses PayrollItemSearchRowBasic::setSubsidiary()
     * @uses PayrollItemSearchRowBasic::setVendor()
     * @uses PayrollItemSearchRowBasic::setCustomFieldList()
     * @param \StructType\SearchColumnStringField[] $expenseAccount
     * @param \StructType\SearchColumnSelectField[] $externalId
     * @param \StructType\SearchColumnSelectField[] $internalId
     * @param \StructType\SearchColumnBooleanField[] $isInactive
     * @param \StructType\SearchColumnStringField[] $itemTypeNoHierarchy
     * @param \StructType\SearchColumnStringField[] $liabilityAccount
     * @param \StructType\SearchColumnStringField[] $name
     * @param \StructType\SearchColumnStringField[] $subsidiary
     * @param \StructType\SearchColumnStringField[] $vendor
     * @param \StructType\SearchColumnCustomFieldList $customFieldList
     */
    public function __construct(array $expenseAccount = array(), array $externalId = array(), array $internalId = array(), array $isInactive = array(), array $itemTypeNoHierarchy = array(), array $liabilityAccount = array(), array $name = array(), array $subsidiary = array(), array $vendor = array(), \StructType\SearchColumnCustomFieldList $customFieldList = null)
    {
        $this
            ->setExpenseAccount($expenseAccount)
            ->setExternalId($externalId)
            ->setInternalId($internalId)
            ->setIsInactive($isInactive)
            ->setItemTypeNoHierarchy($itemTypeNoHierarchy)
            ->setLiabilityAccount($liabilityAccount)
            ->setName($name)
            ->setSubsidiary($subsidiary)
            ->setVendor($vendor)
            ->setCustomFieldList($customFieldList);
    }
    /**
     * Get expenseAccount value
     * @return \StructType\SearchColumnStringField[]|null
     */
    public function getExpenseAccount()
    {
        return $this->expenseAccount;
    }
    /**
     * This method is responsible for validating the values passed to the setExpenseAccount method
     * This method is willingly generated in order to preserve the one-line inline validation within the setExpenseAccount method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateExpenseAccountForArrayConstraintsFromSetExpenseAccount(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $payrollItemSearchRowBasicExpenseAccountItem) {
            // validation for constraint: itemType
            if (!$payrollItemSearchRowBasicExpenseAccountItem instanceof \StructType\SearchColumnStringField) {
                $invalidValues[] = is_object($payrollItemSearchRowBasicExpenseAccountItem) ? get_class($payrollItemSearchRowBasicExpenseAccountItem) : sprintf('%s(%s)', gettype($payrollItemSearchRowBasicExpenseAccountItem), var_export($payrollItemSearchRowBasicExpenseAccountItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The expenseAccount property can only contain items of type \StructType\SearchColumnStringField, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set expenseAccount value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnStringField[] $expenseAccount
     * @return \StructType\PayrollItemSearchRowBasic
     */
    public function setExpenseAccount(array $expenseAccount = array())
    {
        // validation for constraint: array
        if ('' !== ($expenseAccountArrayErrorMessage = self::validateExpenseAccountForArrayConstraintsFromSetExpenseAccount($expenseAccount))) {
            throw new \InvalidArgumentException($expenseAccountArrayErrorMessage, __LINE__);
        }
        $this->expenseAccount = $expenseAccount;
        return $this;
    }
    /**
     * Add item to expenseAccount value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnStringField $item
     * @return \StructType\PayrollItemSearchRowBasic
     */
    public function addToExpenseAccount(\StructType\SearchColumnStringField $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SearchColumnStringField) {
            throw new \InvalidArgumentException(sprintf('The expenseAccount property can only contain items of type \StructType\SearchColumnStringField, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->expenseAccount[] = $item;
        return $this;
    }
    /**
     * Get externalId value
     * @return \StructType\SearchColumnSelectField[]|null
     */
    public function getExternalId()
    {
        return $this->externalId;
    }
    /**
     * This method is responsible for validating the values passed to the setExternalId method
     * This method is willingly generated in order to preserve the one-line inline validation within the setExternalId method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateExternalIdForArrayConstraintsFromSetExternalId(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $payrollItemSearchRowBasicExternalIdItem) {
            // validation for constraint: itemType
            if (!$payrollItemSearchRowBasicExternalIdItem instanceof \StructType\SearchColumnSelectField) {
                $invalidValues[] = is_object($payrollItemSearchRowBasicExternalIdItem) ? get_class($payrollItemSearchRowBasicExternalIdItem) : sprintf('%s(%s)', gettype($payrollItemSearchRowBasicExternalIdItem), var_export($payrollItemSearchRowBasicExternalIdItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The externalId property can only contain items of type \StructType\SearchColumnSelectField, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set externalId value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnSelectField[] $externalId
     * @return \StructType\PayrollItemSearchRowBasic
     */
    public function setExternalId(array $externalId = array())
    {
        // validation for constraint: array
        if ('' !== ($externalIdArrayErrorMessage = self::validateExternalIdForArrayConstraintsFromSetExternalId($externalId))) {
            throw new \InvalidArgumentException($externalIdArrayErrorMessage, __LINE__);
        }
        $this->externalId = $externalId;
        return $this;
    }
    /**
     * Add item to externalId value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnSelectField $item
     * @return \StructType\PayrollItemSearchRowBasic
     */
    public function addToExternalId(\StructType\SearchColumnSelectField $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SearchColumnSelectField) {
            throw new \InvalidArgumentException(sprintf('The externalId property can only contain items of type \StructType\SearchColumnSelectField, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->externalId[] = $item;
        return $this;
    }
    /**
     * Get internalId value
     * @return \StructType\SearchColumnSelectField[]|null
     */
    public function getInternalId()
    {
        return $this->internalId;
    }
    /**
     * This method is responsible for validating the values passed to the setInternalId method
     * This method is willingly generated in order to preserve the one-line inline validation within the setInternalId method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateInternalIdForArrayConstraintsFromSetInternalId(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $payrollItemSearchRowBasicInternalIdItem) {
            // validation for constraint: itemType
            if (!$payrollItemSearchRowBasicInternalIdItem instanceof \StructType\SearchColumnSelectField) {
                $invalidValues[] = is_object($payrollItemSearchRowBasicInternalIdItem) ? get_class($payrollItemSearchRowBasicInternalIdItem) : sprintf('%s(%s)', gettype($payrollItemSearchRowBasicInternalIdItem), var_export($payrollItemSearchRowBasicInternalIdItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The internalId property can only contain items of type \StructType\SearchColumnSelectField, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set internalId value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnSelectField[] $internalId
     * @return \StructType\PayrollItemSearchRowBasic
     */
    public function setInternalId(array $internalId = array())
    {
        // validation for constraint: array
        if ('' !== ($internalIdArrayErrorMessage = self::validateInternalIdForArrayConstraintsFromSetInternalId($internalId))) {
            throw new \InvalidArgumentException($internalIdArrayErrorMessage, __LINE__);
        }
        $this->internalId = $internalId;
        return $this;
    }
    /**
     * Add item to internalId value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnSelectField $item
     * @return \StructType\PayrollItemSearchRowBasic
     */
    public function addToInternalId(\StructType\SearchColumnSelectField $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SearchColumnSelectField) {
            throw new \InvalidArgumentException(sprintf('The internalId property can only contain items of type \StructType\SearchColumnSelectField, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->internalId[] = $item;
        return $this;
    }
    /**
     * Get isInactive value
     * @return \StructType\SearchColumnBooleanField[]|null
     */
    public function getIsInactive()
    {
        return $this->isInactive;
    }
    /**
     * This method is responsible for validating the values passed to the setIsInactive method
     * This method is willingly generated in order to preserve the one-line inline validation within the setIsInactive method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateIsInactiveForArrayConstraintsFromSetIsInactive(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $payrollItemSearchRowBasicIsInactiveItem) {
            // validation for constraint: itemType
            if (!$payrollItemSearchRowBasicIsInactiveItem instanceof \StructType\SearchColumnBooleanField) {
                $invalidValues[] = is_object($payrollItemSearchRowBasicIsInactiveItem) ? get_class($payrollItemSearchRowBasicIsInactiveItem) : sprintf('%s(%s)', gettype($payrollItemSearchRowBasicIsInactiveItem), var_export($payrollItemSearchRowBasicIsInactiveItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The isInactive property can only contain items of type \StructType\SearchColumnBooleanField, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set isInactive value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnBooleanField[] $isInactive
     * @return \StructType\PayrollItemSearchRowBasic
     */
    public function setIsInactive(array $isInactive = array())
    {
        // validation for constraint: array
        if ('' !== ($isInactiveArrayErrorMessage = self::validateIsInactiveForArrayConstraintsFromSetIsInactive($isInactive))) {
            throw new \InvalidArgumentException($isInactiveArrayErrorMessage, __LINE__);
        }
        $this->isInactive = $isInactive;
        return $this;
    }
    /**
     * Add item to isInactive value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnBooleanField $item
     * @return \StructType\PayrollItemSearchRowBasic
     */
    public function addToIsInactive(\StructType\SearchColumnBooleanField $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SearchColumnBooleanField) {
            throw new \InvalidArgumentException(sprintf('The isInactive property can only contain items of type \StructType\SearchColumnBooleanField, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->isInactive[] = $item;
        return $this;
    }
    /**
     * Get itemTypeNoHierarchy value
     * @return \StructType\SearchColumnStringField[]|null
     */
    public function getItemTypeNoHierarchy()
    {
        return $this->itemTypeNoHierarchy;
    }
    /**
     * This method is responsible for validating the values passed to the setItemTypeNoHierarchy method
     * This method is willingly generated in order to preserve the one-line inline validation within the setItemTypeNoHierarchy method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateItemTypeNoHierarchyForArrayConstraintsFromSetItemTypeNoHierarchy(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $payrollItemSearchRowBasicItemTypeNoHierarchyItem) {
            // validation for constraint: itemType
            if (!$payrollItemSearchRowBasicItemTypeNoHierarchyItem instanceof \StructType\SearchColumnStringField) {
                $invalidValues[] = is_object($payrollItemSearchRowBasicItemTypeNoHierarchyItem) ? get_class($payrollItemSearchRowBasicItemTypeNoHierarchyItem) : sprintf('%s(%s)', gettype($payrollItemSearchRowBasicItemTypeNoHierarchyItem), var_export($payrollItemSearchRowBasicItemTypeNoHierarchyItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The itemTypeNoHierarchy property can only contain items of type \StructType\SearchColumnStringField, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set itemTypeNoHierarchy value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnStringField[] $itemTypeNoHierarchy
     * @return \StructType\PayrollItemSearchRowBasic
     */
    public function setItemTypeNoHierarchy(array $itemTypeNoHierarchy = array())
    {
        // validation for constraint: array
        if ('' !== ($itemTypeNoHierarchyArrayErrorMessage = self::validateItemTypeNoHierarchyForArrayConstraintsFromSetItemTypeNoHierarchy($itemTypeNoHierarchy))) {
            throw new \InvalidArgumentException($itemTypeNoHierarchyArrayErrorMessage, __LINE__);
        }
        $this->itemTypeNoHierarchy = $itemTypeNoHierarchy;
        return $this;
    }
    /**
     * Add item to itemTypeNoHierarchy value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnStringField $item
     * @return \StructType\PayrollItemSearchRowBasic
     */
    public function addToItemTypeNoHierarchy(\StructType\SearchColumnStringField $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SearchColumnStringField) {
            throw new \InvalidArgumentException(sprintf('The itemTypeNoHierarchy property can only contain items of type \StructType\SearchColumnStringField, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->itemTypeNoHierarchy[] = $item;
        return $this;
    }
    /**
     * Get liabilityAccount value
     * @return \StructType\SearchColumnStringField[]|null
     */
    public function getLiabilityAccount()
    {
        return $this->liabilityAccount;
    }
    /**
     * This method is responsible for validating the values passed to the setLiabilityAccount method
     * This method is willingly generated in order to preserve the one-line inline validation within the setLiabilityAccount method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateLiabilityAccountForArrayConstraintsFromSetLiabilityAccount(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $payrollItemSearchRowBasicLiabilityAccountItem) {
            // validation for constraint: itemType
            if (!$payrollItemSearchRowBasicLiabilityAccountItem instanceof \StructType\SearchColumnStringField) {
                $invalidValues[] = is_object($payrollItemSearchRowBasicLiabilityAccountItem) ? get_class($payrollItemSearchRowBasicLiabilityAccountItem) : sprintf('%s(%s)', gettype($payrollItemSearchRowBasicLiabilityAccountItem), var_export($payrollItemSearchRowBasicLiabilityAccountItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The liabilityAccount property can only contain items of type \StructType\SearchColumnStringField, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set liabilityAccount value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnStringField[] $liabilityAccount
     * @return \StructType\PayrollItemSearchRowBasic
     */
    public function setLiabilityAccount(array $liabilityAccount = array())
    {
        // validation for constraint: array
        if ('' !== ($liabilityAccountArrayErrorMessage = self::validateLiabilityAccountForArrayConstraintsFromSetLiabilityAccount($liabilityAccount))) {
            throw new \InvalidArgumentException($liabilityAccountArrayErrorMessage, __LINE__);
        }
        $this->liabilityAccount = $liabilityAccount;
        return $this;
    }
    /**
     * Add item to liabilityAccount value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnStringField $item
     * @return \StructType\PayrollItemSearchRowBasic
     */
    public function addToLiabilityAccount(\StructType\SearchColumnStringField $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SearchColumnStringField) {
            throw new \InvalidArgumentException(sprintf('The liabilityAccount property can only contain items of type \StructType\SearchColumnStringField, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->liabilityAccount[] = $item;
        return $this;
    }
    /**
     * Get name value
     * @return \StructType\SearchColumnStringField[]|null
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * This method is responsible for validating the values passed to the setName method
     * This method is willingly generated in order to preserve the one-line inline validation within the setName method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateNameForArrayConstraintsFromSetName(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $payrollItemSearchRowBasicNameItem) {
            // validation for constraint: itemType
            if (!$payrollItemSearchRowBasicNameItem instanceof \StructType\SearchColumnStringField) {
                $invalidValues[] = is_object($payrollItemSearchRowBasicNameItem) ? get_class($payrollItemSearchRowBasicNameItem) : sprintf('%s(%s)', gettype($payrollItemSearchRowBasicNameItem), var_export($payrollItemSearchRowBasicNameItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The name property can only contain items of type \StructType\SearchColumnStringField, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set name value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnStringField[] $name
     * @return \StructType\PayrollItemSearchRowBasic
     */
    public function setName(array $name = array())
    {
        // validation for constraint: array
        if ('' !== ($nameArrayErrorMessage = self::validateNameForArrayConstraintsFromSetName($name))) {
            throw new \InvalidArgumentException($nameArrayErrorMessage, __LINE__);
        }
        $this->name = $name;
        return $this;
    }
    /**
     * Add item to name value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnStringField $item
     * @return \StructType\PayrollItemSearchRowBasic
     */
    public function addToName(\StructType\SearchColumnStringField $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SearchColumnStringField) {
            throw new \InvalidArgumentException(sprintf('The name property can only contain items of type \StructType\SearchColumnStringField, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->name[] = $item;
        return $this;
    }
    /**
     * Get subsidiary value
     * @return \StructType\SearchColumnStringField[]|null
     */
    public function getSubsidiary()
    {
        return $this->subsidiary;
    }
    /**
     * This method is responsible for validating the values passed to the setSubsidiary method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSubsidiary method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateSubsidiaryForArrayConstraintsFromSetSubsidiary(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $payrollItemSearchRowBasicSubsidiaryItem) {
            // validation for constraint: itemType
            if (!$payrollItemSearchRowBasicSubsidiaryItem instanceof \StructType\SearchColumnStringField) {
                $invalidValues[] = is_object($payrollItemSearchRowBasicSubsidiaryItem) ? get_class($payrollItemSearchRowBasicSubsidiaryItem) : sprintf('%s(%s)', gettype($payrollItemSearchRowBasicSubsidiaryItem), var_export($payrollItemSearchRowBasicSubsidiaryItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The subsidiary property can only contain items of type \StructType\SearchColumnStringField, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set subsidiary value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnStringField[] $subsidiary
     * @return \StructType\PayrollItemSearchRowBasic
     */
    public function setSubsidiary(array $subsidiary = array())
    {
        // validation for constraint: array
        if ('' !== ($subsidiaryArrayErrorMessage = self::validateSubsidiaryForArrayConstraintsFromSetSubsidiary($subsidiary))) {
            throw new \InvalidArgumentException($subsidiaryArrayErrorMessage, __LINE__);
        }
        $this->subsidiary = $subsidiary;
        return $this;
    }
    /**
     * Add item to subsidiary value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnStringField $item
     * @return \StructType\PayrollItemSearchRowBasic
     */
    public function addToSubsidiary(\StructType\SearchColumnStringField $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SearchColumnStringField) {
            throw new \InvalidArgumentException(sprintf('The subsidiary property can only contain items of type \StructType\SearchColumnStringField, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->subsidiary[] = $item;
        return $this;
    }
    /**
     * Get vendor value
     * @return \StructType\SearchColumnStringField[]|null
     */
    public function getVendor()
    {
        return $this->vendor;
    }
    /**
     * This method is responsible for validating the values passed to the setVendor method
     * This method is willingly generated in order to preserve the one-line inline validation within the setVendor method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateVendorForArrayConstraintsFromSetVendor(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $payrollItemSearchRowBasicVendorItem) {
            // validation for constraint: itemType
            if (!$payrollItemSearchRowBasicVendorItem instanceof \StructType\SearchColumnStringField) {
                $invalidValues[] = is_object($payrollItemSearchRowBasicVendorItem) ? get_class($payrollItemSearchRowBasicVendorItem) : sprintf('%s(%s)', gettype($payrollItemSearchRowBasicVendorItem), var_export($payrollItemSearchRowBasicVendorItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The vendor property can only contain items of type \StructType\SearchColumnStringField, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set vendor value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnStringField[] $vendor
     * @return \StructType\PayrollItemSearchRowBasic
     */
    public function setVendor(array $vendor = array())
    {
        // validation for constraint: array
        if ('' !== ($vendorArrayErrorMessage = self::validateVendorForArrayConstraintsFromSetVendor($vendor))) {
            throw new \InvalidArgumentException($vendorArrayErrorMessage, __LINE__);
        }
        $this->vendor = $vendor;
        return $this;
    }
    /**
     * Add item to vendor value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnStringField $item
     * @return \StructType\PayrollItemSearchRowBasic
     */
    public function addToVendor(\StructType\SearchColumnStringField $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SearchColumnStringField) {
            throw new \InvalidArgumentException(sprintf('The vendor property can only contain items of type \StructType\SearchColumnStringField, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->vendor[] = $item;
        return $this;
    }
    /**
     * Get customFieldList value
     * @return \StructType\SearchColumnCustomFieldList|null
     */
    public function getCustomFieldList()
    {
        return $this->customFieldList;
    }
    /**
     * Set customFieldList value
     * @param \StructType\SearchColumnCustomFieldList $customFieldList
     * @return \StructType\PayrollItemSearchRowBasic
     */
    public function setCustomFieldList(\StructType\SearchColumnCustomFieldList $customFieldList = null)
    {
        $this->customFieldList = $customFieldList;
        return $this;
    }
}
